/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.publish.CmsPublish;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.ade.publish.shared.CmsPublishResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsRealProjectVirtualWrapper
implements I_CmsVirtualProject {
    private CmsUUID m_projectId;

    public CmsRealProjectVirtualWrapper(CmsUUID id) {
        this.m_projectId = id;
    }

    @Override
    public I_CmsVirtualProject.I_Context createContext(CmsObject cms, Map<String, String> params) {
        return new Context(cms);
    }

    @Override
    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    public class Context
    implements I_CmsVirtualProject.I_Context {
        private CmsObject m_cms;

        public Context(CmsObject cms) {
            this.m_cms = cms;
        }

        @Override
        public CmsProjectBean getProjectBean() {
            try {
                CmsProject project = this.m_cms.readProject(CmsRealProjectVirtualWrapper.this.getProjectId());
                CmsProjectBean result = CmsPublish.createProjectBeanFromProject(this.m_cms, project);
                Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
                String name = Messages.get().getBundle(locale).key("GUI_NORMAL_PROJECT_1", project.getName());
                result.setDefaultGroupName(name);
                return result;
            }
            catch (CmsException e) {
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<CmsResource> getResources() throws CmsException {
            ArrayList<CmsResource> rawResourceList = new ArrayList<CmsResource>();
            CmsProject project = this.m_cms.getRequestContext().getCurrentProject();
            try {
                project = this.m_cms.readProject(CmsRealProjectVirtualWrapper.this.getProjectId());
            }
            catch (CmsException e) {
                // empty catch block
            }
            CmsProject originalProject = this.m_cms.getRequestContext().getCurrentProject();
            try {
                this.m_cms.getRequestContext().setCurrentProject(project);
                rawResourceList.addAll(OpenCms.getPublishManager().getPublishList(this.m_cms).getAllResources());
            }
            finally {
                this.m_cms.getRequestContext().setCurrentProject(originalProject);
            }
            return rawResourceList;
        }

        @Override
        public void preSort(List<CmsPublishResource> publishResources) {
            Collections.sort(publishResources, new Comparator<CmsPublishResource>(){

                @Override
                public int compare(CmsPublishResource o1, CmsPublishResource o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    return ComparisonChain.start().compare(o2.getSortDate(), o1.getSortDate()).result();
                }
            });
        }
    }
}

