/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.HashMap;
import java.util.Map;
import org.opencms.db.I_CmsHistoryDriver;
import org.opencms.db.I_CmsProjectDriver;
import org.opencms.db.I_CmsUserDriver;
import org.opencms.db.I_CmsVfsDriver;
import org.opencms.db.Messages;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsVfsException;
import org.opencms.flex.CmsFlexRequestContextInfo;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.report.I_CmsReport;
import org.opencms.util.CmsUUID;

public class CmsDbContext {
    protected Map<String, Object> m_attributes;
    protected CmsFlexRequestContextInfo m_flexRequestContextInfo;
    protected CmsUUID m_projectId;
    protected CmsRequestContext m_requestContext;

    public CmsDbContext() {
        this(null);
    }

    public CmsDbContext(CmsRequestContext context) {
        this.m_requestContext = context;
        this.m_projectId = CmsUUID.getNullUUID();
        if (this.m_requestContext != null) {
            this.m_flexRequestContextInfo = (CmsFlexRequestContextInfo)this.m_requestContext.getAttribute("Last-Modified");
        }
    }

    public void clear() {
        this.m_requestContext = null;
        this.m_flexRequestContextInfo = null;
    }

    public CmsProject currentProject() {
        return this.m_requestContext.getCurrentProject();
    }

    public CmsUser currentUser() {
        return this.m_requestContext.getCurrentUser();
    }

    public Object getAttribute(String key) {
        if (this.m_attributes == null) {
            return null;
        }
        return this.m_attributes.get(key);
    }

    public CmsFlexRequestContextInfo getFlexRequestContextInfo() {
        return this.m_flexRequestContextInfo;
    }

    public I_CmsHistoryDriver getHistoryDriver(CmsUUID projectId) {
        return null;
    }

    public I_CmsProjectDriver getProjectDriver(CmsUUID projectId) {
        return null;
    }

    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    public CmsRequestContext getRequestContext() {
        return this.m_requestContext;
    }

    public I_CmsUserDriver getUserDriver(CmsUUID projectId) {
        return null;
    }

    public I_CmsVfsDriver getVfsDriver(CmsUUID projectId) {
        return null;
    }

    public boolean isDefaultDbContext() {
        return true;
    }

    public void pop() throws CmsException {
        if (!this.isDefaultDbContext()) {
            throw new CmsException(Messages.get().container("ERR_PROCESS_DB_CONTEXT_0"));
        }
    }

    public void removeAttribute(String key) {
        if (this.m_attributes == null) {
            return;
        }
        this.m_attributes.remove(key);
    }

    public String removeSiteRoot(String resourcename) {
        if (this.m_requestContext != null && resourcename != null) {
            return this.m_requestContext.removeSiteRoot(resourcename);
        }
        return resourcename;
    }

    public void report(I_CmsReport report, CmsMessageContainer message, Throwable throwable) throws CmsVfsException, CmsException {
        if (report != null) {
            if (message != null) {
                report.println(message, 5);
            }
            if (throwable != null) {
                report.println(throwable);
            }
        }
        this.throwException(message, throwable);
    }

    public void rollback() {
    }

    public void setAttribute(String key, Object value) {
        if (this.m_attributes == null) {
            this.m_attributes = new HashMap<String, Object>(4);
        }
        this.m_attributes.put(key, value);
    }

    public void setProjectId(CmsUUID projectId) {
        this.m_projectId = projectId;
    }

    public void throwException(CmsMessageContainer message, Throwable throwable) throws CmsVfsException, CmsException {
        if (throwable instanceof CmsException) {
            throw ((CmsException)throwable).createException(message, throwable);
        }
        if (throwable instanceof CmsRuntimeException) {
            throw ((CmsRuntimeException)throwable).createException(message, throwable);
        }
        throw new CmsVfsException(message, throwable);
    }
}

