/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.jpa;

import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.StackObjectPool;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsDbException;
import org.opencms.db.generic.Messages;
import org.opencms.db.jpa.CmsDbContext;
import org.opencms.db.jpa.CmsPoolEntityManagerFactory;
import org.opencms.file.CmsProject;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsSqlManager
extends org.opencms.db.CmsSqlManager {
    public static final int DEFAULT_ENTITY_MANAGER_POOL_SIZE = 250;
    public static final String JPA_PERSISTENCE_UNIT = "OpenCmsJPAPool";
    public static final String JPA_POOL_SIZE_PROPERTY_NAME = "opencms.jpa.EntityManagerPoolSize";
    public static final String KEY_DRIVER_CLASS_NAME = "driverClassName";
    public static final String KEY_INITIAL_SIZE = "initialSize";
    public static final String KEY_MAX_ACTIVE = "maxActive";
    public static final String KEY_MAX_IDLE = "maxIdle";
    public static final String KEY_MAX_WAIT = "maxWait";
    public static final String KEY_MIN_EVICTABLE_IDLE_TIME = "minEvictableIdleTimeMillis";
    public static final String KEY_MIN_IDLE = "minIdle";
    public static final String KEY_NUM_TESTS_PER_EVICTION_RUN = "numTestsPerEvictionRun";
    public static final String KEY_PASS = "password";
    public static final String KEY_PREP_STATEMENTS = "poolPreparedStatements";
    public static final String KEY_TEST_ON_BORROW = "testOnBorrow";
    public static final String KEY_TEST_WHILE_IDLE = "testWhileIdle";
    public static final String KEY_TIME_BETWEEN_EVICTION_RUNS = "timeBetweenEvictionRunsMillis";
    public static final String KEY_URL = "url";
    public static final String KEY_USER = "username";
    public static final String KEY_VALIDATION_QUERY = "validationQuery";
    protected static ObjectPool m_openCmsEmPool;
    protected static final String OFFLINE_PROJECT = "Offline";
    protected static final String ONLINE_PROJECT = "Online";
    protected static final String QUERY_PROJECT_SEARCH_PATTERN = "${PROJECT}";
    protected static final String QUERY_PROJECT_STRING = "PROJECT";
    private static final String JPQL_PARAMETER_PLACEHOLDER = "?";
    private static final int JPQL_PARAMETER_PLACEHOLDER_LENGTH;
    private static final Log LOG;
    private static Hashtable<String, EntityManagerFactory> m_factoryTable;
    private static boolean m_isInitialized;
    private static EntityManagerFactory m_persistenceFactory;
    private static Hashtable<EntityManager, StackTraceElement[]> m_trackOn;
    private static final String QUERY_PROPERTIES = "org/opencms/db/jpa/query.properties";
    protected Hashtable<String, String> m_cachedQueries;
    protected Hashtable<String, String> m_queries;
    protected Hashtable<String, String> m_queriesWithParameters;

    public CmsSqlManager() throws CmsDbException {
        if (!m_isInitialized) {
            throw new CmsDbException(Messages.get().container("ERR_SQLMANAGER_NOT_INITIALIZED_0"));
        }
        this.m_cachedQueries = new Hashtable();
        this.m_queries = new Hashtable();
        this.m_queriesWithParameters = new Hashtable();
        this.loadQueryProperties(QUERY_PROPERTIES);
    }

    public static EntityManager createEntityManager(String unitName) {
        EntityManager em = null;
        EntityManagerFactory factory = CmsSqlManager.getFactory(unitName);
        if (factory != null) {
            em = factory.createEntityManager();
        }
        return em;
    }

    public static synchronized void destroy() {
        if (CmsLog.INIT.isDebugEnabled()) {
            CmsSqlManager.trackOn();
        }
        try {
            m_openCmsEmPool.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (m_factoryTable != null) {
            Set<String> s = m_factoryTable.keySet();
            for (String f : s) {
                EntityManagerFactory emf = m_factoryTable.get(f);
                if (emf == null) continue;
                emf.close();
                m_factoryTable.remove(f);
            }
        }
        m_isInitialized = false;
    }

    public static EntityManager getEntityManager() {
        EntityManager em = null;
        try {
            em = (EntityManager)m_openCmsEmPool.borrowObject();
            if (CmsLog.INIT.isDebugEnabled()) {
                m_trackOn.put(em, Thread.currentThread().getStackTrace());
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while getting JPA EntityManager", (Throwable)e);
        }
        return em;
    }

    public static EntityManagerFactory getFactory(String unitName) {
        EntityManagerFactory factory = m_factoryTable.get(unitName);
        if (factory == null) {
            factory = Persistence.createEntityManagerFactory((String)unitName);
            m_factoryTable.put(unitName, factory);
        }
        return factory;
    }

    public static CmsSqlManager getInstance(String classname) {
        CmsSqlManager sqlManager;
        try {
            sqlManager = new CmsSqlManager();
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_SQL_MANAGER_INIT_FAILED_1", classname), t);
            sqlManager = null;
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_DRIVER_SQL_MANAGER_1", classname));
        }
        return sqlManager;
    }

    public static void init(CmsParameterConfiguration config) {
        if (!m_isInitialized) {
            m_isInitialized = true;
            String connProps = CmsSqlManager.buildConnectionPropertiesValue(config, "default");
            Properties systemProps = System.getProperties();
            systemProps.setProperty("openjpa.ConnectionProperties", connProps);
            m_persistenceFactory = Persistence.createEntityManagerFactory((String)JPA_PERSISTENCE_UNIT, (Map)systemProps);
            m_factoryTable.put(JPA_PERSISTENCE_UNIT, m_persistenceFactory);
            CmsPoolEntityManagerFactory entityMan = new CmsPoolEntityManagerFactory(m_persistenceFactory);
            int entityManagerPoolSize = config.getInteger("db.pool.default.entityMangerPoolSize", 250);
            m_openCmsEmPool = new StackObjectPool((PoolableObjectFactory)entityMan, entityManagerPoolSize, 0);
        }
    }

    public static void returnEntityManager(EntityManager em) {
        try {
            m_openCmsEmPool.returnObject((Object)em);
            if (CmsLog.INIT.isDebugEnabled()) {
                m_trackOn.remove(em);
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }

    private static String buildConnectionPropertiesValue(CmsParameterConfiguration config, String key) {
        StringBuffer propValue = new StringBuffer();
        String jdbcDriver = config.get("db.pool." + key + '.' + "jdbcDriver");
        String jdbcUrl = config.get("db.pool." + key + '.' + "jdbcUrl");
        String jdbcUrlParams = config.get("db.pool." + key + '.' + "jdbcUrl.params");
        int maxActive = config.getInteger("db.pool." + key + '.' + KEY_MAX_ACTIVE, 10);
        int maxWait = config.getInteger("db.pool." + key + '.' + KEY_MAX_WAIT, 2000);
        int maxIdle = config.getInteger("db.pool." + key + '.' + KEY_MAX_IDLE, 5);
        int minEvictableIdleTime = config.getInteger("db.pool." + key + '.' + "minEvictableIdleTime", 1800000);
        int minIdle = config.getInteger("db.pool." + key + '.' + KEY_MIN_IDLE, 0);
        int numTestsPerEvictionRun = config.getInteger("db.pool." + key + '.' + KEY_NUM_TESTS_PER_EVICTION_RUN, 3);
        int timeBetweenEvictionRuns = config.getInteger("db.pool." + key + '.' + "timeBetweenEvictionRuns", 3600000);
        String username = config.getString("db.pool." + key + '.' + "user", "");
        String password = config.getString("db.pool." + key + '.' + KEY_PASS, "");
        boolean testOnBorrow = Boolean.valueOf(config.getString("db.pool." + key + '.' + KEY_TEST_ON_BORROW, "false").trim());
        boolean testWhileIdle = Boolean.valueOf(config.getString("db.pool." + key + '.' + KEY_TEST_WHILE_IDLE, "false").trim());
        String testQuery = config.get("db.pool." + key + '.' + "testQuery");
        if ("".equals(testQuery)) {
            testQuery = null;
        }
        int initialSize = config.getInteger("db.pool." + key + '.' + KEY_INITIAL_SIZE, 20);
        boolean poolPreparedStatements = config.getBoolean("db.pool." + key + '.' + KEY_PREP_STATEMENTS, true);
        propValue.append(KEY_DRIVER_CLASS_NAME);
        propValue.append("=");
        propValue.append(jdbcDriver);
        propValue.append(", ");
        propValue.append(KEY_URL);
        propValue.append("=");
        propValue.append(jdbcUrl);
        propValue.append(StringUtils.defaultString((String)jdbcUrlParams));
        propValue.append(", ");
        propValue.append(KEY_USER);
        propValue.append("=");
        propValue.append(username);
        propValue.append(", ");
        propValue.append(KEY_PASS);
        propValue.append("=");
        propValue.append(StringUtils.defaultString((String)password));
        propValue.append(", ");
        propValue.append(KEY_MAX_ACTIVE);
        propValue.append("=");
        propValue.append(maxActive);
        propValue.append(", ");
        propValue.append(KEY_MAX_IDLE);
        propValue.append("=");
        propValue.append(maxIdle);
        propValue.append(", ");
        propValue.append(KEY_MAX_WAIT);
        propValue.append("=");
        propValue.append(maxWait);
        propValue.append(", ");
        propValue.append(KEY_MIN_IDLE);
        propValue.append("=");
        propValue.append(minIdle);
        propValue.append(", ");
        if (testQuery != null) {
            propValue.append(KEY_VALIDATION_QUERY);
            propValue.append("=");
            propValue.append(StringUtils.defaultString((String)testQuery));
            propValue.append(", ");
            propValue.append(KEY_TEST_ON_BORROW);
            propValue.append("=");
            propValue.append(testOnBorrow);
            propValue.append(", ");
            propValue.append(KEY_TEST_WHILE_IDLE);
            propValue.append("=");
            propValue.append(testWhileIdle);
            propValue.append(", ");
            propValue.append(KEY_TIME_BETWEEN_EVICTION_RUNS);
            propValue.append("=");
            propValue.append(timeBetweenEvictionRuns);
            propValue.append(", ");
            propValue.append(KEY_NUM_TESTS_PER_EVICTION_RUN);
            propValue.append("=");
            propValue.append(numTestsPerEvictionRun);
            propValue.append(", ");
            propValue.append(KEY_MIN_EVICTABLE_IDLE_TIME);
            propValue.append("=");
            propValue.append(minEvictableIdleTime);
            propValue.append(", ");
        }
        propValue.append(KEY_INITIAL_SIZE);
        propValue.append("=");
        propValue.append(initialSize);
        propValue.append(", ");
        propValue.append(KEY_PREP_STATEMENTS);
        propValue.append("=");
        propValue.append(poolPreparedStatements);
        return propValue.toString();
    }

    private static String replaceProjectPattern(CmsUUID projectId, String query) {
        String replacePattern = projectId == null || projectId.equals(CmsProject.ONLINE_PROJECT_ID) ? ONLINE_PROJECT : OFFLINE_PROJECT;
        return CmsStringUtil.substitute(query, QUERY_PROJECT_SEARCH_PATTERN, replacePattern);
    }

    private static void trackOn() {
        LOG.debug((Object)"#################### Start Tracking on EM instances ");
        LOG.debug((Object)(" there is " + m_trackOn.keySet().size() + " instances uncleared"));
        Set<EntityManager> set = m_trackOn.keySet();
        int i = 0;
        for (EntityManager em : set) {
            LOG.debug((Object)("--- " + ++i + " instance tracelog --- "));
            StackTraceElement[] el = m_trackOn.get(em);
            for (int b = 0; b < el.length; ++b) {
                LOG.debug((Object)el[b].toString());
            }
        }
        LOG.debug((Object)"#################### Stop Tracking on EM instances ");
    }

    public Query createNativeQuery(org.opencms.db.CmsDbContext dbc, CmsUUID projectId, String queryKey) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        jpaDbc.getEntityManager().flush();
        String rawSql = this.readQuery(projectId, queryKey);
        return jpaDbc.getEntityManager().createNativeQuery(this.prepareQueryParameters(rawSql).toUpperCase());
    }

    public Query createQuery(org.opencms.db.CmsDbContext dbc, CmsProject project, String queryKey) {
        return this.createQuery(dbc, project.getUuid(), queryKey);
    }

    public Query createQuery(org.opencms.db.CmsDbContext dbc, CmsUUID projectId, String queryKey) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        jpaDbc.getEntityManager().flush();
        String rawJpql = this.readQuery(projectId, queryKey);
        return jpaDbc.getEntityManager().createQuery(this.prepareQueryParameters(rawJpql));
    }

    public Query createQuery(org.opencms.db.CmsDbContext dbc, String queryKey) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        jpaDbc.getEntityManager().flush();
        String rawJpql = this.readQuery(CmsUUID.getNullUUID(), queryKey);
        return jpaDbc.getEntityManager().createQuery(this.prepareQueryParameters(rawJpql));
    }

    public Query createQueryFromJPQL(org.opencms.db.CmsDbContext dbc, String query) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        jpaDbc.getEntityManager().flush();
        return jpaDbc.getEntityManager().createQuery(this.prepareQueryParameters(query));
    }

    public Query createQueryWithParametersFromJPQL(org.opencms.db.CmsDbContext dbc, String query, List<Object> params) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        jpaDbc.getEntityManager().flush();
        query = CmsStringUtil.substitute(query, "\t", " ");
        query = CmsStringUtil.substitute(query, "\n", " ");
        String realQuery = this.prepareQueryParameters(query, false);
        Query queryObj = jpaDbc.getEntityManager().createQuery(realQuery);
        int index = 1;
        for (Object param : params) {
            if (!(param instanceof String || param instanceof Integer || param instanceof Long)) {
                throw new IllegalArgumentException();
            }
            queryObj.setParameter(index, param);
            ++index;
        }
        return queryObj;
    }

    public <T> T find(org.opencms.db.CmsDbContext dbc, Class<T> cls, Object o) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        return (T)jpaDbc.getEntityManager().find(cls, o);
    }

    public EntityManager getEntityManager(org.opencms.db.CmsDbContext dbc) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        return jpaDbc.getEntityManager();
    }

    public void persist(org.opencms.db.CmsDbContext dbc, Object o) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        jpaDbc.getEntityManager().persist(o);
    }

    public String readQuery(CmsProject project, String queryKey) {
        return this.readQuery(project.getUuid(), queryKey);
    }

    public String readQuery(CmsUUID projectId, String queryKey) {
        String key;
        if (projectId != null && !projectId.isNullUUID()) {
            StringBuffer buffer = new StringBuffer(128);
            buffer.append(queryKey);
            if (projectId.equals(CmsProject.ONLINE_PROJECT_ID)) {
                buffer.append(ONLINE_PROJECT);
            } else {
                buffer.append(OFFLINE_PROJECT);
            }
            key = buffer.toString();
        } else {
            key = queryKey;
        }
        String query = this.m_cachedQueries.get(key);
        if (query == null) {
            query = this.readQuery(queryKey);
            if (query == null) {
                throw new CmsRuntimeException(Messages.get().container("ERR_QUERY_NOT_FOUND_1", queryKey));
            }
            query = CmsStringUtil.substitute(query, "\t", " ");
            query = CmsStringUtil.substitute(query, "\n", " ");
            if (projectId != null && !projectId.isNullUUID()) {
                query = CmsSqlManager.replaceProjectPattern(projectId, query);
            }
            this.m_cachedQueries.put(key, query);
        }
        return query;
    }

    public String readQuery(String queryKey) {
        String value = this.m_queries.get(queryKey);
        if (value == null && !QUERY_PROJECT_STRING.equalsIgnoreCase(queryKey) && LOG.isErrorEnabled()) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_QUERY_NOT_FOUND_1", queryKey));
        }
        return value;
    }

    public void remove(org.opencms.db.CmsDbContext dbc, Object o) {
        CmsDbContext jpaDbc = (CmsDbContext)dbc;
        jpaDbc.getEntityManager().remove(o);
    }

    public String validateEmpty(String value) {
        if (CmsStringUtil.isNotEmpty(value)) {
            return value;
        }
        return " ";
    }

    protected void loadQueryProperties(String propertyFilename) {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getClassLoader().getResourceAsStream(propertyFilename));
            this.m_queries.putAll(CmsCollectionsGenericWrapper.map(properties));
            this.replaceQuerySearchPatterns();
        }
        catch (Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_LOAD_QUERY_PROP_FILE_FAILED_1", propertyFilename), t);
            }
            properties = null;
        }
    }

    protected void replaceQuerySearchPatterns() {
        String currentKey2 = null;
        String currentValue = null;
        int startIndex = 0;
        int endIndex = 0;
        int lastIndex = 0;
        for (String currentKey2 : this.m_queries.keySet()) {
            currentValue = this.m_queries.get(currentKey2);
            startIndex = 0;
            endIndex = 0;
            lastIndex = 0;
            while ((startIndex = currentValue.indexOf("${", lastIndex)) != -1) {
                endIndex = currentValue.indexOf(125, startIndex);
                if (endIndex != -1 && !currentValue.startsWith(QUERY_PROJECT_SEARCH_PATTERN, startIndex - 1)) {
                    String replaceKey = currentValue.substring(startIndex + 2, endIndex);
                    String searchPattern = currentValue.substring(startIndex, endIndex + 1);
                    String replacePattern = this.readQuery(replaceKey);
                    if (replacePattern != null) {
                        currentValue = CmsStringUtil.substitute(currentValue, searchPattern, replacePattern);
                    }
                }
                lastIndex = endIndex + 2;
            }
            this.m_queries.put(currentKey2, currentValue);
        }
    }

    private String prepareQueryParameters(String query) {
        return this.prepareQueryParameters(query, true);
    }

    private String prepareQueryParameters(String query, boolean cache) {
        String jpqlQuery = this.m_queriesWithParameters.get(query);
        if (jpqlQuery != null) {
            return jpqlQuery;
        }
        StringBuilder builder = new StringBuilder(query);
        int startPosition = 0;
        int currPosition = 0;
        int counter = 0;
        while ((currPosition = builder.indexOf(JPQL_PARAMETER_PLACEHOLDER, startPosition)) != -1) {
            builder.insert(currPosition + JPQL_PARAMETER_PLACEHOLDER_LENGTH, ++counter);
            startPosition = currPosition + JPQL_PARAMETER_PLACEHOLDER_LENGTH + (counter < 10 ? 1 : 2);
        }
        jpqlQuery = builder.toString();
        if (cache) {
            this.m_queriesWithParameters.put(query, jpqlQuery);
        }
        return jpqlQuery;
    }

    static {
        JPQL_PARAMETER_PLACEHOLDER_LENGTH = JPQL_PARAMETER_PLACEHOLDER.length();
        LOG = CmsLog.getLog(CmsSqlManager.class);
        m_factoryTable = new Hashtable();
        m_trackOn = new Hashtable();
    }
}

