/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.log;

import java.util.Locale;
import org.opencms.db.Messages;
import org.opencms.i18n.CmsMessages;
import org.opencms.main.CmsIllegalArgumentException;

public enum CmsLogEntryType {
    RESOURCE_ADD_RELATION(21, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_FROM_TO_2"),
    RESOURCE_CLONED(42, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_FROM_TO_2"),
    RESOURCE_CONTENT_MODIFIED(30, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_COPIED(41, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_FROM_TO_2"),
    RESOURCE_CREATED(40, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_DATE_EXPIRED(31, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_DATE_RELEASED(32, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_DELETED(43, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_FLAGS(35, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_HIDDEN(15, LogLevel.WARN, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_HISTORY(50, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_IMPORTED(45, LogLevel.DEBUG, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_MOVE_RESTORED(53, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_FROM_TO_2"),
    RESOURCE_MOVED(44, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_FROM_TO_2"),
    RESOURCE_PERMISSIONS(23, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_PROPERTIES(24, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_PUBLISHED_DELETED(13, LogLevel.FATAL, false, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_PUBLISHED_MODIFIED(11, LogLevel.FATAL, false, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_PUBLISHED_NEW(12, LogLevel.FATAL, false, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_CHANGES_UNDONE(14, LogLevel.FATAL, false, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_REMOVE_RELATION(22, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_AND_RELATION_FILTER_2"),
    RESOURCE_RESTORE_DELETED(51, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_RESTORED(54, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_TOUCHED(33, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_TYPE(34, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1"),
    RESOURCE_UNDELETED(52, LogLevel.INFO, true, "GUI_LOG_ENTRY_DETAIL_PATH_1");

    private String m_detailKey;
    private final int m_id;
    private boolean m_toPubList;

    private CmsLogEntryType(int id, LogLevel logLevel, boolean toPubList, String detailKey) {
        this.m_id = id;
        this.m_toPubList = toPubList;
        this.m_detailKey = detailKey;
    }

    public static CmsLogEntryType valueOf(int id) throws CmsIllegalArgumentException {
        for (CmsLogEntryType type : CmsLogEntryType.values()) {
            if (id != type.getId()) continue;
            return type;
        }
        throw new CmsIllegalArgumentException(Messages.get().container("ERR_MODE_ENUM_PARSE_2", new Integer(id), CmsLogEntryType.class.getName()));
    }

    public String getDetailKey() {
        return this.m_detailKey;
    }

    public int getId() {
        return this.m_id;
    }

    public String getLocalizedName(CmsMessages messages) {
        String nameKey = "GUI_LOG_ENTRY_TYPE_" + this.name() + "_0";
        return messages.key(nameKey);
    }

    public String getLocalizedName(Locale locale) {
        return this.getLocalizedName(org.opencms.db.log.Messages.get().getBundle(locale));
    }

    public boolean isActive() {
        return true;
    }

    public boolean isToPubList() {
        return this.m_toPubList;
    }

    private static enum LogLevel {
        DEBUG,
        ERROR,
        FATAL,
        INFO,
        TRACE,
        WARN;

    }
}

