/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.I_CmsResource;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.CmsCollectorData;
import org.opencms.file.collectors.Messages;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;

public class CmsDefaultResourceCollector
extends A_CmsResourceCollector {
    private static final String[] COLLECTORS = new String[]{"singleFile", "allInFolder", "allInFolderDateReleasedDesc", "allInFolderNavPos", "allInSubTree", "allInSubTreeDateReleasedDesc", "allInSubTreeNavPos"};
    private static final List<String> COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList(COLLECTORS));
    private static final Log LOG = CmsLog.getLog(CmsDefaultResourceCollector.class);

    @Override
    public List<String> getCollectorNames() {
        return COLLECTORS_LIST;
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: {
                return this.getCreateInFolder(cms, param);
            }
            case 4: 
            case 5: 
            case 6: {
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) throws CmsDataAccessException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: {
                return param;
            }
            case 4: 
            case 5: 
            case 6: {
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public int getCreateTypeId(CmsObject cms, String collectorName, String param) {
        int result = -1;
        if (param != null) {
            result = new CmsCollectorData(param).getType();
        }
        return result;
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String param) throws CmsDataAccessException, CmsException {
        if (collectorName == null) {
            collectorName = COLLECTORS[0];
        }
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: {
                return this.getSingleFile(cms, param);
            }
            case 1: {
                return this.getAllInFolder(cms, param, false);
            }
            case 2: {
                return this.allInFolderDateReleasedDesc(cms, param, false);
            }
            case 3: {
                return this.allInFolderNavPos(cms, param, false);
            }
            case 4: {
                return this.getAllInFolder(cms, param, true);
            }
            case 5: {
                return this.allInFolderDateReleasedDesc(cms, param, true);
            }
            case 6: {
                return this.allInFolderNavPos(cms, param, true);
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    protected List<CmsResource> allInFolderDateReleasedDesc(CmsObject cms, String param, boolean tree) throws CmsException {
        CmsCollectorData data = new CmsCollectorData(param);
        String foldername = CmsResource.getFolderPath(data.getFileName());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT_FILES.addRequireType(data.getType()).addExcludeFlags(1024);
        List<CmsResource> result = cms.readResources(foldername, filter, tree);
        Collections.sort(result, I_CmsResource.COMPARE_DATE_RELEASED);
        return this.shrinkToFit(result, data.getCount());
    }

    protected List<CmsResource> allInFolderNavPos(CmsObject cms, String param, boolean readSubTree) throws CmsException {
        CmsCollectorData data = new CmsCollectorData(param);
        String foldername = CmsResource.getFolderPath(data.getFileName());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT_FILES.addRequireType(data.getType()).addExcludeFlags(1024);
        List<CmsResource> foundResources = cms.readResources(foldername, filter, readSubTree);
        CmsJspNavBuilder navBuilder = new CmsJspNavBuilder(cms);
        HashMap<CmsJspNavElement, CmsResource> navElementMap = new HashMap<CmsJspNavElement, CmsResource>();
        int n = foundResources.size();
        for (int i = 0; i < n; ++i) {
            CmsResource resource = foundResources.get(i);
            CmsJspNavElement navElement = navBuilder.getNavigationForResource(cms.getSitePath(resource));
            if (navElement != null && navElement.getNavPosition() != Float.MAX_VALUE) {
                navElementMap.put(navElement, resource);
                continue;
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)Messages.get().getBundle().key("LOG_RESOURCE_WITHOUT_NAVPROP_1", cms.getSitePath(resource)));
        }
        ArrayList navElementList = new ArrayList(navElementMap.keySet());
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        Collections.sort(navElementList);
        int n2 = navElementList.size();
        for (int i = 0; i < n2; ++i) {
            CmsJspNavElement navElement = (CmsJspNavElement)navElementList.get(i);
            result.add((CmsResource)navElementMap.get(navElement));
        }
        return this.shrinkToFit(result, data.getCount());
    }

    protected List<CmsResource> getAllInFolder(CmsObject cms, String param, boolean tree) throws CmsException, CmsIllegalArgumentException {
        CmsCollectorData data = new CmsCollectorData(param);
        String foldername = CmsResource.getFolderPath(data.getFileName());
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT_FILES.addRequireType(data.getType()).addExcludeFlags(1024);
        List<CmsResource> result = cms.readResources(foldername, filter, tree);
        Collections.sort(result, I_CmsResource.COMPARE_ROOT_PATH);
        Collections.reverse(result);
        return this.shrinkToFit(result, data.getCount());
    }

    protected List<CmsResource> getSingleFile(CmsObject cms, String param) throws CmsException {
        if (param == null || cms == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_COLLECTOR_PARAM_SINGLE_FILE_0"));
        }
        ArrayList<CmsResource> result = new ArrayList<CmsResource>(1);
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            result.add(cms.readFile(param));
        } else {
            result.add(cms.readFile(param, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        return result;
    }
}

