/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.collectors.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsSearchManager;
import org.opencms.search.solr.CmsSolrIndex;
import org.opencms.search.solr.CmsSolrQuery;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSolrCollector
extends A_CmsResourceCollector {
    private static final String[] COLLECTORS = new String[]{"byQuery", "byContext"};
    private static final List<String> COLLECTORS_LIST = Collections.unmodifiableList(Arrays.asList(COLLECTORS));
    private static final String PARAM_CREATE_PATH = "createPath=";

    @Override
    public List<String> getCollectorNames() {
        return COLLECTORS_LIST;
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) throws CmsException {
        collectorName = collectorName == null ? COLLECTORS[1] : collectorName;
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: 
            case 1: {
                String path;
                int idx;
                int lastPipe = param.lastIndexOf(124);
                if (lastPipe > 0 && (idx = param.indexOf(PARAM_CREATE_PATH, lastPipe)) > 0 && CmsStringUtil.isNotEmptyOrWhitespaceOnly(path = param.substring(idx + PARAM_CREATE_PATH.length()))) {
                    return OpenCms.getResourceManager().getNameGenerator().getNewFileName(cms, path, 4);
                }
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) throws CmsDataAccessException {
        collectorName = collectorName == null ? COLLECTORS[1] : collectorName;
        switch (COLLECTORS_LIST.indexOf(collectorName)) {
            case 0: 
            case 1: {
                String solrParams = null;
                if (param.indexOf(124) > 0) {
                    int idx;
                    solrParams = param.substring(0, param.indexOf(124));
                    CmsSolrQuery q = new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(solrParams));
                    String type = CmsSolrQuery.getResourceType(q.getFilterQueries());
                    int lastPipe = param.lastIndexOf(124);
                    if (lastPipe > 0 && (idx = param.indexOf(PARAM_CREATE_PATH, lastPipe)) > 0) {
                        String path = param.substring(idx + PARAM_CREATE_PATH.length());
                        if (type != null && path != null) {
                            return param;
                        }
                    }
                }
                return null;
            }
        }
        throw new CmsDataAccessException(Messages.get().container("ERR_COLLECTOR_NAME_INVALID_1", collectorName));
    }

    @Override
    public int getCreateTypeId(CmsObject cms, String collectorName, String param) throws CmsException {
        String solrParams;
        CmsSolrQuery q;
        String type;
        int result = -1;
        if (param.indexOf(124) > 0 && (type = CmsSolrQuery.getResourceType((q = new CmsSolrQuery(null, CmsRequestUtil.createParameterMap(solrParams = param.substring(0, param.indexOf(124))))).getFilterQueries())) != null) {
            result = OpenCms.getResourceManager().getResourceType(type).getTypeId();
        }
        return result;
    }

    @Override
    public List<CmsResource> getResults(CmsObject cms, String name, String param) throws CmsException {
        String string = name = name == null ? COLLECTORS[1] : name;
        if (param != null && param.indexOf(124) != -1) {
            param = param.substring(0, param.indexOf(124));
        }
        Map<String, String[]> pm = CmsRequestUtil.createParameterMap(param);
        CmsSolrIndex index = CmsSearchManager.getIndexSolr(cms, pm);
        CmsSolrQuery q = COLLECTORS_LIST.indexOf(name) == 0 ? new CmsSolrQuery(null, pm) : new CmsSolrQuery(cms, pm);
        return new ArrayList<CmsResource>(index.search(cms, q, true));
    }
}

