/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.wrapper;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opencms.db.Messages;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.wrapper.A_CmsResourceWrapper;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.security.CmsPermissionViolationException;
import org.opencms.util.CmsStringUtil;

public class CmsResourceWrapperPreventCreateNameCI
extends A_CmsResourceWrapper {
    public static final String NAME_SEPARATOR = "|";
    private Set<String> m_disabledNames = new HashSet<String>();

    @Override
    public void configure(String configString) {
        List<String> tokens = CmsStringUtil.splitAsList(configString, NAME_SEPARATOR);
        for (String token : tokens) {
            this.m_disabledNames.add(token.trim().toLowerCase());
        }
    }

    @Override
    public CmsResource createResource(CmsObject cms, String resourcepath, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        String name = CmsResource.getName(resourcepath);
        if (this.m_disabledNames.contains(name.toLowerCase())) {
            throw new CmsPermissionViolationException(Messages.get().container("ERR_PERM_DENIED_2", resourcepath, "+c"));
        }
        return null;
    }

    @Override
    public boolean isWrappedResource(CmsObject cms, CmsResource res) {
        return false;
    }

    @Override
    public boolean moveResource(CmsObject cms, String source, String destination) throws CmsException, CmsIllegalArgumentException {
        String name = CmsResource.getName(destination);
        if (this.m_disabledNames.contains(name)) {
            throw new CmsPermissionViolationException(Messages.get().container("ERR_PERM_DENIED_2", destination, "+c"));
        }
        return false;
    }
}

