/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.flex;

import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequestDispatcher;
import org.opencms.flex.CmsFlexRequestKey;
import org.opencms.flex.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsJspLoader;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsParameterEscaper;
import org.opencms.util.CmsRequestUtil;

public class CmsFlexRequest
extends HttpServletRequestWrapper {
    public static final String PARAMETER_FLEX = "_flex";
    private static final Log LOG = CmsLog.getLog(CmsFlexRequest.class);
    private static CmsJspLoader m_jspLoader;
    private Map<String, Object> m_attributes;
    private boolean m_canCache;
    private CmsParameterEscaper m_escaper;
    private CmsFlexController m_controller;
    private boolean m_doRecompile;
    private String m_elementUri;
    private String m_elementUriSiteRoot;
    private List<String> m_includeCalls;
    private boolean m_isOnline;
    private CmsFlexRequestKey m_key;
    private Map<String, String[]> m_parameters;
    private String m_requestUri;
    private StringBuffer m_requestUrl;

    public CmsFlexRequest(HttpServletRequest req, CmsFlexController controller) {
        super(req);
        this.m_controller = controller;
        CmsObject cms = this.m_controller.getCmsObject();
        this.m_elementUri = cms.getSitePath(this.m_controller.getCmsResource());
        this.m_elementUriSiteRoot = cms.getRequestContext().getSiteRoot();
        this.m_includeCalls = new Vector<String>();
        this.m_parameters = CmsCollectionsGenericWrapper.map(req.getParameterMap());
        this.m_attributes = CmsRequestUtil.getAtrributeMap((ServletRequest)req);
        this.m_isOnline = cms.getRequestContext().getCurrentProject().isOnlineProject();
        String[] params = req.getParameterValues(PARAMETER_FLEX);
        boolean nocachepara = CmsHistoryResourceHandler.isHistoryRequest((ServletRequest)req);
        boolean dorecompile = false;
        if (params != null && OpenCms.getRoleManager().hasRole(cms, CmsRole.WORKPLACE_MANAGER)) {
            List<String> paramList = Arrays.asList(params);
            boolean firstCall = controller.isEmptyRequestList();
            nocachepara |= paramList.contains("nocache");
            dorecompile = paramList.contains("recompile");
            boolean p_on = paramList.contains("online");
            boolean p_off = paramList.contains("offline");
            if (paramList.contains("purge") && firstCall) {
                OpenCms.fireCmsEvent(new CmsEvent(8, new HashMap<String, Object>(0)));
                OpenCms.fireCmsEvent(new CmsEvent(9, Collections.singletonMap("action", new Integer(1))));
                dorecompile = false;
            } else if ((paramList.contains("clearcache") || dorecompile) && firstCall) {
                if (!p_on && !p_off) {
                    OpenCms.fireCmsEvent(new CmsEvent(9, Collections.singletonMap("action", new Integer(0))));
                } else {
                    if (p_on) {
                        OpenCms.fireCmsEvent(new CmsEvent(9, Collections.singletonMap("action", new Integer(2))));
                    }
                    if (p_off) {
                        OpenCms.fireCmsEvent(new CmsEvent(9, Collections.singletonMap("action", new Integer(4))));
                    }
                }
            } else if (paramList.contains("clearvariations") && firstCall) {
                if (!p_on && !p_off) {
                    OpenCms.fireCmsEvent(new CmsEvent(9, Collections.singletonMap("action", new Integer(1))));
                } else {
                    if (p_on) {
                        OpenCms.fireCmsEvent(new CmsEvent(9, Collections.singletonMap("action", new Integer(3))));
                    }
                    if (p_off) {
                        OpenCms.fireCmsEvent(new CmsEvent(9, Collections.singletonMap("action", new Integer(5))));
                    }
                }
            }
        }
        this.m_canCache = (this.m_isOnline && this.m_controller.getCmsCache().isEnabled() || !this.m_isOnline && this.m_controller.getCmsCache().cacheOffline()) && !nocachepara || dorecompile;
        this.m_doRecompile = dorecompile;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUEST_CREATED_NEW_REQUEST_1", this.m_elementUri));
        }
    }

    CmsFlexRequest(HttpServletRequest req, CmsFlexController controller, String resource) {
        super(req);
        this.m_controller = controller;
        this.m_elementUri = CmsLinkManager.getAbsoluteUri(resource, this.m_controller.getCurrentRequest().getElementUri());
        this.m_elementUriSiteRoot = this.m_controller.getCurrentRequest().m_elementUriSiteRoot;
        this.m_isOnline = this.m_controller.getCurrentRequest().isOnline();
        this.m_canCache = this.m_controller.getCurrentRequest().isCacheable();
        this.m_doRecompile = this.m_controller.getCurrentRequest().isDoRecompile();
        this.m_includeCalls = this.m_controller.getCurrentRequest().getCmsIncludeCalls();
        this.m_parameters = CmsCollectionsGenericWrapper.map(req.getParameterMap());
        this.m_attributes = CmsRequestUtil.getAtrributeMap((ServletRequest)req);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_FLEXREQUEST_REUSING_FLEX_REQUEST_1", this.m_elementUri));
        }
    }

    public Map<String, Object> addAttributeMap(Map<String, Object> map) {
        if (map == null) {
            return this.m_attributes;
        }
        if (this.m_attributes == null || this.m_attributes.size() == 0) {
            this.m_attributes = new HashMap<String, Object>(map);
        } else {
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.putAll(this.m_attributes);
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                String key = entry.getKey();
                if ("org.opencms.flex.CmsFlexController".equals(key)) continue;
                if ("cms".equals(key)) {
                    CmsJspStandardContextBean bean = (CmsJspStandardContextBean)entry.getValue();
                    bean.updateCmsObject(this.m_controller.getCmsObject());
                    bean.updateRequestData(this);
                }
                attributes.put(key, entry.getValue());
            }
            this.m_attributes = new HashMap<String, Object>(attributes);
        }
        return this.m_attributes;
    }

    public Map<String, String[]> addParameterMap(Map<String, String[]> map) {
        if (map == null) {
            return this.m_parameters;
        }
        if (this.m_parameters == null || this.m_parameters.size() == 0) {
            this.m_parameters = Collections.unmodifiableMap(map);
        } else {
            HashMap<String, String[]> parameters = new HashMap<String, String[]>();
            parameters.putAll(this.m_parameters);
            for (Map.Entry<String, String[]> entry : map.entrySet()) {
                String key = entry.getKey();
                if (parameters.containsKey(key)) {
                    String[] oldValues = (String[])parameters.get(key);
                    String[] newValues = entry.getValue();
                    String[] mergeValues = new String[oldValues.length + newValues.length];
                    System.arraycopy(newValues, 0, mergeValues, 0, newValues.length);
                    System.arraycopy(oldValues, 0, mergeValues, newValues.length, oldValues.length);
                    parameters.put(key, mergeValues);
                    continue;
                }
                parameters.put(key, entry.getValue());
            }
            this.m_parameters = Collections.unmodifiableMap(parameters);
        }
        return this.m_parameters;
    }

    public void enableParameterEscaping() {
        if (this.m_escaper == null) {
            LOG.info((Object)"Enabling parameter escaping for the current flex request");
            this.m_escaper = new CmsParameterEscaper();
        }
    }

    public Object getAttribute(String name) {
        Object object = this.m_attributes.get(name);
        if (object == null) {
            object = super.getAttribute(name);
        }
        return object;
    }

    public Map<String, Object> getAttributeMap() {
        return this.m_attributes;
    }

    public Enumeration<String> getAttributeNames() {
        Vector<String> v = new Vector<String>();
        v.addAll(this.m_attributes.keySet());
        return v.elements();
    }

    public String getElementRootPath() {
        return this.m_controller.getCmsObject().getRequestContext().addSiteRoot(this.m_elementUriSiteRoot, this.m_elementUri);
    }

    public String getElementUri() {
        return this.m_elementUri;
    }

    public String getParameter(String name) {
        String[] values = this.m_parameters.get(name);
        if (values != null) {
            if (this.m_escaper != null) {
                return this.m_escaper.escape(name, values[0]);
            }
            return values[0];
        }
        return null;
    }

    public CmsParameterEscaper getParameterEscaper() {
        return this.m_escaper;
    }

    public Map<String, String[]> getParameterMap() {
        return this.m_parameters;
    }

    public Enumeration<String> getParameterNames() {
        Vector<String> v = new Vector<String>();
        v.addAll(this.m_parameters.keySet());
        return v.elements();
    }

    public String[] getParameterValues(String name) {
        if (this.m_escaper != null) {
            return this.m_escaper.escape(name, this.m_parameters.get(name));
        }
        return this.m_parameters.get(name);
    }

    public RequestDispatcher getRequestDispatcher(String target) {
        String absolutUri = CmsLinkManager.getAbsoluteUri(target, this.m_controller.getCurrentRequest().getElementUri());
        return new CmsFlexRequestDispatcher(this.m_controller.getTopRequest().getRequestDispatcher(absolutUri), absolutUri, null);
    }

    public CmsFlexRequestDispatcher getRequestDispatcherToExternal(String vfs_target, String ext_target) {
        return new CmsFlexRequestDispatcher(this.m_controller.getTopRequest().getRequestDispatcher(ext_target), CmsLinkManager.getAbsoluteUri(vfs_target, this.m_controller.getCmsObject().getRequestContext().getUri()), ext_target);
    }

    public String getRequestURI() {
        if (this.m_requestUri != null) {
            return this.m_requestUri;
        }
        StringBuffer buf = new StringBuffer(128);
        buf.append(OpenCms.getSystemInfo().getOpenCmsContext());
        buf.append(this.getElementUri());
        this.m_requestUri = buf.toString();
        return this.m_requestUri;
    }

    public StringBuffer getRequestURL() {
        if (this.m_requestUrl != null) {
            return this.m_requestUrl;
        }
        StringBuffer buf = new StringBuffer(128);
        buf.append(this.getScheme());
        buf.append("://");
        buf.append(this.getServerName());
        buf.append(":");
        buf.append(this.getServerPort());
        buf.append(this.getRequestURI());
        this.m_requestUrl = buf;
        return this.m_requestUrl;
    }

    public String getServletPath() {
        ServletRequest req = this.getRequest();
        while (req instanceof CmsFlexRequest) {
            req = ((CmsFlexRequest)req).getRequest();
        }
        String servletPath = null;
        servletPath = req instanceof HttpServletRequest ? ((HttpServletRequest)req).getServletPath() : super.getServletPath();
        CmsJspLoader jspLoader = this.getJspLoader();
        if (jspLoader != null) {
            jspLoader.updateJspFromRequest(servletPath, this);
        }
        return servletPath;
    }

    public boolean isDoRecompile() {
        return this.m_doRecompile;
    }

    public boolean isOnline() {
        return this.m_isOnline;
    }

    public void removeAttribute(String name) {
        this.m_attributes.remove(name);
        this.m_controller.getTopRequest().removeAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        this.m_attributes.put(name, value);
        this.m_controller.getTopRequest().setAttribute(name, value);
    }

    public void setAttributeMap(Map<String, Object> map) {
        this.m_attributes = new HashMap<String, Object>(map);
    }

    public void setParameterMap(Map<String, String[]> map) {
        this.m_parameters = map;
    }

    public String toString() {
        return this.m_elementUri;
    }

    protected List<String> getCmsIncludeCalls() {
        return this.m_includeCalls;
    }

    protected CmsJspLoader getJspLoader() {
        if (m_jspLoader == null) {
            try {
                m_jspLoader = (CmsJspLoader)OpenCms.getResourceManager().getLoader(6);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return m_jspLoader;
    }

    void addInlucdeCall(String target) {
        this.m_includeCalls.add(target);
    }

    boolean containsIncludeCall(String target) {
        return this.m_includeCalls.contains(target);
    }

    CmsFlexRequestKey getCmsCacheKey() {
        if (this.m_key == null) {
            this.m_key = new CmsFlexRequestKey((HttpServletRequest)this, this.m_elementUri, this.m_isOnline);
        }
        return this.m_key;
    }

    boolean isCacheable() {
        return this.m_canCache;
    }

    void removeIncludeCall(String target) {
        this.m_includeCalls.remove(target);
    }
}

