/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.inherited.CmsInheritanceGroupUtils;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.Messages;
import org.opencms.gwt.shared.CmsBrokenLinkBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;

public class CmsBrokenLinkRenderer {
    private static final Log LOG = CmsLog.getLog(CmsBrokenLinkRenderer.class);
    private CmsObject m_cms;

    public CmsBrokenLinkRenderer(CmsObject cms) {
        this.m_cms = cms;
    }

    public List<CmsBrokenLinkBean> renderBrokenLink(CmsResource target, CmsResource source) throws CmsException {
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(source);
        String typeName = resType.getTypeName();
        if (typeName.equals("inheritance_config")) {
            return this.renderBrokenLinkInheritanceGroup(target, source);
        }
        if ("groupcontainer".equals(typeName)) {
            return this.renderBrokenLinkGroupContainer(target, source);
        }
        return this.renderBrokenLinkDefault(target, source);
    }

    public List<CmsBrokenLinkBean> renderBrokenLinkDefault(CmsResource target, CmsResource source) throws CmsException {
        ArrayList<CmsBrokenLinkBean> result = new ArrayList<CmsBrokenLinkBean>();
        result.add(this.createSitemapBrokenLinkBean(source));
        return result;
    }

    public List<CmsBrokenLinkBean> renderBrokenLinkGroupContainer(CmsResource target, CmsResource source) throws CmsException {
        ArrayList<CmsBrokenLinkBean> result = new ArrayList<CmsBrokenLinkBean>();
        CmsBrokenLinkBean brokenLinkBean = this.createSitemapBrokenLinkBean(source);
        result.add(brokenLinkBean);
        try {
            CmsResource referencingPage = this.findReferencingPage(source);
            if (referencingPage != null) {
                String pagePath = this.m_cms.getRequestContext().removeSiteRoot(referencingPage.getRootPath());
                String title = CmsResource.getName(pagePath);
                CmsProperty titleProp = this.m_cms.readPropertyObject(referencingPage, "Title", false);
                if (!titleProp.isNullProperty()) {
                    title = titleProp.getValue();
                }
                this.addPageInfo(brokenLinkBean, title, pagePath);
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    public List<CmsBrokenLinkBean> renderBrokenLinkInheritanceGroup(CmsResource target, CmsResource source) throws CmsException {
        ArrayList<CmsBrokenLinkBean> result = new ArrayList<CmsBrokenLinkBean>();
        try {
            Set<String> names = CmsInheritanceGroupUtils.getNamesOfGroupsContainingResource(this.m_cms, source, target);
            if (!names.isEmpty()) {
                for (String name : names) {
                    String title = null;
                    String path = null;
                    String extraTitle = null;
                    String extraPath = null;
                    CmsResource group = CmsInheritanceGroupUtils.getInheritanceGroupContentByName(this.m_cms, name);
                    String groupParent = CmsResource.getParentFolder(source.getRootPath());
                    CmsProperty titleProp = this.m_cms.readPropertyObject(group, "Title", false);
                    title = CmsResource.getName(group.getRootPath());
                    if (!titleProp.isNullProperty()) {
                        title = titleProp.getValue();
                    }
                    path = this.m_cms.getRequestContext().removeSiteRoot(source.getRootPath());
                    List<CmsRelation> relations = this.m_cms.readRelations(CmsRelationFilter.relationsToStructureId(group.getStructureId()));
                    ArrayList<CmsResource> referencingPages = new ArrayList<CmsResource>();
                    for (CmsRelation relation : relations) {
                        CmsResource relSource = relation.getSource(this.m_cms, CmsResourceFilter.ALL);
                        String pageParent = CmsResource.getParentFolder(relSource.getRootPath());
                        if (!CmsResourceTypeXmlContainerPage.isContainerPage(relSource) || !pageParent.equals(groupParent)) continue;
                        referencingPages.add(relSource);
                    }
                    if (!referencingPages.isEmpty()) {
                        CmsResource firstPage = (CmsResource)referencingPages.get(0);
                        extraPath = this.m_cms.getRequestContext().removeSiteRoot(firstPage.getRootPath());
                        extraTitle = this.m_cms.readPropertyObject(firstPage, "Title", true).getValue();
                    }
                    result.add(this.createBrokenLinkBean("inheritance_config", title, path, extraTitle, extraPath));
                }
            } else {
                result.add(this.createSitemapBrokenLinkBean(source));
            }
        }
        catch (CmsException e) {
            result.add(this.createSitemapBrokenLinkBean(source));
        }
        return result;
    }

    protected void addPageInfo(CmsBrokenLinkBean bean, String extraTitle, String extraPath) {
        if (extraTitle != null) {
            bean.addInfo(this.messagePageTitle(), "" + extraTitle);
        }
        if (extraPath != null) {
            bean.addInfo(this.messagePagePath(), "" + extraPath);
        }
    }

    protected CmsBrokenLinkBean createBrokenLinkBean(String type, String title, String path, String extraTitle, String extraPath) {
        CmsBrokenLinkBean result = new CmsBrokenLinkBean(title, path, type);
        this.addPageInfo(result, extraTitle, extraPath);
        return result;
    }

    protected CmsBrokenLinkBean createSitemapBrokenLinkBean(CmsResource resource) throws CmsException {
        String path;
        CmsProperty titleProp = this.m_cms.readPropertyObject(resource, "Title", true);
        String typeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        String defaultTitle = CmsResource.getName(resource.getRootPath());
        String title = titleProp.getValue(defaultTitle);
        String subtitle = path = this.m_cms.getSitePath(resource);
        return new CmsBrokenLinkBean(title, subtitle, typeName);
    }

    private CmsResource findReferencingPage(CmsResource source) throws CmsException {
        List<CmsRelation> relationsToFile = this.m_cms.readRelations(CmsRelationFilter.relationsToStructureId(source.getStructureId()));
        for (CmsRelation relation : relationsToFile) {
            try {
                CmsResource referencingPage = relation.getSource(this.m_cms, CmsResourceFilter.DEFAULT);
                if (!CmsResourceTypeXmlContainerPage.isContainerPage(referencingPage)) continue;
                return referencingPage;
            }
            catch (CmsException e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    private Locale getLocale() {
        return OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
    }

    private String messagePagePath() {
        return Messages.get().getBundle(this.getLocale()).key("GUI_DEPENDENCY_PAGE_PATH_0");
    }

    private String messagePageTitle() {
        return Messages.get().getBundle(this.getLocale()).key("GUI_DEPENDENCY_PAGE_TITLE_0");
    }
}

