/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsI18nInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.I_CmsLocaleHandler;
import org.opencms.i18n.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;

public class CmsDefaultLocaleHandler
implements I_CmsLocaleHandler {
    private static final Log LOG = CmsLog.getLog(CmsDefaultLocaleHandler.class);
    private CmsObject m_adminCmsObject;

    @Override
    public CmsI18nInfo getI18nInfo(HttpServletRequest req, CmsUser user, CmsProject project, String resourceName) {
        String encoding;
        List<Locale> defaultLocales;
        CmsLocaleManager localeManager;
        block19: {
            localeManager = OpenCms.getLocaleManager();
            defaultLocales = null;
            encoding = null;
            CmsObject adminCms = null;
            try {
                adminCms = OpenCms.initCmsObject(this.m_adminCmsObject);
            }
            catch (CmsException e) {
                // empty catch block
            }
            if (adminCms != null) {
                adminCms.getRequestContext().setCurrentProject(project);
                adminCms.getRequestContext().setUri(resourceName);
                CmsResource res = null;
                try {
                    res = adminCms.readResource(resourceName, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (CmsException e) {
                    // empty catch block
                }
                if (res == null) {
                    try {
                        res = OpenCms.initResource(adminCms, resourceName, req, null);
                    }
                    catch (CmsException e) {
                        // empty catch block
                    }
                }
                String defaultNames = null;
                if (res != null) {
                    try {
                        defaultNames = adminCms.readPropertyObject(res, "locale", true).getValue();
                    }
                    catch (CmsException e) {
                        LOG.warn((Object)Messages.get().getBundle().key("ERR_READ_ENCODING_PROP_1", resourceName), (Throwable)e);
                    }
                    if (defaultNames != null) {
                        defaultLocales = localeManager.getAvailableLocales(defaultNames);
                    }
                    try {
                        encoding = adminCms.readPropertyObject(res, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
                    }
                    catch (CmsException e) {
                        if (!LOG.isInfoEnabled()) break block19;
                        LOG.info((Object)Messages.get().getBundle().key("ERR_READ_ENCODING_PROP_1", resourceName), (Throwable)e);
                    }
                }
            }
        }
        if (defaultLocales == null || defaultLocales.isEmpty()) {
            defaultLocales = localeManager.getDefaultLocales();
        }
        if (encoding == null) {
            encoding = OpenCms.getSystemInfo().getDefaultEncoding();
        }
        if (req != null) {
            try {
                req.setCharacterEncoding(encoding);
            }
            catch (UnsupportedEncodingException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_UNSUPPORTED_REQUEST_ENCODING_1", encoding), (Throwable)e);
            }
        }
        Locale locale = defaultLocales != null && defaultLocales.size() > 0 ? defaultLocales.get(0) : CmsLocaleManager.getDefaultLocale();
        return new CmsI18nInfo(locale, encoding);
    }

    @Override
    public void initHandler(CmsObject cms) {
        this.m_adminCmsObject = cms;
    }
}

