/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.i18n;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.i18n.CmsVfsBundleParameters;
import org.opencms.i18n.CmsVfsResourceBundle;
import org.opencms.i18n.I_CmsResourceBundle;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsVfsBundleManager {
    public static final String TYPE_PROPERTIES_BUNDLE = "propertyvfsbundle";
    public static final String TYPE_XML_BUNDLE = "xmlvfsbundle";
    protected static final Log LOG = CmsLog.getLog(CmsVfsBundleManager.class);
    private Set<String> m_bundleBaseNames;
    private CmsObject m_cms;
    private Listener m_eventListener = new Listener();
    private boolean m_logToErrorChannel;

    public CmsVfsBundleManager(CmsObject cms) {
        this.m_cms = cms;
        this.m_bundleBaseNames = new HashSet<String>();
        CmsVfsResourceBundle.setCmsObject(cms);
        OpenCms.getEventManager().addCmsEventListener(new Listener(), new int[]{2, 5});
    }

    private static Collection<Locale> getAllLocales() {
        HashSet<Locale> result = new HashSet<Locale>();
        result.addAll(OpenCms.getWorkplaceManager().getLocales());
        result.addAll(OpenCms.getLocaleManager().getAvailableLocales());
        return result;
    }

    public Listener getEventListener() {
        return this.m_eventListener;
    }

    public synchronized void reload(boolean isStartup) {
        this.m_logToErrorChannel = isStartup;
        this.flushBundles();
        try {
            int xmlType = OpenCms.getResourceManager().getResourceType(TYPE_XML_BUNDLE).getTypeId();
            List<CmsResource> xmlBundles = this.m_cms.readResources("/", CmsResourceFilter.ALL.addRequireType(xmlType), true);
            for (CmsResource xmlBundle : xmlBundles) {
                this.addXmlBundle(xmlBundle);
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
        try {
            int propType = OpenCms.getResourceManager().getResourceType(TYPE_PROPERTIES_BUNDLE).getTypeId();
            List<CmsResource> propertyBundles = this.m_cms.readResources("/", CmsResourceFilter.ALL.addRequireType(propType), true);
            for (CmsResource propertyBundle : propertyBundles) {
                this.addPropertyBundle(propertyBundle);
            }
        }
        catch (Exception e) {
            this.logError(e);
        }
    }

    protected CmsObject getCmsObject() {
        return this.m_cms;
    }

    protected void logError(Exception e) {
        if (this.m_logToErrorChannel) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        } else {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void addBundle(String baseName, Locale locale, I_CmsResourceBundle bundle) {
        CmsResourceBundleLoader.addBundleToCache(baseName, locale, bundle);
    }

    private void addPropertyBundle(CmsResource bundleResource) {
        NameAndLocale nameAndLocale = this.getNameAndLocale(bundleResource);
        Locale locale = nameAndLocale.getLocale();
        String baseName = nameAndLocale.getName();
        this.m_bundleBaseNames.add(baseName);
        LOG.info((Object)String.format("Adding property VFS bundle (path=%s, name=%s, locale=%s)", bundleResource.getRootPath(), baseName, "" + locale));
        Locale paramLocale = locale != null ? locale : CmsLocaleManager.getDefaultLocale();
        CmsVfsBundleParameters params = new CmsVfsBundleParameters(nameAndLocale.getName(), bundleResource.getRootPath(), paramLocale, locale == null, "properties");
        CmsVfsResourceBundle bundle = new CmsVfsResourceBundle(params);
        this.addBundle(baseName, locale, bundle);
    }

    private void addXmlBundle(CmsResource xmlBundle) {
        String name = xmlBundle.getName();
        String path = xmlBundle.getRootPath();
        this.m_bundleBaseNames.add(name);
        LOG.info((Object)String.format("Adding property VFS bundle (path=%s, name=%s)", xmlBundle.getRootPath(), name));
        for (Locale locale : CmsVfsBundleManager.getAllLocales()) {
            CmsVfsBundleParameters params = new CmsVfsBundleParameters(name, path, locale, false, "xml");
            CmsVfsResourceBundle bundle = new CmsVfsResourceBundle(params);
            this.addBundle(name, locale, bundle);
        }
        CmsVfsBundleParameters params = new CmsVfsBundleParameters(name, path, CmsLocaleManager.getDefaultLocale(), true, "xml");
        CmsVfsResourceBundle defaultLocaleBundle = new CmsVfsResourceBundle(params);
        this.addBundle(name, null, defaultLocaleBundle);
    }

    private void flushBundles() {
        for (String baseName : this.m_bundleBaseNames) {
            CmsResourceBundleLoader.flushBundleCache(baseName, true);
        }
        this.m_bundleBaseNames.clear();
    }

    private NameAndLocale getNameAndLocale(CmsResource bundleRes) {
        String fileName = bundleRes.getName();
        if (TYPE_PROPERTIES_BUNDLE.equals(OpenCms.getResourceManager().getResourceType(bundleRes).getTypeName())) {
            String localeSuffix = CmsStringUtil.getLocaleSuffixForName(fileName);
            if (localeSuffix == null) {
                return new NameAndLocale(fileName, null);
            }
            String base = fileName.substring(0, fileName.lastIndexOf(localeSuffix) - 1);
            Locale locale = CmsLocaleManager.getLocale(localeSuffix);
            return new NameAndLocale(base, locale);
        }
        return new NameAndLocale(fileName, null);
    }

    public class NameAndLocale {
        private Locale m_locale;
        private String m_name;

        public NameAndLocale(String name, Locale locale) {
            this.m_name = name;
            this.m_locale = locale;
        }

        public Locale getLocale() {
            return this.m_locale;
        }

        public String getName() {
            return this.m_name;
        }
    }

    public class Listener
    implements I_CmsEventListener {
        @Override
        public void cmsEvent(CmsEvent event) {
            try {
                this.handleEvent(event);
            }
            catch (Throwable t) {
                LOG.error((Object)t.getLocalizedMessage(), t);
            }
        }

        private void handleEvent(CmsEvent event) {
            switch (event.getType()) {
                case 2: {
                    String publishIdStr = (String)event.getData().get("publishHistoryId");
                    if (publishIdStr == null) break;
                    CmsUUID publishId = new CmsUUID(publishIdStr);
                    try {
                        List<CmsPublishedResource> publishedResources = CmsVfsBundleManager.this.getCmsObject().readPublishedResources(publishId);
                        if (publishedResources.isEmpty()) {
                            this.scheduleReload();
                            break;
                        }
                        String[] typesToMatch = new String[]{CmsVfsBundleManager.TYPE_PROPERTIES_BUNDLE, CmsVfsBundleManager.TYPE_XML_BUNDLE};
                        boolean reload = false;
                        block5: for (CmsPublishedResource res : publishedResources) {
                            for (String typeName : typesToMatch) {
                                if (!OpenCms.getResourceManager().matchResourceType(typeName, res.getType())) continue;
                                reload = true;
                                continue block5;
                            }
                        }
                        if (!reload) break;
                        this.scheduleReload();
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    break;
                }
                default: {
                    this.scheduleReload();
                }
            }
        }

        private void scheduleReload() {
            Thread thread = new Thread(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    CmsVfsBundleManager.this.reload(false);
                }
            };
            thread.start();
        }
    }
}

