/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jlan;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import org.alfresco.jlan.server.auth.PasswordEncryptor;
import org.alfresco.jlan.server.auth.UserAccount;
import org.alfresco.jlan.server.auth.UsersInterface;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.springframework.extensions.config.ConfigElement;

public class CmsJlanUsers
implements UsersInterface {
    public static final String JLAN_HASH = "jlan_hash";
    private static final Log LOG = CmsLog.getLog(CmsJlanUsers.class);
    private static CmsObject m_adminCms;

    public static byte[] hashPassword(String password) throws InvalidKeyException, NoSuchAlgorithmException {
        PasswordEncryptor encryptor = new PasswordEncryptor();
        return encryptor.generateEncryptedPassword(password, null, 3, null, null);
    }

    public static void setAdminCms(CmsObject cms) {
        if (m_adminCms == null) {
            m_adminCms = cms;
        } else {
            LOG.warn((Object)"Can't set admin CmsObject twice!");
        }
    }

    public UserAccount getUserAccount(String userName) {
        try {
            CmsUser user = m_adminCms.readUser(userName);
            UserAccount account = new UserAccount(user.getName(), "");
            Object jlanHash = user.getAdditionalInfo(JLAN_HASH);
            if (jlanHash == null) {
                LOG.warn((Object)("JLAN: Could not log in user " + userName + " because of missing hash"));
                return null;
            }
            account.setMD4Password((byte[])jlanHash);
            return account;
        }
        catch (CmsException e) {
            return null;
        }
    }

    public void initializeUsers(ServerConfiguration config, ConfigElement params) {
    }
}

