/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.Map;
import org.apache.commons.collections.Transformer;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.jsp.util.CmsJspVfsAccessBean;
import org.opencms.jsp.util.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsCollectionsGenericWrapper;

public class CmsJspResourceAccessBean {
    private CmsObject m_cms;
    private CmsFile m_file;
    private Map<String, String> m_historyProperties;
    private Map<String, String> m_properties;
    private CmsResource m_resource;

    public CmsJspResourceAccessBean() {
    }

    public CmsJspResourceAccessBean(CmsObject cms, CmsResource resource) {
        this.init(cms, resource);
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public CmsFile getFile() {
        if (this.m_file == null) {
            try {
                this.m_file = this.m_cms.readFile(this.m_resource);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_FILE_READ_1", this.m_resource.getRootPath()), (Throwable)e);
            }
        }
        return this.m_file;
    }

    public String getFileContentAsString() {
        return new String(this.getFile().getContents());
    }

    public String getFilename() {
        return this.m_cms.getSitePath(this.m_resource);
    }

    public Map<String, String> getHistoryProperty() {
        return this.getReadHistoryProperties();
    }

    public Map<String, String> getProperty() {
        return this.getReadProperties();
    }

    public Map<String, String> getReadHistoryProperties() {
        if (this.m_historyProperties == null) {
            this.m_historyProperties = CmsCollectionsGenericWrapper.createLazyMap(new CmsHistoryPropertyLoaderTransformer(this.m_resource));
        }
        return this.m_historyProperties;
    }

    public Map<String, String> getReadProperties() {
        if (this.m_properties == null) {
            this.m_properties = CmsCollectionsGenericWrapper.createLazyMap(new CmsPropertyLoaderTransformer(this.m_resource));
        }
        return this.m_properties;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public CmsJspVfsAccessBean getVfs() {
        return CmsJspVfsAccessBean.create(this.m_cms);
    }

    public void init(CmsObject cms, CmsResource resource) {
        this.m_cms = cms;
        this.m_resource = resource;
    }

    private class CmsPropertyLoaderTransformer
    implements Transformer {
        private CmsResource m_res;

        public CmsPropertyLoaderTransformer(CmsResource resource) {
            this.m_res = resource;
        }

        public Object transform(Object input) {
            String result;
            try {
                result = CmsJspResourceAccessBean.this.getCmsObject().readPropertyObject(this.m_res, String.valueOf(input), false).getValue();
            }
            catch (CmsException e) {
                result = null;
            }
            return result;
        }
    }

    private class CmsHistoryPropertyLoaderTransformer
    implements Transformer {
        private I_CmsHistoryResource m_res;

        public CmsHistoryPropertyLoaderTransformer(CmsResource resource) {
            this.m_res = (I_CmsHistoryResource)((Object)resource);
        }

        public Object transform(Object input) {
            String result;
            try {
                result = CmsProperty.get(String.valueOf(input), CmsJspResourceAccessBean.this.getCmsObject().readHistoryPropertyObjects(this.m_res)).getValue();
            }
            catch (CmsException e) {
                result = null;
            }
            return result;
        }
    }
}

