/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.main;

import java.io.File;
import java.util.Properties;
import org.opencms.jsp.util.I_CmsJspDeviceSelector;
import org.opencms.mail.CmsMailSettings;
import org.opencms.main.CmsHttpAuthenticationSettings;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsServletContainerSettings;
import org.opencms.main.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSystemInfo {
    public static final String CONFIG_FOLDER_PROPERTY = "opencms.config";
    public static final String FILE_PERSISTENCE = "classes" + File.separatorChar + "META-INF" + File.separatorChar + "persistence.xml";
    public static final String FILE_PROPERTIES = "opencms.properties";
    public static final String FILE_TLD = "opencms.tld";
    public static final String FOLDER_CONFIG_DEFAULT = "config" + File.separatorChar;
    public static final String FOLDER_MODULES = "modules" + File.separatorChar;
    public static final String FOLDER_PACKAGES = "packages" + File.separatorChar;
    public static final String FOLDER_WEBINF = "WEB-INF" + File.separatorChar;
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_VERSION_NUMBER = "8.0.x";
    private String m_configurationFileRfsPath;
    private String m_defaultEncoding;
    private I_CmsJspDeviceSelector m_deviceSelector;
    private boolean m_historyEnabled;
    private int m_historyVersions;
    private int m_historyVersionsAfterDeletion;
    private CmsHttpAuthenticationSettings m_httpAuthenticationSettings;
    private CmsMailSettings m_mailSettings;
    private String m_notificationProject;
    private int m_notificationTime;
    private String m_packagesRfsPath;
    private String m_persistenceFileRfsPath;
    private String m_serverName;
    private CmsServletContainerSettings m_servletContainerSettings;
    private long m_startupTime = System.currentTimeMillis();
    private String m_version;
    private String m_versionNumber;

    public CmsSystemInfo() {
        this.initVersion();
        this.m_defaultEncoding = DEFAULT_ENCODING.intern();
        this.m_servletContainerSettings = new CmsServletContainerSettings(null);
    }

    public String getAbsoluteRfsPathRelativeToWebApplication(String path) {
        if (path == null || this.getWebApplicationRfsPath() == null) {
            return null;
        }
        File f = new File(path);
        if (f.isAbsolute()) {
            path = f.getAbsolutePath();
            if (f.isDirectory() && !path.endsWith(File.separator)) {
                path = path.concat(File.separator);
            }
            return path;
        }
        return CmsFileUtil.normalizePath(this.getWebApplicationRfsPath() + path);
    }

    public String getAbsoluteRfsPathRelativeToWebInf(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        if (f.isAbsolute()) {
            return f.getAbsolutePath();
        }
        return CmsFileUtil.normalizePath(this.getWebInfRfsPath() + path);
    }

    public String getConfigFolder() {
        if (CmsStringUtil.isNotEmpty(System.getProperty(CONFIG_FOLDER_PROPERTY))) {
            return System.getProperty(CONFIG_FOLDER_PROPERTY);
        }
        return this.getAbsoluteRfsPathRelativeToWebInf(FOLDER_CONFIG_DEFAULT);
    }

    public String getConfigurationFileRfsPath() {
        if (this.m_configurationFileRfsPath == null) {
            this.m_configurationFileRfsPath = this.getConfigFolder() + FILE_PROPERTIES;
        }
        return this.m_configurationFileRfsPath;
    }

    public String getContextPath() {
        return this.m_servletContainerSettings.getContextPath();
    }

    public String getDefaultEncoding() {
        return this.m_defaultEncoding;
    }

    public String getDefaultWebApplicationName() {
        return this.m_servletContainerSettings.getDefaultWebApplicationName();
    }

    public I_CmsJspDeviceSelector getDeviceSelector() {
        return this.m_deviceSelector;
    }

    public int getHistoryVersions() {
        return this.m_historyVersions;
    }

    public int getHistoryVersionsAfterDeletion() {
        return this.m_historyVersionsAfterDeletion;
    }

    public CmsHttpAuthenticationSettings getHttpAuthenticationSettings() {
        return this.m_httpAuthenticationSettings;
    }

    public String getLogFileRfsPath() {
        return CmsLog.getLogFileRfsPath();
    }

    public CmsMailSettings getMailSettings() {
        return this.m_mailSettings;
    }

    public String getNotificationProject() {
        return this.m_notificationProject;
    }

    public int getNotificationTime() {
        return this.m_notificationTime;
    }

    public String getOpenCmsContext() {
        return this.m_servletContainerSettings.getOpenCmsContext();
    }

    public String getPackagesRfsPath() {
        if (this.m_packagesRfsPath == null) {
            this.m_packagesRfsPath = this.getAbsoluteRfsPathRelativeToWebInf(FOLDER_PACKAGES);
        }
        return this.m_packagesRfsPath;
    }

    public String getPersistenceFileRfsPath() {
        if (this.m_persistenceFileRfsPath == null) {
            this.m_persistenceFileRfsPath = this.getAbsoluteRfsPathRelativeToWebInf(FILE_PERSISTENCE);
        }
        return this.m_persistenceFileRfsPath;
    }

    public long getRuntime() {
        return System.currentTimeMillis() - this.m_startupTime;
    }

    public String getServerName() {
        return this.m_serverName;
    }

    public CmsServletContainerSettings getServletContainerSettings() {
        return this.m_servletContainerSettings;
    }

    public String getServletPath() {
        return this.m_servletContainerSettings.getServletPath();
    }

    public long getStartupTime() {
        return this.m_startupTime;
    }

    public String getVersion() {
        return this.m_version;
    }

    public String getVersionNumber() {
        return this.m_versionNumber;
    }

    public String getWebApplicationName() {
        return this.m_servletContainerSettings.getWebApplicationName();
    }

    public String getWebApplicationRfsPath() {
        return this.m_servletContainerSettings.getWebApplicationRfsPath();
    }

    public String getWebInfRfsPath() {
        return this.m_servletContainerSettings.getWebInfRfsPath();
    }

    public boolean isHistoryEnabled() {
        return this.m_historyEnabled;
    }

    public void setNotificationProject(String notificationProject) {
        this.m_notificationProject = notificationProject;
    }

    public void setNotificationTime(int notificationTime) {
        this.m_notificationTime = notificationTime;
    }

    public void setVersionHistorySettings(boolean historyEnabled, int historyVersions, int historyVersionsAfterDeletion) {
        this.m_historyEnabled = historyEnabled;
        this.m_historyVersions = historyVersions;
        this.m_historyVersionsAfterDeletion = historyVersionsAfterDeletion < 0 ? historyVersions : historyVersionsAfterDeletion;
    }

    protected void init(CmsServletContainerSettings settings) {
        this.m_servletContainerSettings = settings;
    }

    protected void setDefaultEncoding(String encoding) {
        this.m_defaultEncoding = encoding.intern();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_SET_DEFAULT_ENCODING_1", this.m_defaultEncoding));
        }
    }

    protected void setDeviceSelector(I_CmsJspDeviceSelector selector) {
        this.m_deviceSelector = selector;
    }

    protected void setHttpAuthenticationSettings(CmsHttpAuthenticationSettings httpAuthenticationSettings) {
        this.m_httpAuthenticationSettings = httpAuthenticationSettings;
    }

    protected void setMailSettings(CmsMailSettings mailSettings) {
        this.m_mailSettings = mailSettings;
    }

    protected void setServerName(String serverName) {
        this.m_serverName = serverName;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("LOG_SET_SERVERNAME_1", this.m_serverName));
        }
    }

    private void initVersion() {
        this.m_versionNumber = DEFAULT_VERSION_NUMBER;
        this.m_version = "OpenCms/" + this.m_versionNumber;
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("org/opencms/main/version.properties"));
        }
        catch (Throwable t) {
            return;
        }
        this.m_versionNumber = props.getProperty("version.number", DEFAULT_VERSION_NUMBER);
        this.m_version = "OpenCms/" + this.m_versionNumber;
    }
}

