/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.IOException;
import java.io.Reader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.tika.io.IOUtils;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;

public class CmsLuceneDocument
implements I_CmsSearchDocument {
    public static final FieldType NOT_STORED_ANALYSED_TYPE;
    public static final FieldType STORED_ANALYSED_TYPE;
    public static final FieldType STORED_NOT_ANALYSED_TYPE;
    private Document m_doc;
    private Map<String, Field> m_fields;
    private float m_score;

    public CmsLuceneDocument(Document doc) {
        this.m_doc = doc;
        this.m_fields = new HashMap<String, Field>();
    }

    public static String getDateTerms(long date) {
        Calendar cal = Calendar.getInstance(OpenCms.getLocaleManager().getTimeZone());
        cal.setTimeInMillis(date);
        String day = CmsSearchIndex.DATES[cal.get(5)];
        String month = CmsSearchIndex.DATES[cal.get(2) + 1];
        String year = String.valueOf(cal.get(1));
        StringBuffer result = new StringBuffer();
        result.append(year);
        result.append(month);
        result.append(day);
        result.append(' ');
        result.append(year);
        result.append(month);
        result.append(' ');
        result.append(year);
        return result.toString();
    }

    @Override
    public void addCategoryField(List<CmsCategory> categories) {
        if (categories != null && categories.size() > 0) {
            StringBuffer categoryBuffer = new StringBuffer(128);
            for (CmsCategory category : categories) {
                categoryBuffer.append(category.getPath());
                categoryBuffer.append(' ');
            }
            if (categoryBuffer.length() > 0) {
                Field field = new Field("category", categoryBuffer.toString().toLowerCase(), STORED_ANALYSED_TYPE);
                field.setBoost(0.0f);
                this.add(field);
            }
        } else {
            Field field = new Field("category", "unknown", STORED_ANALYSED_TYPE);
            this.add(field);
        }
    }

    @Override
    public void addContentField(byte[] data) {
        StoredField field = new StoredField("contentblob", data);
        this.m_doc.add((IndexableField)field);
    }

    @Override
    public void addContentLocales(List<Locale> locales) {
    }

    @Override
    public void addDateField(String name, long date, boolean analyzed) {
        Field field = new Field(name, DateTools.dateToString((Date)new Date(date), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), STORED_NOT_ANALYSED_TYPE);
        field.setBoost(0.0f);
        this.add(field);
        if (analyzed) {
            field = new Field(name + "_lookup", CmsLuceneDocument.getDateTerms(date), NOT_STORED_ANALYSED_TYPE);
            this.add(field);
        }
    }

    @Override
    public void addFileSizeField(int length) {
    }

    @Override
    public void addPathField(String rootPath) {
        String parentFolders = CmsSearchFieldConfiguration.getParentFolderTokens(rootPath);
        Field field = new Field("parent-folders", parentFolders, NOT_STORED_ANALYSED_TYPE);
        field.setBoost(0.0f);
        this.add(field);
    }

    @Override
    public void addResourceLocales(List<Locale> locales) {
    }

    @Override
    public void addRootPathField(String rootPath) {
        this.add((Field)new StringField("path", rootPath, Field.Store.YES));
    }

    @Override
    public void addSearchField(CmsSearchField field, String value) {
        if (field instanceof CmsLuceneField) {
            this.add(((CmsLuceneField)field).createField(value));
        } else {
            new CmsRuntimeException(Messages.get().container("LOG_INVALID_FIELD_CLASS_1", field.getClass().getName()));
        }
    }

    @Override
    public void addSuffixField(String suffix) {
        this.add((Field)new StringField("suffix", suffix, Field.Store.YES));
    }

    @Override
    public void addTypeField(String typeName) {
        this.add((Field)new StringField("type", typeName, Field.Store.YES));
    }

    @Override
    public byte[] getContentBlob() {
        IndexableField fieldContentBlob = this.m_doc.getField("contentblob");
        if (fieldContentBlob != null) {
            try {
                if (fieldContentBlob.readerValue() != null) {
                    return IOUtils.toByteArray((Reader)fieldContentBlob.readerValue());
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Object getDocument() {
        return this.m_doc;
    }

    @Override
    public List<String> getFieldNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (IndexableField field : this.m_doc.getFields()) {
            result.add(field.name());
        }
        return result;
    }

    @Override
    public Date getFieldValueAsDate(String fieldName) {
        String contentDate = this.getFieldValueAsString(fieldName);
        if (contentDate != null) {
            try {
                return new Date(DateTools.stringToTime((String)contentDate));
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public String getFieldValueAsString(String fieldName) {
        IndexableField fieldValue = this.m_doc.getField(fieldName);
        if (fieldValue != null) {
            return fieldValue.stringValue();
        }
        return null;
    }

    @Override
    public List<String> getMultivaluedFieldAsStringList(String fieldName) {
        return Collections.singletonList(this.getFieldValueAsString(fieldName));
    }

    @Override
    public String getPath() {
        return this.getFieldValueAsString("path");
    }

    @Override
    public float getScore() {
        return this.m_score;
    }

    @Override
    public String getType() {
        return this.getFieldValueAsString("type");
    }

    @Override
    public void setBoost(float boost) {
        this.m_doc.removeFields("meta");
        this.m_doc.removeFields("content");
        this.m_doc.removeFields("description");
        this.m_doc.removeFields("keywords");
        this.m_doc.removeFields("title-key");
        this.m_doc.removeFields("title");
        Field f = this.m_fields.get("meta");
        if (f != null) {
            f.setBoost(boost);
            this.m_doc.add((IndexableField)f);
        }
        if ((f = this.m_fields.get("content")) != null) {
            f.setBoost(boost);
            this.m_doc.add((IndexableField)f);
        }
        if ((f = this.m_fields.get("description")) != null) {
            f.setBoost(boost);
            this.m_doc.add((IndexableField)f);
        }
        if ((f = this.m_fields.get("keywords")) != null) {
            f.setBoost(boost);
            this.m_doc.add((IndexableField)f);
        }
        if ((f = this.m_fields.get("title-key")) != null) {
            f.setBoost(boost);
            this.m_doc.add((IndexableField)f);
        }
        if ((f = this.m_fields.get("meta")) != null) {
            f.setBoost(boost);
            this.m_doc.add((IndexableField)f);
        }
        if ((f = this.m_fields.get("title")) != null) {
            f.setBoost(boost);
            this.m_doc.add((IndexableField)f);
        }
    }

    @Override
    public void setScore(float score) {
        this.m_score = score;
    }

    private void add(Field f) {
        this.m_fields.put(f.name(), f);
        this.m_doc.add((IndexableField)f);
    }

    static {
        STORED_ANALYSED_TYPE = new FieldType();
        STORED_ANALYSED_TYPE.setIndexed(true);
        STORED_ANALYSED_TYPE.setOmitNorms(false);
        STORED_ANALYSED_TYPE.setStored(true);
        STORED_ANALYSED_TYPE.setTokenized(true);
        STORED_ANALYSED_TYPE.setStoreTermVectorPositions(false);
        STORED_ANALYSED_TYPE.setStoreTermVectorOffsets(false);
        STORED_ANALYSED_TYPE.setStoreTermVectors(false);
        STORED_ANALYSED_TYPE.freeze();
        NOT_STORED_ANALYSED_TYPE = new FieldType();
        NOT_STORED_ANALYSED_TYPE.setIndexed(true);
        NOT_STORED_ANALYSED_TYPE.setOmitNorms(false);
        NOT_STORED_ANALYSED_TYPE.setStored(false);
        NOT_STORED_ANALYSED_TYPE.setTokenized(true);
        NOT_STORED_ANALYSED_TYPE.setStoreTermVectorPositions(false);
        NOT_STORED_ANALYSED_TYPE.setStoreTermVectorOffsets(false);
        NOT_STORED_ANALYSED_TYPE.setStoreTermVectors(false);
        NOT_STORED_ANALYSED_TYPE.freeze();
        STORED_NOT_ANALYSED_TYPE = new FieldType();
        STORED_NOT_ANALYSED_TYPE.setIndexed(true);
        STORED_NOT_ANALYSED_TYPE.setOmitNorms(false);
        STORED_NOT_ANALYSED_TYPE.setStored(true);
        STORED_NOT_ANALYSED_TYPE.setTokenized(false);
        STORED_NOT_ANALYSED_TYPE.setStoreTermVectorPositions(false);
        STORED_NOT_ANALYSED_TYPE.setStoreTermVectorOffsets(false);
        STORED_NOT_ANALYSED_TYPE.setStoreTermVectors(false);
        STORED_NOT_ANALYSED_TYPE.freeze();
    }
}

