/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Scorer;
import org.opencms.main.CmsLog;
import org.opencms.search.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSearchCategoryCollector
extends Collector {
    public static final String UNKNOWN_CATEGORY = "unknown";
    private static final Log LOG = CmsLog.getLog(CmsSearchCategoryCollector.class);
    private Map<String, CmsCategroyCount> m_categories;
    private int m_docBase = 0;
    private IndexSearcher m_searcher;

    public CmsSearchCategoryCollector(IndexSearcher searcher) {
        this.m_searcher = searcher;
        this.m_categories = new HashMap<String, CmsCategroyCount>();
    }

    public static final String formatCategoryMap(Map<String, Integer> categories) {
        StringBuffer result = new StringBuffer(256);
        result.append("Total categories: ");
        result.append(categories.size());
        result.append('\n');
        for (Map.Entry<String, Integer> entry : categories.entrySet()) {
            result.append(CmsStringUtil.padRight(entry.getKey(), 30));
            result.append(entry.getValue());
            result.append('\n');
        }
        return result.toString();
    }

    public boolean acceptsDocsOutOfOrder() {
        return true;
    }

    public void collect(int id) {
        CmsCategroyCount count;
        String category;
        block5: {
            category = null;
            int rebasedId = this.m_docBase + id;
            try {
                Document doc = this.m_searcher.doc(rebasedId);
                category = doc.get("category");
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block5;
                LOG.debug((Object)Messages.get().getBundle().key("LOG_READ_CATEGORY_FAILED_1", new Integer(rebasedId)), (Throwable)e);
            }
        }
        if (category == null) {
            category = UNKNOWN_CATEGORY;
        }
        if ((count = this.m_categories.get(category)) != null) {
            count.inc();
        } else {
            count = new CmsCategroyCount();
            this.m_categories.put(category, count);
        }
    }

    public Map<String, Integer> getCategoryCountResult() {
        TreeMap<String, Integer> result = new TreeMap<String, Integer>();
        for (Map.Entry<String, CmsCategroyCount> entry : this.m_categories.entrySet()) {
            result.put(entry.getKey(), entry.getValue().toInteger());
        }
        return result;
    }

    public void setNextReader(AtomicReaderContext ctx) {
        this.m_docBase = ctx.docBase;
    }

    public void setScorer(Scorer arg0) {
    }

    public String toString() {
        return CmsSearchCategoryCollector.formatCategoryMap(this.getCategoryCountResult());
    }

    private static class CmsCategroyCount {
        int m_count = 1;

        CmsCategroyCount() {
        }

        void inc() {
            ++this.m_count;
        }

        Integer toInteger() {
            return new Integer(this.m_count);
        }
    }
}

