/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.galleries;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.BooleanFilter;
import org.apache.lucene.queries.FilterClause;
import org.apache.lucene.queries.TermsFilter;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopFieldDocs;
import org.opencms.ade.galleries.shared.CmsGallerySearchScope;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsLuceneDocument;
import org.opencms.search.CmsSearchException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.I_CmsTermHighlighter;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.galleries.CmsGallerySearchParameters;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.search.galleries.CmsGallerySearchResultList;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsGallerySearchIndex
extends CmsSearchIndex {
    public static final String FOLDER_SYSTEM = "/system/";
    public static final String FOLDER_SYSTEM_GALLERIES = "/system/galleries/";
    public static final String FOLDER_SYTEM_MODULES = "/system/modules/";
    public static final String GALLERY_INDEX_NAME = "Gallery Index";
    public static final String TYPE_XMLCONTENT_GALLERIES = "xmlcontent-galleries";
    public static final String TYPE_XMLPAGE_GALLERIES = "xmlpage-galleries";
    private static final List<String> EXCLUDE_PROPERTY_VALUES = Arrays.asList("all", "gallery");
    private static final Log LOG = CmsLog.getLog(CmsGallerySearchIndex.class);

    public CmsGallerySearchIndex() {
        this.setRequireViewPermission(true);
    }

    public CmsGallerySearchIndex(String name) throws CmsIllegalArgumentException {
        this.setName(name);
        this.setRequireViewPermission(true);
    }

    public List<String> computeScopeFolders(CmsObject cms, CmsGallerySearchParameters params) {
        String subsite = null;
        if (params.getReferencePath() != null && (subsite = OpenCms.getADEManager().getSubSiteRoot(cms, cms.getRequestContext().addSiteRoot(params.getReferencePath()))) != null) {
            subsite = cms.getRequestContext().removeSiteRoot(subsite);
        }
        List<String> scopeFolders = this.getSearchRootsForScope(params.getScope(), cms.getRequestContext().getSiteRoot(), subsite);
        return scopeFolders;
    }

    @Deprecated
    public I_CmsSearchDocument getDocument(CmsUUID structureId) {
        return this.getDocument("res_structureId", structureId.toString());
    }

    @Override
    public I_CmsDocumentFactory getDocumentFactory(CmsResource res) {
        if (res != null && this.getSources() != null) {
            if (CmsResourceTypeXmlContent.isXmlContent(res) || CmsResourceTypeXmlContainerPage.isContainerPage(res)) {
                return OpenCms.getSearchManager().getDocumentFactory(TYPE_XMLCONTENT_GALLERIES, null);
            }
            if (CmsResourceTypeXmlPage.isXmlPage(res)) {
                return OpenCms.getSearchManager().getDocumentFactory(TYPE_XMLPAGE_GALLERIES, null);
            }
            return super.getDocumentFactory(res);
        }
        return null;
    }

    @Override
    public Locale getLocaleForResource(CmsObject cms, CmsResource resource, List<Locale> availableLocales) {
        List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
        Locale result = availableLocales != null && availableLocales.size() > 0 ? OpenCms.getLocaleManager().getBestMatchingLocale(defaultLocales.get(0), defaultLocales, availableLocales) : defaultLocales.get(0);
        return result;
    }

    public List<String> getSearchRootsForScope(CmsGallerySearchScope scope, String siteParam, String subSiteParam) {
        String sharedFolder;
        ArrayList<String> result = new ArrayList<String>();
        if (scope == CmsGallerySearchScope.everything) {
            result.add("/");
            return result;
        }
        if (scope.isIncludeSite()) {
            result.add(siteParam);
        }
        if (scope.isIncludeSubSite() && subSiteParam != null) {
            result.add(CmsStringUtil.joinPaths(siteParam, subSiteParam));
        }
        if (scope.isIncludeShared() && (sharedFolder = OpenCms.getSiteManager().getSharedFolder()) != null) {
            result.add(sharedFolder);
        }
        return result;
    }

    public synchronized CmsGallerySearchResultList searchGallery(CmsObject cms, CmsGallerySearchParameters params) throws CmsSearchException {
        CmsGallerySearchResultList searchResults = new CmsGallerySearchResultList();
        try {
            TopFieldDocs hits;
            Locale locale;
            CmsObject searchCms = OpenCms.initCmsObject(cms);
            searchCms.getRequestContext().setRequestTime(cms.getRequestContext().getRequestTime());
            searchCms.getRequestContext().setCurrentProject(searchCms.readProject(this.getProject()));
            BooleanFilter filter = new BooleanFilter();
            ArrayList<String> folders = new ArrayList<String>();
            if (params.getFolders() != null) {
                folders.addAll(params.getFolders());
            }
            if (params.getGalleries() != null) {
                folders.addAll(params.getGalleries());
            }
            filter = this.appendPathFilter(searchCms, filter, folders);
            filter = this.appendCategoryFilter(searchCms, filter, params.getCategories());
            filter = this.appendContainerTypeFilter(searchCms, filter, params.getContainerTypes());
            filter = this.appendResourceTypeFilter(searchCms, filter, params.getResourceTypes());
            if (folders.isEmpty()) {
                if (params.getResourceTypes() != null && params.getResourceTypes().contains("function")) {
                    Filter functionTypeFilter = this.getTermQueryFilter("type", "function");
                    List<String> searchRootsForOtherTypes = this.computeScopeFolders(cms, params);
                    ArrayList<String> searchRootsForFunctions = new ArrayList<String>(searchRootsForOtherTypes);
                    searchRootsForFunctions.add(FOLDER_SYTEM_MODULES);
                    BooleanFilter scopeFilter = this.filterOr((Filter)this.filterAnd(functionTypeFilter, (Filter)this.createPathFilter(searchRootsForFunctions)), (Filter)this.filterAnd((Filter)this.filterNot(functionTypeFilter), (Filter)this.createPathFilter(searchRootsForOtherTypes)));
                    filter.add((Filter)scopeFilter, BooleanClause.Occur.MUST);
                } else {
                    List<String> scopeFolders = this.computeScopeFolders(cms, params);
                    filter = this.appendPathFilter(searchCms, filter, scopeFolders);
                }
            }
            filter = this.appendLocaleFilter(searchCms, filter, params.getLocale());
            filter = this.appendDateLastModifiedFilter(filter, params.getDateLastModifiedRange().getStartTime(), params.getDateLastModifiedRange().getEndTime());
            filter = this.appendDateCreatedFilter(filter, params.getDateCreatedRange().getStartTime(), params.getDateCreatedRange().getEndTime());
            filter = this.appendIgnoreSearchExclude(filter, params.isIgnoreSearchExclude());
            MatchAllDocsQuery query = null;
            MatchAllDocsQuery fieldsQuery = null;
            this.indexSearcherUpdate();
            IndexSearcher searcher = this.getSearcher();
            Locale locale2 = locale = params.getLocale() == null ? null : CmsLocaleManager.getLocale(params.getLocale());
            if (params.getSearchWords() != null) {
                BooleanQuery booleanFieldsQuery = new BooleanQuery();
                OpenCms.getLocaleManager();
                List<String> fields = params.getFields();
                fields = this.getLocaleExtendedFields(params.getFields(), locale);
                for (String field : fields) {
                    QueryParser p = new QueryParser(CmsSearchIndex.LUCENE_VERSION, field, this.getAnalyzer());
                    booleanFieldsQuery.add(p.parse(params.getSearchWords()), BooleanClause.Occur.SHOULD);
                }
                fieldsQuery = searcher.rewrite((Query)booleanFieldsQuery);
            }
            if ((query = fieldsQuery) == null) {
                query = new MatchAllDocsQuery();
            }
            if ((hits = searcher.search((Query)query, (Filter)filter, this.getMaxHits(), params.getSort(), true, true)) != null) {
                int hitCount = hits.totalHits > hits.scoreDocs.length ? hits.scoreDocs.length : hits.totalHits;
                int page = params.getResultPage();
                int start = -1;
                int end = -1;
                if (params.getMatchesPerPage() > 0 && page > 0 && hitCount > 0) {
                    start = params.getMatchesPerPage() * (page - 1);
                    end = start + params.getMatchesPerPage();
                    start = start > hitCount ? hitCount : start;
                    end = end > hitCount ? hitCount : end;
                } else {
                    start = 0;
                    end = hitCount;
                }
                CmsSearchParameters searchParams = params.getCmsSearchParams();
                int visibleHitCount = hitCount;
                int cnt = 0;
                for (int i = 0; i < hitCount && cnt < end; ++i) {
                    try {
                        Document doc = this.getSearcher().doc(hits.scoreDocs[i].doc);
                        CmsLuceneDocument searchDoc = new CmsLuceneDocument(doc);
                        if (this.hasReadPermission(searchCms, searchDoc)) {
                            if (cnt >= start) {
                                String excerpt = null;
                                if (this.isCreatingExcerpt() && fieldsQuery != null) {
                                    I_CmsTermHighlighter highlighter = OpenCms.getSearchManager().getHighlighter();
                                    excerpt = highlighter.getExcerpt(doc, this, searchParams, (Query)fieldsQuery, this.getAnalyzer());
                                }
                                CmsGallerySearchResult searchResult = new CmsGallerySearchResult(Math.round(hits.scoreDocs[i].score / hits.getMaxScore() * 100.0f), doc, excerpt, locale);
                                searchResults.add(searchResult);
                            }
                            ++cnt;
                            continue;
                        }
                        --visibleHitCount;
                        continue;
                    }
                    catch (Exception e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)Messages.get().getBundle().key("LOG_RESULT_ITERATION_FAILED_0"), (Throwable)e);
                    }
                }
                searchResults.setHitCount(visibleHitCount);
            } else {
                searchResults.setHitCount(0);
            }
        }
        catch (RuntimeException e) {
            throw new CmsSearchException(Messages.get().container("ERR_SEARCH_PARAMS_1", params), (Throwable)e);
        }
        catch (Exception e) {
            throw new CmsSearchException(Messages.get().container("ERR_SEARCH_PARAMS_1", params), (Throwable)e);
        }
        return searchResults;
    }

    protected BooleanFilter appendContainerTypeFilter(CmsObject cms, BooleanFilter filter, List<String> containers) {
        if (containers != null && containers.size() > 0) {
            filter.add(new FilterClause(this.getMultiTermQueryFilter("container_types", containers), BooleanClause.Occur.MUST));
        }
        return filter;
    }

    protected BooleanFilter appendIgnoreSearchExclude(BooleanFilter filter, boolean ignoreSearchExclude) {
        if (!ignoreSearchExclude) {
            filter.add(new FilterClause(this.getMultiTermQueryFilter("search_exclude", EXCLUDE_PROPERTY_VALUES), BooleanClause.Occur.MUST_NOT));
        }
        return filter;
    }

    protected BooleanFilter appendLocaleFilter(CmsObject cms, BooleanFilter filter, String locale) {
        if (locale != null) {
            filter.add(new FilterClause(this.getTermQueryFilter("res_locales", locale), BooleanClause.Occur.MUST));
        }
        return filter;
    }

    @Override
    protected BooleanFilter appendPathFilter(CmsObject cms, BooleanFilter filter, List<String> roots) {
        ArrayList<Term> terms = new ArrayList<Term>();
        if (roots != null && roots.size() > 0) {
            for (int i = 0; i < roots.size(); ++i) {
                this.extendPathFilter(terms, roots.get(i));
            }
        } else {
            this.extendPathFilter(terms, cms.getRequestContext().getSiteRoot());
            this.extendPathFilter(terms, OpenCms.getSiteManager().getSharedFolder());
            this.extendPathFilter(terms, FOLDER_SYTEM_MODULES);
            this.extendPathFilter(terms, FOLDER_SYSTEM_GALLERIES);
        }
        filter.add(new FilterClause((Filter)new TermsFilter(terms), BooleanClause.Occur.MUST));
        return filter;
    }

    protected TermsFilter createPathFilter(Collection<String> roots) {
        ArrayList<Term> terms = new ArrayList<Term>();
        for (String root : roots) {
            this.extendPathFilter(terms, root);
        }
        return new TermsFilter(terms);
    }

    @Override
    protected boolean excludeFromIndex(CmsObject cms, CmsResource resource) {
        return resource.isFolder() || resource.isTemporaryFile();
    }

    protected List<String> getLocaleExtendedFields(List<String> fields, Locale locale) {
        ArrayList<String> result = new ArrayList<String>(fields.size() * 2);
        for (String fieldName : fields) {
            result.add(fieldName);
            if (locale != null) {
                result.add(CmsSearchFieldConfiguration.getLocaleExtendedName(fieldName, locale));
                continue;
            }
            for (Locale l : OpenCms.getLocaleManager().getAvailableLocales()) {
                result.add(CmsSearchFieldConfiguration.getLocaleExtendedName(fieldName, l));
            }
        }
        return result;
    }

    @Override
    protected CmsResource getResource(CmsObject cms, I_CmsSearchDocument doc) {
        String fieldStructureId = doc.getFieldValueAsString("res_structureId");
        CmsUUID structureId = new CmsUUID(fieldStructureId);
        CmsResourceFilter filter = CmsResourceFilter.DEFAULT;
        if (this.isRequireViewPermission()) {
            filter = CmsResourceFilter.DEFAULT_ONLY_VISIBLE;
        }
        try {
            return cms.readResource(structureId, filter);
        }
        catch (CmsException e) {
            return null;
        }
    }

    private BooleanFilter filterAnd(Filter f1, Filter f2) {
        BooleanFilter filter = new BooleanFilter();
        filter.add(f1, BooleanClause.Occur.MUST);
        filter.add(f2, BooleanClause.Occur.MUST);
        return filter;
    }

    private BooleanFilter filterNot(Filter f1) {
        BooleanFilter filter = new BooleanFilter();
        filter.add(f1, BooleanClause.Occur.MUST_NOT);
        return filter;
    }

    private BooleanFilter filterOr(Filter f1, Filter f2) {
        BooleanFilter filter = new BooleanFilter();
        filter.add(f1, BooleanClause.Occur.SHOULD);
        filter.add(f2, BooleanClause.Occur.SHOULD);
        return filter;
    }
}

