/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.main.OpenCms;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.solr.CmsSolrField;
import org.opencms.search.solr.CmsSolrFieldConfiguration;
import org.opencms.util.CmsStringUtil;

public class CmsGallerySolrFieldConfiguration
extends CmsSolrFieldConfiguration {
    public CmsGallerySolrFieldConfiguration() {
        CmsLuceneField sortTitle = new CmsLuceneField("sort-title", "sort-title", false, true);
        sortTitle.setTokenized(false);
        this.addField(sortTitle);
    }

    @Override
    protected I_CmsSearchDocument appendFieldMappings(I_CmsSearchDocument document, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        for (CmsSolrField fieldConfig : this.getSolrFields().values()) {
            if ("title-key".equals(fieldConfig.getName()) || CmsResourceTypeXmlContent.isXmlContent(resource) && ("content".equals(fieldConfig.getName()) || "title".equals(fieldConfig.getName()) || "sort-title".equals(fieldConfig.getName()) || "description".equals(fieldConfig.getName()) || "meta".equals(fieldConfig.getName()))) {
                this.appendMultipleFieldMapping(document, fieldConfig, cms, resource, extractionResult, properties, propertiesSearched);
                continue;
            }
            this.appendFieldMapping(document, fieldConfig, cms, resource, extractionResult, properties, propertiesSearched);
        }
        return document;
    }

    protected I_CmsSearchDocument appendMultipleFieldMapping(I_CmsSearchDocument document, CmsSearchField field, CmsObject cms, CmsResource resource, I_CmsExtractionResult extractionResult, List<CmsProperty> properties, List<CmsProperty> propertiesSearched) {
        String mappingName = null;
        String fieldName = field.getName();
        String value = null;
        if ("content".equals(fieldName)) {
            mappingName = "content";
        } else if ("title".equals(fieldName)) {
            mappingName = "title";
        } else if ("title-key".equals(fieldName) || "sort-title".equals(fieldName)) {
            if (!CmsResourceTypeXmlContent.isXmlContent(resource)) {
                value = CmsProperty.get("Title", properties).getValue();
            } else {
                mappingName = "title";
            }
        } else if ("description".equals(fieldName)) {
            mappingName = "description";
        } else if ("meta".equals(fieldName)) {
            mappingName = "meta";
        }
        for (Locale locale : OpenCms.getLocaleManager().getAvailableLocales()) {
            if (mappingName != null && extractionResult != null) {
                if (mappingName == "meta") {
                    String title = extractionResult.getContentItems().get(CmsGallerySolrFieldConfiguration.getLocaleExtendedName("title", locale));
                    String description = extractionResult.getContentItems().get(CmsGallerySolrFieldConfiguration.getLocaleExtendedName("description", locale));
                    StringBuffer v = new StringBuffer();
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(title)) {
                        v.append(title);
                        v.append('\n');
                    }
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(description)) {
                        v.append(description);
                    }
                    if (v.length() > 0) {
                        value = v.toString();
                    }
                } else {
                    String localeMapping = CmsGallerySolrFieldConfiguration.getLocaleExtendedName(mappingName, locale);
                    value = extractionResult.getContentItems().get(localeMapping);
                }
            }
            if (value == null || !(field instanceof CmsLuceneField)) continue;
            if (field.getName().equals("title") || field.getName().equals("sort-title")) {
                value = value.toLowerCase();
            }
            CmsSolrField s = (CmsSolrField)field;
            s.setName(CmsGallerySolrFieldConfiguration.getLocaleExtendedName(fieldName, locale));
            document.addSearchField(s, value);
        }
        return document;
    }
}

