/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsPasswordEncryptionException;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPasswordHandler;
import org.opencms.security.Messages;

public class CmsDefaultPasswordHandler
implements I_CmsPasswordHandler {
    public static final int PASSWORD_MIN_LENGTH = 4;
    private static final Log LOG = CmsLog.getLog(CmsDefaultPasswordHandler.class);
    private static SecureRandom m_secureRandom;
    private CmsParameterConfiguration m_configuration = new CmsParameterConfiguration();
    private String m_digestType = "md5";
    private String m_inputEncoding = "UTF-8";

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        this.m_configuration.put(paramName, paramValue);
    }

    @Override
    public String digest(String password) throws CmsPasswordEncryptionException {
        return this.digest(password, this.m_digestType, this.m_inputEncoding);
    }

    @Override
    public String digest(String password, String digestType, String inputEncoding) throws CmsPasswordEncryptionException {
        String result;
        try {
            if ("plain".equals(digestType.toLowerCase())) {
                result = password;
            } else if ("ssha".equals(digestType.toLowerCase())) {
                byte[] salt = new byte[4];
                if (m_secureRandom == null) {
                    m_secureRandom = SecureRandom.getInstance("SHA1PRNG");
                }
                m_secureRandom.nextBytes(salt);
                MessageDigest md = MessageDigest.getInstance("sha");
                md.reset();
                md.update(password.getBytes(inputEncoding));
                md.update(salt);
                byte[] digest = md.digest();
                byte[] total = new byte[digest.length + salt.length];
                System.arraycopy(digest, 0, total, 0, digest.length);
                System.arraycopy(salt, 0, total, digest.length, salt.length);
                result = new String(Base64.encodeBase64((byte[])total));
            } else {
                MessageDigest md = MessageDigest.getInstance(digestType);
                md.reset();
                md.update(password.getBytes(inputEncoding));
                result = new String(Base64.encodeBase64((byte[])md.digest()));
            }
        }
        catch (NoSuchAlgorithmException e) {
            CmsMessageContainer message = Messages.get().container("ERR_UNSUPPORTED_ALGORITHM_1", digestType);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key(), (Throwable)e);
            }
            throw new CmsPasswordEncryptionException(message, (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            CmsMessageContainer message = Messages.get().container("ERR_UNSUPPORTED_PASSWORD_ENCODING_1", inputEncoding);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key(), (Throwable)e);
            }
            throw new CmsPasswordEncryptionException(message, (Throwable)e);
        }
        return result;
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return this.m_configuration;
    }

    @Override
    public String getDigestType() {
        return this.m_digestType;
    }

    @Override
    public String getInputEncoding() {
        return this.m_inputEncoding;
    }

    @Override
    public void initConfiguration() {
        if (LOG.isDebugEnabled()) {
            CmsMessageContainer message = Messages.get().container("LOG_INIT_CONFIG_CALLED_1", this);
            LOG.debug((Object)message.key());
            LOG.debug((Object)Messages.get().getBundle().key("LOG_INIT_CONFIG_CALLED_1", this));
        }
        this.m_configuration = CmsParameterConfiguration.unmodifiableVersion(this.m_configuration);
    }

    @Override
    public void setDigestType(String digestType) {
        this.m_digestType = digestType;
    }

    @Override
    public void setInputEncoding(String inputEncoding) {
        this.m_inputEncoding = inputEncoding;
    }

    @Override
    public void validatePassword(String password) throws CmsSecurityException {
        if (password == null || password.length() < 4) {
            throw new CmsSecurityException(Messages.get().container("ERR_PASSWORD_TOO_SHORT_1", new Integer(4)));
        }
    }
}

