/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsSelectWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;

public class CmsComboWidget
extends A_CmsSelectWidget {
    public CmsComboWidget() {
    }

    public CmsComboWidget(List<CmsSelectWidgetOption> configuration) {
        super(configuration);
    }

    public CmsComboWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getDialogHtmlEnd(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(256);
        List<CmsSelectWidgetOption> options = this.parseSelectOptions(cms, widgetDialog, param);
        if (options.size() > 0) {
            String itemId;
            result.append("<div class=\"widgetcombo\" id=\"combo");
            result.append(id);
            result.append("\">\n");
            int count = 0;
            for (CmsSelectWidgetOption option : options) {
                itemId = new StringBuffer(64).append("ci").append(id).append('.').append(count).toString();
                result.append("\t<a href=\"javascript:setComboValue('");
                result.append(id);
                result.append("', '");
                result.append(itemId);
                result.append("')\" name=\"");
                result.append(itemId);
                result.append("\" id=\"");
                result.append(itemId);
                result.append("\"");
                if (option.getHelp() != null) {
                    String locValue = CmsStringUtil.substitute(option.getHelp(), "\"", "&quot;");
                    result.append(this.getJsHelpMouseHandler(widgetDialog, itemId, CmsStringUtil.escapeJavaScript(locValue)));
                }
                result.append(">");
                result.append(option.getValue());
                result.append("</a>\n");
                ++count;
            }
            result.append("</div>\n");
            if (widgetDialog.useNewStyle()) {
                count = 0;
                for (CmsSelectWidgetOption option : options) {
                    if (option.getHelp() == null) continue;
                    itemId = new StringBuffer(64).append("ci").append(id).append('.').append(count).toString();
                    result.append("<div class=\"help\" id=\"help");
                    result.append(itemId);
                    result.append("\"");
                    result.append(this.getJsHelpMouseHandler(widgetDialog, itemId, itemId));
                    result.append(">");
                    result.append(option.getHelp());
                    result.append("</div>\n");
                    ++count;
                }
            }
        }
        result.append(super.getDialogHtmlEnd(cms, widgetDialog, param));
        return result.toString();
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/combobox.js"));
        return result.toString();
    }

    @Override
    public String getDialogInitCall(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        return "\tinitComboBox();\n";
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        result.append("<td class=\"xmlTd\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr><td>");
        result.append("<input type=\"text\" class=\"xmlInputMedium");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\"");
        this.parseSelectOptions(cms, widgetDialog, param);
        String selected = this.getSelectedValue(cms, param);
        if (selected != null) {
            result.append(" value=\"");
            result.append(CmsEncoder.escapeXml(selected));
            result.append("\"");
        }
        result.append(">");
        result.append("</td><td>");
        result.append("<button name=\"test\" onclick=\"showCombo('").append(id).append("', 'combo").append(id);
        result.append("');return false;\" class=\"widgetcombobutton\">");
        result.append("<img src=\"");
        result.append(CmsWorkplace.getSkinUri()).append("components/widgets/combo.png");
        result.append("\" width=\"7\" height=\"12\" alt=\"\" border=\"0\">");
        result.append("</button></td></tr></table>");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getWidgetName() {
        return CmsComboWidget.class.getName();
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsComboWidget(this.getConfiguration());
    }
}

