/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.loader.CmsImageScaler;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsAdeImageGalleryWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.CmsVfsImageWidgetConfiguration;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.types.CmsXmlVfsImageValue;

public class CmsVfsImageWidget
extends CmsAdeImageGalleryWidget {
    private static final Log LOG = CmsLog.getLog(CmsVfsImageWidget.class);
    private static final String PREFIX_DESCRIPTION = "desc.";
    private static final String PREFIX_FORMAT = "format.";
    private static final String PREFIX_FORMATVALUE = "fmtval.";
    private static final String PREFIX_IMAGE = "img.";
    private static final String PREFIX_IMAGERATIO = "imgrat.";
    private static final String PREFIX_SCALE = "scale.";

    public CmsVfsImageWidget() {
    }

    public CmsVfsImageWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(256);
        result.append(this.getJSIncludeFile(CmsWorkplace.getSkinUri() + "components/widgets/vfsimage.js"));
        return result.toString();
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        CmsXmlVfsImageValue value;
        String imageLink;
        String id = param.getId();
        long idHash = id.hashCode();
        if (idHash < 0L) {
            idHash = -idHash;
            idHash += 0x100000000L;
        }
        if ((imageLink = (value = (CmsXmlVfsImageValue)param).getRequestLink(cms)) == null) {
            imageLink = "";
        }
        StringBuffer result = new StringBuffer(4096);
        result.append("<td class=\"xmlTd\" style=\"height: 25px;\">");
        result.append("<table class=\"xmlTableNested\">");
        result.append("<tr>");
        result.append("<td class=\"xmlLabel\">");
        result.append(widgetDialog.getMessages().key("GUI_EDITOR_LABEL_IMAGE_PATH_0"));
        result.append(" </td>");
        result.append("<td>");
        result.append("<input class=\"xmlInputMedium\" value=\"").append(imageLink).append("\" name=\"");
        result.append(PREFIX_IMAGE).append(id).append("\" id=\"");
        result.append(PREFIX_IMAGE).append(id);
        result.append("\" onkeyup=\"checkVfsImagePreview('");
        result.append(id);
        result.append("');\" />");
        result.append("</td>");
        result.append(widgetDialog.dialogHorizontalSpacer(10));
        result.append("<td><table class=\"editorbuttonbackground\" border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button(this.getOpenGalleryCall(cms, widgetDialog, param, idHash), null, this.getGalleryName() + "gallery", Messages.getButtonName(this.getGalleryName()), widgetDialog.getButtonStyle()));
        String previewClass = "hide";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(imageLink)) {
            previewClass = "show";
        }
        result.append("<td class=\"");
        result.append(previewClass);
        result.append("\" id=\"preview");
        result.append(id);
        result.append("\">");
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\"><tr>");
        result.append(widgetDialog.button(this.getOpenPreviewCall(widgetDialog, PREFIX_IMAGE + param.getId()), null, "preview.png", "GUI_BUTTON_PREVIEW_0", widgetDialog.getButtonStyle()));
        result.append("</tr></table></td>");
        result.append("</tr></table></td>");
        result.append("</tr>");
        JSONObject additional = null;
        try {
            additional = this.getAdditionalGalleryInfo(cms, widgetDialog instanceof CmsDialog ? ((CmsDialog)((Object)widgetDialog)).getParamResource() : null, widgetDialog.getMessages(), param);
        }
        catch (JSONException e) {
            LOG.error((Object)"Error parsing widget configuration", (Throwable)e);
        }
        if (additional != null) {
            result.append("\n<script type=\"text/javascript\">\n");
            result.append("var cms_additional_").append(idHash).append("=");
            result.append(additional.toString()).append(";\n");
            result.append("</script>");
        }
        CmsVfsImageWidgetConfiguration configuration = this.getWidgetConfiguration(cms, widgetDialog.getMessages(), param);
        String format = value.getFormat(cms);
        if (configuration.isShowFormat()) {
            result.append("<tr>");
            result.append("<td class=\"xmlLabel\">");
            result.append(widgetDialog.getMessages().key("GUI_EDITOR_LABEL_IMAGE_FORMAT_0"));
            result.append(" </td>");
            result.append("<td class=\"xmlTd\">");
            result.append("<select class=\"xmlInput");
            if (param.hasError()) {
                result.append(" xmlInputError");
            }
            result.append("\" name=\"");
            result.append(PREFIX_FORMAT).append(id);
            result.append("\" id=\"");
            result.append(PREFIX_FORMAT).append(id);
            result.append("\"");
            result.append(" onchange=\"setImageFormat('");
            result.append(id);
            result.append("', 'imgFmts");
            result.append(idHash);
            result.append("');\"");
            result.append(">");
            List<CmsSelectWidgetOption> options = configuration.getSelectFormat();
            String selected = this.getSelectedValue(cms, options, format);
            int selectedIndex = 0;
            for (int i = 0; i < options.size(); ++i) {
                CmsSelectWidgetOption option = options.get(i);
                result.append("<option value=\"");
                result.append(option.getValue());
                result.append("\"");
                if (selected != null && selected.equals(option.getValue())) {
                    result.append(" selected=\"selected\"");
                    selectedIndex = i;
                }
                result.append(">");
                result.append(option.getOption());
                result.append("</option>");
            }
            result.append("</select>");
            result.append("</td>");
            result.append("</tr>");
            List<String> formatValues = configuration.getFormatValues();
            String selectedFormat = "";
            try {
                selectedFormat = formatValues.get(selectedIndex);
            }
            catch (Exception e) {
                // empty catch block
            }
            result.append("<input type=\"hidden\" value=\"").append(selectedFormat).append("\" name=\"");
            result.append(PREFIX_FORMATVALUE).append(id).append("\" id=\"");
            result.append(PREFIX_FORMATVALUE).append(id).append("\" />");
            String ratio = "";
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(imageLink)) {
                try {
                    CmsImageScaler scaler = new CmsImageScaler(cms, cms.readResource(imageLink));
                    float r = (float)scaler.getWidth() / (float)scaler.getHeight();
                    ratio = String.valueOf(r);
                }
                catch (CmsException e) {
                    // empty catch block
                }
            }
            result.append("<input type=\"hidden\" value=\"").append(ratio).append("\" name=\"");
            result.append(PREFIX_IMAGERATIO).append(id).append("\" id=\"");
            result.append(PREFIX_IMAGERATIO).append(id).append("\" />");
            result.append("\n<script type=\"text/javascript\">");
            JSONArray formatsJson = new JSONArray(configuration.getFormatValues());
            result.append("\nvar imgFmts").append(idHash).append(" = ").append(formatsJson).append(";");
            result.append("\nvar imgFmtNames").append(idHash).append(" = \"").append(CmsEncoder.escape(configuration.getSelectFormatString(), "UTF-8")).append("\";");
            result.append("\nvar useFmts").append(idHash).append(" = true;");
            result.append("\n</script>");
        } else {
            result.append("<input type=\"hidden\" value=\"\" name=\"");
            result.append(PREFIX_IMAGERATIO).append(id).append("\" id=\"");
            result.append(PREFIX_IMAGERATIO).append(id).append("\" />");
            result.append("<input type=\"hidden\" value=\"").append(format).append("\" name=\"");
            result.append(PREFIX_FORMAT).append(id).append("\" id=\"");
            result.append(PREFIX_FORMAT).append(id).append("\" />");
            result.append("\n<script type=\"text/javascript\">");
            result.append("\nvar useFmts").append(idHash).append(" = false;");
            result.append("\n</script>");
        }
        String description = value.getDescription(cms);
        if (description == null) {
            description = "";
        }
        if (configuration.isShowDescription()) {
            result.append("<tr>");
            result.append("<td class=\"xmlLabel\">");
            result.append(widgetDialog.getMessages().key("GUI_EDITOR_LABEL_IMAGE_DESC_0"));
            result.append("</td>");
            result.append("<td class=\"xmlTd\">");
            result.append("<textarea class=\"xmlInput maxwidth");
            if (param.hasError()) {
                result.append(" xmlInputError");
            }
            result.append("\" name=\"");
            result.append(PREFIX_DESCRIPTION).append(id).append("\" id=\"");
            result.append(PREFIX_DESCRIPTION).append(id);
            result.append("\" rows=\"");
            result.append(2);
            result.append("\" cols=\"60\" style=\"height: 3em; overflow:auto;\">");
            result.append(CmsEncoder.escapeXml(description));
            result.append("</textarea>");
            result.append("</td>");
            result.append("</tr>");
        } else {
            result.append("<input type=\"hidden\" value=\"").append(CmsEncoder.escapeXml(description)).append("\" name=\"");
            result.append(PREFIX_DESCRIPTION).append(id).append("\" id=\"");
            result.append(PREFIX_DESCRIPTION).append(id).append("\" />");
        }
        result.append("</table>");
        String scale = value.getScaleOptions(cms);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration.getScaleParams()) && scale.indexOf(configuration.getScaleParams()) == -1) {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(scale)) {
                scale = scale + ",";
            }
            scale = scale + configuration.getScaleParams();
        }
        result.append("<input type=\"hidden\" value=\"").append(scale).append("\" name=\"");
        result.append(PREFIX_SCALE).append(id).append("\" id=\"");
        result.append(PREFIX_SCALE).append(id).append("\" />");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getWidgetName() {
        return CmsVfsImageWidget.class.getName();
    }

    @Override
    public String getWidgetStringValue(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String result = super.getWidgetStringValue(cms, widgetDialog, param);
        String configuration = CmsMacroResolver.resolveMacros(this.getConfiguration(), cms, widgetDialog.getMessages());
        if (configuration == null) {
            configuration = param.getDefault(cms);
        }
        List<CmsSelectWidgetOption> options = CmsSelectWidgetOption.parseOptions(configuration);
        for (int m = 0; m < options.size(); ++m) {
            CmsSelectWidgetOption option = options.get(m);
            if (!result.equals(option.getValue())) continue;
            result = option.getOption();
            break;
        }
        return result;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsVfsImageWidget(this.getConfiguration());
    }

    @Override
    public void setEditorValue(CmsObject cms, Map<String, String[]> formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] imgValues = formParameters.get(PREFIX_IMAGE + param.getId());
        if (imgValues != null && imgValues.length > 0) {
            param.setStringValue(cms, imgValues[0]);
        }
        CmsXmlVfsImageValue value = (CmsXmlVfsImageValue)param;
        String[] descValues = formParameters.get(PREFIX_DESCRIPTION + param.getId());
        value.setDescription(cms, descValues[0]);
        String[] formatValues = formParameters.get(PREFIX_FORMAT + param.getId());
        value.setFormat(cms, formatValues[0]);
        String[] scaleValues = formParameters.get(PREFIX_SCALE + param.getId());
        value.setScaleOptions(cms, scaleValues[0]);
    }

    @Override
    protected JSONObject getAdditionalGalleryInfo(CmsObject cms, String resource, CmsMessages messages, I_CmsWidgetParameter param) throws JSONException {
        JSONObject result = super.getAdditionalGalleryInfo(cms, resource, messages, param);
        result.put("isAdvancedWidget", true);
        return result;
    }

    @Override
    protected Map<String, String> getGalleryOpenParams(CmsObject cms, CmsMessages widgetDialog, I_CmsWidgetParameter param, String resource, long hashId) {
        Map<String, String> result = super.getGalleryOpenParams(cms, widgetDialog, param, resource, hashId);
        StringBuffer currentElement = new StringBuffer("'+document.getElementById('");
        if (param != null) {
            currentElement.append(PREFIX_IMAGE).append(param.getId());
        }
        currentElement.append("').getAttribute('value')+'");
        if (param != null && this.getWidgetConfiguration(cms, widgetDialog, param).isShowFormat()) {
            currentElement.append("%3F__scale%3D'+document.getElementById('");
            currentElement.append(PREFIX_SCALE).append(param.getId()).append("').getAttribute('value')+'");
            currentElement.append("%26format%3D'+escape(document.getElementById('").append(PREFIX_FORMAT).append(param.getId()).append("')[document.getElementById('").append(PREFIX_FORMAT).append(param.getId()).append("').selectedIndex].value)+'");
        }
        result.put("currentelement", currentElement.toString());
        return result;
    }

    protected String getSelectedValue(CmsObject cms, List<CmsSelectWidgetOption> selectOptions, String currentValue) {
        CmsSelectWidgetOption option;
        String paramValue = currentValue;
        if (CmsStringUtil.isEmpty(paramValue) && (option = CmsSelectWidgetOption.getDefaultOption(selectOptions)) != null) {
            paramValue = option.getValue();
        }
        return paramValue;
    }
}

