/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.CmsListExplorerColumn;

public class CmsProgressThread
extends Thread {
    private static final Log LOG = CmsLog.getLog(CmsProgressThread.class);
    private String m_description;
    private Throwable m_error;
    private long m_finishtime;
    private String m_key;
    private A_CmsListDialog m_list;
    private Locale m_locale;
    private int m_progress = 0;
    private String m_result;
    private long m_starttime;

    public CmsProgressThread(A_CmsListDialog list, String key, Locale locale) {
        this.m_list = list;
        this.m_key = key;
        this.m_starttime = 0L;
        this.m_finishtime = 0L;
        this.m_locale = locale;
        this.setName(Messages.get().getBundle().key("GUI_PROGRESS_THREAD_NAME_1", key));
    }

    public String getDescription() {
        return this.m_description;
    }

    public Throwable getError() {
        return this.m_error;
    }

    public long getFinishTime() {
        return this.m_finishtime;
    }

    public String getKey() {
        return this.m_key;
    }

    public A_CmsListDialog getList() {
        return this.m_list;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public int getProgress() {
        return this.m_progress;
    }

    public String getResult() {
        return this.m_result;
    }

    public synchronized long getRuntime() {
        if (!this.isAlive()) {
            return this.m_finishtime - this.m_starttime;
        }
        if (this.m_starttime > 0L) {
            return System.currentTimeMillis() - this.m_starttime;
        }
        return 0L;
    }

    public long getStartTime() {
        return this.m_starttime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PROGRESS_START_THREAD_1", this.getKey()));
            }
            this.m_starttime = System.currentTimeMillis();
            this.m_list.refreshList();
            CmsHtmlList list = this.m_list.getList();
            list.setBoxed(false);
            StringBuffer result = new StringBuffer();
            result.append("<input type='hidden' name='result' value='");
            result.append(list.getTotalSize()).append("'>\n");
            result.append(CmsListExplorerColumn.getExplorerStyleDef());
            result.append("<div style='height:200px; overflow: auto;'>\n");
            result.append(list.listHtml());
            result.append("</div>\n");
            this.m_result = result.toString();
        }
        catch (Throwable t) {
            this.m_error = t;
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_ERROR_EXECUTING_THREAD_0"), t);
            }
        }
        finally {
            this.m_finishtime = System.currentTimeMillis();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PROGRESS_FINISHED_THREAD_1", this.getKey()));
            }
        }
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public void setProgress(int progress) {
        this.m_progress = progress;
    }
}

