/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.opencms.util.CmsStringUtil;

public final class CmsTinyMceToolbarHelper {
    public static final String BUTTON_TRANSLATION = "|newdocument:newdocument|bold:bold|italic:italic|underline:underline|strikethrough:strikethrough|alignleft:alignleft|aligncenter:aligncenter|alignright:alignright|justify:alignjustify|style:styleselect|formatselect:formatselect|fontselect:fontselect|fontsizeselect:fontsizeselect|cut:cut|copy:copy|paste:paste,pastetext|pastetext:pastetext|find:searchreplace|replace:searchreplace|unorderedlist:bullist|orderedlist:numlist|outdent:outdent|indent:indent|blockquote:blockquote|undo:undo|redo:redo|editorlink:link|unlink:unlink|anchor:anchor|image:image|cleanup:cleanup|source:code|insertdate:insertdate|inserttime:inserttime|forecolor:forecolor|backcolor:backcolor|table:table|hr:hr|removeformat:removeformat|visualaid:visualaid|subscript:subscript|superscript:superscript|specialchar:charmap|emotions:emoticons|spellcheck:iespell|media:media|print:print|ltr:ltr|rtl:rtl|fitwindow:fullscreen|insertlayer:insertlayer|moveforward:moveforward|movebackward:movebackward|absolute:absolute|styleprops:styleprops|cite:cite|abbr:abbr|acronym:acronym|del:del|ins:ins|attribs:attribs|visualchars:visualchars|nonbreaking:nonbreaking|template:template|pagebreak:pagebreak|selectall:selectall|fullpage:fullpage|imagegallery:OcmsImageGallery|downloadgallery:OcmsDownloadGallery|linkgallery:OcmsLinkGallery|htmlgallery:OcmsHtmlGallery|tablegallery:OcmsTableGallery|link:link";
    public static final Map<String, String> BUTTON_TRANSLATION_MAP = CmsStringUtil.splitAsMap("|newdocument:newdocument|bold:bold|italic:italic|underline:underline|strikethrough:strikethrough|alignleft:alignleft|aligncenter:aligncenter|alignright:alignright|justify:alignjustify|style:styleselect|formatselect:formatselect|fontselect:fontselect|fontsizeselect:fontsizeselect|cut:cut|copy:copy|paste:paste,pastetext|pastetext:pastetext|find:searchreplace|replace:searchreplace|unorderedlist:bullist|orderedlist:numlist|outdent:outdent|indent:indent|blockquote:blockquote|undo:undo|redo:redo|editorlink:link|unlink:unlink|anchor:anchor|image:image|cleanup:cleanup|source:code|insertdate:insertdate|inserttime:inserttime|forecolor:forecolor|backcolor:backcolor|table:table|hr:hr|removeformat:removeformat|visualaid:visualaid|subscript:subscript|superscript:superscript|specialchar:charmap|emotions:emoticons|spellcheck:iespell|media:media|print:print|ltr:ltr|rtl:rtl|fitwindow:fullscreen|insertlayer:insertlayer|moveforward:moveforward|movebackward:movebackward|absolute:absolute|styleprops:styleprops|cite:cite|abbr:abbr|acronym:acronym|del:del|ins:ins|attribs:attribs|visualchars:visualchars|nonbreaking:nonbreaking|template:template|pagebreak:pagebreak|selectall:selectall|fullpage:fullpage|imagegallery:OcmsImageGallery|downloadgallery:OcmsDownloadGallery|linkgallery:OcmsLinkGallery|htmlgallery:OcmsHtmlGallery|tablegallery:OcmsTableGallery|link:link", "|", ":");

    private CmsTinyMceToolbarHelper() {
    }

    public static String createTinyMceToolbarStringFromGenericToolbarItems(List<String> barItems) {
        ArrayList blocks = new ArrayList();
        blocks.add(new ArrayList());
        String lastItem = null;
        ArrayList<String> processedItems = new ArrayList<String>();
        for (String barItem : barItems) {
            String translated = CmsTinyMceToolbarHelper.translateButton(barItem);
            if (translated != null) {
                barItem = translated;
            }
            if (barItem.equals("[") || barItem.equals("]") || barItem.equals("-")) {
                barItem = "|";
                if ("|".equals(lastItem)) continue;
            }
            if (barItem.indexOf(",") > -1) {
                for (String subItem : barItem.split(",")) {
                    processedItems.add(subItem);
                }
            } else {
                processedItems.add(barItem);
            }
            lastItem = barItem;
        }
        if (processedItems.size() > 0 && ((String)processedItems.get(0)).equals("|")) {
            processedItems.remove(0);
        }
        if (processedItems.size() > 0 && ((String)processedItems.get(processedItems.size() - 1)).equals("|")) {
            processedItems.remove(processedItems.size() - 1);
        }
        HashSet<String> writtenItems = new HashSet<String>();
        for (String processedItem : processedItems) {
            if (!writtenItems.contains(processedItem)) {
                ((List)blocks.get(blocks.size() - 1)).add(processedItem);
            }
            if ("|".equals(processedItem)) {
                blocks.add(new ArrayList());
                continue;
            }
            writtenItems.add(processedItem);
        }
        String toolbar = "";
        for (List list : blocks) {
            toolbar = toolbar + CmsStringUtil.listAsString(list, " ") + " ";
        }
        return toolbar;
    }

    public static String getContextMenuEntries(List<String> barItems) {
        String result = "";
        if (barItems.contains("link")) {
            result = result + CmsTinyMceToolbarHelper.translateButton("link");
        }
        if (barItems.contains("downloadgallery")) {
            result = result + " " + CmsTinyMceToolbarHelper.translateButton("downloadgallery");
        }
        if (barItems.contains("imagegallery")) {
            result = result + " " + CmsTinyMceToolbarHelper.translateButton("imagegallery");
        }
        if (barItems.contains("table")) {
            result = result + " inserttable | cell row column deletetable";
        }
        return result.trim();
    }

    public static String translateButton(String cmsButtonName) {
        return BUTTON_TRANSLATION_MAP.get(cmsButtonName);
    }
}

