/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.main.CmsEvent;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.workplace.explorer.CmsExplorerTypeAccess;

public class CmsExplorerTypeAccessFlushListener
implements I_CmsEventListener {
    private List<WeakReference<CmsExplorerTypeAccess>> m_contents = new ArrayList<WeakReference<CmsExplorerTypeAccess>>();

    public synchronized void add(CmsExplorerTypeAccess access) {
        this.m_contents.add(new WeakReference<CmsExplorerTypeAccess>(access));
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        switch (event.getType()) {
            case 5: 
            case 16: 
            case 17: {
                this.doFlush();
                break;
            }
        }
    }

    public void install() {
        OpenCms.getEventManager().addCmsEventListener(this, new int[]{5, 16, 17});
    }

    protected synchronized void doFlush() {
        Iterator<WeakReference<CmsExplorerTypeAccess>> iter = this.m_contents.iterator();
        while (iter.hasNext()) {
            WeakReference<CmsExplorerTypeAccess> ref = iter.next();
            CmsExplorerTypeAccess access = (CmsExplorerTypeAccess)ref.get();
            if (access == null) {
                iter.remove();
                continue;
            }
            access.flushCache();
        }
    }
}

