/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.help;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.search.CmsSearch;
import org.opencms.search.CmsSearchResult;
import org.opencms.search.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsHelpSearchResultView {
    protected CmsProject m_offlineProject;
    protected CmsProject m_onlineProject;
    private boolean m_exportLinks;
    private SortedMap m_formCache;
    private CmsJspActionElement m_jsp;
    private String m_searchRessourceUrl;

    public CmsHelpSearchResultView(CmsJspActionElement action) {
        this.m_jsp = action;
        this.m_formCache = new TreeMap();
        try {
            this.m_onlineProject = this.m_jsp.getCmsObject().readProject(CmsProject.ONLINE_PROJECT_ID);
            this.m_offlineProject = this.m_jsp.getRequestContext().getCurrentProject();
        }
        catch (CmsException e) {
            this.m_onlineProject = this.m_offlineProject;
        }
    }

    public CmsHelpSearchResultView(PageContext pageContext, HttpServletRequest request, HttpServletResponse response) {
        this(new CmsJspActionElement(pageContext, request, response));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String displaySearchResult(CmsSearch search) {
        List<CmsSearchResult> searchResult;
        this.initSearch(search);
        StringBuffer result = new StringBuffer(800);
        CmsMessages messages = Messages.get().getBundle(this.m_jsp.getRequestContext().getLocale());
        result.append("<h1>\n");
        result.append(messages.key("GUI_HELP_SEARCH_RESULT_TITLE_0"));
        result.append("\n</h1>\n");
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(search.getQuery())) {
            search.setQuery("");
            searchResult = new ArrayList<CmsSearchResult>();
        } else {
            searchResult = search.getSearchResult();
        }
        HttpServletRequest request = this.m_jsp.getRequest();
        String action = request.getParameter("action");
        if (action != null && searchResult == null) {
            result.append("<p class=\"formerror\">\n");
            if (search.getLastException() != null) {
                result.append(messages.key("GUI_HELP_SEARCH_UNAVAILABLE_0"));
                result.append("\n<!-- ").append(search.getLastException().toString());
                result.append(" //-->\n");
            } else {
                result.append(messages.key("GUI_HELP_SEARCH_NOMATCH_1", search.getQuery()));
                result.append("\n");
            }
            result.append("</p>\n");
        } else if (action != null && searchResult.size() <= 0) {
            result.append("<p class=\"formerror\">\n");
            result.append(messages.key("GUI_HELP_SEARCH_NOMATCH_1", search.getQuery()));
            result.append("\n");
            result.append("</p>\n");
        } else if (action != null && searchResult.size() > 0) {
            result.append("<p>\n");
            result.append(messages.key("GUI_HELP_SEARCH_RESULT_START_0"));
            result.append("\n");
            result.append("</p>\n<p>\n");
            Iterator<CmsSearchResult> iterator = searchResult.iterator();
            try {
                if (this.m_exportLinks) {
                    this.m_jsp.getRequestContext().setCurrentProject(this.m_onlineProject);
                }
                while (iterator.hasNext()) {
                    CmsSearchResult entry = iterator.next();
                    result.append("\n<div class=\"searchResult\"><a class=\"navhelp\" href=\"");
                    result.append(this.m_jsp.link(new StringBuffer("/system/modules/org.opencms.workplace.help/jsptemplates/help_body.jsp?helpresource=").append(this.m_jsp.getRequestContext().removeSiteRoot(entry.getPath())).append("&").append("__locale").append("=").append(this.m_jsp.getRequestContext().getLocale()).toString()));
                    result.append("\">\n");
                    result.append(entry.getField("title-key"));
                    result.append("</a>");
                    result.append("&nbsp;(").append(entry.getScore()).append("&nbsp;%)\n");
                    result.append("<span class=\"searchExcerpt\">\n");
                    result.append(entry.getExcerpt()).append('\n');
                    result.append("</span>\n");
                    result.append("</div>\n");
                }
            }
            finally {
                this.m_jsp.getRequestContext().setCurrentProject(this.m_offlineProject);
            }
            result.append("</p>\n");
            if (search.getPreviousUrl() != null || search.getNextUrl() != null) {
                result.append("<p>");
                if (search.getPreviousUrl() != null) {
                    result.append("<a href=\"");
                    result.append(this.getSearchPageLink(this.m_jsp.link(new StringBuffer(search.getPreviousUrl()).append('&').append("__locale").append("=").append(this.m_jsp.getRequestContext().getLocale()).toString())));
                    result.append("\">");
                    result.append(messages.key("GUI_HELP_BUTTON_BACK_0"));
                    result.append(" &lt;&lt;</a>&nbsp;&nbsp;\n");
                }
                Map<Integer, String> pageLinks = search.getPageLinks();
                for (int pageNumber : pageLinks.keySet()) {
                    result.append(" ");
                    if (pageNumber != search.getSearchPage()) {
                        result.append("<a href=\"").append(this.getSearchPageLink(this.m_jsp.link(new StringBuffer(pageLinks.get(new Integer(pageNumber))).append('&').append("__locale").append("=").append(this.m_jsp.getRequestContext().getLocale()).toString())));
                        result.append("\" target=\"_self\">").append(pageNumber).append("</a>\n");
                        continue;
                    }
                    result.append(pageNumber);
                }
                if (search.getNextUrl() != null) {
                    result.append("&nbsp;&nbsp;&nbsp;<a href=\"");
                    result.append(this.getSearchPageLink(new StringBuffer(this.m_jsp.link(search.getNextUrl())).append('&').append("__locale").append("=").append(this.m_jsp.getRequestContext().getLocale()).toString()));
                    result.append("\">&gt;&gt;");
                    result.append(messages.key("GUI_HELP_BUTTON_NEXT_0"));
                    result.append("</a>\n");
                }
                result.append("</p>\n");
            }
        }
        Iterator values = this.m_formCache.values().iterator();
        while (values.hasNext()) {
            result.append(values.next());
        }
        return result.toString();
    }

    public boolean isExportLinks() {
        return this.m_exportLinks;
    }

    public void setExportLinks(boolean exportLinks) {
        this.m_exportLinks = exportLinks;
    }

    public void setSearchRessourceUrl(String uri) {
        this.m_searchRessourceUrl = uri;
    }

    private String getSearchPageLink(String link) {
        if (this.m_searchRessourceUrl != null) {
            String pageParams = "";
            int paramIndex = link.indexOf(63);
            if (paramIndex > 0) {
                pageParams = link.substring(paramIndex);
            }
            String formurl = new StringBuffer(this.m_searchRessourceUrl).append(pageParams).toString();
            this.toPostParameters(formurl);
            link = new StringBuffer("javascript:document.forms['").append("form").append(this.m_formCache.size() - 1).append("'].submit()").toString();
        }
        return link;
    }

    private void initSearch(CmsSearch search) {
        CmsObject cmsObject = this.m_jsp.getCmsObject();
        HttpServletRequest request = this.m_jsp.getRequest();
        search.init(cmsObject);
        search.setField(new String[]{"title-key", "keywords", "description", "content"});
        search.setMatchesPerPage(5);
        search.setDisplayPages(7);
        search.setSearchRoot(new StringBuffer("/system/workplace/locales/").append(this.m_jsp.getRequestContext().getLocale()).append("/help/").toString());
        String query = request.getParameter("query");
        search.setQuery(query);
    }

    private void toPostParameters(String getRequestUri) {
        if (!this.m_formCache.containsKey(getRequestUri)) {
            StringBuffer result = new StringBuffer();
            int index = getRequestUri.indexOf(63);
            String query = "";
            String path = "";
            if (index > 0) {
                query = getRequestUri.substring(index + 1);
                path = getRequestUri.substring(0, index);
                result.append("\n<form method=\"post\" name=\"form").append(this.m_formCache.size()).append("\" action=\"");
                result.append(path).append("\">\n");
                StringTokenizer entryTokens = new StringTokenizer(query, "&", false);
                while (entryTokens.hasMoreTokens()) {
                    StringTokenizer keyValueToken = new StringTokenizer(entryTokens.nextToken(), "=", false);
                    if (keyValueToken.countTokens() != 2) continue;
                    String key = CmsEncoder.decode(keyValueToken.nextToken());
                    String value = CmsEncoder.decode(keyValueToken.nextToken());
                    result.append("  <input type=\"hidden\" name=\"");
                    result.append(key).append("\" value=\"");
                    result.append(value).append("\" />\n");
                }
                result.append("</form>\n");
                this.m_formCache.put(getRequestUri, result.toString());
            }
        }
    }
}

