/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.commons.CmsProgressThread;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListState;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.list.I_CmsListResourceCollector;
import org.opencms.workplace.list.Messages;

public abstract class A_CmsListResourceCollector
implements I_CmsListResourceCollector {
    public static final String VFS_PATH_NONE = "none";
    private static final Log LOG = CmsLog.getLog(A_CmsListResourceCollector.class);
    protected String m_collectorParameter;
    protected Map<String, CmsListItem> m_liCache = new HashMap<String, CmsListItem>();
    protected Map<String, CmsResource> m_resCache = new HashMap<String, CmsResource>();
    protected List<CmsResource> m_resources;
    private A_CmsListExplorerDialog m_wp;

    protected A_CmsListResourceCollector(A_CmsListExplorerDialog wp) {
        CmsListState state;
        this.m_wp = wp;
        CmsListState cmsListState = state = wp != null ? wp.getListStateForCollector() : new CmsListState();
        if (state.getPage() < 1) {
            state.setPage(1);
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(state.getColumn())) {
            state.setColumn("ecn");
        }
        if (state.getOrder() == null) {
            state.setOrder(CmsListOrderEnum.ORDER_ASCENDING);
        }
        if (state.getFilter() == null) {
            state.setFilter("");
        }
        this.m_collectorParameter = "page:" + state.getPage();
        this.m_collectorParameter = this.m_collectorParameter + "|sortby:" + state.getColumn();
        this.m_collectorParameter = this.m_collectorParameter + "|order:" + state.getOrder();
        this.m_collectorParameter = this.m_collectorParameter + "|filter:" + state.getFilter();
    }

    @Override
    public int compareTo(I_CmsResourceCollector arg0) {
        return 0;
    }

    @Override
    public String getCreateLink(CmsObject cms) {
        return null;
    }

    @Override
    public String getCreateLink(CmsObject cms, String collectorName, String param) {
        return null;
    }

    @Override
    public int getCreateTypeId(CmsObject cms, String collectorName, String param) {
        return -1;
    }

    @Override
    public String getCreateParam(CmsObject cms) {
        return null;
    }

    @Override
    public String getCreateParam(CmsObject cms, String collectorName, String param) {
        return null;
    }

    @Override
    public String getDefaultCollectorName() {
        return this.getCollectorNames().get(0);
    }

    @Override
    public String getDefaultCollectorParam() {
        return this.m_collectorParameter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CmsListItem> getListItems(String parameter) throws CmsException {
        A_CmsListResourceCollector a_CmsListResourceCollector = this;
        synchronized (a_CmsListResourceCollector) {
            CmsListColumnDefinition colPermissions;
            if (parameter == null) {
                parameter = this.m_collectorParameter;
            }
            Map<String, String> params = CmsStringUtil.splitAsMap(parameter, "|", ":");
            CmsListState state = this.getState(params);
            List<CmsResource> resources = this.getInternalResources(this.getWp().getCms(), params);
            List<CmsListItem> ret = new ArrayList<CmsListItem>();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_COLLECTOR_PROCESS_ITEMS_START_1", new Integer(resources.size())));
            }
            this.getWp().applyColumnVisibilities();
            CmsHtmlList list = this.getWp().getList();
            CmsProgressThread thread = null;
            int progressOffset = 0;
            if (Thread.currentThread() instanceof CmsProgressThread) {
                thread = (CmsProgressThread)Thread.currentThread();
                progressOffset = thread.getProgress();
            }
            boolean showPermissions = (colPermissions = list.getMetadata().getColumnDefinition("ecp")).isVisible() || colPermissions.isPrintable();
            CmsListColumnDefinition colDateLastMod = list.getMetadata().getColumnDefinition("ecdl");
            boolean showDateLastMod = colDateLastMod.isVisible() || colDateLastMod.isPrintable();
            CmsListColumnDefinition colUserLastMod = list.getMetadata().getColumnDefinition("ecul");
            boolean showUserLastMod = colUserLastMod.isVisible() || colUserLastMod.isPrintable();
            CmsListColumnDefinition colDateCreate = list.getMetadata().getColumnDefinition("ecdc");
            boolean showDateCreate = colDateCreate.isVisible() || colDateCreate.isPrintable();
            CmsListColumnDefinition colUserCreate = list.getMetadata().getColumnDefinition("ecuc");
            boolean showUserCreate = colUserCreate.isVisible() || colUserCreate.isPrintable();
            CmsListColumnDefinition colDateRel = list.getMetadata().getColumnDefinition("ecdr");
            boolean showDateRel = colDateRel.isVisible() || colDateRel.isPrintable();
            CmsListColumnDefinition colDateExp = list.getMetadata().getColumnDefinition("ecde");
            boolean showDateExp = colDateExp.isVisible() || colDateExp.isPrintable();
            CmsListColumnDefinition colState = list.getMetadata().getColumnDefinition("ecs");
            boolean showState = colState.isVisible() || colState.isPrintable();
            CmsListColumnDefinition colLockedBy = list.getMetadata().getColumnDefinition("eclb");
            boolean showLockedBy = colLockedBy.isVisible() || colLockedBy.isPrintable();
            CmsListColumnDefinition colSite = list.getMetadata().getColumnDefinition("ecsi");
            boolean showSite = colSite.isVisible() || colSite.isPrintable();
            Iterator<CmsResource> itRes = resources.iterator();
            int count = 0;
            while (itRes.hasNext()) {
                CmsResource obj;
                if (thread != null) {
                    ++count;
                    if (thread.isInterrupted()) {
                        throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                    }
                    thread.setProgress(count * 40 / resources.size() + progressOffset);
                    thread.setDescription(org.opencms.workplace.commons.Messages.get().getBundle(thread.getLocale()).key("GUI_PROGRESS_PUBLISH_STEP2_2", new Integer(count), new Integer(resources.size())));
                }
                if (!((obj = itRes.next()) instanceof CmsResource)) {
                    ret.add(this.getDummyListItem(list));
                    continue;
                }
                CmsResource resource = obj;
                CmsListItem item = this.m_liCache.get(resource.getStructureId().toString());
                if (item == null) {
                    item = this.createResourceListItem(resource, list, showPermissions, showDateLastMod, showUserLastMod, showDateCreate, showUserCreate, showDateRel, showDateExp, showState, showLockedBy, showSite);
                    this.m_liCache.put(resource.getStructureId().toString(), item);
                }
                ret.add(item);
            }
            CmsListMetadata metadata = list.getMetadata();
            if (metadata != null) {
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(state.getFilter())) {
                    ret = metadata.getSearchAction().filter(ret, state.getFilter());
                }
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(state.getColumn()) && metadata.getColumnDefinition(state.getColumn()) != null && metadata.getColumnDefinition(state.getColumn()).isSorteable()) {
                    I_CmsListItemComparator c = metadata.getColumnDefinition(state.getColumn()).getListItemComparator();
                    Collections.sort(ret, c.getComparator(state.getColumn(), this.getWp().getLocale()));
                    if (state.getOrder().equals(CmsListOrderEnum.ORDER_DESCENDING)) {
                        Collections.reverse(ret);
                    }
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_COLLECTOR_PROCESS_ITEMS_END_1", new Integer(ret.size())));
            }
            return ret;
        }
    }

    @Override
    public int getOrder() {
        return 0;
    }

    @Override
    public CmsResource getResource(CmsObject cms, CmsListItem item) {
        CmsResource res;
        block3: {
            CmsUUID id;
            res = this.m_resCache.get(item.getId());
            if (res == null && !(id = new CmsUUID(item.getId())).isNullUUID()) {
                try {
                    res = cms.readResource(id, CmsResourceFilter.ALL);
                    this.m_resCache.put(item.getId(), res);
                }
                catch (CmsException e) {
                    if (!LOG.isErrorEnabled()) break block3;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        return res;
    }

    @Override
    public abstract List<CmsResource> getResources(CmsObject var1, Map<String, String> var2) throws CmsException;

    @Override
    public List<CmsResource> getResults(CmsObject cms) throws CmsException {
        return this.getResults(cms, this.getDefaultCollectorName(), this.m_collectorParameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CmsResource> getResults(CmsObject cms, String collectorName, String parameter) throws CmsException {
        A_CmsListResourceCollector a_CmsListResourceCollector = this;
        synchronized (a_CmsListResourceCollector) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_COLLECTOR_GET_RESULTS_START_0"));
            }
            if (parameter == null) {
                parameter = this.m_collectorParameter;
            }
            ArrayList<CmsResource> resources = new ArrayList();
            if (this.getWp().getList() != null) {
                for (CmsListItem item : this.getListItems(parameter)) {
                    resources.add(this.getResource(cms, item));
                }
            } else {
                Map<String, String> params = CmsStringUtil.splitAsMap(parameter, "|", ":");
                resources = this.getInternalResources(cms, params);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_COLLECTOR_GET_RESULTS_END_1", new Integer(resources.size())));
            }
            return resources;
        }
    }

    @Override
    public A_CmsListExplorerDialog getWp() {
        return this.m_wp;
    }

    @Override
    public void setDefaultCollectorName(String collectorName) {
    }

    @Override
    public void setDefaultCollectorParam(String param) {
        this.m_collectorParameter = param;
    }

    @Override
    public void setOrder(int order) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPage(int page) {
        int pos;
        if (this.m_collectorParameter != null && (pos = this.m_collectorParameter.indexOf("page")) >= 0) {
            String params = "";
            int endPos = this.m_collectorParameter.indexOf("|", pos);
            if (pos > 0) {
                params = params + this.m_collectorParameter.substring(0, pos -= "|".length());
            }
            if (endPos >= 0) {
                if (pos == 0) {
                    endPos += "|".length();
                }
                params = params + this.m_collectorParameter.substring(endPos, this.m_collectorParameter.length());
            }
            this.m_collectorParameter = params;
        }
        if (this.m_collectorParameter == null) {
            this.m_collectorParameter = "";
        } else if (this.m_collectorParameter.length() > 0) {
            this.m_collectorParameter = this.m_collectorParameter + "|";
        }
        this.m_collectorParameter = this.m_collectorParameter + "page:" + page;
        A_CmsListResourceCollector a_CmsListResourceCollector = this;
        synchronized (a_CmsListResourceCollector) {
            this.m_resources = null;
        }
    }

    protected CmsListItem createResourceListItem(CmsResource resource, CmsHtmlList list, boolean showPermissions, boolean showDateLastMod, boolean showUserLastMod, boolean showDateCreate, boolean showUserCreate, boolean showDateRel, boolean showDateExp, boolean showState, boolean showLockedBy, boolean showSite) {
        CmsListItem item = list.newItem(resource.getStructureId().toString());
        CmsResourceUtil resUtil = this.getWp().getResourceUtil();
        resUtil.setResource(resource);
        item.set("ecn", resUtil.getPath());
        item.set("crp", resUtil.getFullPath());
        item.set("ect", resUtil.getTitle());
        item.set("ecy", resUtil.getResourceTypeName());
        item.set("ecz", resUtil.getSizeString());
        if (showPermissions) {
            item.set("ecp", resUtil.getPermissionString());
        }
        if (showDateLastMod) {
            item.set("ecdl", new Date(resource.getDateLastModified()));
        }
        if (showUserLastMod) {
            item.set("ecul", resUtil.getUserLastModified());
        }
        if (showDateCreate) {
            item.set("ecdc", new Date(resource.getDateCreated()));
        }
        if (showUserCreate) {
            item.set("ecuc", resUtil.getUserCreated());
        }
        if (showDateRel) {
            item.set("ecdr", new Date(resource.getDateReleased()));
        }
        if (showDateExp) {
            item.set("ecde", new Date(resource.getDateExpired()));
        }
        if (showState) {
            item.set("ecs", resUtil.getStateName());
        }
        if (showLockedBy) {
            item.set("eclb", resUtil.getLockedByName());
        }
        if (showSite) {
            item.set("ecsi", resUtil.getSiteTitle());
        }
        this.setAdditionalColumns(item, resUtil);
        return item;
    }

    protected CmsListItem getDummyListItem(CmsHtmlList list) {
        CmsListItem item = list.newItem(CmsUUID.getNullUUID().toString());
        item.set("ecn", "");
        item.set("ect", "");
        item.set("ecy", "");
        item.set("ecz", "");
        item.set("ecp", "");
        item.set("ecdl", new Date());
        item.set("ecul", "");
        item.set("ecdc", new Date());
        item.set("ecuc", "");
        item.set("ecdr", new Date());
        item.set("ecde", new Date());
        item.set("ecs", "");
        item.set("eclb", "");
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<CmsResource> getInternalResources(CmsObject cms, Map<String, String> params) throws CmsException {
        A_CmsListResourceCollector a_CmsListResourceCollector = this;
        synchronized (a_CmsListResourceCollector) {
            if (this.m_resources == null) {
                this.m_resources = this.getResources(cms, params);
                for (CmsResource resource : this.m_resources) {
                    this.m_resCache.put(resource.getStructureId().toString(), resource);
                }
            }
        }
        return this.m_resources;
    }

    protected List<String> getResourceNamesFromParam(Map<String, String> params) {
        String resourcesParam = "/";
        if (params.containsKey("resources")) {
            resourcesParam = params.get("resources");
        }
        if (resourcesParam.length() == 0) {
            return Collections.emptyList();
        }
        return CmsStringUtil.splitAsList(resourcesParam, "#");
    }

    protected CmsListState getState(Map<String, String> params) {
        CmsListState state = new CmsListState();
        try {
            state.setPage(Integer.parseInt(params.get("page")));
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            state.setOrder(CmsListOrderEnum.valueOf(params.get("order")));
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            state.setFilter(params.get("filter"));
        }
        catch (Throwable e) {
            // empty catch block
        }
        try {
            state.setColumn(params.get("sortby"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return state;
    }

    protected abstract void setAdditionalColumns(CmsListItem var1, CmsResourceUtil var2);

    protected void setResourcesParam(List<String> resources) {
        this.m_collectorParameter = this.m_collectorParameter + "|resources:";
        this.m_collectorParameter = resources == null ? this.m_collectorParameter + "/" : this.m_collectorParameter + CmsStringUtil.collectionAsString(resources, "#");
    }
}

