/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.Comparator;
import java.util.Locale;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListItemComparator;

public class CmsListItemActionIconComparator
implements I_CmsListItemComparator {
    public Comparator getComparator(final String columnId, Locale locale) {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                CmsListItem li1 = (CmsListItem)o1;
                CmsListItem li2 = (CmsListItem)o2;
                CmsListColumnDefinition col = li1.getMetadata().getColumnDefinition(columnId);
                if (col.getDirectActions().size() > 0) {
                    String i1 = null;
                    String i2 = null;
                    for (I_CmsListDirectAction action : col.getDirectActions()) {
                        CmsListItem tmp = action.getItem();
                        action.setItem(li1);
                        if (action.isVisible()) {
                            i1 = action.getIconPath();
                        }
                        action.setItem(li2);
                        if (action.isVisible()) {
                            i2 = action.getIconPath();
                        }
                        action.setItem(tmp);
                    }
                    if (i1 != null) {
                        if (i2 == null) {
                            return 1;
                        }
                        return i1.compareTo(i2);
                    }
                    if (i2 != null) {
                        return -1;
                    }
                    return 0;
                }
                Comparable c1 = (Comparable)((CmsListItem)o1).get(columnId);
                Comparable c2 = (Comparable)((CmsListItem)o2).get(columnId);
                if (c1 != null) {
                    if (c2 == null) {
                        return 1;
                    }
                    return c1.compareTo(c2);
                }
                if (c2 != null) {
                    return -1;
                }
                return 0;
            }
        };
    }
}

