/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.list.A_CmsListDefaultJsAction;
import org.opencms.workplace.list.Messages;

public class CmsListOpenResourceAction
extends A_CmsListDefaultJsAction {
    private final String m_resColumnPathId;

    public CmsListOpenResourceAction(String id, String resColumnPathId) {
        super(id);
        this.m_resColumnPathId = resColumnPathId;
        this.setName(Messages.get().container("GUI_OPENRESOURCE_ACTION_NAME_0"));
        this.setHelpText(Messages.get().container("GUI_OPENRESOURCE_ACTION_HELP_0"));
    }

    @Override
    public CmsMessageContainer getHelpText() {
        if (this.isEnabled()) {
            return super.getHelpText();
        }
        return Messages.get().container("GUI_OPENRESOURCE_ACTION_DISABLED_HELP_0");
    }

    @Override
    public boolean isEnabled() {
        if (this.getResourceName() != null) {
            return super.isEnabled();
        }
        return false;
    }

    @Override
    public String jsCode() {
        StringBuffer jsCode = new StringBuffer(256);
        jsCode.append("javascript:top.openwinfull('");
        jsCode.append(this.getResourceName());
        jsCode.append("', true)");
        return jsCode.toString();
    }

    protected String getResourceName() {
        String resource = this.getItem().get(this.m_resColumnPathId).toString();
        if (!this.getWp().getCms().existsResource(resource, CmsResourceFilter.DEFAULT)) {
            String siteRoot = OpenCms.getSiteManager().getSiteRoot(resource);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(siteRoot)) {
                resource = resource.substring(siteRoot.length());
            }
            if (!this.getWp().getCms().existsResource(resource, CmsResourceFilter.DEFAULT)) {
                resource = null;
            }
        }
        return resource;
    }
}

