/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsEncoder;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.Messages;
import org.xml.sax.EntityResolver;

public final class CmsXmlContentFactory {
    private CmsXmlContentFactory() {
    }

    public static CmsXmlContent createDocument(CmsObject cms, Locale locale, CmsResourceTypeXmlContent resourceType) throws CmsXmlException {
        String schema = resourceType.getSchema();
        CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, schema);
        CmsXmlContent xmlContent = CmsXmlContentFactory.createDocument(cms, locale, OpenCms.getSystemInfo().getDefaultEncoding(), contentDefinition);
        return xmlContent;
    }

    public static CmsXmlContent createDocument(CmsObject cms, Locale locale, String modelUri) throws CmsException {
        CmsXmlContent content = new CmsXmlContent(cms, locale, modelUri);
        return content.getContentDefinition().getContentHandler().prepareForUse(cms, content);
    }

    public static CmsXmlContent createDocument(CmsObject cms, Locale locale, String encoding, CmsXmlContentDefinition contentDefinition) {
        CmsXmlContent content = new CmsXmlContent(cms, locale, encoding, contentDefinition);
        return content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlContent unmarshal(CmsObject cms, byte[] xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlContentFactory.unmarshal(cms, CmsXmlUtils.unmarshalHelper(xmlData, resolver), encoding, resolver);
    }

    public static CmsXmlContent unmarshal(CmsObject cms, CmsFile file) throws CmsXmlException {
        return CmsXmlContentFactory.unmarshal(cms, file, true);
    }

    public static CmsXmlContent unmarshal(CmsObject cms, CmsFile file, boolean keepEncoding) throws CmsXmlException {
        CmsXmlContent content;
        byte[] contentBytes = file.getContents();
        String filename = cms.getSitePath(file);
        String encoding = null;
        try {
            encoding = cms.readPropertyObject(filename, "content-encoding", true).getValue();
        }
        catch (CmsException e) {
            // empty catch block
        }
        if (encoding == null) {
            encoding = OpenCms.getSystemInfo().getDefaultEncoding();
        } else if ((encoding = CmsEncoder.lookupEncoding(encoding, null)) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ENC_1", filename));
        }
        if (contentBytes.length > 0) {
            if (keepEncoding) {
                content = CmsXmlContentFactory.unmarshal(cms, contentBytes, encoding, (EntityResolver)new CmsXmlEntityResolver(cms));
            } else {
                try {
                    String contentStr = new String(contentBytes, encoding);
                    content = CmsXmlContentFactory.unmarshal(cms, contentStr, encoding, (EntityResolver)new CmsXmlEntityResolver(cms));
                }
                catch (UnsupportedEncodingException e) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ENC_1", filename));
                }
            }
        } else {
            content = new CmsXmlContent(cms, DocumentHelper.createDocument(), encoding, new CmsXmlEntityResolver(cms));
        }
        content.setFile(file);
        return content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlContent unmarshal(CmsObject cms, CmsResource resource, ServletRequest req) throws CmsXmlException, CmsLoaderException, CmsException {
        String rootPath = resource.getRootPath();
        if (!CmsResourceTypeXmlContent.isXmlContent(resource)) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_TYPE_1", cms.getSitePath(resource)));
        }
        CmsXmlContent content = (CmsXmlContent)req.getAttribute(rootPath);
        if (content == null) {
            content = CmsXmlContentFactory.unmarshal(cms, cms.readFile(resource));
            req.setAttribute(rootPath, (Object)content);
        }
        return content;
    }

    public static CmsXmlContent unmarshal(CmsObject cms, Document document, String encoding, EntityResolver resolver) {
        CmsXmlContent content = new CmsXmlContent(cms, document, encoding, resolver);
        return content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlContent unmarshal(CmsObject cms, String xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlContentFactory.unmarshal(cms, CmsXmlUtils.unmarshalHelper(xmlData, resolver), encoding, resolver);
    }

    public static CmsXmlContent unmarshal(String xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlContentFactory.unmarshal(null, xmlData, encoding, resolver);
    }
}

