/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.I_CmsGlobalConfigurationCache;
import org.opencms.ade.configuration.formatters.CmsFormatterBeanParser;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsFormatterConfigurationCache
implements I_CmsGlobalConfigurationCache {
    public static final CmsUUID RELOAD_MARKER = CmsUUID.getNullUUID();
    public static final String TYPE_FORMATTER_CONFIG = "formatter_config";
    protected static int UPDATE_DELAY_SECONDS = 7;
    private static final Log LOG = CmsLog.getLog(CmsFormatterConfigurationCache.class);
    private CmsObject m_cms;
    private Set<CmsUUID> m_idsToUpdate = new HashSet<CmsUUID>();
    private String m_name;
    private boolean m_scheduledUpdate;
    private CmsFormatterConfigurationCacheState m_state = new CmsFormatterConfigurationCacheState(Collections.<CmsUUID, I_CmsFormatterBean>emptyMap());

    public CmsFormatterConfigurationCache(CmsObject cms, String name) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
        Map<CmsUUID, I_CmsFormatterBean> noFormatters = Collections.emptyMap();
        this.m_state = new CmsFormatterConfigurationCacheState(noFormatters);
        this.m_name = name;
    }

    @Override
    public void clear() {
        this.markForUpdate(RELOAD_MARKER);
    }

    public String getName() {
        return this.m_name;
    }

    public CmsFormatterConfigurationCacheState getState() {
        return this.m_state;
    }

    public synchronized void performUpdate() {
        this.m_scheduledUpdate = false;
        HashSet<CmsUUID> copiedIds = new HashSet<CmsUUID>(this.m_idsToUpdate);
        this.m_idsToUpdate.clear();
        if (copiedIds.contains(RELOAD_MARKER)) {
            this.reload();
        } else {
            HashMap formattersToUpdate = Maps.newHashMap();
            for (CmsUUID structureId : copiedIds) {
                CmsFormatterBean formatterBean = this.readFormatter(structureId);
                formattersToUpdate.put(structureId, formatterBean);
            }
            this.m_state = this.m_state.createUpdatedCopy(formattersToUpdate);
        }
    }

    public synchronized void reload() {
        try {
            this.m_idsToUpdate.clear();
            int typeId = OpenCms.getResourceManager().getResourceType(TYPE_FORMATTER_CONFIG).getTypeId();
            CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(typeId);
            List<CmsResource> formatterResources = this.m_cms.readResources("/", filter);
            HashMap newFormatters = Maps.newHashMap();
            for (CmsResource formatterResource : formatterResources) {
                CmsFormatterBean formatterBean = this.readFormatter(formatterResource.getStructureId());
                if (formatterBean == null) continue;
                newFormatters.put(formatterResource.getStructureId(), formatterBean);
            }
            this.m_state = new CmsFormatterConfigurationCacheState(newFormatters);
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    @Override
    public void remove(CmsPublishedResource pubRes) {
        this.checkIfUpdateIsNeeded(pubRes.getStructureId(), pubRes.getRootPath(), pubRes.getType());
    }

    @Override
    public void remove(CmsResource resource) {
        this.checkIfUpdateIsNeeded(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    @Override
    public void update(CmsPublishedResource pubRes) {
        this.checkIfUpdateIsNeeded(pubRes.getStructureId(), pubRes.getRootPath(), pubRes.getType());
    }

    @Override
    public void update(CmsResource resource) {
        this.checkIfUpdateIsNeeded(resource.getStructureId(), resource.getRootPath(), resource.getTypeId());
    }

    public synchronized void waitForUpdate() {
        while (this.m_scheduledUpdate) {
            try {
                this.wait(300L);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected CmsFormatterBean readFormatter(CmsUUID structureId) {
        CmsFormatterBean formatterBean = null;
        CmsResource formatterRes = null;
        try {
            formatterRes = this.m_cms.readResource(structureId);
            CmsFile formatterFile = this.m_cms.readFile(formatterRes);
            CmsFormatterBeanParser parser = new CmsFormatterBeanParser(this.m_cms);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.m_cms, formatterFile);
            formatterBean = parser.parse(content, formatterRes.getRootPath(), "" + formatterRes.getStructureId());
        }
        catch (Exception e) {
            if (formatterRes == null) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            LOG.error((Object)("Error while trying to read formatter configuration " + formatterRes.getRootPath() + ":    " + e.getLocalizedMessage()), (Throwable)e);
        }
        return formatterBean;
    }

    private void checkIfUpdateIsNeeded(CmsUUID structureId, String path, int resourceType) {
        if (CmsResource.isTemporaryFileName(path)) {
            return;
        }
        if (OpenCms.getResourceManager().matchResourceType(TYPE_FORMATTER_CONFIG, resourceType)) {
            this.markForUpdate(structureId);
        }
    }

    private synchronized void markForUpdate(CmsUUID structureId) {
        this.m_idsToUpdate.add(structureId);
        if (!this.m_scheduledUpdate) {
            OpenCms.getExecutor().schedule(new Runnable(){

                @Override
                public void run() {
                    CmsFormatterConfigurationCache.this.performUpdate();
                }
            }, (long)UPDATE_DELAY_SECONDS, TimeUnit.SECONDS);
            this.m_scheduledUpdate = true;
        }
    }
}

