/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.containerpage.CmsElementUtil;
import org.opencms.ade.containerpage.CmsRelationTargetListBean;
import org.opencms.ade.containerpage.Messages;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReference;
import org.opencms.ade.containerpage.inherited.CmsInheritanceReferenceParser;
import org.opencms.ade.containerpage.inherited.CmsInheritedContainerState;
import org.opencms.ade.containerpage.shared.CmsCntPageData;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.containerpage.shared.CmsContainerElement;
import org.opencms.ade.containerpage.shared.CmsContainerElementData;
import org.opencms.ade.containerpage.shared.CmsCreateElementData;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.ade.containerpage.shared.CmsGroupContainer;
import org.opencms.ade.containerpage.shared.CmsGroupContainerSaveResult;
import org.opencms.ade.containerpage.shared.CmsInheritanceContainer;
import org.opencms.ade.containerpage.shared.CmsInheritanceInfo;
import org.opencms.ade.containerpage.shared.CmsRemovedElementStatus;
import org.opencms.ade.containerpage.shared.rpc.I_CmsContainerpageService;
import org.opencms.ade.detailpage.CmsDetailPageResourceHandler;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsDefaultResourceStatusProvider;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.CmsVfsService;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.gwt.shared.CmsTemplateContextInfo;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.CmsWorkplaceEditorManager;
import org.opencms.workplace.explorer.CmsNewResourceXmlContent;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsGroupContainerBean;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.CmsXmlGroupContainer;
import org.opencms.xml.containerpage.CmsXmlGroupContainerFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsContainerpageService
extends CmsGwtService
implements I_CmsContainerpageService {
    public static final String ADDINFO_EDIT_SMALL_ELEMENTS = "EDIT_SMALL_ELEMENTS";
    private static final Log LOG = CmsLog.getLog(CmsContainerpageService.class);
    private static final long serialVersionUID = -6188370638303594280L;
    private CmsADESessionCache m_sessionCache;

    public static List<CmsModelResourceInfo> generateModelResourceList(CmsObject cms, String resourceType, List<CmsResource> modelResources, Locale contentLocale) throws CmsException {
        ArrayList<CmsModelResourceInfo> result = new ArrayList<CmsModelResourceInfo>();
        Locale wpLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        CmsModelResourceInfo defaultInfo = new CmsModelResourceInfo(Messages.get().getBundle(wpLocale).key("GUI_TITLE_DEFAULT_RESOURCE_CONTENT_0"), Messages.get().getBundle(wpLocale).key("GUI_DESCRIPTION_DEFAULT_RESOURCE_CONTENT_0"), null);
        defaultInfo.setResourceType(resourceType);
        result.add(defaultInfo);
        for (CmsResource model : modelResources) {
            CmsGallerySearchResult searchInfo = CmsGallerySearch.searchById(cms, model.getStructureId(), contentLocale);
            CmsModelResourceInfo modelInfo = new CmsModelResourceInfo(searchInfo.getTitle(), searchInfo.getDescription(), null);
            modelInfo.addAdditionalInfo(Messages.get().getBundle(wpLocale).key("GUI_LABEL_PATH_0"), cms.getSitePath(model));
            modelInfo.setResourceType(resourceType);
            modelInfo.setStructureId(model.getStructureId());
            result.add(modelInfo);
        }
        return result;
    }

    public static String getSerializedElementInfo(CmsObject cms, HttpServletRequest request, HttpServletResponse response, CmsContainerElementBean elementBean) throws Exception {
        CmsContainerElement result = new CmsContainerElement();
        CmsElementUtil util = new CmsElementUtil(cms, cms.getRequestContext().getUri(), null, request, response, cms.getRequestContext().getLocale());
        util.setElementInfo(elementBean, result);
        return CmsGwtActionElement.serialize(I_CmsContainerpageService.class.getMethod("getElementInfo", new Class[0]), result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CmsCntPageData prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsContainerpageService srv = new CmsContainerpageService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsCntPageData result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    @Override
    public void addToFavoriteList(String clientId) throws CmsRpcException {
        try {
            this.ensureSession();
            List<CmsContainerElementBean> list = OpenCms.getADEManager().getFavoriteList(this.getCmsObject());
            this.updateFavoriteRecentList(clientId, list);
            OpenCms.getADEManager().saveFavoriteList(this.getCmsObject(), list);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void addToRecentList(String clientId) throws CmsRpcException {
        try {
            this.ensureSession();
            List<CmsContainerElementBean> list = OpenCms.getADEManager().getRecentList(this.getCmsObject());
            this.updateFavoriteRecentList(clientId, list);
            OpenCms.getADEManager().saveRecentList(this.getCmsObject(), list);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public boolean checkContainerpageOrElementsChanged(CmsUUID structureId, CmsUUID detailContentId) throws CmsRpcException {
        try {
            ArrayList<CmsUUID> additionalIds = new ArrayList<CmsUUID>();
            additionalIds.add(structureId);
            if (detailContentId != null) {
                additionalIds.add(detailContentId);
            }
            CmsRelationTargetListBean result = CmsDefaultResourceStatusProvider.getContainerpageRelationTargets(this.getCmsObject(), structureId, additionalIds, true);
            return result.isChanged();
        }
        catch (Throwable e) {
            this.error(e);
            return false;
        }
    }

    @Override
    public CmsCreateElementData checkCreateNewElement(CmsUUID pageStructureId, String clientId, String resourceType, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsCreateElementData result = new CmsCreateElementData();
        try {
            CmsResource currentPage = cms.readResource(pageStructureId);
            List<CmsResource> modelResources = CmsNewResourceXmlContent.getModelFiles(this.getCmsObject(), CmsResource.getFolderPath(cms.getSitePath(currentPage)), resourceType);
            if (modelResources.isEmpty()) {
                result.setCreatedElement(this.createNewElement(pageStructureId, clientId, resourceType, null, locale));
            } else {
                result.setModelResources(CmsContainerpageService.generateModelResourceList(this.getCmsObject(), resourceType, modelResources, CmsLocaleManager.getLocale(locale)));
            }
        }
        catch (CmsException e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public boolean checkNewWidgetsAvailable(CmsUUID structureId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = cms.readResource(structureId);
            return CmsWorkplaceEditorManager.checkAcaciaEditorAvailable(cms, resource);
        }
        catch (Throwable t) {
            this.error(t);
            return false;
        }
    }

    public CmsUUID convertToServerId(String id) throws CmsIllegalArgumentException {
        if (id == null) {
            throw new CmsIllegalArgumentException(org.opencms.xml.containerpage.Messages.get().container("ERR_INVALID_ID_1", id));
        }
        String serverId = id;
        try {
            if (serverId.contains("#")) {
                serverId = serverId.substring(0, serverId.indexOf("#"));
            }
            return new CmsUUID(serverId);
        }
        catch (NumberFormatException e) {
            throw new CmsIllegalArgumentException(org.opencms.xml.containerpage.Messages.get().container("ERR_INVALID_ID_1", id));
        }
    }

    @Override
    public CmsUUID copyElement(CmsUUID pageId, CmsUUID originalElementId) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource page = cms.readResource(pageId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsResource element = cms.readResource(originalElementId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, page.getRootPath());
            String typeName = OpenCms.getResourceManager().getResourceType(element.getTypeId()).getTypeName();
            CmsResourceTypeConfig typeConfig = config.getResourceType(typeName);
            if (typeConfig == null) {
                LOG.error((Object)("copyElement: Type not configured in ADE configuration: " + typeName));
                return originalElementId;
            }
            CmsResource newResource = typeConfig.createNewElement(cms, element);
            return newResource.getStructureId();
        }
        catch (Throwable e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsContainerElement createNewElement(CmsUUID pageStructureId, String clientId, String resourceType, CmsUUID modelResourceStructureId, String locale) throws CmsRpcException {
        CmsContainerElement element = null;
        try {
            this.ensureSession();
            CmsObject cms = this.getCmsObject();
            CmsResource pageResource = cms.readResource(pageStructureId);
            CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, pageResource.getRootPath());
            CmsResourceTypeConfig typeConfig = configData.getResourceType(resourceType);
            CmsObject cloneCms = OpenCms.initCmsObject(cms);
            cloneCms.getRequestContext().setLocale(CmsLocaleManager.getLocale(locale));
            CmsResource modelResource = null;
            if (modelResourceStructureId != null) {
                modelResource = cms.readResource(modelResourceStructureId);
            }
            CmsResource newResource = typeConfig.createNewElement(cloneCms, modelResource);
            CmsContainerElementBean bean = this.getCachedElement(clientId);
            CmsContainerElementBean newBean = new CmsContainerElementBean(newResource.getStructureId(), null, bean.getIndividualSettings(), false);
            String newClientId = newBean.editorHash();
            this.getSessionCache().setCacheContainerElement(newClientId, newBean);
            element = new CmsContainerElement();
            element.setNewEditorDisabled(!CmsWorkplaceEditorManager.checkAcaciaEditorAvailable(cms, newResource));
            element.setClientId(newClientId);
            element.setSitePath(cms.getSitePath(newResource));
            element.setResourceType(resourceType);
        }
        catch (CmsException e) {
            this.error(e);
        }
        return element;
    }

    @Override
    public CmsContainerElement getElementInfo() {
        throw new UnsupportedOperationException("This method is used for serialization only.");
    }

    @Override
    public Map<String, CmsContainerElementData> getElementsData(CmsUUID pageStructureId, CmsUUID detailContentId, String reqParams, Collection<String> clientIds, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        Map<String, CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource pageResource = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(pageResource);
            result = this.getElements(clientIds, containerpageUri, detailContentId, containers, CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsContainerElementData getElementWithSettings(CmsUUID pageStructureId, CmsUUID detailContentId, String uriParams, String clientId, Map<String, String> settings, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        CmsContainerElementData element = null;
        try {
            this.ensureSession();
            CmsObject cms = this.getCmsObject();
            CmsResource pageResource = cms.readResource(pageStructureId);
            String containerpageUri = cms.getSitePath(pageResource);
            Locale contentLocale = CmsLocaleManager.getLocale(locale);
            CmsElementUtil elemUtil = new CmsElementUtil(cms, containerpageUri, detailContentId, this.getRequest(), this.getResponse(), contentLocale);
            CmsContainerElementBean elementBean = this.getCachedElement(clientId);
            elementBean.initResource(cms);
            elementBean = CmsContainerElementBean.cloneWithSettings(elementBean, this.convertSettingValues(elementBean.getResource(), settings, contentLocale));
            this.getSessionCache().setCacheContainerElement(elementBean.editorHash(), elementBean);
            element = elemUtil.getElementData(elementBean, containers);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return element;
    }

    @Override
    public List<CmsContainerElementData> getFavoriteList(CmsUUID pageStructureId, CmsUUID detailContentId, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        List<CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource containerpage = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(containerpage);
            result = this.getListElementsData(OpenCms.getADEManager().getFavoriteList(this.getCmsObject()), containerpageUri, detailContentId, containers, CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsContainerElementData getNewElementData(CmsUUID pageStructureId, CmsUUID detailContentId, String reqParams, String resourceType, Collection<CmsContainer> containers, String localeName) throws CmsRpcException {
        CmsContainerElementData result = null;
        try {
            this.ensureSession();
            CmsResource pageResource = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(pageResource);
            Locale locale = CmsLocaleManager.getLocale(localeName);
            result = this.getNewElement(resourceType, containerpageUri, detailContentId, containers, locale);
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public List<CmsContainerElementData> getRecentList(CmsUUID pageStructureId, CmsUUID detailContentId, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        List<CmsContainerElementData> result = null;
        try {
            this.ensureSession();
            CmsResource containerpage = this.getCmsObject().readResource(pageStructureId);
            String containerpageUri = this.getCmsObject().getSitePath(containerpage);
            result = this.getListElementsData(OpenCms.getADEManager().getRecentList(this.getCmsObject()), containerpageUri, detailContentId, containers, CmsLocaleManager.getLocale(locale));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return result;
    }

    @Override
    public CmsRemovedElementStatus getRemovedElementStatus(String id, CmsUUID containerpageId) throws CmsRpcException {
        if (id == null || !id.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*$")) {
            return new CmsRemovedElementStatus(null, null, false);
        }
        try {
            CmsUUID structureId = this.convertToServerId(id);
            return this.internalGetRemovedElementStatus(structureId, containerpageId);
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    public CmsRemovedElementStatus internalGetRemovedElementStatus(CmsUUID structureId, CmsUUID containerpageId) throws CmsException, CmsLoaderException {
        CmsObject cms = this.getCmsObject();
        CmsResource elementResource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
        boolean hasWritePermissions = cms.hasPermissions(elementResource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
        boolean isSystemResource = elementResource.getRootPath().startsWith("/system/");
        CmsRelationFilter relationFilter = CmsRelationFilter.relationsToStructureId(structureId);
        List<CmsRelation> relationsToElement = cms.readRelations(relationFilter);
        Iterator<CmsRelation> iter = relationsToElement.iterator();
        while (iter.hasNext()) {
            CmsRelation relation = iter.next();
            if (containerpageId == null || !containerpageId.equals(relation.getSourceId()) || !relation.getType().equals(CmsRelationType.XML_STRONG)) continue;
            iter.remove();
        }
        boolean hasNoRelations = relationsToElement.isEmpty();
        boolean deletionCandidate = hasNoRelations && hasWritePermissions && !isSystemResource;
        CmsListInfoBean elementInfo = CmsVfsService.getPageInfo(cms, elementResource);
        return new CmsRemovedElementStatus(structureId, elementInfo, deletionCandidate);
    }

    @Override
    public CmsCntPageData prefetch() throws CmsRpcException {
        CmsCntPageData data = null;
        CmsObject cms = this.getCmsObject();
        HttpServletRequest request = this.getRequest();
        try {
            String noEditReason;
            CmsTemplateContextInfo info = OpenCms.getTemplateContextManager().getContextInfoBean(cms, request);
            CmsResource containerPage = this.getContainerpage(cms);
            CmsJspStandardContextBean.TemplateBean templateBean = (CmsJspStandardContextBean.TemplateBean)this.getRequest().getAttribute("ATTR_TEMPLATE_BEAN");
            CmsADESessionCache sessionCache = CmsADESessionCache.getCache(this.getRequest(), cms);
            sessionCache.setTemplateBean(containerPage.getRootPath(), templateBean);
            long lastModified = containerPage.getDateLastModified();
            String editorUri = OpenCms.getWorkplaceManager().getEditorHandler().getEditorUri(cms, "xmlcontent", "User agent", false);
            boolean useClassicEditor = editorUri == null || !editorUri.contains("acacia");
            CmsResource detailResource = CmsDetailPageResourceHandler.getDetailResource((ServletRequest)request);
            String detailContainerPage = null;
            if (detailResource != null) {
                detailContainerPage = CmsJspTagContainer.getDetailOnlyPageName(cms.getSitePath(detailResource));
                if (cms.existsResource(detailContainerPage)) {
                    noEditReason = this.getNoEditReason(cms, cms.readResource(detailContainerPage));
                } else {
                    String permissionFolder = CmsResource.getFolderPath(detailContainerPage);
                    if (!cms.existsResource(permissionFolder)) {
                        permissionFolder = CmsResource.getParentFolder(permissionFolder);
                    }
                    noEditReason = this.getNoEditReason(cms, cms.readResource(permissionFolder));
                }
            } else {
                noEditReason = this.getNoEditReason(cms, containerPage);
            }
            data = new CmsCntPageData(noEditReason, CmsRequestUtil.encodeParams(request), "/system/modules/org.opencms.ade.sitemap/pages/sitemap.jsp", detailResource != null ? detailResource.getStructureId() : null, detailContainerPage, this.getNewTypes(cms, request), lastModified, this.getLockInfo(containerPage), cms.getRequestContext().getLocale().toString(), useClassicEditor, info, this.isEditSmallElements(request, cms));
        }
        catch (Throwable e) {
            this.error(e);
        }
        return data;
    }

    @Override
    public void saveContainerpage(CmsUUID pageStructureId, List<CmsContainer> containers, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            this.ensureSession();
            CmsResource containerpage = cms.readResource(pageStructureId);
            this.ensureLock(containerpage);
            String containerpageUri = cms.getSitePath(containerpage);
            Locale contentLocale = CmsLocaleManager.getLocale(locale);
            this.saveContainers(cms, containerpage, containerpageUri, containers, contentLocale);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void saveDetailContainers(String detailContainerResource, List<CmsContainer> containers, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        try {
            CmsResource containerpage;
            this.ensureSession();
            if (cms.existsResource(detailContainerResource)) {
                containerpage = cms.readResource(detailContainerResource);
            } else {
                String parentFolder = CmsResource.getFolderPath(detailContainerResource);
                if (!cms.existsResource(parentFolder)) {
                    CmsResource parentRes = cms.createResource(parentFolder, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()).getTypeId());
                    cms.writePropertyObject(parentFolder, new CmsProperty("search.exclude", "all", null));
                    this.tryUnlock(parentRes);
                }
                containerpage = cms.createResource(detailContainerResource, CmsResourceTypeXmlContainerPage.getContainerPageTypeId());
            }
            this.ensureLock(containerpage);
            Locale contentLocale = CmsLocaleManager.getLocale(locale);
            this.saveContainers(cms, containerpage, detailContainerResource, containers, contentLocale);
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void saveFavoriteList(List<String> clientIds) throws CmsRpcException {
        try {
            this.ensureSession();
            OpenCms.getADEManager().saveFavoriteList(this.getCmsObject(), this.getCachedElements(clientIds));
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public CmsGroupContainerSaveResult saveGroupContainer(CmsUUID pageStructureId, CmsUUID detailContentId, String reqParams, CmsGroupContainer groupContainer, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        List<CmsRemovedElementStatus> removedElements = null;
        try {
            CmsPair<CmsContainerElement, List<CmsRemovedElementStatus>> saveResult = this.internalSaveGroupContainer(cms, pageStructureId, groupContainer);
            removedElements = saveResult.getSecond();
        }
        catch (Throwable e) {
            this.error(e);
        }
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(groupContainer.getClientId());
        OpenCms.getSearchManager().updateOfflineIndexes(30000L);
        return new CmsGroupContainerSaveResult(this.getElementsData(pageStructureId, detailContentId, reqParams, ids, containers, locale), removedElements);
    }

    @Override
    public Map<String, CmsContainerElementData> saveInheritanceContainer(CmsUUID pageStructureId, CmsUUID detailContentId, CmsInheritanceContainer inheritanceContainer, Collection<CmsContainer> containers, String locale) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource containerPage = cms.readResource(pageStructureId);
            String sitePath = cms.getSitePath(containerPage);
            Locale requestedLocale = CmsLocaleManager.getLocale(locale);
            CmsResource referenceResource = null;
            if (inheritanceContainer.isNew()) {
                CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, containerPage.getRootPath());
                CmsResourceTypeConfig typeConfig = config.getResourceType("inheritance_group");
                referenceResource = typeConfig.createNewElement(cms);
                inheritanceContainer.setClientId(referenceResource.getStructureId().toString());
            }
            if (referenceResource == null) {
                CmsUUID id = this.convertToServerId(inheritanceContainer.getClientId());
                referenceResource = cms.readResource(id, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            }
            this.ensureLock(referenceResource);
            this.saveInheritanceGroup(referenceResource, inheritanceContainer);
            this.tryUnlock(referenceResource);
            ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
            for (CmsContainerElement clientElement : inheritanceContainer.getElements()) {
                CmsContainerElementBean elementBean = this.getCachedElement(clientElement.getClientId());
                CmsInheritanceInfo inheritanceInfo = clientElement.getInheritanceInfo();
                if (inheritanceInfo.isNew() && CmsStringUtil.isEmptyOrWhitespaceOnly(inheritanceInfo.getKey())) {
                    inheritanceInfo.setKey(CmsResource.getFolderPath(sitePath) + new CmsUUID().toString());
                }
                elementBean.setInheritanceInfo(inheritanceInfo);
                elements.add(elementBean);
            }
            cms.getRequestContext().setLocale(requestedLocale);
            if (inheritanceContainer.getElementsChanged()) {
                OpenCms.getADEManager().saveInheritedContainer(cms, containerPage, inheritanceContainer.getName(), true, elements);
            }
            OpenCms.getSearchManager().updateOfflineIndexes(30000L);
            return this.getElements(new ArrayList<String>(Collections.singletonList(inheritanceContainer.getClientId())), sitePath, detailContentId, containers, requestedLocale);
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public void saveRecentList(List<String> clientIds) throws CmsRpcException {
        try {
            this.ensureSession();
            OpenCms.getADEManager().saveRecentList(this.getCmsObject(), this.getCachedElements(clientIds));
        }
        catch (Throwable e) {
            this.error(e);
        }
    }

    @Override
    public void setEditSmallElements(boolean editSmallElements) throws CmsRpcException {
        try {
            CmsObject cms = this.getCmsObject();
            CmsUser user = cms.getRequestContext().getCurrentUser();
            user.getAdditionalInfo().put(ADDINFO_EDIT_SMALL_ELEMENTS, "" + editSmallElements);
            cms.writeUser(user);
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Override
    public void syncSaveContainerpage(CmsUUID pageStructureId, List<CmsContainer> containers, String locale) throws CmsRpcException {
        this.saveContainerpage(pageStructureId, containers, locale);
    }

    @Override
    public void syncSaveDetailContainers(String detailContainerResource, List<CmsContainer> containers, String locale) throws CmsRpcException {
        this.saveDetailContainers(detailContainerResource, containers, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> convertSettingValues(CmsResource resource, Map<String, String> settings, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        Locale origLocale = cms.getRequestContext().getLocale();
        try {
            cms.getRequestContext().setLocale(locale);
            Map<String, CmsXmlContentProperty> settingsConf = OpenCms.getADEManager().getElementSettings(cms, resource);
            HashMap<String, String> changedSettings = new HashMap<String, String>();
            if (settings != null) {
                for (Map.Entry<String, String> entry : settings.entrySet()) {
                    String settingName = entry.getKey();
                    String settingType = "string";
                    if (settingsConf.get(settingName) != null) {
                        settingType = settingsConf.get(settingName).getType();
                    }
                    changedSettings.put(settingName, CmsXmlContentPropertyHelper.getPropValueIds(this.getCmsObject(), settingType, entry.getValue()));
                }
            }
            HashMap<String, String> hashMap = changedSettings;
            return hashMap;
        }
        finally {
            cms.getRequestContext().setLocale(origLocale);
        }
    }

    private CmsContainerElementBean getCachedElement(String clientId) {
        String id = clientId;
        CmsContainerElementBean element = null;
        element = this.getSessionCache().getCacheContainerElement(id);
        if (element != null) {
            return element;
        }
        if (id.contains("#")) {
            id = id.substring(0, id.indexOf("#"));
            element = this.getSessionCache().getCacheContainerElement(id);
            if (element != null) {
                return element;
            }
        }
        element = new CmsContainerElementBean(this.convertToServerId(id), null, null, false);
        this.getSessionCache().setCacheContainerElement(id, element);
        return element;
    }

    private List<CmsContainerElementBean> getCachedElements(List<String> clientIds) {
        ArrayList<CmsContainerElementBean> result = new ArrayList<CmsContainerElementBean>();
        for (String id : clientIds) {
            try {
                result.add(this.getCachedElement(id));
            }
            catch (CmsIllegalArgumentException e) {
                this.log(e.getLocalizedMessage(), e);
            }
        }
        return result;
    }

    private CmsContainerBean getContainerBeanToSave(CmsContainer container, CmsResource containerpage) {
        CmsObject cms = this.getCmsObject();
        ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElement elementData : container.getElements()) {
            try {
                CmsContainerElementBean newElementBean = this.getContainerElementBeanToSave(cms, containerpage, container, elementData);
                if (newElementBean == null) continue;
                elements.add(newElementBean);
            }
            catch (Exception e) {
                this.log(e.getLocalizedMessage(), e);
            }
        }
        CmsContainerBean result = new CmsContainerBean(container.getName(), container.getType(), elements);
        return result;
    }

    private CmsContainerElementBean getContainerElementBeanToSave(CmsObject cms, CmsResource containerpage, CmsContainer container, CmsContainerElement elementData) throws CmsException {
        boolean isCreateNew;
        String elementClientId = elementData.getClientId();
        boolean hasUuidPrefix = elementClientId != null && elementClientId.matches("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}.*$");
        boolean bl = isCreateNew = elementData.isNew() && hasUuidPrefix;
        if (elementData.isNew() && !hasUuidPrefix) {
            return null;
        }
        CmsContainerElementBean element = this.getCachedElement(elementData.getClientId());
        CmsResource resource = cms.readResource(element.getId(), CmsResourceFilter.IGNORE_EXPIRATION);
        int containerWidth = container.getWidth();
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, containerpage.getRootPath());
        CmsFormatterConfiguration formatters = config.getFormatters(cms, resource);
        String typeName = OpenCms.getResourceManager().getResourceType(resource).getTypeName();
        String containerType = null;
        containerType = "groupcontainer".equals(typeName) || "inheritance_group".equals(typeName) ? "_PREVIEW_" : container.getType();
        I_CmsFormatterBean formatter = null;
        if (element.getSettings() != null && element.getSettings().containsKey(CmsFormatterConfig.getSettingsKeyForContainer(container.getName()))) {
            String formatterConfigId = element.getSettings().get(CmsFormatterConfig.getSettingsKeyForContainer(container.getName()));
            if (CmsUUID.isValidUUID(formatterConfigId)) {
                formatter = OpenCms.getADEManager().getCachedFormatters(false).getFormatters().get(new CmsUUID(formatterConfigId));
            }
            if (formatter == null) {
                formatter = formatters.getDefaultSchemaFormatter(containerType, containerWidth);
            }
        }
        if (formatter == null) {
            formatter = formatters.getDefaultFormatter(containerType, containerWidth);
        }
        CmsContainerElementBean newElementBean = null;
        if (formatter != null) {
            HashMap<String, String> settings = new HashMap<String, String>(element.getIndividualSettings());
            settings.put(CmsFormatterConfig.getSettingsKeyForContainer(container.getName()), formatter.getId());
            newElementBean = new CmsContainerElementBean(element.getId(), formatter.getJspStructureId(), settings, isCreateNew);
        }
        return newElementBean;
    }

    private CmsResource getContainerpage(CmsObject cms) throws CmsException {
        String currentUri = cms.getRequestContext().getUri();
        CmsResource containerPage = cms.readResource(currentUri);
        if (!CmsResourceTypeXmlContainerPage.isContainerPage(containerPage)) {
            String cntPagePath = cms.readPropertyObject(containerPage, "template-elements", true).getValue("");
            try {
                containerPage = cms.readResource(cntPagePath);
            }
            catch (CmsException e) {
                if (!LOG.isDebugEnabled()) {
                    LOG.warn((Object)e.getLocalizedMessage());
                }
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return containerPage;
    }

    private Map<String, CmsContainerElementData> getElements(Collection<String> clientIds, String uriParam, CmsUUID detailContentId, Collection<CmsContainer> containers, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsElementUtil elemUtil = new CmsElementUtil(cms, uriParam, detailContentId, this.getRequest(), this.getResponse(), locale);
        HashMap<String, CmsContainerElementData> result = new HashMap<String, CmsContainerElementData>();
        HashSet<String> ids = new HashSet<String>();
        for (String elemId : clientIds) {
            if (elemId == null || ids.contains(elemId)) continue;
            CmsContainerElementBean element = this.getCachedElement(elemId);
            CmsContainerElementData elementData = elemUtil.getElementData(element, containers);
            result.put(element.editorHash(), elementData);
            if (elementData.isGroupContainer() || elementData.isInheritContainer()) {
                CmsResource elementRes = cms.readResource(element.getId());
                List<CmsContainerElementBean> subElements = elementData.isGroupContainer() ? this.getGroupContainerElements(elementRes, locale) : this.getInheritedElements(elementRes, locale, uriParam);
                for (CmsContainerElementBean subElement : subElements) {
                    this.getSessionCache().setCacheContainerElement(subElement.editorHash(), subElement);
                    if (ids.contains(subElement.editorHash())) continue;
                    CmsContainerElementData subItemData = elemUtil.getElementData(subElement, containers);
                    ids.add(subElement.editorHash());
                    result.put(subElement.editorHash(), subItemData);
                }
            }
            ids.add(elemId);
        }
        return result;
    }

    private CmsGroupContainerBean getGroupContainerBean(CmsGroupContainer groupContainer, CmsUUID pageStructureId, String locale) {
        CmsObject cms = this.getCmsObject();
        ArrayList<CmsContainerElementBean> elements = new ArrayList<CmsContainerElementBean>();
        for (CmsContainerElement elementData : groupContainer.getElements()) {
            try {
                CmsContainerElementBean element;
                if (elementData.isNew()) {
                    elementData = this.createNewElement(pageStructureId, elementData.getClientId(), elementData.getResourceType(), null, locale);
                }
                if (!cms.existsResource((element = this.getCachedElement(elementData.getClientId())).getId(), CmsResourceFilter.IGNORE_EXPIRATION)) continue;
                elements.add(element);
            }
            catch (Exception e) {
                this.log(e.getLocalizedMessage(), e);
            }
        }
        return new CmsGroupContainerBean(groupContainer.getTitle(), groupContainer.getDescription(), elements, groupContainer.getTypes());
    }

    private List<CmsContainerElementBean> getGroupContainerElements(CmsResource resource, Locale locale) throws CmsException {
        CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(this.getCmsObject(), resource, (ServletRequest)this.getRequest());
        CmsGroupContainerBean groupContainer = xmlGroupContainer.getGroupContainer(this.getCmsObject(), locale);
        return groupContainer.getElements();
    }

    private Set<CmsUUID> getGroupElementIds(CmsXmlGroupContainer groupContainer, Locale locale) {
        HashSet<CmsUUID> idSet = new HashSet<CmsUUID>();
        CmsGroupContainerBean groupContainerBean = groupContainer.getGroupContainer(this.getCmsObject(), locale);
        if (groupContainerBean != null) {
            for (CmsContainerElementBean element : groupContainerBean.getElements()) {
                idSet.add(element.getId());
            }
        }
        return idSet;
    }

    private List<CmsContainerElementBean> getInheritedElements(CmsResource resource, Locale locale, String uriParam) throws CmsException {
        CmsObject cms = this.getCmsObject();
        cms.getRequestContext().setLocale(locale);
        CmsInheritanceReferenceParser parser = new CmsInheritanceReferenceParser(cms);
        parser.parse(resource);
        CmsInheritanceReference ref = parser.getReference(locale);
        if (ref == null) {
            return Collections.emptyList();
        }
        String name = ref.getName();
        CmsADEManager adeManager = OpenCms.getADEManager();
        CmsInheritedContainerState result = adeManager.getInheritedContainerState(cms, cms.addSiteRoot(uriParam), name);
        return result.getElements(true);
    }

    private List<CmsContainerElementData> getListElementsData(List<CmsContainerElementBean> listElements, String containerpageUri, CmsUUID detailContentId, Collection<CmsContainer> containers, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsElementUtil elemUtil = new CmsElementUtil(cms, containerpageUri, detailContentId, this.getRequest(), this.getResponse(), locale);
        CmsADESessionCache cache = this.getSessionCache();
        ArrayList<CmsContainerElementData> result = new ArrayList<CmsContainerElementData>();
        for (CmsContainerElementBean element : listElements) {
            if (!cms.existsResource(element.getId(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) continue;
            cache.setCacheContainerElement(element.editorHash(), element);
            CmsContainerElementData elementData = elemUtil.getElementData(element, containers);
            result.add(elementData);
        }
        return result;
    }

    private String getLockInfo(CmsResource resource) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsResourceUtil resourceUtil = new CmsResourceUtil(cms, resource);
        CmsLock lock = resourceUtil.getLock();
        String lockInfo = null;
        if (!lock.isLockableBy(cms.getRequestContext().getCurrentUser())) {
            if (lock.getType() == CmsLockType.PUBLISH) {
                lockInfo = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_LOCKED_FOR_PUBLISH_0");
            } else {
                CmsUser lockOwner = cms.readUser(lock.getUserId());
                lockInfo = Messages.get().getBundle(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms)).key("GUI_LOCKED_BY_1", lockOwner.getFullName());
            }
        }
        return lockInfo;
    }

    private CmsContainerElementData getNewElement(String resourceTypeName, String uriParam, CmsUUID detailContentId, Collection<CmsContainer> containers, Locale locale) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsElementUtil elemUtil = new CmsElementUtil(cms, uriParam, detailContentId, this.getRequest(), this.getResponse(), locale);
        CmsContainerElementBean elementBean = this.getSessionCache().getCacheContainerElement(resourceTypeName);
        if (elementBean == null) {
            elementBean = CmsContainerElementBean.createElementForResourceType(cms, OpenCms.getResourceManager().getResourceType(resourceTypeName), "/", Collections.<String, String>emptyMap(), locale);
            this.getSessionCache().setCacheContainerElement(elementBean.editorHash(), elementBean);
        }
        return elemUtil.getElementData(elementBean, containers);
    }

    private Map<String, String> getNewTypes(CmsObject cms, HttpServletRequest request) throws CmsRpcException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        try {
            List<CmsResourceTypeConfig> types = configData.getCreatableTypes(cms);
            for (CmsResourceTypeConfig type : types) {
                result.put(type.getTypeName(), CmsUUID.getNullUUID().toString());
            }
            return result;
        }
        catch (CmsException e) {
            this.error(e);
            return null;
        }
    }

    private String getNoEditReason(CmsObject cms, CmsResource containerPage) throws CmsException {
        return new CmsResourceUtil(cms, containerPage).getNoEditReason(OpenCms.getWorkplaceManager().getWorkplaceLocale(cms));
    }

    private CmsADESessionCache getSessionCache() {
        if (this.m_sessionCache == null) {
            this.m_sessionCache = CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject());
        }
        return this.m_sessionCache;
    }

    private CmsPair<CmsContainerElement, List<CmsRemovedElementStatus>> internalSaveGroupContainer(CmsObject cms, CmsUUID pageStructureId, CmsGroupContainer groupContainer) throws CmsException, CmsXmlException {
        this.ensureSession();
        CmsResource pageResource = this.getCmsObject().readResource(pageStructureId, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsResource groupContainerResource = null;
        if (groupContainer.isNew()) {
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), pageResource.getRootPath());
            CmsResourceTypeConfig typeConfig = config.getResourceType("groupcontainer");
            groupContainerResource = typeConfig.createNewElement(this.getCmsObject());
            String resourceName = cms.getSitePath(groupContainerResource);
            groupContainer.setSitePath(resourceName);
            groupContainer.setClientId(groupContainerResource.getStructureId().toString());
        }
        if (groupContainerResource == null) {
            CmsUUID id = this.convertToServerId(groupContainer.getClientId());
            groupContainerResource = cms.readResource(id, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        }
        CmsGroupContainerBean groupContainerBean = this.getGroupContainerBean(groupContainer, pageResource.getStructureId(), Locale.ENGLISH.toString());
        cms.lockResourceTemporary(groupContainerResource);
        CmsFile groupContainerFile = cms.readFile(groupContainerResource);
        Locale locale = Locale.ENGLISH;
        CmsXmlGroupContainer xmlGroupContainer = CmsXmlGroupContainerFactory.unmarshal(cms, groupContainerFile);
        Set<CmsUUID> oldElementIds = this.getGroupElementIds(xmlGroupContainer, locale);
        xmlGroupContainer.clearLocales();
        xmlGroupContainer.save(cms, groupContainerBean, locale);
        cms.unlockResource(groupContainerResource);
        Set<CmsUUID> newElementIds = this.getGroupElementIds(xmlGroupContainer, locale);
        Sets.SetView removedElementIds = Sets.difference(oldElementIds, newElementIds);
        ArrayList<CmsRemovedElementStatus> deletionCandidateStatuses = new ArrayList<CmsRemovedElementStatus>();
        for (CmsUUID removedId : removedElementIds) {
            CmsRemovedElementStatus status = this.internalGetRemovedElementStatus(removedId, null);
            if (!status.isDeletionCandidate()) continue;
            deletionCandidateStatuses.add(status);
        }
        CmsContainerElement element = new CmsContainerElement();
        element.setClientId(groupContainerFile.getStructureId().toString());
        element.setSitePath(cms.getSitePath(groupContainerFile));
        element.setResourceType("groupcontainer");
        return CmsPair.create(element, deletionCandidateStatuses);
    }

    private boolean isEditSmallElements(HttpServletRequest request, CmsObject cms) {
        CmsUser user = cms.getRequestContext().getCurrentUser();
        String editSmallElementsStr = (String)user.getAdditionalInfo().get(ADDINFO_EDIT_SMALL_ELEMENTS);
        if (editSmallElementsStr == null) {
            return true;
        }
        return Boolean.valueOf(editSmallElementsStr);
    }

    private void saveContainers(CmsObject cms, CmsResource containerpage, String containerpageUri, List<CmsContainer> containers, Locale contentLocale) throws CmsException {
        ArrayList<CmsContainerBean> containerBeans = new ArrayList<CmsContainerBean>();
        for (CmsContainer container : containers) {
            CmsContainerBean containerBean = this.getContainerBeanToSave(container, containerpage);
            containerBeans.add(containerBean);
        }
        CmsContainerPageBean page = new CmsContainerPageBean(contentLocale, containerBeans);
        CmsXmlContainerPage xmlCnt = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(containerpageUri));
        xmlCnt.save(cms, contentLocale, page);
    }

    private void saveInheritanceGroup(CmsResource resource, CmsInheritanceContainer inheritanceContainer) throws CmsException {
        CmsObject cms = this.getCmsObject();
        CmsFile file = cms.readFile(resource);
        CmsXmlContent document = CmsXmlContentFactory.unmarshal(cms, file);
        for (Locale docLocale : document.getLocales()) {
            document.removeLocale(docLocale);
        }
        Locale locale = Locale.ENGLISH;
        document.addLocale(cms, locale);
        document.getValue("Title", locale).setStringValue(cms, inheritanceContainer.getTitle());
        document.getValue("Description", locale).setStringValue(cms, inheritanceContainer.getDescription());
        document.getValue("ConfigName", locale).setStringValue(cms, inheritanceContainer.getName());
        byte[] content = document.marshal();
        file.setContents(content);
        cms.writeFile(file);
    }

    private List<CmsContainerElementBean> updateFavoriteRecentList(String clientId, List<CmsContainerElementBean> list) {
        CmsContainerElementBean element = this.getCachedElement(clientId);
        Iterator<CmsContainerElementBean> listIt = list.iterator();
        while (listIt.hasNext()) {
            CmsContainerElementBean listElem = listIt.next();
            if (!listElem.getId().equals(element.getId())) continue;
            listIt.remove();
        }
        list.add(0, element);
        return list;
    }
}

