/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import com.alkacon.acacia.shared.AttributeConfiguration;
import com.alkacon.acacia.shared.TabInfo;
import com.alkacon.acacia.shared.Type;
import com.alkacon.vie.shared.I_Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.opencms.ade.contenteditor.CmsContentService;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.ade.contenteditor.shared.CmsComplexWidgetData;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsMessages;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.main.OpenCms;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsComplexWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.content.CmsXmlContentTab;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsContentTypeVisitor {
    private Map<String, AttributeConfiguration> m_attributeConfigurations;
    private CmsObject m_cms;
    private Map<String, CmsComplexWidgetData> m_complexWidgets = new HashMap<String, CmsComplexWidgetData>();
    private I_CmsXmlContentHandler m_contentHandler;
    private CmsFile m_file;
    private Locale m_locale;
    private CmsMultiMessages m_messages;
    private Map<String, I_Type> m_registeredTypes;
    private List<TabInfo> m_tabInfos;
    private Map<String, CmsExternalWidgetConfiguration> m_widgetConfigurations;
    private List<I_CmsWidget> m_widgets = new ArrayList<I_CmsWidget>();

    public CmsContentTypeVisitor(CmsObject cms, CmsFile file, Locale locale) {
        this.m_file = file;
        this.m_cms = cms;
        this.m_locale = locale;
    }

    public CmsObject getCmsObject() {
        return this.m_cms;
    }

    public List<I_CmsWidget> getCollectedWidgets() {
        return Collections.unmodifiableList(this.m_widgets);
    }

    public Map<String, CmsComplexWidgetData> getComplexWidgetData() {
        return this.m_complexWidgets;
    }

    public List<TabInfo> getTabInfos() {
        return this.m_tabInfos;
    }

    public boolean isEditorCompatible(CmsXmlContentDefinition xmlContentDefinition) throws CmsXmlException {
        boolean result = true;
        for (I_CmsXmlSchemaType subType : xmlContentDefinition.getTypeSequence()) {
            if (subType.isSimpleType()) {
                result = this.isEditorCompatible((A_CmsXmlContentValue)subType);
            } else {
                CmsXmlContentDefinition subTypeDefinition = ((CmsXmlNestedContentDefinition)subType).getNestedContentDefinition();
                result = this.isEditorCompatible(subTypeDefinition);
            }
            if (result) continue;
            break;
        }
        return result;
    }

    public void visitTypes(CmsXmlContentDefinition xmlContentDefinition, Locale messageLocale) {
        this.m_contentHandler = xmlContentDefinition.getContentHandler();
        CmsMessages messages = null;
        this.m_messages = new CmsMultiMessages(messageLocale);
        try {
            messages = OpenCms.getWorkplaceManager().getMessages(messageLocale);
            if (messages != null) {
                this.m_messages.addMessages(messages);
            }
            if ((messages = this.m_contentHandler.getMessages(messageLocale)) != null) {
                this.m_messages.addMessages(messages);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        this.m_attributeConfigurations = new HashMap<String, AttributeConfiguration>();
        this.m_widgetConfigurations = new HashMap<String, CmsExternalWidgetConfiguration>();
        this.m_registeredTypes = new HashMap<String, I_Type>();
        this.m_tabInfos = this.collectTabInfos(xmlContentDefinition);
        this.readTypes(xmlContentDefinition, "");
    }

    protected Map<String, AttributeConfiguration> getAttributeConfigurations() {
        return this.m_attributeConfigurations;
    }

    protected Map<String, I_Type> getTypes() {
        return this.m_registeredTypes;
    }

    protected Collection<CmsExternalWidgetConfiguration> getWidgetConfigurations() {
        return this.m_widgetConfigurations.values();
    }

    private List<TabInfo> collectTabInfos(CmsXmlContentDefinition definition) {
        ArrayList<TabInfo> result = new ArrayList<TabInfo>();
        if (definition.getContentHandler().getTabs() != null) {
            for (CmsXmlContentTab xmlTab : definition.getContentHandler().getTabs()) {
                String tabName = this.m_messages.keyDefault("label." + definition.getInnerName() + "." + xmlTab.getTabName(), xmlTab.getTabName());
                result.add(new TabInfo(tabName, xmlTab.getIdName(), xmlTab.getStartName(), xmlTab.isCollapsed()));
            }
        }
        return result;
    }

    private String getHelp(I_CmsXmlSchemaType value) {
        StringBuffer result = new StringBuffer(64);
        result.append("label.");
        result.append(this.getTypeKey(value));
        result.append(".help");
        return this.m_messages.keyDefault(result.toString(), null);
    }

    private String getLabel(I_CmsXmlSchemaType value) {
        StringBuffer result = new StringBuffer(64);
        result.append("label.");
        result.append(this.getTypeKey(value));
        return this.m_messages.keyDefault(result.toString(), value.getName());
    }

    private String getTypeKey(I_CmsXmlSchemaType value) {
        StringBuffer result = new StringBuffer(64);
        result.append(value.getContentDefinition().getInnerName());
        result.append('.');
        result.append(value.getName());
        return result.toString();
    }

    private boolean isEditorCompatible(A_CmsXmlContentValue schemaType) throws CmsXmlException {
        boolean result = false;
        I_CmsXmlContentHandler contentHandler = schemaType.getContentDefinition().getContentHandler();
        I_CmsWidget widget = contentHandler.getWidget(schemaType);
        result = widget == null || widget instanceof I_CmsADEWidget;
        return result;
    }

    private boolean isTabRootLevel(String path) {
        if (!(path = path.substring(1)).contains("/")) {
            return true;
        }
        if (this.m_tabInfos != null) {
            for (TabInfo info : this.m_tabInfos) {
                if (!info.isCollapsed() || !path.startsWith(info.getStartName()) || path.substring(info.getStartName().length() + 1).contains("/")) continue;
                return true;
            }
        }
        return false;
    }

    private DisplayTypeEvaluator readConfiguration(A_CmsXmlContentValue schemaType, String path) {
        String widgetName = null;
        String widgetConfig = null;
        CmsObject cms = this.getCmsObject();
        String label = this.getLabel(schemaType);
        I_CmsXmlContentHandler.DisplayType configuredType = I_CmsXmlContentHandler.DisplayType.none;
        I_CmsXmlContentHandler.DisplayType defaultType = I_CmsXmlContentHandler.DisplayType.none;
        EvaluationRule rule = EvaluationRule.none;
        try {
            I_CmsXmlContentHandler contentHandler = schemaType.getContentDefinition().getContentHandler();
            I_CmsWidget widget = contentHandler.getWidget(schemaType);
            configuredType = contentHandler.getDisplayType(schemaType);
            if (configuredType.equals((Object)I_CmsXmlContentHandler.DisplayType.none) && schemaType.isSimpleType()) {
                if (this.isTabRootLevel(path)) {
                    rule = EvaluationRule.rootLevel;
                } else if (label.length() > 15) {
                    rule = EvaluationRule.labelLength;
                } else if (schemaType.getMinOccurs() == 0) {
                    rule = EvaluationRule.optional;
                }
            }
            if (widget != null) {
                widgetName = widget.getClass().getName();
                if (!(configuredType != I_CmsXmlContentHandler.DisplayType.column || schemaType.isSimpleType() && schemaType.getMaxOccurs() == 1 && widget.isCompactViewEnabled())) {
                    configuredType = I_CmsXmlContentHandler.DisplayType.singleline;
                }
                long timer = 0L;
                if (widget instanceof I_CmsADEWidget) {
                    if (CmsContentService.LOG.isDebugEnabled()) {
                        timer = System.currentTimeMillis();
                    }
                    I_CmsADEWidget adeWidget = (I_CmsADEWidget)widget;
                    defaultType = adeWidget.getDefaultDisplayType();
                    widgetName = adeWidget.getWidgetName();
                    widgetConfig = adeWidget.getConfiguration(cms, schemaType, this.m_messages, this.m_file, this.m_locale);
                    if (!adeWidget.isInternal() && !this.m_widgetConfigurations.containsKey(widgetName)) {
                        CmsExternalWidgetConfiguration externalConfiguration = new CmsExternalWidgetConfiguration(widgetName, adeWidget.getInitCall(), adeWidget.getJavaScriptResourceLinks(cms), adeWidget.getCssResourceLinks(cms));
                        this.m_widgetConfigurations.put(widgetName, externalConfiguration);
                    }
                    if (CmsContentService.LOG.isDebugEnabled()) {
                        CmsContentService.LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_READING_WIDGET_CONFIGURATION_TIME_2", widgetName, "" + (System.currentTimeMillis() - timer)));
                    }
                }
                this.m_widgets.add(widget);
            } else if (contentHandler.getComplexWidget(schemaType) != null) {
                I_CmsComplexWidget complexWidget = contentHandler.getComplexWidget(schemaType);
                CmsComplexWidgetData widgetData = complexWidget.getWidgetData(this.m_cms);
                CmsExternalWidgetConfiguration externalConfig = widgetData.getExternalWidgetConfiguration();
                if (externalConfig != null) {
                    this.m_widgetConfigurations.put(complexWidget.getName(), externalConfig);
                }
                this.m_complexWidgets.put(CmsContentService.getAttributeName(schemaType), widgetData);
            }
        }
        catch (Exception e) {
            CmsContentService.LOG.debug((Object)e.getMessage(), (Throwable)e);
        }
        AttributeConfiguration result = new AttributeConfiguration(label, this.getHelp(schemaType), widgetName, widgetConfig, this.readDefaultValue(schemaType, path), configuredType.name());
        return new DisplayTypeEvaluator(result, configuredType, defaultType, rule);
    }

    private String readDefaultValue(I_CmsXmlSchemaType schemaType, String path) {
        return this.m_contentHandler.getDefault(this.getCmsObject(), this.m_file, schemaType, path, this.m_locale);
    }

    private void readTypes(CmsXmlContentDefinition xmlContentDefinition, String path) {
        String typeName = CmsContentService.getTypeUri(xmlContentDefinition);
        if (this.m_registeredTypes.containsKey(typeName)) {
            return;
        }
        Type type = new Type(typeName);
        type.setChoiceMaxOccurrence(xmlContentDefinition.getChoiceMaxOccurs());
        this.m_registeredTypes.put(typeName, (I_Type)type);
        if (type.isChoice()) {
            Type choiceType = new Type(typeName + "/" + "ATTRIBUTE_CHOICE");
            this.m_registeredTypes.put(choiceType.getId(), (I_Type)choiceType);
            type.addAttribute("ATTRIBUTE_CHOICE", choiceType.getId(), 1, xmlContentDefinition.getChoiceMaxOccurs());
            type = choiceType;
        }
        ArrayList<DisplayTypeEvaluator> evaluators = new ArrayList<DisplayTypeEvaluator>();
        for (I_CmsXmlSchemaType subType : xmlContentDefinition.getTypeSequence()) {
            String subTypeName = null;
            String childPath = path + "/" + subType.getName();
            String subAttributeName = CmsContentService.getAttributeName(subType.getName(), typeName);
            DisplayTypeEvaluator ev = this.readConfiguration((A_CmsXmlContentValue)subType, childPath);
            ev.setAttributeName(subAttributeName);
            evaluators.add(ev);
            if (subType.isSimpleType()) {
                subTypeName = "http://opencms.org/types/" + subType.getTypeName();
                if (!this.m_registeredTypes.containsKey(subTypeName)) {
                    this.m_registeredTypes.put(subTypeName, (I_Type)new Type(subTypeName));
                }
            } else {
                CmsXmlContentDefinition subTypeDefinition = ((CmsXmlNestedContentDefinition)subType).getNestedContentDefinition();
                subTypeName = CmsContentService.getTypeUri(subTypeDefinition);
                this.readTypes(subTypeDefinition, childPath);
            }
            type.addAttribute(subAttributeName, subTypeName, subType.getMinOccurs(), subType.getMaxOccurs());
        }
        I_CmsXmlContentHandler.DisplayType predecessor = null;
        for (int i = 0; i < evaluators.size(); ++i) {
            DisplayTypeEvaluator ev = (DisplayTypeEvaluator)evaluators.get(i);
            I_CmsXmlContentHandler.DisplayType successor = i + 1 < evaluators.size() ? ((DisplayTypeEvaluator)evaluators.get(i + 1)).getProposedType() : null;
            AttributeConfiguration evaluated = ev.getEvaluatedConfiguration(predecessor, successor);
            this.m_attributeConfigurations.put(ev.getAttributeName(), evaluated);
            predecessor = I_CmsXmlContentHandler.DisplayType.valueOf(evaluated.getDisplayType());
        }
    }

    protected static enum EvaluationRule {
        labelLength,
        none,
        optional,
        rootLevel;

    }

    protected class DisplayTypeEvaluator {
        private String m_attributeName;
        private AttributeConfiguration m_config;
        private I_CmsXmlContentHandler.DisplayType m_configuredType;
        private I_CmsXmlContentHandler.DisplayType m_default;
        private EvaluationRule m_rule;

        protected DisplayTypeEvaluator(AttributeConfiguration config, I_CmsXmlContentHandler.DisplayType configuredType, I_CmsXmlContentHandler.DisplayType defaultType, EvaluationRule rule) {
            this.m_config = config;
            this.m_configuredType = configuredType;
            this.m_default = defaultType;
            this.m_rule = rule;
        }

        protected String getAttributeName() {
            return this.m_attributeName;
        }

        protected AttributeConfiguration getEvaluatedConfiguration(I_CmsXmlContentHandler.DisplayType predecessor, I_CmsXmlContentHandler.DisplayType successor) {
            I_CmsXmlContentHandler.DisplayType resultingType = this.m_configuredType;
            if (resultingType.equals((Object)I_CmsXmlContentHandler.DisplayType.none)) {
                if (this.m_rule.equals((Object)EvaluationRule.rootLevel)) {
                    resultingType = I_CmsXmlContentHandler.DisplayType.wide;
                } else {
                    boolean strong;
                    resultingType = this.getProposedType();
                    if (predecessor != null && predecessor.equals((Object)I_CmsXmlContentHandler.DisplayType.none)) {
                        predecessor = null;
                    }
                    if (successor != null && successor.equals((Object)I_CmsXmlContentHandler.DisplayType.none)) {
                        successor = null;
                    }
                    if (predecessor != null && predecessor.equals((Object)I_CmsXmlContentHandler.DisplayType.column)) {
                        predecessor = I_CmsXmlContentHandler.DisplayType.singleline;
                    }
                    if (successor != null && successor.equals((Object)I_CmsXmlContentHandler.DisplayType.column)) {
                        successor = I_CmsXmlContentHandler.DisplayType.singleline;
                    }
                    boolean bl = strong = this.m_rule.equals((Object)EvaluationRule.none) || this.m_rule.equals((Object)EvaluationRule.optional) && this.m_default.equals((Object)I_CmsXmlContentHandler.DisplayType.singleline) || this.m_rule.equals((Object)EvaluationRule.optional) && this.m_default.equals((Object)I_CmsXmlContentHandler.DisplayType.singleline);
                    if ((predecessor == null || successor == null) && strong) {
                        resultingType = this.m_default;
                    } else if (!(predecessor == null && successor == null || predecessor != null && resultingType.equals((Object)predecessor) || successor != null && resultingType.equals((Object)successor))) {
                        I_CmsXmlContentHandler.DisplayType match = predecessor != null && (predecessor.equals((Object)I_CmsXmlContentHandler.DisplayType.wide) || predecessor.equals((Object)I_CmsXmlContentHandler.DisplayType.singleline)) ? predecessor : (successor != null && (successor.equals((Object)I_CmsXmlContentHandler.DisplayType.wide) || successor.equals((Object)I_CmsXmlContentHandler.DisplayType.singleline)) ? successor : null);
                        resultingType = match != null ? match : resultingType;
                    }
                }
            }
            this.m_config.setDisplayType(resultingType.name());
            return this.m_config;
        }

        protected I_CmsXmlContentHandler.DisplayType getProposedType() {
            I_CmsXmlContentHandler.DisplayType resultingType = this.m_configuredType;
            if (resultingType.equals((Object)I_CmsXmlContentHandler.DisplayType.none)) {
                switch (this.m_rule) {
                    case rootLevel: 
                    case labelLength: {
                        resultingType = I_CmsXmlContentHandler.DisplayType.wide;
                        break;
                    }
                    case optional: {
                        resultingType = I_CmsXmlContentHandler.DisplayType.singleline;
                        break;
                    }
                    default: {
                        resultingType = this.m_default;
                    }
                }
            }
            return resultingType;
        }

        protected void setAttributeName(String attributeName) {
            this.m_attributeName = attributeName;
        }
    }
}

