/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor.shared;

import com.alkacon.acacia.shared.AttributeConfiguration;
import com.alkacon.acacia.shared.ContentDefinition;
import com.alkacon.acacia.shared.Entity;
import com.alkacon.acacia.shared.TabInfo;
import com.alkacon.vie.shared.I_Entity;
import com.alkacon.vie.shared.I_EntityAttribute;
import com.alkacon.vie.shared.I_Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opencms.ade.contenteditor.shared.CmsComplexWidgetData;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.util.CmsUUID;

public class CmsContentDefinition
extends ContentDefinition {
    private static final String ENTITY_ID_PREFIX = "http://opencms.org/resources/";
    private boolean m_autoUnlock;
    private Map<String, String> m_availableLocales;
    private Map<String, CmsComplexWidgetData> m_complexWidgetData;
    private List<String> m_contentLocales;
    private boolean m_deleteOnCancel;
    private List<CmsExternalWidgetConfiguration> m_externalWidgetConfigurations;
    private boolean m_isDirectEdit;
    private List<CmsModelResourceInfo> m_modelInfos;
    private String m_newLink;
    private boolean m_performedAutocorrection;
    private CmsUUID m_referenceResourceId;
    private String m_resourceType;
    private String m_sitePath;
    private String m_title;

    public CmsContentDefinition(Entity entity, Map<String, AttributeConfiguration> configurations, Collection<CmsExternalWidgetConfiguration> externalWidgetConfigurations, Map<String, CmsComplexWidgetData> complexWidgetData, Map<String, I_Type> types, List<TabInfo> tabInfos, String locale, List<String> contentLocales, Map<String, String> availableLocales, String title, String sitePath, String resourceType, boolean performedAutocorrection, boolean autoUnlock) {
        super(entity, configurations, types, tabInfos, true, locale);
        this.m_contentLocales = contentLocales;
        this.m_availableLocales = availableLocales;
        this.m_complexWidgetData = complexWidgetData;
        this.m_title = title;
        this.m_sitePath = sitePath;
        this.m_resourceType = resourceType;
        this.m_externalWidgetConfigurations = new ArrayList<CmsExternalWidgetConfiguration>(externalWidgetConfigurations);
        this.m_performedAutocorrection = performedAutocorrection;
        this.m_autoUnlock = autoUnlock;
    }

    public CmsContentDefinition(List<CmsModelResourceInfo> modelInfos, String newLink, CmsUUID referenceId, String locale) {
        super(null, null, null, null, true, locale);
        this.m_modelInfos = modelInfos;
        this.m_newLink = newLink;
        this.m_referenceResourceId = referenceId;
    }

    protected CmsContentDefinition() {
    }

    public static CmsUUID entityIdToUuid(String entityId) {
        if (entityId.startsWith(ENTITY_ID_PREFIX)) {
            entityId = entityId.substring(entityId.lastIndexOf("/") + 1);
        }
        return new CmsUUID(entityId);
    }

    public static String getLocaleFromId(String entityId) {
        if (entityId.startsWith(ENTITY_ID_PREFIX)) {
            return entityId.substring(ENTITY_ID_PREFIX.length(), entityId.lastIndexOf("/"));
        }
        return null;
    }

    public static String getValueForPath(I_Entity entity, String path) {
        I_EntityAttribute attribute;
        String attributeName;
        String result = null;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (path.contains("/")) {
            attributeName = path.substring(0, path.indexOf("/"));
            path = path.substring(path.indexOf("/"));
        } else {
            attributeName = path;
            path = null;
        }
        int index = ContentDefinition.extractIndex((String)attributeName);
        if (index > 0) {
            --index;
        }
        if (!((attribute = entity.getAttribute(attributeName = entity.getTypeName() + "/" + ContentDefinition.removeIndex((String)attributeName))) == null || attribute.isComplexValue() && path == null)) {
            if (attribute.isSimpleValue()) {
                if (path == null && attribute.getValueCount() > 0) {
                    List values = attribute.getSimpleValues();
                    result = (String)values.get(index);
                }
            } else if (attribute.getValueCount() > index) {
                List values = attribute.getComplexValues();
                result = CmsContentDefinition.getValueForPath((I_Entity)values.get(index), path);
            }
        }
        return result;
    }

    public static String uuidToEntityId(CmsUUID uuid, String locale) {
        return ENTITY_ID_PREFIX + locale + "/" + uuid.toString();
    }

    public Map<String, String> getAvailableLocales() {
        return this.m_availableLocales;
    }

    public Map<String, CmsComplexWidgetData> getComplexWidgetData() {
        return this.m_complexWidgetData;
    }

    public List<String> getContentLocales() {
        return this.m_contentLocales;
    }

    public List<CmsExternalWidgetConfiguration> getExternalWidgetConfigurations() {
        return this.m_externalWidgetConfigurations;
    }

    public List<CmsModelResourceInfo> getModelInfos() {
        return this.m_modelInfos;
    }

    public String getNewLink() {
        return this.m_newLink;
    }

    public CmsUUID getReferenceResourceId() {
        return this.m_referenceResourceId;
    }

    public String getResourceType() {
        return this.m_resourceType;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public String getTitle() {
        return this.m_title;
    }

    public boolean isAutoUnlock() {
        return this.m_autoUnlock;
    }

    public boolean isDeleteOnCancel() {
        return this.m_deleteOnCancel;
    }

    public boolean isDirectEdit() {
        return this.m_isDirectEdit;
    }

    public boolean isModelInfo() {
        return this.m_modelInfos != null;
    }

    public boolean isPerformedAutocorrection() {
        return this.m_performedAutocorrection;
    }

    public void setDeleteOnCancel(boolean deleteOnCancel) {
        this.m_deleteOnCancel = deleteOnCancel;
    }

    public void setDirectEdit(boolean isDirectEdit) {
        this.m_isDirectEdit = isDirectEdit;
    }
}

