/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsCurrentPageProject
implements I_CmsVirtualProject {
    public static final CmsUUID ID = CmsUUID.getConstantUUID("currentpage");
    static final Log LOG = CmsLog.getLog(CmsCurrentPageProject.class);

    @Override
    public CmsProjectBean getProjectBean(CmsObject cms, Map<String, String> params) {
        String pageId = params.get("containerpage");
        String elementId = params.get("content");
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String title = Messages.get().getBundle(locale).key("GUI_CURRENTPAGE_PROJECT_0");
        if (pageId == null && elementId == null) {
            return null;
        }
        CmsUUID structureIdForTitle = pageId != null ? new CmsUUID(pageId) : new CmsUUID(elementId);
        CmsProjectBean bean = new CmsProjectBean(ID, 0, title, title);
        bean.setRank(100);
        bean.setDefaultGroupName("");
        try {
            CmsResource titleResource = cms.readResource(structureIdForTitle, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsProperty titleProp = cms.readPropertyObject(titleResource, "Title", true);
            String rawName = titleProp.isNullProperty() ? cms.getSitePath(titleResource) : titleProp.getValue();
            bean.setDefaultGroupName(Messages.get().getBundle(locale).key("GUI_PAGE_1", rawName));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return bean;
    }

    @Override
    public CmsUUID getProjectId() {
        return ID;
    }

    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params, String workflowId) {
        String containerpageId = params.get("containerpage");
        String elementId = params.get("content");
        String detailId = params.get("detail");
        HashSet<CmsResource> resources = new HashSet<CmsResource>();
        for (String id : new String[]{containerpageId, elementId, detailId}) {
            if (!CmsUUID.isValidUUID(id)) continue;
            try {
                CmsResource resource = cms.readResource(new CmsUUID(id), CmsResourceFilter.ALL);
                resources.add(resource);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Lists.newArrayList(resources);
    }

    @Override
    public boolean isAutoSelectable() {
        return true;
    }
}

