/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.publish.I_CmsVirtualProject;
import org.opencms.ade.publish.Messages;
import org.opencms.ade.publish.shared.CmsProjectBean;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;

public class CmsMyChangesProject
implements I_CmsVirtualProject {
    public static final CmsUUID ID = CmsUUID.getNullUUID();
    private static final Log LOG = CmsLog.getLog(CmsMyChangesProject.class);

    @Override
    public CmsProjectBean getProjectBean(CmsObject cms, Map<String, String> params) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String title = Messages.get().getBundle(locale).key("GUI_MYCHANGES_PROJECT_0");
        CmsProjectBean bean = new CmsProjectBean(ID, 0, title, title);
        bean.setRank(200);
        bean.setDefaultGroupName("");
        return bean;
    }

    @Override
    public CmsUUID getProjectId() {
        return ID;
    }

    @Override
    public List<CmsResource> getResources(CmsObject cms, Map<String, String> params, String workflowId) {
        try {
            return Lists.newArrayList(OpenCms.getPublishManager().getUsersPubList(cms));
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return Lists.newArrayList();
        }
    }

    @Override
    public boolean isAutoSelectable() {
        return true;
    }
}

