/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.publish;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeBinary;
import org.opencms.file.types.CmsResourceTypeImage;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.util.CmsUUID;

public class CmsPublishRelationFinder {
    private static final Log LOG = CmsLog.getLog(CmsPublishRelationFinder.class);
    private static final String[] VALID_WEAK_RELATION_TARGET_TYPES = new String[]{CmsResourceTypePlain.getStaticTypeName(), CmsResourceTypeImage.getStaticTypeName(), CmsResourceTypePointer.getStaticTypeName(), CmsResourceTypeBinary.getStaticTypeName()};
    private CmsObject m_cms;
    private boolean m_keepOriginalUnchangedResources;
    private Set<CmsResource> m_originalResources;
    private Map<CmsUUID, CmsResource> m_resources = Maps.newHashMap();

    public CmsPublishRelationFinder(CmsObject cms, Collection<CmsResource> resources, boolean keepOriginalUnchangedResources) {
        this.m_cms = cms;
        this.m_originalResources = Sets.newHashSet(resources);
        for (CmsResource res : resources) {
            this.m_resources.put(res.getStructureId(), res);
        }
        this.m_keepOriginalUnchangedResources = keepOriginalUnchangedResources;
    }

    public ResourceMap getPublishRelatedResources() {
        ResourceMap related = this.computeRelatedResources();
        ResourceMap reachable = this.computeReachability(related);
        ResourceMap publishRelatedResources = this.getChangedResourcesReachableFromOriginalResources(reachable);
        this.removeNestedItemsFromTopLevel(publishRelatedResources);
        this.removeUnchangedTopLevelResources(publishRelatedResources);
        return publishRelatedResources;
    }

    public void removeUnchangedTopLevelResources(ResourceMap publishRelatedResources) {
        HashSet unchangedParents = Sets.newHashSet();
        HashSet childrenOfUnchangedParents = Sets.newHashSet();
        HashSet other = Sets.newHashSet();
        for (CmsResource parent : publishRelatedResources.keySet()) {
            if (this.isUnchangedAndShouldBeRemoved(parent)) {
                unchangedParents.add(parent);
                childrenOfUnchangedParents.addAll(publishRelatedResources.get(parent));
                continue;
            }
            other.add(parent);
            other.addAll(publishRelatedResources.get(parent));
        }
        childrenOfUnchangedParents.removeAll(other);
        for (CmsResource parent : unchangedParents) {
            publishRelatedResources.remove(parent);
        }
        for (CmsResource child : childrenOfUnchangedParents) {
            publishRelatedResources.put(child, new HashSet());
        }
    }

    private ResourceMap computeReachability(ResourceMap relatedResources) {
        int newSize;
        int oldSize;
        ResourceMap result = new ResourceMap();
        for (CmsResource resource : relatedResources.keySet()) {
            result.get(resource).add(resource);
            result.get(resource).addAll(relatedResources.get(resource));
        }
        do {
            ResourceMap newReachableResources = new ResourceMap();
            oldSize = result.totalSize();
            for (CmsResource source : result.keySet()) {
                Iterator i$ = result.get(source).iterator();
                while (i$.hasNext()) {
                    CmsResource target = (CmsResource)i$.next();
                    if (!result.containsKey(target)) continue;
                    newReachableResources.get(source).addAll(result.get(target));
                }
            }
            newSize = newReachableResources.totalSize();
            result = newReachableResources;
        } while (oldSize < newSize);
        return result;
    }

    private ResourceMap computeRelatedResources() {
        ResourceMap relatedResources = new ResourceMap();
        HashSet resourcesToProcess = Sets.newHashSet(this.m_originalResources);
        HashSet processedResources = Sets.newHashSet();
        while (!resourcesToProcess.isEmpty()) {
            CmsResource currentResource = (CmsResource)resourcesToProcess.iterator().next();
            resourcesToProcess.remove(currentResource);
            processedResources.add(currentResource);
            if (currentResource.getState().isDeleted()) continue;
            Set<CmsResource> directlyRelatedResources = this.getDirectlyRelatedResources(currentResource);
            for (CmsResource target : directlyRelatedResources) {
                if (!processedResources.contains(target)) {
                    resourcesToProcess.add(target);
                }
                relatedResources.get(currentResource).add(target);
            }
        }
        return relatedResources;
    }

    private ResourceMap getChangedResourcesReachableFromOriginalResources(ResourceMap reachable) {
        ResourceMap publishRelatedResources = new ResourceMap();
        for (CmsResource res : this.m_originalResources) {
            Object reachableItems = reachable.get(res);
            ArrayList changedItems = Lists.newArrayList();
            Iterator i$ = reachableItems.iterator();
            while (i$.hasNext()) {
                CmsResource item = (CmsResource)i$.next();
                if (this.isUnchangedAndShouldBeRemoved(item) || item.getStructureId().equals(res.getStructureId())) continue;
                changedItems.add(item);
            }
            publishRelatedResources.get(res).addAll(changedItems);
        }
        return publishRelatedResources;
    }

    private Set<CmsResource> getDirectlyRelatedResources(CmsResource currentResource) {
        HashSet directlyRelatedResources = Sets.newHashSet();
        List<CmsRelation> relations = this.getRelationsFromResource(currentResource);
        for (CmsRelation relation : relations) {
            CmsResource target = this.getResource(relation.getTargetId());
            if (target == null || !relation.getType().isStrong() && !this.shouldAddWeakRelationTarget(target)) continue;
            directlyRelatedResources.add(target);
        }
        try {
            CmsResource parentFolder = this.m_cms.readParentFolder(currentResource.getStructureId());
            if (parentFolder.getState().isNew() || currentResource.isFile()) {
                directlyRelatedResources.add(parentFolder);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return directlyRelatedResources;
    }

    private List<CmsRelation> getRelationsFromResource(CmsResource currentResource) {
        try {
            return this.m_cms.readRelations(CmsRelationFilter.relationsFromStructureId(currentResource.getStructureId()));
        }
        catch (CmsException e) {
            return Collections.emptyList();
        }
    }

    private CmsResource getResource(CmsUUID structureId) {
        CmsResource resource = this.m_resources.get(structureId);
        if (resource == null) {
            try {
                resource = this.m_cms.readResource(structureId, CmsResourceFilter.ALL);
                this.m_resources.put(structureId, resource);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return resource;
    }

    private boolean isUnchangedAndShouldBeRemoved(CmsResource item) {
        if (item.getState().isUnchanged()) {
            return !this.m_keepOriginalUnchangedResources || !this.m_originalResources.contains(item);
        }
        return false;
    }

    private void removeNestedItemsFromTopLevel(ResourceMap publishRelatedResources) {
        HashSet toDelete = Sets.newHashSet();
        for (CmsResource parent : publishRelatedResources.keySet()) {
            if (toDelete.contains(parent)) continue;
            Iterator i$ = publishRelatedResources.get(parent).iterator();
            while (i$.hasNext()) {
                CmsResource child = (CmsResource)i$.next();
                if (!publishRelatedResources.containsKey(child)) continue;
                toDelete.add(child);
            }
        }
        for (CmsResource delResource : toDelete) {
            publishRelatedResources.remove(delResource);
        }
    }

    private boolean shouldAddWeakRelationTarget(CmsResource weakRelationTarget) {
        for (String typeName : VALID_WEAK_RELATION_TARGET_TYPES) {
            if (!OpenCms.getResourceManager().matchResourceType(typeName, weakRelationTarget.getTypeId())) continue;
            return true;
        }
        return false;
    }

    public static class ResourceMap
    extends HashMap<CmsResource, Set<CmsResource>> {
        private static final long serialVersionUID = 1L;

        @Override
        public Set<CmsResource> get(Object res) {
            Set result = (Set)super.get(res);
            if (result == null) {
                result = Sets.newHashSet();
                this.put((CmsResource)res, result);
            }
            return result;
        }

        public int totalSize() {
            int result = 0;
            for (Map.Entry entry : this.entrySet()) {
                result += ((Set)entry.getValue()).size();
            }
            return result;
        }
    }
}

