/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import com.google.common.base.Objects;
import com.google.common.collect.ArrayListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.pool.ObjectPool;
import org.opencms.configuration.CmsConfigurationManager;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.db.CmsAlias;
import org.opencms.db.CmsAliasFilter;
import org.opencms.db.CmsCacheSettings;
import org.opencms.db.CmsDbConsistencyException;
import org.opencms.db.CmsDbContext;
import org.opencms.db.CmsDbEntryNotFoundException;
import org.opencms.db.CmsDbException;
import org.opencms.db.CmsDbPool;
import org.opencms.db.CmsExportPoint;
import org.opencms.db.CmsExportPointDriver;
import org.opencms.db.CmsLogToPublishListChangeConverter;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsPublishedResource;
import org.opencms.db.CmsResourceState;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.db.CmsRewriteAliasFilter;
import org.opencms.db.CmsSecurityManager;
import org.opencms.db.CmsSqlManager;
import org.opencms.db.CmsSubscriptionFilter;
import org.opencms.db.CmsVfsOnlineResourceAlreadyExistsException;
import org.opencms.db.CmsVisitedByFilter;
import org.opencms.db.I_CmsCacheKey;
import org.opencms.db.I_CmsDbContextFactory;
import org.opencms.db.I_CmsDriver;
import org.opencms.db.I_CmsHistoryDriver;
import org.opencms.db.I_CmsProjectDriver;
import org.opencms.db.I_CmsSubscriptionDriver;
import org.opencms.db.I_CmsUserDriver;
import org.opencms.db.I_CmsVfsDriver;
import org.opencms.db.generic.Messages;
import org.opencms.db.log.CmsLogEntry;
import org.opencms.db.log.CmsLogEntryType;
import org.opencms.db.log.CmsLogFilter;
import org.opencms.db.urlname.CmsUrlNameMappingEntry;
import org.opencms.db.urlname.CmsUrlNameMappingFilter;
import org.opencms.file.CmsDataAccessException;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsUser;
import org.opencms.file.CmsUserSearchParameters;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.I_CmsResource;
import org.opencms.file.history.CmsHistoryFile;
import org.opencms.file.history.CmsHistoryFolder;
import org.opencms.file.history.CmsHistoryPrincipal;
import org.opencms.file.history.CmsHistoryProject;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexRequestContextInfo;
import org.opencms.gwt.shared.alias.CmsAliasImportResult;
import org.opencms.gwt.shared.alias.CmsAliasImportStatus;
import org.opencms.gwt.shared.alias.CmsAliasMode;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockException;
import org.opencms.lock.CmsLockFilter;
import org.opencms.lock.CmsLockManager;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsEvent;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsInitException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsMultiException;
import org.opencms.main.I_CmsEventListener;
import org.opencms.main.OpenCms;
import org.opencms.module.CmsModule;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.publish.CmsPublishEngine;
import org.opencms.publish.CmsPublishJobInfoBean;
import org.opencms.publish.CmsPublishReport;
import org.opencms.relations.CmsCategoryService;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationSystemValidator;
import org.opencms.relations.CmsRelationType;
import org.opencms.relations.I_CmsLinkParseable;
import org.opencms.report.CmsLogReport;
import org.opencms.report.I_CmsReport;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsAccessControlList;
import org.opencms.security.CmsAuthentificationException;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsPasswordEncryptionException;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsPermissionSetCustom;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsSecurityException;
import org.opencms.security.I_CmsPermissionHandler;
import org.opencms.security.I_CmsPrincipal;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.PrintfFormat;
import org.opencms.workplace.commons.CmsProgressThread;

public final class CmsDriverManager
implements I_CmsEventListener {
    public static final String PARAM_LOG_TABLE_ENABLED = "log.table.enabled";
    public static final String ATTRIBUTE_LOGIN = "A_LOGIN";
    public static final String CACHE_ALL_PROPERTIES = "_CAP_";
    public static final int CHANGED_ACCESSCONTROL = 1;
    public static final int CHANGED_CONTENT = 16;
    public static final int CHANGED_LASTMODIFIED = 4;
    public static final int CHANGED_PROJECT = 32;
    public static final int CHANGED_RESOURCE = 8;
    public static final int CHANGED_TIMEFRAME = 2;
    public static final String CONFIGURATION_CACHE = "cache";
    public static final String CONFIGURATION_DB = "db";
    public static final String CONFIGURATION_HISTORY = "driver.history";
    public static final String CONFIGURATION_PROJECT = "driver.project";
    public static final String CONFIGURATION_SUBSCRIPTION = "driver.subscription";
    public static final String CONFIGURATION_USER = "driver.user";
    public static final String CONFIGURATION_VFS = "driver.vfs";
    public static final String KEY_CHANGED_AND_DELETED = "changedAndDeleted";
    public static final String LOST_AND_FOUND_FOLDER = "/system/lost-found";
    public static final int MAX_VFS_RESOURCE_PATH_LENGTH = 512;
    public static final int NOTHING_CHANGED = 0;
    public static final String READ_IGNORE_PARENT = null;
    public static final long READ_IGNORE_TIME = 0L;
    public static final int READ_IGNORE_TYPE = -1;
    public static final int READMODE_EXCLUDE_STATE = 8;
    public static final int READMODE_EXCLUDE_TREE = 1;
    public static final int READMODE_EXCLUDE_TYPE = 4;
    public static final int READMODE_IGNORESTATE = 0;
    public static final int READMODE_INCLUDE_PROJECT = 2;
    public static final int READMODE_INCLUDE_TREE = 0;
    public static final int READMODE_MATCHSTATE = 1;
    public static final int READMODE_ONLY_FILES = 128;
    public static final int READMODE_ONLY_FOLDERS = 64;
    public static final int READMODE_UNMATCHSTATE = 2;
    public static final String TEMP_FILE_PREFIX = "~";
    public static final int UPDATE_ALL = 3;
    public static final int UPDATE_RESOURCE = 4;
    public static final int UPDATE_RESOURCE_PROJECT = 6;
    public static final int UPDATE_RESOURCE_STATE = 1;
    public static final int UPDATE_RESOURCE_STATE_CONTENT = 7;
    public static final int UPDATE_STRUCTURE = 5;
    public static final int UPDATE_STRUCTURE_STATE = 2;
    private static final Log LOG = CmsLog.getLog(CmsDriverManager.class);
    private static final CmsReadChangedProjectResourceMode RCPRM_FILES_AND_FOLDERS_MODE = new CmsReadChangedProjectResourceMode();
    private static final CmsReadChangedProjectResourceMode RCPRM_FILES_ONLY_MODE = new CmsReadChangedProjectResourceMode();
    private static final CmsReadChangedProjectResourceMode RCPRM_FOLDERS_ONLY_MODE = new CmsReadChangedProjectResourceMode();
    private List<PoolingDriver> m_connectionPools;
    private I_CmsHistoryDriver m_historyDriver;
    private CmsRelationSystemValidator m_htmlLinkValidator;
    private I_CmsCacheKey m_keyGenerator;
    private CmsLockManager m_lockManager;
    private List<CmsLogEntry> m_log = new ArrayList<CmsLogEntry>();
    private CmsMemoryMonitor m_monitor;
    private I_CmsProjectDriver m_projectDriver;
    private CmsParameterConfiguration m_propertyConfiguration;
    private CmsPublishEngine m_publishEngine;
    private Object m_publishListUpdateLock = new Object();
    private CmsSecurityManager m_securityManager;
    private CmsSqlManager m_sqlManager;
    private I_CmsSubscriptionDriver m_subscriptionDriver;
    private I_CmsUserDriver m_userDriver;
    private I_CmsVfsDriver m_vfsDriver;

    private CmsDriverManager() {
    }

    public static CmsDriverManager newInstance(CmsConfigurationManager configurationManager, CmsSecurityManager securityManager, I_CmsDbContextFactory runtimeInfoFactory, CmsPublishEngine publishEngine) throws CmsInitException {
        CmsParameterConfiguration config = configurationManager.getConfiguration();
        CmsDriverManager driverManager = null;
        try {
            driverManager = new CmsDriverManager();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE1_0"));
            }
            if (runtimeInfoFactory == null) {
                throw new CmsInitException(org.opencms.main.Messages.get().container("ERR_CRITICAL_NO_DB_CONTEXT_0"));
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("LOG_ERR_DRIVER_MANAGER_START_0");
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)message.key(), (Throwable)exc);
            }
            throw new CmsInitException(message, (Throwable)exc);
        }
        driverManager.m_propertyConfiguration = config;
        driverManager.m_securityManager = securityManager;
        driverManager.m_connectionPools = new ArrayList<PoolingDriver>();
        driverManager.m_lockManager = new CmsLockManager(driverManager);
        driverManager.m_sqlManager = new CmsSqlManager(driverManager);
        driverManager.m_publishEngine = publishEngine;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE2_0"));
        }
        List<String> driverPoolNames = config.getList("db.pools");
        if (CmsLog.INIT.isInfoEnabled()) {
            String names = "";
            for (String name : driverPoolNames) {
                names = names + name + " ";
            }
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_POOLS_1", names));
        }
        for (String name : driverPoolNames) {
            driverManager.newPoolInstance(config, name);
        }
        runtimeInfoFactory.initialize(driverManager);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE3_0"));
        }
        CmsDbContext dbc = runtimeInfoFactory.getDbContext();
        driverManager.m_vfsDriver = (I_CmsVfsDriver)driverManager.createDriver(dbc, configurationManager, config, CONFIGURATION_VFS, ".vfs.driver");
        dbc.clear();
        dbc = runtimeInfoFactory.getDbContext();
        driverManager.m_userDriver = (I_CmsUserDriver)driverManager.createDriver(dbc, configurationManager, config, CONFIGURATION_USER, ".user.driver");
        dbc.clear();
        dbc = runtimeInfoFactory.getDbContext();
        driverManager.m_projectDriver = (I_CmsProjectDriver)driverManager.createDriver(dbc, configurationManager, config, CONFIGURATION_PROJECT, ".project.driver");
        dbc.clear();
        dbc = runtimeInfoFactory.getDbContext();
        driverManager.m_historyDriver = (I_CmsHistoryDriver)driverManager.createDriver(dbc, configurationManager, config, CONFIGURATION_HISTORY, ".history.driver");
        dbc.clear();
        dbc = runtimeInfoFactory.getDbContext();
        try {
            driverManager.m_subscriptionDriver = (I_CmsSubscriptionDriver)driverManager.createDriver(dbc, configurationManager, config, CONFIGURATION_SUBSCRIPTION, ".subscription.driver");
        }
        catch (IndexOutOfBoundsException npe) {
            LOG.warn((Object)"Could not instantiate subscription driver!");
            LOG.warn((Object)npe.getLocalizedMessage(), (Throwable)npe);
        }
        dbc.clear();
        OpenCms.addCmsEventListener(driverManager, new int[]{19, 5, 6, 29, 2});
        return driverManager;
    }

    public void addAlias(CmsDbContext dbc, CmsProject project, CmsAlias alias) throws CmsException {
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        vfsDriver.insertAlias(dbc, project, alias);
    }

    public void addRelationToResource(CmsDbContext dbc, CmsResource resource, CmsResource target, CmsRelationType type, boolean importCase) throws CmsException {
        if (type.isDefinedInContent()) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_ADD_RELATION_IN_CONTENT_3", dbc.removeSiteRoot(resource.getRootPath()), dbc.removeSiteRoot(target.getRootPath()), type.getLocalizedName(dbc.getRequestContext().getLocale())));
        }
        CmsRelation relation = new CmsRelation(resource, target, type);
        this.getVfsDriver(dbc).createRelation(dbc, dbc.currentProject().getUuid(), relation);
        if (!importCase) {
            this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_ADD_RELATION, new String[]{relation.getSourcePath(), relation.getTargetPath()}), false);
            this.setDateLastModified(dbc, resource, System.currentTimeMillis());
        }
    }

    public void addResourceToOrgUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsResource resource) throws CmsException {
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.HAS_ROLE, CmsMemoryMonitor.CacheType.ROLE_LIST);
        this.getUserDriver(dbc).addResourceToOrganizationalUnit(dbc, orgUnit, resource);
    }

    public void addUserToGroup(CmsDbContext dbc, String username, String groupname, boolean readRoles) throws CmsException, CmsDbEntryNotFoundException {
        CmsGroup group = this.readGroup(dbc, groupname);
        if (group == null) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        if (group.isVirtual() && !readRoles) {
            this.addUserToGroup(dbc, username, CmsRole.valueOf(group).getGroupName(), true);
            return;
        }
        if (group.isVirtual()) {
            readRoles = false;
        }
        if (readRoles && !group.isRole() || !readRoles && group.isRole()) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        if (this.userInGroup(dbc, username, groupname, readRoles)) {
            return;
        }
        CmsUser user = this.readUser(dbc, username);
        if (user == null) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_USER_1", username));
        }
        if (readRoles) {
            CmsRole role = CmsRole.valueOf(group);
            this.m_securityManager.checkRole(dbc, role);
            if (this.m_securityManager.hasRole(dbc, user, role)) {
                return;
            }
            List<CmsRole> children = role.getChildren(true);
            for (CmsGroup roleGroup : this.getGroupsOfUser(dbc, username, group.getOuFqn(), true, true, true, dbc.getRequestContext().getRemoteAddress())) {
                if (!children.contains(CmsRole.valueOf(roleGroup))) continue;
                this.removeUserFromGroup(dbc, username, roleGroup.getName(), true);
            }
            for (CmsGroup virtualGroup : this.getVirtualGroupsForRole(dbc, role)) {
                this.addUserToGroup(dbc, username, virtualGroup.getName(), true);
            }
            CmsRole wpUser = CmsRole.WORKPLACE_USER.forOrgUnit(group.getOuFqn());
            if (!(role.equals(wpUser) || role.getChildren(true).contains(wpUser) || this.m_securityManager.hasRole(dbc, user, wpUser))) {
                this.addUserToGroup(dbc, username, wpUser.getGroupName(), true);
            }
        }
        this.getUserDriver(dbc).createUserInGroup(dbc, user.getId(), group.getId());
        if (readRoles) {
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.HAS_ROLE, CmsMemoryMonitor.CacheType.ROLE_LIST);
        }
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.USERGROUPS, CmsMemoryMonitor.CacheType.USER_LIST);
        if (!dbc.getProjectId().isNullUUID() && !CmsProject.ONLINE_PROJECT_ID.equals(dbc.getProjectId())) {
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("userId", user.getId().toString());
        eventData.put("userName", user.getName());
        eventData.put("userId", user.getId().toString());
        eventData.put("groupName", group.getName());
        eventData.put("userAction", "addUserToGroup");
        OpenCms.fireCmsEvent(new CmsEvent(29, eventData));
    }

    public void changeLock(CmsDbContext dbc, CmsResource resource, CmsLockType lockType) throws CmsException, CmsSecurityException {
        CmsLock currentLock = this.getLock(dbc, resource);
        if (currentLock.getEditionLock().isUnlocked() && currentLock.getSystemLock().isUnlocked()) {
            throw new CmsLockException(org.opencms.db.Messages.get().container("ERR_CHANGE_LOCK_UNLOCKED_RESOURCE_1", dbc.getRequestContext().getSitePath(resource)));
        }
        if (lockType == CmsLockType.EXCLUSIVE && currentLock.isExclusiveOwnedInProjectBy(dbc.currentUser(), dbc.currentProject())) {
            return;
        }
        int denied = 0;
        boolean canIgnorePermissions = this.m_securityManager.hasRoleForResource(dbc, dbc.currentUser(), CmsRole.VFS_MANAGER, resource);
        if (!canIgnorePermissions && CmsResourceTypeJsp.isJsp(resource) && !this.m_securityManager.hasRoleForResource(dbc, dbc.currentUser(), CmsRole.DEVELOPER, resource)) {
            denied |= 2;
        }
        CmsPermissionSetCustom permissions = canIgnorePermissions ? new CmsPermissionSetCustom(-1) : this.getPermissions(dbc, resource, dbc.currentUser());
        permissions.denyPermissions(denied);
        if ((CmsPermissionSet.ACCESS_WRITE.getPermissions() & permissions.getPermissions()) != CmsPermissionSet.ACCESS_WRITE.getPermissions()) {
            this.m_securityManager.checkPermissions(dbc.getRequestContext(), resource, CmsPermissionSet.ACCESS_WRITE, I_CmsPermissionHandler.PERM_DENIED);
        }
        this.m_lockManager.removeResource(dbc, resource, true, lockType.isSystem());
        this.lockResource(dbc, resource, lockType);
    }

    public List<CmsResource> changeResourcesInFolderWithProperty(CmsDbContext dbc, CmsResource resource, String propertyDefinition, String oldValue, String newValue, boolean recursive) throws CmsVfsException, CmsException {
        Pattern oldPattern;
        CmsResourceFilter filter = CmsResourceFilter.IGNORE_EXPIRATION;
        List<Object> resources = new ArrayList<CmsResource>();
        if (recursive) {
            resources = this.readResourcesWithProperty(dbc, resource, propertyDefinition, null, filter);
            resources.add(resource);
        } else {
            resources.add(resource);
        }
        try {
            String tmpOldValue = oldValue;
            if (tmpOldValue.contains("{") && tmpOldValue.contains("}")) {
                tmpOldValue = tmpOldValue.replace("{", "");
                tmpOldValue = tmpOldValue.replace("}", "");
            }
            oldPattern = Pattern.compile(tmpOldValue);
        }
        catch (PatternSyntaxException e) {
            throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_CHANGE_RESOURCES_IN_FOLDER_WITH_PROP_4", new Object[]{propertyDefinition, oldValue, newValue, resource.getRootPath()}), (Throwable)e);
        }
        ArrayList<CmsResource> changedResources = new ArrayList<CmsResource>(resources.size());
        CmsPermissionSet perm = CmsPermissionSet.ACCESS_WRITE;
        for (int i = 0; i < resources.size(); ++i) {
            CmsResource res = (CmsResource)resources.get(i);
            try {
                this.m_securityManager.checkPermissions(dbc, res, perm, true, filter);
            }
            catch (Exception e) {
                continue;
            }
            CmsProperty property = this.readPropertyObject(dbc, res, propertyDefinition, false);
            String propertyValue = property.getValue();
            boolean changed = false;
            if (propertyValue != null && oldPattern.matcher(propertyValue).matches()) {
                String tmpNewValue = CmsStringUtil.transformValues(oldValue, newValue, propertyValue);
                property.setStructureValue(tmpNewValue);
                changed = true;
            }
            if (!changed) continue;
            this.writePropertyObject(dbc, res, property);
            changedResources.add(res);
        }
        return changedResources;
    }

    public void chflags(CmsDbContext dbc, CmsResource resource, int flags) throws CmsException {
        CmsResource clone = (CmsResource)resource.clone();
        clone.setFlags(flags);
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_FLAGS, new String[]{resource.getRootPath()}), false);
        this.writeResource(dbc, clone);
    }

    public void chtype(CmsDbContext dbc, CmsResource resource, int type) throws CmsException {
        CmsResource clone = (CmsResource)resource.clone();
        I_CmsResourceType newType = OpenCms.getResourceManager().getResourceType(type);
        clone.setType(newType.getTypeId());
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_TYPE, new String[]{resource.getRootPath()}), false);
        this.writeResource(dbc, clone);
    }

    @Override
    public void cmsEvent(CmsEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)org.opencms.db.Messages.get().getBundle().key("LOG_CMS_EVENT_1", new Integer(event.getType())));
        }
        switch (event.getType()) {
            case 19: {
                CmsDbContext dbc = (CmsDbContext)event.getData().get("dbContext");
                this.updateExportPoints(dbc);
                break;
            }
            case 2: {
                CmsUUID publishHistoryId = new CmsUUID((String)event.getData().get("publishHistoryId"));
                I_CmsReport report = (I_CmsReport)event.getData().get("report");
                CmsDbContext dbc = (CmsDbContext)event.getData().get("dbContext");
                this.m_monitor.clearCache();
                this.writeExportPoints(dbc, report, publishHistoryId);
                break;
            }
            case 5: {
                this.m_monitor.clearCache();
                break;
            }
            case 6: 
            case 29: {
                this.m_monitor.clearPrincipalsCache();
                break;
            }
        }
    }

    public void copyAccessControlEntries(CmsDbContext dbc, CmsResource source, CmsResource destination, boolean updateLastModifiedInfo) throws CmsException {
        ListIterator<CmsAccessControlEntry> aceList = this.getUserDriver(dbc).readAccessControlEntries(dbc, dbc.currentProject(), source.getResourceId(), false).listIterator();
        this.getUserDriver(dbc).removeAccessControlEntries(dbc, dbc.currentProject(), destination.getResourceId());
        while (aceList.hasNext()) {
            CmsAccessControlEntry ace = aceList.next();
            this.getUserDriver(dbc).createAccessControlEntry(dbc, dbc.currentProject(), destination.getResourceId(), ace.getPrincipal(), ace.getPermissions().getAllowedPermissions(), ace.getPermissions().getDeniedPermissions(), ace.getFlags());
        }
        this.log(dbc, new CmsLogEntry(dbc, destination.getStructureId(), CmsLogEntryType.RESOURCE_PERMISSIONS, new String[]{destination.getRootPath()}), false);
        if (updateLastModifiedInfo) {
            this.setDateLastModified(dbc, destination, destination.getDateLastModified());
        }
        this.m_monitor.clearAccessControlListCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", destination);
        data.put("change", new Integer(1));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void copyResource(CmsDbContext dbc, CmsResource source, String destination, CmsResource.CmsResourceCopyMode siblingMode) throws CmsException, CmsIllegalArgumentException {
        CmsUUID userLastModified;
        long dateLastModified;
        boolean copyAsSibling = false;
        if (!source.isFolder()) {
            if (siblingMode == CmsResource.COPY_AS_SIBLING) {
                copyAsSibling = true;
            }
            if (siblingMode == CmsResource.COPY_PRESERVE_SIBLING && source.getSiblingCount() > 1) {
                copyAsSibling = true;
            }
        }
        List<CmsProperty> properties = this.readPropertyObjects(dbc, source, false);
        if (copyAsSibling) {
            this.createSibling(dbc, source, destination, properties);
            return;
        }
        byte[] content = null;
        if (source.isFile()) {
            if (source instanceof CmsFile) {
                content = ((CmsFile)source).getContents();
            }
            if (content == null || content.length < 1) {
                content = this.getVfsDriver(dbc).readContent(dbc, dbc.currentProject().getUuid(), source.getResourceId());
            }
        }
        String destinationFoldername = CmsResource.getParentFolder(destination);
        CmsFolder destinationFolder = this.m_securityManager.readFolder(dbc, destinationFoldername, CmsResourceFilter.IGNORE_EXPIRATION);
        long currentTime = System.currentTimeMillis();
        if (source.isFolder()) {
            dateLastModified = currentTime;
            userLastModified = dbc.currentUser().getId();
        } else {
            dateLastModified = source.getDateLastModified();
            userLastModified = source.getUserLastModified();
        }
        int flags = source.getFlags();
        if (source.isLabeled()) {
            flags &= 0xFFFFFFFD;
        }
        CmsResource newResource = new CmsResource(new CmsUUID(), new CmsUUID(), destination, source.getTypeId(), source.isFolder(), flags, dbc.currentProject().getUuid(), CmsResource.STATE_NEW, currentTime, dbc.currentUser().getId(), dateLastModified, userLastModified, source.getDateReleased(), source.getDateExpired(), 1, source.getLength(), source.getDateContent(), source.getVersion());
        newResource.setDateLastModified(dateLastModified);
        this.log(dbc, new CmsLogEntry(dbc, newResource.getStructureId(), CmsLogEntryType.RESOURCE_COPIED, new String[]{newResource.getRootPath()}), false);
        newResource = this.createResource(dbc, destination, newResource, content, properties, false);
        this.copyRelations(dbc, source, newResource);
        this.copyAccessControlEntries(dbc, source, newResource, false);
        this.m_monitor.clearAccessControlListCache();
        ArrayList<CmsResource> modifiedResources = new ArrayList<CmsResource>();
        modifiedResources.add(source);
        modifiedResources.add(newResource);
        modifiedResources.add(destinationFolder);
        OpenCms.fireCmsEvent(new CmsEvent(24, Collections.singletonMap("resources", modifiedResources)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void copyResourceToProject(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (!this.isInsideCurrentProject(dbc, resource.getRootPath())) {
            I_CmsProjectDriver projectDriver = this.getProjectDriver(dbc);
            if (resource.isFolder()) {
                List<String> projectResources = projectDriver.readProjectResources(dbc, dbc.currentProject());
                for (int i = 0; i < projectResources.size(); ++i) {
                    String resname = projectResources.get(i);
                    if (!resname.startsWith(resource.getRootPath())) continue;
                    projectDriver.deleteProjectResource(dbc, dbc.currentProject().getUuid(), resname);
                }
            }
            try {
                projectDriver.createProjectResource(dbc, dbc.currentProject().getUuid(), resource.getRootPath());
            }
            catch (CmsException exc) {
                this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
                OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
                catch (Throwable throwable) {
                    this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
                    OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
                    throw throwable;
                }
            }
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
            OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
        }
    }

    public int countLockedResources(CmsProject project) {
        return this.m_lockManager.countExclusiveLocksInProject(project);
    }

    public CmsGroup createGroup(CmsDbContext dbc, CmsUUID id, String name, String description, int flags, String parent) throws CmsIllegalArgumentException, CmsException {
        CmsGroup parentGroup;
        OpenCms.getValidationHandler().checkGroupName(CmsOrganizationalUnit.getSimpleName(name));
        name = name.trim();
        this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(name));
        if (CmsStringUtil.isNotEmpty(parent) && !(parentGroup = this.readGroup(dbc, parent)).isRole() && !CmsOrganizationalUnit.getParentFqn(parent).equals(CmsOrganizationalUnit.getParentFqn(name))) {
            throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_PARENT_GROUP_MUST_BE_IN_SAME_OU_3", CmsOrganizationalUnit.getSimpleName(name), CmsOrganizationalUnit.getParentFqn(name), parent));
        }
        CmsGroup group = this.getUserDriver(dbc).createGroup(dbc, id, name, description, flags, parent);
        if (group.isVirtual()) {
            String groupname = CmsRole.valueOf(group).getGroupName();
            for (CmsUser user : this.getUsersOfGroup(dbc, groupname, true, false, true)) {
                this.addUserToGroup(dbc, user.getName(), group.getName(), true);
            }
        }
        this.m_monitor.cacheGroup(group);
        if (!dbc.getProjectId().isNullUUID()) {
            return group;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("groupName", group.getName());
        eventData.put("groupId", group.getId().toString());
        eventData.put("userAction", "createGroup");
        OpenCms.fireCmsEvent(new CmsEvent(31, eventData));
        return group;
    }

    public CmsOrganizationalUnit createOrganizationalUnit(CmsDbContext dbc, String ouFqn, String description, int flags, CmsResource resource) throws CmsException {
        CmsOrganizationalUnit parent = this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(ouFqn));
        String name = CmsOrganizationalUnit.getSimpleName(ouFqn);
        if (name.endsWith("/")) {
            name = name.substring(0, name.length() - 1);
        }
        CmsResource.checkResourceName(name);
        name = name.trim();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(description)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_OU_DESCRIPTION_EMPTY_0"));
        }
        CmsOrganizationalUnit orgUnit = this.getUserDriver(dbc).createOrganizationalUnit(dbc, name, description, flags, parent, resource != null ? resource.getRootPath() : null);
        this.m_monitor.cacheOrgUnit(orgUnit);
        this.m_monitor.clearPrincipalsCache();
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        CmsResource ouRes = this.readResource(dbc, "/system/orgunits/" + orgUnit.getName(), CmsResourceFilter.DEFAULT);
        CmsPublishList pl = new CmsPublishList(ouRes, false);
        pl.add(ouRes, false);
        this.getProjectDriver(dbc).writePublishHistory(dbc, pl.getPublishHistoryId(), new CmsPublishedResource(ouRes, -1, CmsResourceState.STATE_NEW));
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("publishHistoryId", pl.getPublishHistoryId().toString());
        eventData.put("projectId", dbc.currentProject().getUuid());
        eventData.put("dbContext", dbc);
        CmsEvent afterPublishEvent = new CmsEvent(2, eventData);
        OpenCms.fireCmsEvent(afterPublishEvent);
        if (!dbc.getProjectId().isNullUUID()) {
            return orgUnit;
        }
        HashMap<String, Object> event2Data = new HashMap<String, Object>();
        event2Data.put("ouName", orgUnit.getName());
        event2Data.put("ouId", orgUnit.getId().toString());
        event2Data.put("userAction", "createOu");
        OpenCms.fireCmsEvent(new CmsEvent(30, event2Data));
        return orgUnit;
    }

    public CmsProject createProject(CmsDbContext dbc, String name, String description, String groupname, String managergroupname, CmsProject.CmsProjectType projecttype) throws CmsIllegalArgumentException, CmsException {
        if ("Online".equals(name)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_CREATE_PROJECT_ONLINE_PROJECT_NAME_1", "Online"));
        }
        CmsProject.checkProjectName(CmsOrganizationalUnit.getSimpleName(name));
        this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(name));
        CmsGroup group = this.readGroup(dbc, groupname);
        CmsGroup managergroup = this.readGroup(dbc, managergroupname);
        return this.getProjectDriver(dbc).createProject(dbc, new CmsUUID(), dbc.currentUser(), group, managergroup, name, description, projecttype.getDefaultFlags(), projecttype);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPropertyDefinition createPropertyDefinition(CmsDbContext dbc, String name) throws CmsException {
        CmsPropertyDefinition propertyDefinition = null;
        name = name.trim();
        CmsPropertyDefinition.checkPropertyName(name);
        try {
            try {
                propertyDefinition = this.getVfsDriver(dbc).readPropertyDefinition(dbc, name, dbc.currentProject().getUuid());
            }
            catch (CmsException e) {
                propertyDefinition = this.getVfsDriver(dbc).createPropertyDefinition(dbc, dbc.currentProject().getUuid(), name, CmsPropertyDefinition.TYPE_NORMAL);
            }
            try {
                this.getVfsDriver(dbc).readPropertyDefinition(dbc, name, CmsProject.ONLINE_PROJECT_ID);
            }
            catch (CmsException e) {
                this.getVfsDriver(dbc).createPropertyDefinition(dbc, CmsProject.ONLINE_PROJECT_ID, name, CmsPropertyDefinition.TYPE_NORMAL);
            }
            try {
                this.getHistoryDriver(dbc).readPropertyDefinition(dbc, name);
            }
            catch (CmsException e) {
                this.getHistoryDriver(dbc).createPropertyDefinition(dbc, name, CmsPropertyDefinition.TYPE_NORMAL);
            }
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(28, Collections.singletonMap("propertyDefinition", propertyDefinition)));
        }
        return propertyDefinition;
    }

    public void createPublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsException {
        this.getProjectDriver(dbc).createPublishJob(dbc, publishJob);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CmsResource createResource(CmsDbContext dbc, String resourcePath, CmsResource resource, byte[] content, List<CmsProperty> properties, boolean importCase) throws CmsException {
        CmsResource newResource = null;
        if (resource.isFolder()) {
            resourcePath = CmsFileUtil.addTrailingSeparator(resourcePath);
        }
        try {
            block47: {
                int contentLength;
                String parentFolderName = CmsResource.getParentFolder(resourcePath);
                CmsFolder parentFolder = this.readFolder(dbc, parentFolderName, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsLock parentLock = this.getLock(dbc, parentFolder);
                if (!(parentLock.isUnlocked() || parentLock.isOwnedBy(dbc.currentUser()) || CmsResource.getName(resourcePath).startsWith(TEMP_FILE_PREFIX) && this.m_securityManager.hasRole(dbc, dbc.currentUser(), CmsRole.ROOT_ADMIN))) {
                    throw new CmsLockException(org.opencms.db.Messages.get().container("ERR_CREATE_RESOURCE_PARENT_LOCK_1", dbc.removeSiteRoot(resourcePath)));
                }
                if (CmsResourceTypeJsp.isJsp(resource)) {
                    this.m_securityManager.checkRoleForResource(dbc, CmsRole.DEVELOPER, (CmsResource)parentFolder);
                }
                boolean useLostAndFound = importCase && !OpenCms.getImportExportManager().overwriteCollidingResources();
                CmsResource currentResourceByName = null;
                try {
                    currentResourceByName = this.readResource(dbc, resourcePath, CmsResourceFilter.ALL);
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
                try {
                    CmsResource currentResourceById = this.readResource(dbc, resource.getStructureId(), CmsResourceFilter.ALL);
                    if (!currentResourceById.getRootPath().equals(resourcePath)) {
                        throw new CmsVfsResourceAlreadyExistsException(org.opencms.db.Messages.get().container("ERR_RESOURCE_WITH_ID_ALREADY_EXISTS_3", dbc.removeSiteRoot(resourcePath), dbc.removeSiteRoot(currentResourceById.getRootPath()), currentResourceById.getStructureId()));
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
                if (currentResourceByName == null) {
                    this.m_securityManager.checkPermissions(dbc, (CmsResource)parentFolder, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
                } else {
                    this.m_securityManager.checkPermissions(dbc, currentResourceByName, CmsPermissionSet.ACCESS_WRITE, !importCase, CmsResourceFilter.ALL);
                }
                if (currentResourceByName != null) {
                    boolean overwrite = true;
                    if (currentResourceByName.getState().isDeleted()) {
                        if (!currentResourceByName.isFolder()) {
                            overwrite = false;
                        }
                    } else {
                        if (!importCase) {
                            throw new CmsVfsResourceAlreadyExistsException(Messages.get().container("ERR_RESOURCE_WITH_NAME_ALREADY_EXISTS_1", dbc.removeSiteRoot(resource.getRootPath())));
                        }
                        if (!resource.isFolder() && useLostAndFound && !currentResourceByName.getResourceId().equals(resource.getResourceId())) {
                            this.moveToLostAndFound(dbc, currentResourceByName, false);
                        }
                    }
                    if (!overwrite) {
                        this.lockResource(dbc, currentResourceByName, CmsLockType.EXCLUSIVE);
                        currentResourceByName = null;
                    }
                }
                CmsResource overwrittenResource = currentResourceByName;
                String targetName = CmsResource.getName(resourcePath);
                if (resource.isFolder()) {
                    contentLength = -1;
                    if (CmsResource.isFolder(targetName)) {
                        targetName = targetName.substring(0, targetName.length() - 1);
                    }
                } else {
                    contentLength = content != null ? content.length : (overwrittenResource != null ? overwrittenResource.getLength() : resource.getLength());
                }
                CmsResource.checkResourceName(targetName);
                CmsUUID structureId = resource.getStructureId();
                CmsUUID resourceId = resource.getResourceId();
                if (overwrittenResource != null) {
                    structureId = overwrittenResource.getStructureId();
                }
                if (structureId.isNullUUID()) {
                    structureId = new CmsUUID();
                }
                if (overwrittenResource != null) {
                    resourceId = overwrittenResource.getResourceId();
                }
                if (resourceId.isNullUUID()) {
                    resourceId = new CmsUUID();
                }
                try {
                    CmsResource onlineResource = this.getVfsDriver(dbc).readResource(dbc, CmsProject.ONLINE_PROJECT_ID, resourcePath, true);
                    try {
                        CmsResource offlineResource = this.getVfsDriver(dbc).readResource(dbc, dbc.currentProject().getUuid(), onlineResource.getStructureId(), true);
                        if (!offlineResource.getRootPath().equals(onlineResource.getRootPath())) {
                            throw new CmsVfsOnlineResourceAlreadyExistsException(org.opencms.db.Messages.get().container("ERR_ONLINE_RESOURCE_EXISTS_2", dbc.removeSiteRoot(resourcePath), dbc.removeSiteRoot(offlineResource.getRootPath())));
                        }
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        if (LOG.isErrorEnabled()) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
                newResource = new CmsResource(structureId, resourceId, resourcePath, resource.getTypeId(), resource.isFolder(), resource.getFlags(), dbc.currentProject().getUuid(), resource.getState(), resource.getDateCreated(), resource.getUserCreated(), resource.getDateLastModified(), resource.getUserLastModified(), resource.getDateReleased(), resource.getDateExpired(), 1, contentLength, resource.getDateContent(), resource.getVersion());
                if (resource.isTouched()) {
                    newResource.setDateLastModified(resource.getDateLastModified());
                }
                if (resource.isFile()) {
                    if (this.labelResource(dbc, resource, resourcePath, 2)) {
                        int flags = resource.getFlags();
                        resource.setFlags(flags |= 2);
                    }
                    if (content == null) {
                        newResource.setState(CmsResource.STATE_KEEP);
                    }
                }
                this.getVfsDriver(dbc).deleteRelations(dbc, dbc.currentProject().getUuid(), newResource, CmsRelationFilter.TARGETS);
                if (overwrittenResource == null) {
                    CmsLock lock = this.getLock(dbc, newResource);
                    if (lock.getEditionLock().isExclusive()) {
                        this.unlockResource(dbc, newResource, true, false);
                    }
                    newResource = this.getVfsDriver(dbc).createResource(dbc, dbc.currentProject().getUuid(), newResource, content);
                } else {
                    int updateStates = overwrittenResource.getState().isNew() ? 0 : 3;
                    this.getVfsDriver(dbc).writeResource(dbc, dbc.currentProject().getUuid(), newResource, updateStates);
                    if (content != null && resource.isFile()) {
                        this.getVfsDriver(dbc).writeContent(dbc, newResource.getResourceId(), content);
                    }
                }
                this.writePropertyObjects(dbc, newResource, properties, false);
                try {
                    this.lockResource(dbc, newResource, CmsLockType.EXCLUSIVE);
                }
                catch (CmsLockException cle) {
                    if (!LOG.isDebugEnabled()) break block47;
                    LOG.debug((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CREATE_RESOURCE_LOCK_1", new Object[]{dbc.removeSiteRoot(newResource.getRootPath())}));
                }
            }
            if (!importCase) {
                this.log(dbc, new CmsLogEntry(dbc, newResource.getStructureId(), CmsLogEntryType.RESOURCE_CREATED, new String[]{resource.getRootPath()}), false);
            } else {
                this.log(dbc, new CmsLogEntry(dbc, newResource.getStructureId(), CmsLogEntryType.RESOURCE_IMPORTED, new String[]{resource.getRootPath()}), false);
            }
            this.m_monitor.clearAccessControlListCache();
        }
        catch (Throwable throwable) {
            this.m_monitor.clearAccessControlListCache();
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
            if (newResource != null) {
                OpenCms.fireCmsEvent(new CmsEvent(23, Collections.singletonMap("resource", newResource)));
            }
            throw throwable;
        }
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        if (newResource != null) {
            OpenCms.fireCmsEvent(new CmsEvent(23, Collections.singletonMap("resource", newResource)));
        }
        return newResource;
    }

    public CmsResource createResource(CmsDbContext dbc, String resourcename, int type, byte[] content, List<CmsProperty> properties) throws CmsException, CmsIllegalArgumentException {
        int size;
        String targetName = resourcename;
        if (content == null) {
            content = new byte[]{};
        }
        if (CmsFolder.isFolderType(type)) {
            if (CmsResource.isFolder(targetName)) {
                targetName = targetName.substring(0, targetName.length() - 1);
            }
            size = -1;
        } else {
            size = content.length;
        }
        CmsResource newResource = new CmsResource(CmsUUID.getNullUUID(), CmsUUID.getNullUUID(), targetName, type, CmsFolder.isFolderType(type), 0, dbc.currentProject().getUuid(), CmsResource.STATE_NEW, 0L, dbc.currentUser().getId(), 0L, dbc.currentUser().getId(), 0L, Long.MAX_VALUE, 1, size, 0L, 0);
        return this.createResource(dbc, targetName, newResource, content, properties, false);
    }

    public CmsResource createSibling(CmsDbContext dbc, CmsResource source, String destination, List<CmsProperty> properties) throws CmsException {
        if (source.isFolder()) {
            throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_VFS_FOLDERS_DONT_SUPPORT_SIBLINGS_0"));
        }
        String destinationFoldername = CmsResource.getParentFolder(destination);
        CmsFolder destinationFolder = this.readFolder(dbc, destinationFoldername, CmsResourceFilter.IGNORE_EXPIRATION);
        int flags = source.getFlags();
        if (this.labelResource(dbc, source, destination, 1)) {
            flags |= 2;
        }
        CmsResource newResource = new CmsResource(new CmsUUID(), source.getResourceId(), destination, source.getTypeId(), source.isFolder(), flags, dbc.currentProject().getUuid(), CmsResource.STATE_KEEP, source.getDateCreated(), source.getUserCreated(), source.getDateLastModified(), source.getUserLastModified(), source.getDateReleased(), source.getDateExpired(), source.getSiblingCount() + 1, source.getLength(), source.getDateContent(), source.getVersion());
        newResource.setDateLastModified(newResource.getDateLastModified());
        this.log(dbc, new CmsLogEntry(dbc, newResource.getStructureId(), CmsLogEntryType.RESOURCE_CLONED, new String[]{newResource.getRootPath()}), false);
        newResource = this.createResource(dbc, destination, newResource, null, properties, false);
        this.copyRelations(dbc, source, newResource);
        this.m_monitor.clearAccessControlListCache();
        ArrayList<CmsResource> modifiedResources = new ArrayList<CmsResource>();
        modifiedResources.add(source);
        modifiedResources.add(newResource);
        modifiedResources.add(destinationFolder);
        OpenCms.fireCmsEvent(new CmsEvent(27, Collections.singletonMap("resources", modifiedResources)));
        return newResource;
    }

    public CmsProject createTempfileProject(CmsDbContext dbc) throws CmsException {
        CmsGroup projectUserGroup = this.readGroup(dbc, dbc.currentProject().getGroupId());
        CmsGroup projectManagerGroup = this.readGroup(dbc, dbc.currentProject().getManagerGroupId());
        CmsProject tempProject = this.getProjectDriver(dbc).createProject(dbc, new CmsUUID(), dbc.currentUser(), projectUserGroup, projectManagerGroup, "tempFileProject", org.opencms.db.Messages.get().getBundle(dbc.getRequestContext().getLocale()).key("GUI_WORKPLACE_TEMPFILE_PROJECT_DESC_0"), 4, CmsProject.PROJECT_TYPE_NORMAL);
        this.getProjectDriver(dbc).createProjectResource(dbc, tempProject.getUuid(), "/");
        OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", tempProject)));
        return tempProject;
    }

    public CmsUser createUser(CmsDbContext dbc, String name, String password, String description, Map<String, Object> additionalInfos) throws CmsException, CmsIllegalArgumentException {
        name = name.trim();
        String userName = CmsOrganizationalUnit.getSimpleName(name);
        OpenCms.getValidationHandler().checkUserName(userName);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_USER_1", userName));
        }
        CmsOrganizationalUnit ou = this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(name));
        this.validatePassword(password);
        HashMap<String, Object> info = new HashMap<String, Object>();
        if (additionalInfos != null) {
            info.putAll(additionalInfos);
        }
        if (description != null) {
            info.put("USER_DESCRIPTION", description);
        }
        int flags = 0;
        if (ou.hasFlagWebuser()) {
            flags += 32768;
        }
        CmsUser user = this.getUserDriver(dbc).createUser(dbc, new CmsUUID(), name, OpenCms.getPasswordHandler().digest(password), " ", " ", " ", 0L, 0 + flags, 0L, info);
        if (!dbc.getProjectId().isNullUUID()) {
            return user;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("userId", user.getId().toString());
        eventData.put("userAction", "createUser");
        OpenCms.fireCmsEvent(new CmsEvent(29, eventData));
        return user;
    }

    public void deleteAliases(CmsDbContext dbc, CmsProject project, CmsAliasFilter filter) throws CmsException {
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        vfsDriver.deleteAliases(dbc, project, filter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteAllProperties(CmsDbContext dbc, String resourcename) throws CmsException {
        ArrayList<CmsResource> resources;
        block3: {
            CmsResource resource = null;
            resources = new ArrayList<CmsResource>();
            try {
                resource = this.readResource(dbc, resourcename, CmsResourceFilter.IGNORE_EXPIRATION);
                this.m_securityManager.checkPermissions(dbc, resource, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
                if (resource.getSiblingCount() > 1) {
                    this.getVfsDriver(dbc).deletePropertyObjects(dbc, dbc.currentProject().getUuid(), resource, 2);
                    resources.addAll(this.readSiblings(dbc, resource, CmsResourceFilter.ALL));
                    break block3;
                }
                this.getVfsDriver(dbc).deletePropertyObjects(dbc, dbc.currentProject().getUuid(), resource, 1);
                resources.add(resource);
            }
            catch (Throwable throwable) {
                this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
                OpenCms.fireCmsEvent(new CmsEvent(27, Collections.singletonMap("resources", resources)));
                throw throwable;
            }
        }
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        OpenCms.fireCmsEvent(new CmsEvent(27, Collections.singletonMap("resources", resources)));
    }

    public void deleteAllStaticExportPublishedResources(CmsDbContext dbc, int linkType) throws CmsException {
        this.getProjectDriver(dbc).deleteAllStaticExportPublishedResources(dbc, linkType);
    }

    public void deleteGroup(CmsDbContext dbc, CmsGroup group, CmsUUID replacementId) throws CmsDataAccessException, CmsException {
        CmsGroup replacementGroup = null;
        if (replacementId != null) {
            replacementGroup = this.readGroup(dbc, replacementId);
        }
        List<CmsGroup> children = this.getChildren(dbc, group, false);
        List<CmsUser> users = this.getUsersOfGroup(dbc, group.getName(), true, true, group.isRole());
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        if (replacementGroup == null) {
            for (CmsUser user : users) {
                if (!this.userInGroup(dbc, user.getName(), group.getName(), group.isRole())) continue;
                this.removeUserFromGroup(dbc, user.getName(), group.getName(), group.isRole());
            }
            CmsUUID parentId = group.getParentId();
            if (parentId == null) {
                parentId = CmsUUID.getNullUUID();
            }
            for (CmsGroup child : children) {
                child.setParentId(parentId);
                this.writeGroup(dbc, child);
            }
        } else {
            for (CmsGroup child : children) {
                child.setParentId(replacementId);
                this.writeGroup(dbc, child);
            }
            for (CmsUser user : users) {
                this.addUserToGroup(dbc, user.getName(), replacementGroup.getName(), group.isRole());
                this.removeUserFromGroup(dbc, user.getName(), group.getName(), group.isRole());
            }
            this.transferPrincipalResources(dbc, dbc.currentProject(), group.getId(), replacementId, true);
            this.transferPrincipalResources(dbc, onlineProject, group.getId(), replacementId, true);
        }
        this.getUserDriver(dbc).removeAccessControlEntriesForPrincipal(dbc, dbc.currentProject(), onlineProject, group.getId());
        this.getUserDriver(dbc).deleteGroup(dbc, group.getName());
        this.getHistoryDriver(dbc).writePrincipal(dbc, group);
        if (OpenCms.getSubscriptionManager().isEnabled()) {
            this.unsubscribeAllResourcesFor(dbc, OpenCms.getSubscriptionManager().getPoolName(), group);
        }
        this.m_monitor.uncacheGroup(group);
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.USERGROUPS, CmsMemoryMonitor.CacheType.USER_LIST, CmsMemoryMonitor.CacheType.ACL);
        if (!dbc.getProjectId().isNullUUID()) {
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("groupId", group.getId().toString());
        eventData.put("groupName", group.getName());
        eventData.put("userAction", "deleteGroup");
        OpenCms.fireCmsEvent(new CmsEvent(31, eventData));
    }

    public void deleteHistoricalVersions(CmsDbContext dbc, int versionsToKeep, int versionsDeleted, long timeDeleted, I_CmsReport report) throws CmsException {
        int m;
        int n;
        List<I_CmsHistoryResource> resources;
        report.println(org.opencms.db.Messages.get().container("RPT_START_DELETE_VERSIONS_0"), 2);
        if (versionsToKeep >= 0) {
            report.println(org.opencms.db.Messages.get().container("RPT_START_DELETE_ACT_VERSIONS_1", new Integer(versionsToKeep)), 2);
            resources = this.getHistoryDriver(dbc).getAllNotDeletedEntries(dbc);
            if (resources.isEmpty()) {
                report.println(org.opencms.db.Messages.get().container("RPT_DELETE_NOTHING_0"), 4);
            }
            n = resources.size();
            m = 1;
            for (I_CmsHistoryResource histResource : resources) {
                block12: {
                    report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
                    report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(histResource.getRootPath())));
                    report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    try {
                        int deleted = this.getHistoryDriver(dbc).deleteEntries(dbc, histResource, versionsToKeep, -1L);
                        report.print(org.opencms.db.Messages.get().container("RPT_VERSION_DELETING_1", new Integer(deleted)), 3);
                        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    }
                    catch (CmsDataAccessException e) {
                        report.println(org.opencms.report.Messages.get().container("RPT_ERROR_0"), 5);
                        if (!LOG.isDebugEnabled()) break block12;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                ++m;
            }
            report.println(org.opencms.db.Messages.get().container("RPT_END_DELETE_ACT_VERSIONS_0"), 2);
        }
        if (versionsDeleted >= 0 || timeDeleted >= 0L) {
            if (timeDeleted >= 0L) {
                report.println(org.opencms.db.Messages.get().container("RPT_START_DELETE_DEL_VERSIONS_2", new Integer(versionsDeleted), new Date(timeDeleted)), 2);
            } else {
                report.println(org.opencms.db.Messages.get().container("RPT_START_DELETE_DEL_VERSIONS_1", new Integer(versionsDeleted)), 2);
            }
            resources = this.getHistoryDriver(dbc).getAllDeletedEntries(dbc);
            if (resources.isEmpty()) {
                report.println(org.opencms.db.Messages.get().container("RPT_DELETE_NOTHING_0"), 4);
            }
            n = resources.size();
            m = 1;
            for (I_CmsHistoryResource histResource : resources) {
                block13: {
                    report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", String.valueOf(m), String.valueOf(n)), 3);
                    report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", dbc.removeSiteRoot(histResource.getRootPath())));
                    report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                    try {
                        int deleted = this.getHistoryDriver(dbc).deleteEntries(dbc, histResource, versionsDeleted, timeDeleted);
                        report.print(org.opencms.db.Messages.get().container("RPT_VERSION_DELETING_1", new Integer(deleted)), 3);
                        report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
                        report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                    }
                    catch (CmsDataAccessException e) {
                        report.println(org.opencms.report.Messages.get().container("RPT_ERROR_0"), 5);
                        if (!LOG.isDebugEnabled()) break block13;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                ++m;
            }
            report.println(org.opencms.db.Messages.get().container("RPT_END_DELETE_DEL_VERSIONS_0"), 2);
        }
        report.println(org.opencms.db.Messages.get().container("RPT_END_DELETE_VERSIONS_0"), 2);
    }

    public void deleteLogEntries(CmsDbContext dbc, CmsLogFilter filter) throws CmsException {
        this.updateLog(dbc);
        this.m_projectDriver.deleteLog(dbc, filter);
    }

    public void deleteOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit organizationalUnit) throws CmsException {
        if (dbc.getRequestContext().getOuFqn().equals(organizationalUnit.getName())) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_IN_CONTEXT_1", organizationalUnit.getName()));
        }
        if (dbc.currentUser().getOuFqn().equals(organizationalUnit.getName())) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_CURRENT_USER_1", organizationalUnit.getName()));
        }
        if (!this.getOrganizationalUnits(dbc, organizationalUnit, true).isEmpty()) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_SUB_ORGUNITS_1", organizationalUnit.getName()));
        }
        List<CmsGroup> groups = this.getGroups(dbc, organizationalUnit, true, false);
        for (CmsGroup group : groups) {
            if (OpenCms.getDefaultUsers().isDefaultGroup(group.getName())) continue;
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_GROUPS_1", organizationalUnit.getName()));
        }
        if (!this.getUsers(dbc, organizationalUnit, true).isEmpty()) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_DELETE_USERS_1", organizationalUnit.getName()));
        }
        for (CmsGroup group : groups) {
            this.deleteGroup(dbc, group, null);
        }
        for (CmsProject project : this.getProjectDriver(dbc).readProjects(dbc, organizationalUnit.getName())) {
            this.deleteProject(dbc, project);
        }
        for (CmsGroup role : this.getGroups(dbc, organizationalUnit, true, true)) {
            this.deleteGroup(dbc, role, null);
        }
        CmsResource resource = this.readResource(dbc, organizationalUnit.getId(), CmsResourceFilter.DEFAULT);
        CmsPublishList pl = new CmsPublishList(resource, false);
        pl.add(resource, false);
        this.getUserDriver(dbc).deleteOrganizationalUnit(dbc, organizationalUnit);
        this.getProjectDriver(dbc).writePublishHistory(dbc, pl.getPublishHistoryId(), new CmsPublishedResource(resource, -1, CmsResourceState.STATE_DELETED));
        this.m_monitor.clearPrincipalsCache();
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("publishHistoryId", pl.getPublishHistoryId().toString());
        eventData.put("projectId", dbc.currentProject().getUuid());
        eventData.put("dbContext", dbc);
        CmsEvent afterPublishEvent = new CmsEvent(2, eventData);
        OpenCms.fireCmsEvent(afterPublishEvent);
        this.m_lockManager.removeDeletedResource(dbc, resource.getRootPath());
        if (!dbc.getProjectId().isNullUUID()) {
            return;
        }
        HashMap<String, Object> event2Data = new HashMap<String, Object>();
        event2Data.put("ouName", organizationalUnit.getName());
        event2Data.put("userAction", "deleteOu");
        OpenCms.fireCmsEvent(new CmsEvent(30, event2Data));
    }

    public void deleteProject(CmsDbContext dbc, CmsProject deleteProject) throws CmsException {
        CmsResource currentFolder;
        CmsLock lock;
        CmsResource currentFile;
        int i;
        CmsUUID projectId = deleteProject.getUuid();
        List<CmsResource> modifiedFiles = this.readChangedResourcesInsideProject(dbc, projectId, RCPRM_FILES_ONLY_MODE);
        List<CmsResource> modifiedFolders = this.readChangedResourcesInsideProject(dbc, projectId, RCPRM_FOLDERS_ONLY_MODE);
        for (i = 0; i < modifiedFiles.size(); ++i) {
            currentFile = modifiedFiles.get(i);
            if (!currentFile.getState().isNew()) continue;
            lock = this.getLock(dbc, currentFile);
            if (lock.isNullLock()) {
                this.lockResource(dbc, currentFile, CmsLockType.EXCLUSIVE);
            } else if (!lock.isOwnedBy(dbc.currentUser()) || !lock.isInProject(dbc.currentProject())) {
                this.changeLock(dbc, currentFile, CmsLockType.EXCLUSIVE);
            }
            this.getVfsDriver(dbc).deletePropertyObjects(dbc, projectId, currentFile, 1);
            this.getVfsDriver(dbc).removeFile(dbc, dbc.currentProject().getUuid(), currentFile);
            this.getUserDriver(dbc).removeAccessControlEntries(dbc, dbc.currentProject(), currentFile.getResourceId());
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFile)));
        }
        for (i = 0; i < modifiedFolders.size(); ++i) {
            currentFolder = modifiedFolders.get(i);
            if (!currentFolder.getState().isNew()) continue;
            this.getVfsDriver(dbc).deletePropertyObjects(dbc, projectId, currentFolder, 1);
            this.getVfsDriver(dbc).removeFolder(dbc, dbc.currentProject(), currentFolder);
            this.getUserDriver(dbc).removeAccessControlEntries(dbc, dbc.currentProject(), currentFolder.getResourceId());
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFolder)));
        }
        for (i = 0; i < modifiedFolders.size(); ++i) {
            currentFolder = modifiedFolders.get(i);
            if (!currentFolder.getState().isChanged() && !currentFolder.getState().isDeleted()) continue;
            lock = this.getLock(dbc, currentFolder);
            if (lock.isNullLock()) {
                this.lockResource(dbc, currentFolder, CmsLockType.EXCLUSIVE);
            } else if (!lock.isOwnedBy(dbc.currentUser()) || !lock.isInProject(dbc.currentProject())) {
                this.changeLock(dbc, currentFolder, CmsLockType.EXCLUSIVE);
            }
            this.undoChanges(dbc, currentFolder, CmsResource.UNDO_CONTENT);
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFolder)));
        }
        for (i = 0; i < modifiedFiles.size(); ++i) {
            currentFile = modifiedFiles.get(i);
            if (!currentFile.getState().isChanged() && !currentFile.getState().isDeleted()) continue;
            lock = this.getLock(dbc, currentFile);
            if (lock.isNullLock()) {
                this.lockResource(dbc, currentFile, CmsLockType.EXCLUSIVE);
            } else if (!lock.isOwnedInProjectBy(dbc.currentUser(), dbc.currentProject()) && lock.isLockableBy(dbc.currentUser())) {
                this.changeLock(dbc, currentFile, CmsLockType.EXCLUSIVE);
            }
            this.undoChanges(dbc, currentFile, CmsResource.UNDO_CONTENT);
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", currentFile)));
        }
        this.m_lockManager.removeResourcesInProject(deleteProject.getUuid(), true);
        this.m_monitor.clearAccessControlListCache();
        this.m_monitor.clearResourceCache();
        if (projectId.equals(dbc.currentProject().getUuid())) {
            dbc.getRequestContext().setCurrentProject(this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID));
        }
        this.getProjectDriver(dbc).deleteProject(dbc, deleteProject);
        this.m_monitor.uncacheProject(deleteProject);
        OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", deleteProject)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePropertyDefinition(CmsDbContext dbc, String name) throws CmsException {
        CmsPropertyDefinition propertyDefinition = null;
        try {
            propertyDefinition = this.readPropertyDefinition(dbc, name);
            this.getVfsDriver(dbc).deletePropertyDefinition(dbc, propertyDefinition);
            this.getHistoryDriver(dbc).deletePropertyDefinition(dbc, propertyDefinition);
        }
        finally {
            OpenCms.fireCmsEvent(new CmsEvent(26, Collections.singletonMap("propertyDefinition", propertyDefinition)));
        }
    }

    public void deletePublishJob(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        this.getProjectDriver(dbc).deletePublishJob(dbc, publishHistoryId);
    }

    public void deletePublishList(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        this.getProjectDriver(dbc).deletePublishList(dbc, publishHistoryId);
    }

    public void deleteRelationsForResource(CmsDbContext dbc, CmsResource resource, CmsRelationFilter filter) throws CmsException {
        if (filter.includesDefinedInContent()) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_DELETE_RELATION_IN_CONTENT_2", dbc.removeSiteRoot(resource.getRootPath()), filter.getTypes()));
        }
        this.getVfsDriver(dbc).deleteRelations(dbc, dbc.currentProject().getUuid(), resource, filter);
        this.setDateLastModified(dbc, resource, System.currentTimeMillis());
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_REMOVE_RELATION, new String[]{resource.getRootPath(), filter.toString()}), false);
    }

    public void deleteResource(CmsDbContext dbc, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        CmsResource currentResource;
        int i;
        boolean allSiblingsRemoved;
        List<CmsResource> resources;
        CmsLock currentLock = this.getLock(dbc, resource);
        if (currentLock.getEditionLock().isDirectlyInherited()) {
            this.lockResource(dbc, resource, CmsLockType.EXCLUSIVE);
        }
        if (resource.isFolder()) {
            siblingMode = CmsResource.DELETE_PRESERVE_SIBLINGS;
        }
        if (siblingMode == CmsResource.DELETE_REMOVE_SIBLINGS) {
            resources = new ArrayList<CmsResource>(this.readSiblings(dbc, resource, CmsResourceFilter.ALL));
            allSiblingsRemoved = true;
            resources.remove(resource);
            resources.add(resource);
        } else {
            resources = Collections.singletonList(resource);
            allSiblingsRemoved = false;
        }
        int size = resources.size();
        if (size > 1) {
            CmsMultiException me = new CmsMultiException();
            for (i = 0; i < size; ++i) {
                currentResource = resources.get(i);
                currentLock = this.getLock(dbc, currentResource);
                if (currentLock.getEditionLock().isUnlocked() || currentLock.isOwnedBy(dbc.currentUser())) continue;
                CmsRequestContext context = dbc.getRequestContext();
                me.addException(new CmsLockException(org.opencms.lock.Messages.get().container("ERR_SIBLING_LOCKED_2", context.getSitePath(currentResource), context.getSitePath(resource))));
            }
            if (!me.getExceptions().isEmpty()) {
                throw me;
            }
        }
        boolean removeAce = true;
        if (resource.isFolder()) {
            Iterator<CmsResource> childResources = this.getVfsDriver(dbc).readChildResources(dbc, dbc.currentProject(), resource, true, true).iterator();
            CmsUUID projectId = CmsProject.ONLINE_PROJECT_ID;
            if (dbc.currentProject().isOnlineProject()) {
                projectId = CmsUUID.getOpenCmsUUID();
            }
            StringBuffer errorResNames = new StringBuffer(128);
            while (childResources.hasNext()) {
                boolean error;
                CmsResource errorRes = childResources.next();
                if (errorRes.getState().isDeleted()) continue;
                boolean bl = error = !dbc.currentProject().isOnlineProject();
                if (!error) {
                    try {
                        String originalPath = this.getVfsDriver(dbc).readResource(dbc, projectId, errorRes.getRootPath(), true).getRootPath();
                        error = originalPath.equals(errorRes.getRootPath()) || originalPath.startsWith(resource.getRootPath());
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        // empty catch block
                    }
                }
                if (!error) continue;
                if (errorResNames.length() != 0) {
                    errorResNames.append(", ");
                }
                errorResNames.append("[" + dbc.removeSiteRoot(errorRes.getRootPath()) + "]");
            }
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(errorResNames.toString())) {
                throw new CmsVfsException(Messages.get().container("ERR_DELETE_NONEMTY_FOLDER_2", dbc.removeSiteRoot(resource.getRootPath()), errorResNames.toString()));
            }
        }
        for (i = 0; i < size; ++i) {
            boolean existsOnline;
            currentResource = resources.get(i);
            if (!currentResource.equals(resource) && I_CmsPermissionHandler.PERM_ALLOWED != this.m_securityManager.hasPermissions(dbc, currentResource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL)) {
                allSiblingsRemoved = false;
                continue;
            }
            boolean bl = existsOnline = this.getVfsDriver(dbc).validateStructureIdExists(dbc, CmsProject.ONLINE_PROJECT_ID, currentResource.getStructureId()) || !currentResource.getState().equals(CmsResource.STATE_NEW);
            if (!existsOnline) {
                this.deleteAllProperties(dbc, currentResource.getRootPath());
                if (currentResource.isFolder()) {
                    this.getVfsDriver(dbc).removeFolder(dbc, dbc.currentProject(), currentResource);
                } else {
                    if (currentResource.isLabeled() && !this.labelResource(dbc, currentResource, null, 2)) {
                        int flags = currentResource.getFlags();
                        currentResource.setFlags(flags &= 0xFFFFFFFD);
                    }
                    this.getVfsDriver(dbc).removeFile(dbc, dbc.currentProject().getUuid(), currentResource);
                }
                this.m_lockManager.removeDeletedResource(dbc, currentResource.getRootPath());
                this.getVfsDriver(dbc).deleteRelations(dbc, dbc.currentProject().getUuid(), currentResource, CmsRelationFilter.TARGETS);
                this.getVfsDriver(dbc).deleteUrlNameMappingEntries(dbc, false, CmsUrlNameMappingFilter.ALL.filterStructureId(currentResource.getStructureId()));
                this.getVfsDriver(dbc).deleteAliases(dbc, dbc.currentProject(), new CmsAliasFilter(null, null, currentResource.getStructureId()));
                continue;
            }
            removeAce = false;
            currentResource.setState(CmsResource.STATE_DELETED);
            this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), currentResource, 5, false);
            this.getVfsDriver(dbc).writeLastModifiedProjectId(dbc, dbc.currentProject(), dbc.currentProject().getUuid(), currentResource);
            this.log(dbc, new CmsLogEntry(dbc, currentResource.getStructureId(), CmsLogEntryType.RESOURCE_DELETED, new String[]{currentResource.getRootPath()}), true);
        }
        if ((resource.getSiblingCount() <= 1 || allSiblingsRemoved) && removeAce) {
            this.getUserDriver(dbc).removeAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId());
        }
        this.m_monitor.clearAccessControlListCache();
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST, CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
        OpenCms.fireCmsEvent(new CmsEvent(25, Collections.singletonMap("resources", resources)));
    }

    public void deleteStaticExportPublishedResource(CmsDbContext dbc, String resourceName, int linkType, String linkParameter) throws CmsException {
        this.getProjectDriver(dbc).deleteStaticExportPublishedResource(dbc, resourceName, linkType, linkParameter);
    }

    public void deleteUser(CmsDbContext dbc, CmsProject project, String username, String replacementUsername) throws CmsException {
        CmsUser user = this.readUser(dbc, username);
        CmsUser replacementUser = null;
        if (replacementUsername != null) {
            replacementUser = this.readUser(dbc, replacementUsername);
        }
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        boolean withACEs = true;
        if (replacementUser == null) {
            withACEs = false;
            replacementUser = this.readUser(dbc, OpenCms.getDefaultUsers().getUserDeletedResource());
        }
        boolean isVfsManager = this.m_securityManager.hasRole(dbc, replacementUser, CmsRole.VFS_MANAGER);
        boolean readRoles = false;
        while (!readRoles) {
            for (CmsGroup group : this.getGroupsOfUser(dbc, username, "", true, readRoles, true, dbc.getRequestContext().getRemoteAddress())) {
                if (!isVfsManager && !this.userInGroup(dbc, replacementUser.getName(), group.getName(), readRoles)) {
                    this.addUserToGroup(dbc, replacementUser.getName(), group.getName(), readRoles);
                }
                if (!this.userInGroup(dbc, username, group.getName(), readRoles)) continue;
                this.removeUserFromGroup(dbc, username, group.getName(), readRoles);
            }
            readRoles = !readRoles;
        }
        this.m_lockManager.removeLocks(user.getId());
        if (dbc.getProjectId().isNullUUID()) {
            this.transferPrincipalResources(dbc, project, user.getId(), replacementUser.getId(), withACEs);
        }
        this.transferPrincipalResources(dbc, onlineProject, user.getId(), replacementUser.getId(), withACEs);
        this.getUserDriver(dbc).removeAccessControlEntriesForPrincipal(dbc, project, onlineProject, user.getId());
        this.getHistoryDriver(dbc).writePrincipal(dbc, user);
        this.getUserDriver(dbc).deleteUser(dbc, username);
        this.m_monitor.clearUserCache(user);
        if (!dbc.getProjectId().isNullUUID()) {
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("userId", user.getId().toString());
        eventData.put("userName", user.getName());
        eventData.put("userAction", "deleteUser");
        OpenCms.fireCmsEvent(new CmsEvent(29, eventData));
    }

    public void destroy() {
        try {
            if (this.m_projectDriver != null) {
                try {
                    this.m_projectDriver.destroy();
                }
                catch (Throwable t) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CLOSE_PROJECT_DRIVER_0"), t);
                }
                this.m_projectDriver = null;
            }
            if (this.m_userDriver != null) {
                try {
                    this.m_userDriver.destroy();
                }
                catch (Throwable t) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CLOSE_USER_DRIVER_0"), t);
                }
                this.m_userDriver = null;
            }
            if (this.m_vfsDriver != null) {
                try {
                    this.m_vfsDriver.destroy();
                }
                catch (Throwable t) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CLOSE_VFS_DRIVER_0"), t);
                }
                this.m_vfsDriver = null;
            }
            if (this.m_historyDriver != null) {
                try {
                    this.m_historyDriver.destroy();
                }
                catch (Throwable t) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_CLOSE_HISTORY_DRIVER_0"), t);
                }
                this.m_historyDriver = null;
            }
            if (this.m_connectionPools != null) {
                for (int i = 0; i < this.m_connectionPools.size(); ++i) {
                    String[] pools;
                    PoolingDriver driver = this.m_connectionPools.get(i);
                    for (String pool : pools = driver.getPoolNames()) {
                        try {
                            driver.closePool(pool);
                            if (!CmsLog.INIT.isDebugEnabled()) continue;
                            CmsLog.INIT.debug((Object)org.opencms.db.Messages.get().getBundle().key("INIT_CLOSE_CONN_POOL_1", pool));
                        }
                        catch (Throwable t) {
                            LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_CLOSE_CONN_POOL_ERROR_1", pool), t);
                        }
                    }
                }
                this.m_connectionPools = null;
            }
            this.m_monitor.clearCache();
            this.m_lockManager = null;
            this.m_htmlLinkValidator = null;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_DESTROY_1", this.getClass().getName()));
        }
        org.opencms.db.jpa.CmsSqlManager.destroy();
    }

    public boolean existsResourceId(CmsDbContext dbc, CmsUUID resourceId) throws CmsException {
        return this.getVfsDriver(dbc).validateResourceIdExists(dbc, dbc.currentProject().getUuid(), resourceId);
    }

    public void fillPublishList(CmsDbContext dbc, CmsPublishList publishList) throws CmsException {
        if (!publishList.isDirectPublish()) {
            List<CmsResource> folderList = this.getVfsDriver(dbc).readResourceTree(dbc, dbc.currentProject().getUuid(), READ_IGNORE_PARENT, -1, CmsResource.STATE_UNCHANGED, 0L, 0L, 0L, 0L, 0L, 0L, 74);
            publishList.addAll(this.filterResources(dbc, null, folderList), true);
            List<CmsResource> fileList = this.getVfsDriver(dbc).readResourceTree(dbc, dbc.currentProject().getUuid(), READ_IGNORE_PARENT, -1, CmsResource.STATE_UNCHANGED, 0L, 0L, 0L, 0L, 0L, 0L, 138);
            publishList.addAll(this.filterResources(dbc, publishList, fileList), true);
        } else {
            for (CmsResource directPublishResource : publishList.getDirectPublishResources()) {
                CmsLock lock;
                if (directPublishResource.isFolder()) {
                    boolean shouldPublishDeletedSubResources;
                    lock = this.getLock(dbc, directPublishResource);
                    if (!directPublishResource.getState().isUnchanged() && lock.isLockableBy(dbc.currentUser())) {
                        try {
                            this.m_securityManager.checkPermissions(dbc, directPublishResource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
                            publishList.add(directPublishResource, true);
                        }
                        catch (CmsException e) {
                            // empty catch block
                        }
                    }
                    boolean bl = shouldPublishDeletedSubResources = publishList.isUserPublishList() && directPublishResource.getState().isDeleted();
                    if (!publishList.isPublishSubResources() && !shouldPublishDeletedSubResources) continue;
                    this.addSubResources(dbc, publishList, directPublishResource);
                    continue;
                }
                if (!directPublishResource.isFile() || directPublishResource.getState().isUnchanged() || !(lock = this.getLock(dbc, directPublishResource)).isLockableBy(dbc.currentUser())) continue;
                try {
                    this.m_securityManager.checkPermissions(dbc, directPublishResource, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
                    publishList.add(directPublishResource, true);
                }
                catch (CmsException e) {}
            }
        }
        if (publishList.isPublishSiblings()) {
            List<CmsResource> publishFiles = publishList.getFileList();
            int size = publishFiles.size();
            HashSet<CmsResource> siblingsClosure = new HashSet<CmsResource>(publishFiles);
            for (int i = 0; i < size; ++i) {
                CmsResource currentFile = publishFiles.get(i);
                if (currentFile.getSiblingCount() <= 1) continue;
                siblingsClosure.addAll(this.readSiblings(dbc, currentFile, CmsResourceFilter.ALL_MODIFIED));
            }
            publishList.addAll(this.filterSiblings(dbc, publishList, siblingsClosure), true);
        }
        publishList.initialize();
    }

    public List<CmsAccessControlEntry> getAccessControlEntries(CmsDbContext dbc, CmsResource resource, boolean getInherited) throws CmsException {
        int d;
        I_CmsUserDriver userDriver = this.getUserDriver(dbc);
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        List<CmsAccessControlEntry> ace = userDriver.readAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId(), false);
        boolean overwriteAll = this.sortAceList(ace);
        String parentPath = CmsResource.getParentFolder(resource.getRootPath());
        int n = d = resource.isFolder() ? 1 : 0;
        while (!overwriteAll && getInherited && parentPath != null) {
            resource = vfsDriver.readFolder(dbc, dbc.currentProject().getUuid(), parentPath);
            List<CmsAccessControlEntry> entries = userDriver.readAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId(), d > 0);
            overwriteAll = this.sortAceList(entries);
            for (CmsAccessControlEntry e : entries) {
                e.setFlags(8);
            }
            ace.addAll(entries);
            parentPath = CmsResource.getParentFolder(resource.getRootPath());
            ++d;
        }
        return ace;
    }

    public CmsAccessControlList getAccessControlList(CmsDbContext dbc, CmsResource resource) throws CmsException {
        return this.getAccessControlList(dbc, resource, false);
    }

    public CmsAccessControlList getAccessControlList(CmsDbContext dbc, CmsResource resource, boolean inheritedOnly) throws CmsException {
        return this.getAccessControlList(dbc, resource, inheritedOnly, resource.isFolder(), 0);
    }

    public int getActiveConnections(String dbPoolUrl) throws CmsDbException {
        try {
            Iterator<PoolingDriver> i$ = this.m_connectionPools.iterator();
            if (i$.hasNext()) {
                PoolingDriver d = i$.next();
                ObjectPool p = d.getConnectionPool(dbPoolUrl);
                return p.getNumActive();
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_ACCESSING_POOL_1", dbPoolUrl);
            throw new CmsDbException(message, (Throwable)exc);
        }
        CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_UNKNOWN_POOL_URL_1", dbPoolUrl);
        throw new CmsDbException(message);
    }

    public List<CmsAccessControlEntry> getAllAccessControlEntries(CmsDbContext dbc) throws CmsException {
        I_CmsUserDriver userDriver = this.getUserDriver(dbc);
        List<CmsAccessControlEntry> ace = userDriver.readAccessControlEntries(dbc, dbc.currentProject(), CmsAccessControlEntry.PRINCIPAL_READALL_ID, false);
        return ace;
    }

    public List<CmsProject> getAllAccessibleProjects(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean includeSubOus) throws CmsException {
        HashSet<CmsProject> projects = new HashSet<CmsProject>();
        List<CmsOrganizationalUnit> ous = this.getOrgUnitsForRole(dbc, CmsRole.PROJECT_MANAGER.forOrgUnit(orgUnit.getName()), includeSubOus);
        HashSet<CmsUUID> userGroupIds = new HashSet<CmsUUID>();
        for (CmsGroup group : this.getGroupsOfUser(dbc, dbc.currentUser().getName(), false)) {
            userGroupIds.add(group.getId());
        }
        projects.addAll(this.getProjectDriver(dbc).readProjects(dbc, orgUnit.getName()));
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsProject project = (CmsProject)itProjects.next();
            boolean accessible = true;
            boolean bl = accessible = accessible && !project.isHidden();
            if (!includeSubOus) {
                accessible = accessible && project.getOuFqn().equals(orgUnit.getName());
            } else {
                boolean bl2 = accessible = accessible && project.getOuFqn().startsWith(orgUnit.getName());
            }
            if (!accessible) {
                itProjects.remove();
                continue;
            }
            accessible = false;
            accessible = accessible || project.isOnlineProject();
            accessible = accessible || project.getOwnerId().equals(dbc.currentUser().getId());
            Iterator<CmsOrganizationalUnit> itOus = ous.iterator();
            while (!accessible && itOus.hasNext()) {
                CmsOrganizationalUnit ou = itOus.next();
                accessible = accessible || project.getOuFqn().startsWith(ou.getName());
            }
            if (!accessible) {
                CmsUUID groupId = null;
                if (userGroupIds.contains(project.getGroupId())) {
                    groupId = project.getGroupId();
                } else if (userGroupIds.contains(project.getManagerGroupId())) {
                    groupId = project.getManagerGroupId();
                }
                if (groupId != null) {
                    String oufqn = this.readGroup(dbc, groupId).getOuFqn();
                    boolean bl3 = accessible = accessible || oufqn.startsWith(dbc.getRequestContext().getOuFqn());
                }
            }
            if (accessible) continue;
            itProjects.remove();
        }
        ArrayList<CmsProject> accessibleProjects = new ArrayList<CmsProject>(projects);
        Collections.sort(accessibleProjects);
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        if (accessibleProjects.contains(onlineProject)) {
            accessibleProjects.remove(onlineProject);
        }
        accessibleProjects.add(0, onlineProject);
        return accessibleProjects;
    }

    public List<CmsHistoryProject> getAllHistoricalProjects(CmsDbContext dbc) throws CmsException {
        HashSet<CmsOrganizationalUnit> manOus = new HashSet<CmsOrganizationalUnit>(this.getOrgUnitsForRole(dbc, CmsRole.PROJECT_MANAGER, true));
        List<CmsHistoryProject> projects = this.getHistoryDriver(dbc).readProjects(dbc);
        Iterator<CmsHistoryProject> itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsHistoryProject project = itProjects.next();
            if (project.isHidden()) {
                itProjects.remove();
                continue;
            }
            if (!project.getOuFqn().startsWith(dbc.currentUser().getOuFqn())) {
                itProjects.remove();
                continue;
            }
            CmsOrganizationalUnit ou = this.readOrganizationalUnit(dbc, project.getOuFqn());
            if (manOus.contains(ou) || project.getOwnerId().equals(dbc.currentUser().getId())) continue;
            boolean found = false;
            for (CmsGroup group : this.getGroupsOfUser(dbc, dbc.currentUser().getName(), false)) {
                if (!project.getManagerGroupId().equals(group.getId())) continue;
                found = true;
                break;
            }
            if (found) continue;
            itProjects.remove();
        }
        return projects;
    }

    public List<CmsProject> getAllManageableProjects(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean includeSubOus) throws CmsException {
        HashSet<CmsProject> projects = new HashSet<CmsProject>();
        List<CmsOrganizationalUnit> ous = this.getOrgUnitsForRole(dbc, CmsRole.PROJECT_MANAGER.forOrgUnit(orgUnit.getName()), includeSubOus);
        HashSet<CmsUUID> userGroupIds = new HashSet<CmsUUID>();
        for (CmsGroup group : this.getGroupsOfUser(dbc, dbc.currentUser().getName(), false)) {
            userGroupIds.add(group.getId());
        }
        projects.addAll(this.getProjectDriver(dbc).readProjects(dbc, orgUnit.getName()));
        Iterator itProjects = projects.iterator();
        while (itProjects.hasNext()) {
            CmsProject project = (CmsProject)itProjects.next();
            boolean manageable = true;
            manageable = manageable && !project.isOnlineProject();
            boolean bl = manageable = manageable && !project.isHidden();
            if (!includeSubOus) {
                manageable = manageable && project.getOuFqn().equals(orgUnit.getName());
            } else {
                boolean bl2 = manageable = manageable && project.getOuFqn().startsWith(orgUnit.getName());
            }
            if (!manageable) {
                itProjects.remove();
                continue;
            }
            manageable = false;
            manageable = manageable || project.getOwnerId().equals(dbc.currentUser().getId());
            Iterator<CmsOrganizationalUnit> itOus = ous.iterator();
            while (!manageable && itOus.hasNext()) {
                CmsOrganizationalUnit ou = itOus.next();
                manageable = manageable || project.getOuFqn().startsWith(ou.getName());
            }
            if (!manageable && userGroupIds.contains(project.getManagerGroupId())) {
                String oufqn = this.readGroup(dbc, project.getManagerGroupId()).getOuFqn();
                boolean bl3 = manageable = manageable || oufqn.startsWith(dbc.getRequestContext().getOuFqn());
            }
            if (manageable) continue;
            itProjects.remove();
        }
        ArrayList<CmsProject> manageableProjects = new ArrayList<CmsProject>(projects);
        Collections.sort(manageableProjects);
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        if (manageableProjects.contains(onlineProject)) {
            manageableProjects.remove(onlineProject);
        }
        return manageableProjects;
    }

    public List<CmsGroup> getChildren(CmsDbContext dbc, CmsGroup group, boolean includeSubChildren) throws CmsException {
        if (!includeSubChildren) {
            return this.getUserDriver(dbc).readChildGroups(dbc, group.getName());
        }
        TreeSet<CmsGroup> allChildren = new TreeSet<CmsGroup>();
        for (CmsGroup child : this.getUserDriver(dbc).readChildGroups(dbc, group.getName())) {
            allChildren.add(child);
            allChildren.addAll(this.getChildren(dbc, child, true));
        }
        return new ArrayList<CmsGroup>(allChildren);
    }

    public long getDateLastVisitedBy(CmsDbContext dbc, String poolName, CmsUser user, CmsResource resource) throws CmsException {
        return this.m_subscriptionDriver.getDateLastVisitedBy(dbc, poolName, user, resource);
    }

    public List<CmsGroup> getGroups(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean includeSubOus, boolean readRoles) throws CmsException {
        return this.getUserDriver(dbc).getGroups(dbc, orgUnit, includeSubOus, readRoles);
    }

    public List<CmsGroup> getGroupsOfUser(CmsDbContext dbc, String username, boolean readRoles) throws CmsException {
        return this.getGroupsOfUser(dbc, username, "", true, readRoles, false, dbc.getRequestContext().getRemoteAddress());
    }

    public List<CmsGroup> getGroupsOfUser(CmsDbContext dbc, String username, String ouFqn, boolean includeChildOus, boolean readRoles, boolean directGroupsOnly, String remoteAddress) throws CmsException {
        CmsUser user = this.readUser(dbc, username);
        String prefix = ouFqn + "_" + includeChildOus + "_" + directGroupsOnly + "_" + readRoles + "_" + remoteAddress;
        String cacheKey = this.m_keyGenerator.getCacheKeyForUserGroups(prefix, dbc, user);
        List<CmsGroup> groups = this.m_monitor.getCachedUserGroups(cacheKey);
        if (groups == null) {
            int i;
            List<CmsGroup> directGroups = this.getUserDriver(dbc).readGroupsOfUser(dbc, user.getId(), readRoles ? "" : ouFqn, readRoles ? true : includeChildOus, remoteAddress, readRoles);
            HashSet<CmsGroup> allGroups = new HashSet<CmsGroup>();
            if (!readRoles) {
                allGroups.addAll(directGroups);
            }
            if (!directGroupsOnly && !readRoles) {
                for (i = 0; i < directGroups.size(); ++i) {
                    CmsGroup parent = this.getParent(dbc, directGroups.get(i).getName());
                    while (parent != null && !allGroups.contains(parent)) {
                        if (parent.getOuFqn().startsWith(ouFqn)) {
                            allGroups.add(parent);
                        }
                        parent = this.getParent(dbc, parent.getName());
                    }
                }
            }
            if (readRoles) {
                for (i = 0; i < directGroups.size(); ++i) {
                    CmsGroup group = directGroups.get(i);
                    CmsRole role = CmsRole.valueOf(group);
                    if (!includeChildOus && role.getOuFqn().equals(ouFqn)) {
                        allGroups.add(group);
                    }
                    if (includeChildOus && role.getOuFqn().startsWith(ouFqn)) {
                        allGroups.add(group);
                    }
                    if (directGroupsOnly) continue;
                    for (CmsRole childRole : role.getChildren(true)) {
                        if (!childRole.isSystemRole()) continue;
                        allGroups.add(this.readGroup(dbc, childRole.getGroupName()));
                    }
                    if (!includeChildOus) continue;
                    for (CmsOrganizationalUnit subOu : this.getOrganizationalUnits(dbc, this.readOrganizationalUnit(dbc, group.getOuFqn()), true)) {
                        block18: {
                            try {
                                allGroups.add(this.readGroup(dbc, role.forOrgUnit(subOu.getName()).getGroupName()));
                            }
                            catch (CmsDbEntryNotFoundException e) {
                                if (!LOG.isDebugEnabled()) break block18;
                                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                        for (CmsRole childRole : role.getChildren(true)) {
                            try {
                                allGroups.add(this.readGroup(dbc, childRole.forOrgUnit(subOu.getName()).getGroupName()));
                            }
                            catch (CmsDbEntryNotFoundException e) {
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                            }
                        }
                    }
                }
            }
            groups = Collections.unmodifiableList(new ArrayList(allGroups));
            if (dbc.getProjectId().isNullUUID()) {
                this.m_monitor.cacheUserGroups(cacheKey, groups);
            }
        }
        return groups;
    }

    public I_CmsHistoryDriver getHistoryDriver() {
        return this.m_historyDriver;
    }

    public I_CmsHistoryDriver getHistoryDriver(CmsDbContext dbc) {
        if (dbc == null || dbc.getProjectId() == null || dbc.getProjectId().isNullUUID()) {
            return this.m_historyDriver;
        }
        I_CmsHistoryDriver driver = dbc.getHistoryDriver(dbc.getProjectId());
        return driver != null ? driver : this.m_historyDriver;
    }

    public int getIdleConnections(String dbPoolUrl) throws CmsDbException {
        try {
            Iterator<PoolingDriver> i$ = this.m_connectionPools.iterator();
            if (i$.hasNext()) {
                PoolingDriver d = i$.next();
                ObjectPool p = d.getConnectionPool(dbPoolUrl);
                return p.getNumIdle();
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_ACCESSING_POOL_1", dbPoolUrl);
            throw new CmsDbException(message, (Throwable)exc);
        }
        CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_UNKNOWN_POOL_URL_1", dbPoolUrl);
        throw new CmsDbException(message);
    }

    public CmsLock getLock(CmsDbContext dbc, CmsResource resource) throws CmsException {
        return this.m_lockManager.getLock(dbc, resource);
    }

    public List<String> getLockedResources(CmsDbContext dbc, CmsResource resource, CmsLockFilter filter) throws CmsException {
        ArrayList<String> lockedResources = new ArrayList<String>();
        for (CmsLock lock : this.m_lockManager.getLocks(dbc, resource.getRootPath(), filter)) {
            lockedResources.add(dbc.removeSiteRoot(lock.getResourceName()));
        }
        Collections.sort(lockedResources);
        return lockedResources;
    }

    public List<CmsResource> getLockedResourcesObjects(CmsDbContext dbc, CmsResource resource, CmsLockFilter filter) throws CmsException {
        return this.m_lockManager.getLockedResources(dbc, resource, filter);
    }

    public List<CmsResource> getLockedResourcesObjectsWithCache(CmsDbContext dbc, CmsResource resource, CmsLockFilter filter, Map<String, CmsResource> cache) throws CmsException {
        return this.m_lockManager.getLockedResourcesWithCache(dbc, resource, filter, cache);
    }

    public List<CmsLogEntry> getLogEntries(CmsDbContext dbc, CmsLogFilter filter) throws CmsException {
        this.updateLog(dbc);
        return this.m_projectDriver.readLog(dbc, filter);
    }

    public int getNextPublishTag(CmsDbContext dbc) {
        return this.getHistoryDriver(dbc).readNextPublishTag(dbc);
    }

    public List<CmsOrganizationalUnit> getOrganizationalUnits(CmsDbContext dbc, CmsOrganizationalUnit parent, boolean includeChildren) throws CmsException {
        if (parent == null) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_PARENT_ORGUNIT_NULL_0"));
        }
        return this.getUserDriver(dbc).getOrganizationalUnits(dbc, parent, includeChildren);
    }

    public List<CmsOrganizationalUnit> getOrgUnitsForRole(CmsDbContext dbc, CmsRole role, boolean includeSubOus) throws CmsException {
        String ouFqn = role.getOuFqn();
        if (ouFqn == null) {
            ouFqn = "";
            role = role.forOrgUnit("");
        }
        CmsOrganizationalUnit ou = this.readOrganizationalUnit(dbc, ouFqn);
        ArrayList<CmsOrganizationalUnit> orgUnits = new ArrayList<CmsOrganizationalUnit>();
        if (this.m_securityManager.hasRole(dbc, dbc.currentUser(), role)) {
            orgUnits.add(ou);
        }
        if (includeSubOus) {
            for (CmsOrganizationalUnit orgUnit : this.getOrganizationalUnits(dbc, ou, true)) {
                if (!this.m_securityManager.hasRole(dbc, dbc.currentUser(), role.forOrgUnit(orgUnit.getName()))) continue;
                orgUnits.add(orgUnit);
            }
        }
        return orgUnits;
    }

    public CmsGroup getParent(CmsDbContext dbc, String groupname) throws CmsException {
        CmsGroup group = this.readGroup(dbc, groupname);
        if (group.getParentId().isNullUUID()) {
            return null;
        }
        CmsGroup parent = this.m_monitor.getCachedGroup(group.getParentId().toString());
        if (parent == null) {
            parent = this.getUserDriver(dbc).readGroup(dbc, group.getParentId());
            this.m_monitor.cacheGroup(parent);
        }
        return parent;
    }

    public CmsPermissionSetCustom getPermissions(CmsDbContext dbc, CmsResource resource, CmsUser user) throws CmsException {
        CmsAccessControlList acList = this.getAccessControlList(dbc, resource, false);
        return acList.getPermissions(user, this.getGroupsOfUser(dbc, user.getName(), false), this.getRolesForUser(dbc, user));
    }

    public I_CmsProjectDriver getProjectDriver() {
        return this.m_projectDriver;
    }

    public I_CmsProjectDriver getProjectDriver(CmsDbContext dbc) {
        if (dbc == null || dbc.getProjectId() == null || dbc.getProjectId().isNullUUID()) {
            return this.m_projectDriver;
        }
        I_CmsProjectDriver driver = dbc.getProjectDriver(dbc.getProjectId());
        return driver != null ? driver : this.m_projectDriver;
    }

    public I_CmsProjectDriver getProjectDriver(CmsDbContext dbc, I_CmsProjectDriver defaultDriver) {
        if (dbc == null || dbc.getProjectId() == null || dbc.getProjectId().isNullUUID()) {
            return defaultDriver;
        }
        I_CmsProjectDriver driver = dbc.getProjectDriver(dbc.getProjectId());
        return driver != null ? driver : defaultDriver;
    }

    public CmsUUID getProjectId(CmsDbContext dbc, int id) throws CmsException {
        for (CmsProject project : this.getAllAccessibleProjects(dbc, this.readOrganizationalUnit(dbc, ""), true)) {
            if (project.getUuid().hashCode() != id) continue;
            return project.getUuid();
        }
        return null;
    }

    public CmsParameterConfiguration getPropertyConfiguration() {
        return this.m_propertyConfiguration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CmsPublishList getRelatedResourcesToPublish(CmsDbContext dbc, CmsPublishList publishList, CmsRelationFilter filter) throws CmsException {
        HashMap<String, CmsResource> relations = new HashMap<String, CmsResource>();
        CmsProgressThread thread = null;
        if (Thread.currentThread() instanceof CmsProgressThread) {
            thread = (CmsProgressThread)Thread.currentThread();
        }
        List<CmsResource> publishResources = publishList.getAllResources();
        Iterator<CmsResource> itCheckList = publishResources.iterator();
        int count = 0;
        while (itCheckList.hasNext()) {
            ++count;
            if (thread != null) {
                if (thread.isInterrupted()) {
                    throw new CmsIllegalStateException(org.opencms.workplace.commons.Messages.get().container("ERR_PROGRESS_INTERRUPTED_0"));
                }
                thread.setProgress(count * 20 / publishResources.size());
                thread.setDescription(org.opencms.workplace.commons.Messages.get().getBundle().key("GUI_PROGRESS_PUBLISH_STEP1_2", new Integer(count), new Integer(publishResources.size())));
            }
            CmsResource checkResource = itCheckList.next();
            for (CmsRelation relation : this.getRelationsForResource(dbc, checkResource, filter)) {
                try {
                    CmsResource target;
                    try {
                        target = this.readResource(dbc, relation.getTargetId(), CmsResourceFilter.ALL);
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        String storedSiteRoot = dbc.getRequestContext().getSiteRoot();
                        try {
                            dbc.getRequestContext().setSiteRoot("");
                            target = this.readResource(dbc, relation.getTargetPath(), CmsResourceFilter.ALL);
                        }
                        finally {
                            dbc.getRequestContext().setSiteRoot(storedSiteRoot);
                        }
                    }
                    CmsLock lock = this.getLock(dbc, target);
                    if (publishResources.contains(target) || relations.containsKey(target.getRootPath()) || target.getState().isUnchanged() || !lock.isLockableBy(dbc.currentUser())) continue;
                    relations.put(target.getRootPath(), target);
                    CmsFolder parent = this.getVfsDriver(dbc).readParentFolder(dbc, dbc.currentProject().getUuid(), target.getStructureId());
                    while (parent != null && parent.getState().isNew()) {
                        if (!publishResources.contains(parent) && !relations.containsKey(parent.getRootPath())) {
                            relations.put(parent.getRootPath(), parent);
                        }
                        parent = this.getVfsDriver(dbc).readParentFolder(dbc, dbc.currentProject().getUuid(), parent.getStructureId());
                    }
                }
                catch (CmsVfsResourceNotFoundException e) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        CmsPublishList ret = new CmsPublishList(publishList.getDirectPublishResources(), false, false);
        ret.addAll(relations.values(), false);
        ret.initialize();
        return ret;
    }

    public List<CmsRelation> getRelationsForResource(CmsDbContext dbc, CmsResource resource, CmsRelationFilter filter) throws CmsException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        return this.getVfsDriver(dbc).readRelations(dbc, projectId, resource, filter);
    }

    public List<CmsOrganizationalUnit> getResourceOrgUnits(CmsDbContext dbc, CmsResource resource) throws CmsException {
        List<CmsOrganizationalUnit> result = this.getVfsDriver(dbc).getResourceOus(dbc, dbc.currentProject().getUuid(), resource);
        return result;
    }

    public List<CmsResource> getResourcesForOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit) throws CmsException {
        return this.getUserDriver(dbc).getResourcesForOrganizationalUnit(dbc, orgUnit);
    }

    public Set<CmsResource> getResourcesForPrincipal(CmsDbContext dbc, CmsProject project, CmsUUID principalId, CmsPermissionSet permissions, boolean includeAttr) throws CmsException {
        HashSet<CmsResource> resources = new HashSet<CmsResource>(this.getVfsDriver(dbc).readResourcesForPrincipalACE(dbc, project, principalId));
        if (permissions != null) {
            Iterator itRes = resources.iterator();
            while (itRes.hasNext()) {
                CmsAccessControlEntry ace = this.readAccessControlEntry(dbc, (CmsResource)itRes.next(), principalId);
                if ((ace.getPermissions().getPermissions() & permissions.getPermissions()) == permissions.getPermissions()) continue;
                itRes.remove();
            }
        }
        if (includeAttr) {
            resources.addAll(this.getVfsDriver(dbc).readResourcesForPrincipalAttr(dbc, project, principalId));
        }
        return resources;
    }

    public List<CmsRewriteAlias> getRewriteAliases(CmsDbContext dbc, CmsRewriteAliasFilter filter) throws CmsException {
        return this.getVfsDriver(dbc).readRewriteAliases(dbc, filter);
    }

    public Set<CmsGroup> getRoleGroups(CmsDbContext dbc, String roleGroupName, boolean directUsersOnly) throws CmsException {
        return this.getRoleGroupsImpl(dbc, roleGroupName, directUsersOnly, new HashMap<String, Set<CmsGroup>>());
    }

    public Set<CmsGroup> getRoleGroupsImpl(CmsDbContext dbc, String roleGroupName, boolean directUsersOnly, Map<String, Set<CmsGroup>> accumulator) throws CmsException {
        HashSet<CmsGroup> result = new HashSet<CmsGroup>();
        if (accumulator.get(roleGroupName) != null) {
            return accumulator.get(roleGroupName);
        }
        CmsGroup group = this.readGroup(dbc, roleGroupName);
        if (group == null || !group.isRole()) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", roleGroupName));
        }
        result.add(group);
        if (!directUsersOnly) {
            String parentOu;
            block7: {
                CmsRole role = CmsRole.valueOf(group);
                if (role.getParentRole() != null) {
                    try {
                        String parentGroup = role.getParentRole().getGroupName();
                        result.addAll(this.getRoleGroupsImpl(dbc, parentGroup, directUsersOnly, accumulator));
                    }
                    catch (CmsDbEntryNotFoundException e) {
                        if (!LOG.isDebugEnabled()) break block7;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if ((parentOu = CmsOrganizationalUnit.getParentFqn(group.getOuFqn())) != null) {
                result.addAll(this.getRoleGroupsImpl(dbc, parentOu + group.getSimpleName(), directUsersOnly, accumulator));
            }
        }
        accumulator.put(roleGroupName, result);
        return result;
    }

    public List<CmsRole> getRolesForResource(CmsDbContext dbc, CmsUser user, CmsResource resource) throws CmsException {
        if (user.isGuestUser()) {
            return Collections.emptyList();
        }
        String key = user.getId().toString() + resource.getRootPath();
        List<CmsRole> result = this.m_monitor.getCachedRoleList(key);
        if (result != null) {
            return result;
        }
        result = new ArrayList<CmsRole>();
        for (CmsOrganizationalUnit ou : this.getResourceOrgUnits(dbc, resource)) {
            ArrayList<CmsGroup> groups = new ArrayList<CmsGroup>(this.getGroupsOfUser(dbc, user.getName(), ou.getName(), false, true, false, dbc.getRequestContext().getRemoteAddress()));
            for (CmsGroup group : groups) {
                CmsRole givenRole = CmsRole.valueOf(group).forOrgUnit(null);
                if (givenRole.isOrganizationalUnitIndependent() || result.contains(givenRole)) continue;
                result.add(givenRole);
            }
        }
        result = Collections.unmodifiableList(result);
        this.m_monitor.cacheRoleList(key, result);
        return result;
    }

    public List<CmsRole> getRolesForUser(CmsDbContext dbc, CmsUser user) throws CmsException {
        if (user.isGuestUser()) {
            return Collections.emptyList();
        }
        String key = user.getId().toString();
        List<CmsRole> result = this.m_monitor.getCachedRoleList(key);
        if (result != null) {
            return result;
        }
        result = new ArrayList<CmsRole>();
        ArrayList<CmsGroup> groups = new ArrayList<CmsGroup>(this.getGroupsOfUser(dbc, user.getName(), "", true, true, false, dbc.getRequestContext().getRemoteAddress()));
        for (CmsGroup group : groups) {
            CmsRole givenRole = CmsRole.valueOf(group);
            if (result.contains(givenRole = givenRole.forOrgUnit(null))) continue;
            result.add(givenRole);
        }
        result = Collections.unmodifiableList(result);
        this.m_monitor.cacheRoleList(key, result);
        return result;
    }

    public CmsSecurityManager getSecurityManager() {
        return this.m_securityManager;
    }

    public CmsSqlManager getSqlManager() {
        return this.m_sqlManager;
    }

    public I_CmsSubscriptionDriver getSubscriptionDriver() {
        return this.m_subscriptionDriver;
    }

    public I_CmsUserDriver getUserDriver() {
        return this.m_userDriver;
    }

    public I_CmsUserDriver getUserDriver(CmsDbContext dbc) {
        if (dbc == null || dbc.getProjectId() == null || dbc.getProjectId().isNullUUID()) {
            return this.m_userDriver;
        }
        I_CmsUserDriver driver = dbc.getUserDriver(dbc.getProjectId());
        return driver != null ? driver : this.m_userDriver;
    }

    public I_CmsUserDriver getUserDriver(CmsDbContext dbc, I_CmsUserDriver defaultDriver) {
        if (dbc == null || dbc.getProjectId() == null || dbc.getProjectId().isNullUUID()) {
            return defaultDriver;
        }
        I_CmsUserDriver driver = dbc.getUserDriver(dbc.getProjectId());
        return driver != null ? driver : defaultDriver;
    }

    public List<CmsUser> getUsers(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean recursive) throws CmsException {
        return this.getUserDriver(dbc).getUsers(dbc, orgUnit, recursive);
    }

    public List<CmsUser> getUsersOfGroup(CmsDbContext dbc, String groupname, boolean includeOtherOuUsers, boolean directUsersOnly, boolean readRoles) throws CmsException {
        return this.internalUsersOfGroup(dbc, CmsOrganizationalUnit.getParentFqn(groupname), groupname, includeOtherOuUsers, directUsersOnly, readRoles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<CmsResource> getUsersPubList(CmsDbContext dbc, CmsUUID userId) throws CmsDataAccessException {
        Object object = this.m_publishListUpdateLock;
        synchronized (object) {
            this.updateLog(dbc);
            return this.m_projectDriver.getUsersPubList(dbc, userId);
        }
    }

    public List<CmsUser> getUsersWithoutAdditionalInfo(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, boolean recursive) throws CmsException {
        return this.getUserDriver(dbc).getUsersWithoutAdditionalInfo(dbc, orgUnit, recursive);
    }

    public I_CmsVfsDriver getVfsDriver() {
        return this.m_vfsDriver;
    }

    public I_CmsVfsDriver getVfsDriver(CmsDbContext dbc) {
        if (dbc == null || dbc.getProjectId() == null || dbc.getProjectId().isNullUUID()) {
            return this.m_vfsDriver;
        }
        I_CmsVfsDriver driver = dbc.getVfsDriver(dbc.getProjectId());
        return driver != null ? driver : this.m_vfsDriver;
    }

    public void importAccessControlEntries(CmsDbContext dbc, CmsResource resource, List<CmsAccessControlEntry> acEntries) throws CmsException {
        I_CmsUserDriver userDriver = this.getUserDriver(dbc);
        userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId());
        Iterator<CmsAccessControlEntry> i = acEntries.iterator();
        while (i.hasNext()) {
            userDriver.writeAccessControlEntry(dbc, dbc.currentProject(), i.next());
        }
        this.m_monitor.clearAccessControlListCache();
    }

    public CmsAliasImportResult importRewriteAlias(CmsDbContext dbc, String siteRoot, String source, String target, CmsAliasMode mode) throws CmsException {
        I_CmsVfsDriver vfs = this.getVfsDriver(dbc);
        List<CmsRewriteAlias> existingAliases = vfs.readRewriteAliases(dbc, new CmsRewriteAliasFilter().setSiteRoot(siteRoot));
        CmsUUID idToDelete = null;
        for (CmsRewriteAlias alias : existingAliases) {
            if (!alias.getPatternString().equals(source)) continue;
            idToDelete = alias.getId();
        }
        if (idToDelete != null) {
            vfs.deleteRewriteAliases(dbc, new CmsRewriteAliasFilter().setId(idToDelete));
        }
        CmsRewriteAlias alias = new CmsRewriteAlias(new CmsUUID(), siteRoot, source, target, mode);
        ArrayList<CmsRewriteAlias> aliases = new ArrayList<CmsRewriteAlias>();
        aliases.add(alias);
        this.getVfsDriver(dbc).insertRewriteAliases(dbc, aliases);
        CmsAliasImportResult result = new CmsAliasImportResult(CmsAliasImportStatus.aliasNew, "OK", source, target, mode);
        return result;
    }

    public CmsUser importUser(CmsDbContext dbc, String id, String name, String password, String firstname, String lastname, String email, int flags, long dateCreated, Map<String, Object> additionalInfos) throws CmsException {
        name = name.trim();
        String userName = CmsOrganizationalUnit.getSimpleName(name);
        OpenCms.getValidationHandler().checkUserName(userName);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(userName)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_USER_1", userName));
        }
        CmsOrganizationalUnit ou = this.readOrganizationalUnit(dbc, CmsOrganizationalUnit.getParentFqn(name));
        if (ou.hasFlagWebuser() && (flags & 0x8000) == 0) {
            flags += 32768;
        }
        CmsUser newUser = this.getUserDriver(dbc).createUser(dbc, new CmsUUID(id), name, password, firstname, lastname, email, 0L, flags, dateCreated, additionalInfos);
        return newUser;
    }

    public int incrementCounter(CmsDbContext dbc, String name) throws CmsException {
        return this.getVfsDriver(dbc).incrementCounter(dbc, name);
    }

    public void init(CmsConfigurationManager configurationManager, I_CmsDbContextFactory dbContextFactory) throws CmsException, Exception {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_MANAGER_START_PHASE4_0"));
        }
        this.m_monitor = OpenCms.getMemoryMonitor();
        CmsSystemConfiguration systemConfiguation = (CmsSystemConfiguration)configurationManager.getConfiguration(CmsSystemConfiguration.class);
        CmsCacheSettings settings = systemConfiguation.getCacheSettings();
        this.m_keyGenerator = (I_CmsCacheKey)Class.forName(settings.getCacheKeyGenerator()).newInstance();
        this.m_htmlLinkValidator = new CmsRelationSystemValidator(this);
        CmsDbContext dbc1 = dbContextFactory.getDbContext();
        this.getUserDriver().fillDefaults(dbc1);
        this.getProjectDriver().fillDefaults(dbc1);
        this.m_publishEngine.setDriverManager(this);
        CmsDbContext dbc2 = dbContextFactory.getDbContext(new CmsRequestContext(this.readUser(dbc1, OpenCms.getDefaultUsers().getUserAdmin()), this.readProject(dbc1, CmsProject.ONLINE_PROJECT_ID), null, "", null, null, null, 0L, null, null, ""));
        dbc1.clear();
        this.getUserDriver().createRootOrganizationalUnit(dbc2);
        dbc2.clear();
    }

    public boolean isInsideCurrentProject(CmsDbContext dbc, String resourcename) {
        List<String> projectResources = null;
        try {
            projectResources = this.readProjectResources(dbc, dbc.currentProject());
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_CHECK_RESOURCE_INSIDE_CURRENT_PROJECT_2", resourcename, dbc.currentProject().getName()), (Throwable)e);
            }
            return false;
        }
        return CmsProject.isInsideProject(projectResources, resourcename);
    }

    public boolean isSubscriptionDriverAvailable() {
        return this.m_subscriptionDriver != null;
    }

    public boolean isTempfileProject(CmsProject project) {
        return project.getName().equals("tempFileProject");
    }

    public boolean labelResource(CmsDbContext dbc, CmsResource resource, String newResource, int action) throws CmsDataAccessException {
        List<String> labeledSites = OpenCms.getWorkplaceManager().getLabelSiteFolders();
        if (labeledSites.size() == 0) {
            return false;
        }
        if (action == 1) {
            if (!resource.isLabeled()) {
                boolean linkInside = false;
                boolean sourceInside = false;
                for (int i = 0; i < labeledSites.size(); ++i) {
                    String curSite = labeledSites.get(i);
                    if (newResource.startsWith(curSite)) {
                        linkInside = true;
                    }
                    if (resource.getRootPath().startsWith(curSite)) {
                        sourceInside = true;
                    }
                    if (linkInside && sourceInside) break;
                }
                return linkInside != sourceInside;
            }
            return false;
        }
        boolean isInside = false;
        boolean isOutside = false;
        List<CmsResource> siblings = this.getVfsDriver(dbc).readSiblings(dbc, dbc.currentProject().getUuid(), resource, false);
        this.updateContextDates(dbc, siblings);
        Iterator<CmsResource> i = siblings.iterator();
        while (!(!i.hasNext() || isInside && isOutside)) {
            CmsResource currentResource = i.next();
            if (currentResource.equals(resource)) continue;
            String curPath = currentResource.getRootPath();
            boolean curInside = false;
            for (int k = 0; k < labeledSites.size(); ++k) {
                if (!curPath.startsWith(labeledSites.get(k))) continue;
                isInside = true;
                curInside = true;
                break;
            }
            if (curInside) continue;
            isOutside = true;
        }
        if (newResource != null) {
            boolean curInside = false;
            for (int k = 0; k < labeledSites.size(); ++k) {
                if (!newResource.startsWith(labeledSites.get(k))) continue;
                isInside = true;
                curInside = true;
                break;
            }
            if (!curInside) {
                isOutside = true;
            }
        }
        return isInside && isOutside;
    }

    public CmsUser lockedBy(CmsDbContext dbc, CmsResource resource) throws CmsException {
        return this.readUser(dbc, this.m_lockManager.getLock(dbc, resource).getEditionLock().getUserId());
    }

    public void lockResource(CmsDbContext dbc, CmsResource resource, CmsLockType type) throws CmsException {
        this.m_monitor.clearResourceCache();
        CmsProject project = dbc.currentProject();
        this.m_lockManager.addResource(dbc, resource, dbc.currentUser(), project, type);
        boolean changedProjectLastModified = false;
        if (!resource.getState().isUnchanged() && !resource.getState().isKeep()) {
            this.getVfsDriver(dbc).writeLastModifiedProjectId(dbc, project, project.getUuid(), resource);
            changedProjectLastModified = true;
        }
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PERMISSION);
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(changedProjectLastModified ? 32 : 0));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void log(CmsDbContext dbc, CmsLogEntry logEntry, boolean force) {
        if (dbc == null) {
            return;
        }
        if (!logEntry.getType().isActive()) {
            return;
        }
        if (!force) {
            boolean abort = dbc.getAttribute("ATTR_LOG_ENTRY") != null;
            if (abort |= dbc.getRequestContext().getAttribute("ATTR_LOG_ENTRY") != null) {
                return;
            }
        }
        dbc.setAttribute("ATTR_LOG_ENTRY", Boolean.TRUE);
        this.m_log.add(logEntry);
    }

    public CmsUser loginUser(CmsDbContext dbc, String userName, String password, String remoteAddress) throws CmsAuthentificationException, CmsDataAccessException, CmsPasswordEncryptionException {
        CmsUser newUser;
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(password)) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_USER_1", userName));
        }
        try {
            newUser = this.getUserDriver(dbc).readUser(dbc, userName, password, remoteAddress);
        }
        catch (CmsDbEntryNotFoundException e) {
            String parentOu;
            CmsUser user = null;
            try {
                user = this.readUser(dbc, userName);
            }
            catch (CmsDataAccessException e2) {
                // empty catch block
            }
            if (user != null) {
                if (dbc.currentUser().isGuestUser()) {
                    OpenCms.getLoginManager().addInvalidLogin(userName, remoteAddress);
                }
                OpenCms.getLoginManager().checkInvalidLogins(userName, remoteAddress);
                throw new CmsAuthentificationException(org.opencms.security.Messages.get().container("ERR_LOGIN_FAILED_2", userName, remoteAddress), (Throwable)e);
            }
            String userOu = CmsOrganizationalUnit.getParentFqn(userName);
            if (userOu != null && (parentOu = CmsOrganizationalUnit.getParentFqn(userOu)) != null) {
                String uName = CmsOrganizationalUnit.getSimpleName(userName);
                return this.loginUser(dbc, parentOu + uName, password, remoteAddress);
            }
            throw new CmsAuthentificationException(org.opencms.security.Messages.get().container("ERR_LOGIN_FAILED_NO_USER_2", userName, remoteAddress), (Throwable)e);
        }
        if (!newUser.isEnabled()) {
            throw new CmsAuthentificationException(org.opencms.security.Messages.get().container("ERR_LOGIN_FAILED_DISABLED_2", userName, remoteAddress));
        }
        if (dbc.currentUser().isGuestUser()) {
            OpenCms.getLoginManager().checkInvalidLogins(userName, remoteAddress);
            OpenCms.getLoginManager().removeInvalidLogins(userName, remoteAddress);
        }
        if (!this.m_securityManager.hasRole(dbc, newUser, CmsRole.ADMINISTRATOR.forOrgUnit(dbc.getRequestContext().getOuFqn()))) {
            OpenCms.getLoginManager().checkLoginAllowed();
        }
        this.m_monitor.clearUserCache(newUser);
        newUser.setLastlogin(System.currentTimeMillis());
        dbc.setAttribute(ATTRIBUTE_LOGIN, newUser.getName());
        Map<String, Object> additionalInfosForRepositories = OpenCms.getRepositoryManager().getAdditionalInfoForLogin(newUser.getName(), password);
        newUser.getAdditionalInfo().putAll(additionalInfosForRepositories);
        this.getUserDriver(dbc).writeUser(dbc, newUser);
        this.m_monitor.cacheUser(newUser);
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.ACL, CmsMemoryMonitor.CacheType.GROUP, CmsMemoryMonitor.CacheType.ORG_UNIT, CmsMemoryMonitor.CacheType.USERGROUPS, CmsMemoryMonitor.CacheType.USER_LIST, CmsMemoryMonitor.CacheType.PERMISSION, CmsMemoryMonitor.CacheType.RESOURCE_LIST);
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("userId", newUser.getId().toString());
        eventData.put("userName", newUser.getName());
        eventData.put("userAction", "writeUser");
        OpenCms.fireCmsEvent(new CmsEvent(29, eventData));
        return newUser;
    }

    public I_CmsPrincipal lookupPrincipal(CmsDbContext dbc, CmsUUID principalId) {
        try {
            CmsGroup group = this.getUserDriver(dbc).readGroup(dbc, principalId);
            if (group != null) {
                return group;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            CmsUser user = this.readUser(dbc, principalId);
            if (user != null) {
                return user;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public I_CmsPrincipal lookupPrincipal(CmsDbContext dbc, String principalName) {
        try {
            CmsGroup group = this.getUserDriver(dbc).readGroup(dbc, principalName);
            if (group != null) {
                return group;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            CmsUser user = this.readUser(dbc, principalName);
            if (user != null) {
                return user;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void markResourceAsVisitedBy(CmsDbContext dbc, String poolName, CmsResource resource, CmsUser user) throws CmsException {
        this.getSubscriptionDriver().markResourceAsVisitedBy(dbc, poolName, resource, user);
    }

    public void moveResource(CmsDbContext dbc, CmsResource source, String destination, boolean internal) throws CmsException {
        ArrayList<CmsResource> resources;
        CmsResource destRes;
        CmsFolder destinationFolder;
        block7: {
            destinationFolder = this.readFolder(dbc, CmsResource.getParentFolder(destination), CmsResourceFilter.ALL);
            this.m_securityManager.checkPermissions(dbc, (CmsResource)destinationFolder, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
            if (source.isFolder()) {
                this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.HAS_ROLE, CmsMemoryMonitor.CacheType.ROLE_LIST);
            }
            this.getVfsDriver(dbc).moveResource(dbc, dbc.getRequestContext().getCurrentProject().getUuid(), source, destination);
            if (!internal) {
                CmsResourceState newState = CmsResource.STATE_CHANGED;
                if (source.getState().isNew()) {
                    newState = CmsResource.STATE_NEW;
                } else if (source.getState().isDeleted()) {
                    newState = CmsResource.STATE_DELETED;
                }
                source.setState(newState);
                this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), source, 2, false);
                this.log(dbc, new CmsLogEntry(dbc, source.getStructureId(), CmsLogEntryType.RESOURCE_MOVED, new String[]{source.getRootPath(), destination}), false);
            }
            destRes = this.readResource(dbc, destination, CmsResourceFilter.ALL);
            this.m_lockManager.moveResource(source.getRootPath(), destRes.getRootPath());
            this.m_monitor.clearAccessControlListCache();
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST, CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
            resources = new ArrayList<CmsResource>(4);
            resources.add(source);
            try {
                resources.add(this.readFolder(dbc, CmsResource.getParentFolder(source.getRootPath()), CmsResourceFilter.ALL));
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug((Object)e);
            }
        }
        resources.add(destRes);
        resources.add(destinationFolder);
        OpenCms.fireCmsEvent(new CmsEvent(22, Collections.singletonMap("resources", resources)));
    }

    public String moveToLostAndFound(CmsDbContext dbc, CmsResource resource, boolean returnNameOnly) throws CmsException, CmsIllegalArgumentException {
        String resourcename = dbc.removeSiteRoot(resource.getRootPath());
        String siteRoot = dbc.getRequestContext().getSiteRoot();
        dbc.getRequestContext().setSiteRoot("");
        String destination = LOST_AND_FOUND_FOLDER + resourcename;
        try {
            String folderPath = CmsResource.getParentFolder(destination);
            folderPath = folderPath.substring(1, folderPath.length() - 1);
            Iterator<String> folders = CmsStringUtil.splitAsList(folderPath, '/').iterator();
            folderPath = "/";
            while (folders.hasNext()) {
                folderPath = folderPath + folders.next().toString() + "/";
                try {
                    this.readFolder(dbc, folderPath, CmsResourceFilter.IGNORE_EXPIRATION);
                }
                catch (Exception e1) {
                    if (returnNameOnly) break;
                    this.createResource(dbc, folderPath, 0, null, new ArrayList<CmsProperty>());
                }
            }
            String des = destination;
            int postfix = 1;
            boolean found = true;
            while (found) {
                try {
                    found = true;
                    this.readResource(dbc, des, CmsResourceFilter.ALL);
                    String path = destination.substring(0, destination.lastIndexOf(47) + 1);
                    String filename = destination.substring(destination.lastIndexOf(47) + 1, destination.length());
                    des = path;
                    des = filename.lastIndexOf(46) > 0 ? des + filename.substring(0, filename.lastIndexOf(46)) : des + filename;
                    des = des + "_" + postfix;
                    if (filename.lastIndexOf(46) > 0) {
                        des = des + filename.substring(filename.lastIndexOf(46), filename.length());
                    }
                    ++postfix;
                }
                catch (CmsException e3) {
                    found = false;
                }
            }
            destination = des;
            if (!returnNameOnly) {
                this.copyResource(dbc, resource, destination, CmsResource.COPY_AS_SIBLING);
                this.deleteResource(dbc, resource, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
        }
        catch (CmsException e2) {
            throw e2;
        }
        finally {
            dbc.getRequestContext().setSiteRoot(siteRoot);
        }
        return destination;
    }

    public Object newDriverInstance(CmsDbContext dbc, CmsConfigurationManager configurationManager, String driverName, List<String> successiveDrivers) throws CmsInitException {
        Class<?> driverClass = null;
        I_CmsDriver driver = null;
        try {
            driverClass = Class.forName(driverName);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_START_1", driverName));
            }
            driver = (I_CmsDriver)driverClass.newInstance();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_INITIALIZING_1", driverName));
            }
            driver.init(dbc, configurationManager, successiveDrivers, this);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_INIT_FINISHED_0"));
            }
        }
        catch (Throwable t) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_ERROR_INITIALIZING_DRIVER_1", driverName);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key(), t);
            }
            throw new CmsInitException(message, t);
        }
        return driver;
    }

    public Object newDriverInstance(CmsParameterConfiguration configuration, String driverName, String driverPoolUrl) throws CmsException {
        Class[] initParamClasses = new Class[]{CmsParameterConfiguration.class, String.class, CmsDriverManager.class};
        Object[] initParams = new Object[]{configuration, driverPoolUrl, this};
        Class<?> driverClass = null;
        Object driver = null;
        try {
            driverClass = Class.forName(driverName);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_START_1", driverName));
            }
            driver = driverClass.newInstance();
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_INITIALIZING_1", driverName));
            }
            driver.getClass().getMethod("init", initParamClasses).invoke(driver, initParams);
            if (CmsLog.INIT.isInfoEnabled()) {
                CmsLog.INIT.info((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_INIT_FINISHED_1", driverPoolUrl));
            }
        }
        catch (Exception exc) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_INIT_DRIVER_MANAGER_1");
            if (LOG.isFatalEnabled()) {
                LOG.fatal((Object)message.key(), (Throwable)exc);
            }
            throw new CmsDbException(message, (Throwable)exc);
        }
        return driver;
    }

    public void newPoolInstance(CmsParameterConfiguration configuration, String poolName) throws CmsInitException {
        PoolingDriver driver;
        try {
            driver = CmsDbPool.createDriverManagerConnectionPool(configuration, poolName);
        }
        catch (Exception e) {
            CmsMessageContainer message = org.opencms.db.Messages.get().container("ERR_INIT_CONN_POOL_1", poolName);
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)message.key(), (Throwable)e);
            }
            throw new CmsInitException(message, (Throwable)e);
        }
        this.m_connectionPools.add(driver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publishJob(CmsObject cms, CmsDbContext dbc, CmsPublishList publishList, I_CmsReport report) throws CmsException {
        block12: {
            try {
                boolean temporaryProject;
                ArrayList<CmsResource> allResources = new ArrayList<CmsResource>(publishList.getFolderList());
                allResources.addAll(publishList.getDeletedFolderList());
                allResources.addAll(publishList.getFileList());
                for (CmsResource resource : allResources) {
                    try {
                        resource = this.readResource(dbc, resource.getStructureId(), CmsResourceFilter.ALL);
                    }
                    catch (CmsVfsResourceNotFoundException e) {
                        continue;
                    }
                    if (resource.getState().isUnchanged()) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)org.opencms.db.Messages.get().getBundle().key("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
                        }
                        publishList.remove(resource);
                        this.unlockResource(dbc, resource, true, true);
                        continue;
                    }
                    CmsLock lock = this.m_lockManager.getLock(dbc, resource, false);
                    if (lock.getSystemLock().isPublish()) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)org.opencms.db.Messages.get().getBundle().key("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
                    }
                    publishList.remove(resource);
                }
                CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
                this.m_monitor.clearCache();
                int publishTag = this.getNextPublishTag(dbc);
                this.getProjectDriver(dbc).publishProject(dbc, report, onlineProject, publishList, publishTag);
                Iterator<String> i = OpenCms.getModuleManager().getModuleNames().iterator();
                while (i.hasNext()) {
                    CmsModule module = OpenCms.getModuleManager().getModule(i.next());
                    if (module == null || module.getActionInstance() == null) continue;
                    module.getActionInstance().publishProject(cms, publishList, publishTag, report);
                }
                boolean bl = temporaryProject = cms.getRequestContext().getCurrentProject().getType() == CmsProject.PROJECT_TYPE_TEMPORARY;
                if (!temporaryProject || publishList.isDirectPublish()) break block12;
                try {
                    this.getProjectDriver(dbc).deleteProject(dbc, dbc.currentProject());
                }
                catch (CmsException e) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_DELETE_TEMP_PROJECT_FAILED_1", cms.getRequestContext().getCurrentProject().getName()));
                }
                cms.getRequestContext().setCurrentProject(onlineProject);
            }
            finally {
                this.m_monitor.clearCache();
            }
        }
    }

    public synchronized void publishProject(CmsObject cms, CmsDbContext dbc, CmsPublishList publishList, I_CmsReport report) throws CmsException {
        block16: {
            this.checkParentFolders(dbc, publishList);
            this.ensureSubResourcesOfMovedFoldersPublished(cms, dbc, publishList);
            try {
                HashMap<String, Object> eventData = new HashMap<String, Object>();
                eventData.put("report", report);
                eventData.put("publishList", publishList);
                eventData.put("projectId", dbc.currentProject().getUuid());
                eventData.put("dbContext", dbc);
                CmsEvent beforePublishEvent = new CmsEvent(3, eventData);
                OpenCms.fireCmsEvent(beforePublishEvent);
            }
            catch (Throwable t) {
                if (report != null) {
                    report.addError(t);
                    report.println(t);
                }
                if (!LOG.isErrorEnabled()) break block16;
                LOG.error((Object)t.getLocalizedMessage(), t);
            }
        }
        for (CmsResource resource : new ArrayList<CmsResource>(publishList.getAllResources())) {
            CmsLock lock = this.m_lockManager.getLock(dbc, resource, false);
            if (lock.getSystemLock().isUnlocked() && lock.isLockableBy(dbc.currentUser())) {
                if (this.getLock(dbc, resource).getEditionLock().isNullLock()) {
                    this.lockResource(dbc, resource, CmsLockType.PUBLISH);
                } else {
                    this.changeLock(dbc, resource, CmsLockType.PUBLISH);
                }
            } else {
                if (lock.getSystemLock().isPublish()) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
                    }
                    publishList.remove(resource);
                    continue;
                }
                this.changeLock(dbc, resource, CmsLockType.PUBLISH);
            }
            if ((lock = this.m_lockManager.getLock(dbc, resource, false)).getSystemLock().isPublish()) continue;
            if (report != null) {
                report.println(org.opencms.db.Messages.get().container("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())), 1);
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("RPT_PUBLISH_REMOVED_RESOURCE_1", dbc.removeSiteRoot(resource.getRootPath())));
            }
            publishList.remove(resource);
        }
        CmsException enqueueException = null;
        try {
            this.m_publishEngine.enqueuePublishJob(cms, publishList, report);
        }
        catch (CmsException exc) {
            enqueueException = exc;
        }
        if (enqueueException != null) {
            for (CmsResource resource : publishList.getAllResources()) {
                CmsLock lock = this.m_lockManager.getLock(dbc, resource, false);
                if (!lock.getSystemLock().isPublish() || !lock.getSystemLock().isOwnedInProjectBy(cms.getRequestContext().getCurrentUser(), cms.getRequestContext().getCurrentProject())) continue;
                this.unlockResource(dbc, resource, true, true);
            }
            throw enqueueException;
        }
    }

    public void publishUrlNameMapping(CmsDbContext dbc, CmsResource res) throws CmsDataAccessException {
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        if (res.getState().isDeleted()) {
            CmsUrlNameMappingFilter idFilter = CmsUrlNameMappingFilter.ALL.filterStructureId(res.getStructureId());
            vfsDriver.deleteUrlNameMappingEntries(dbc, true, idFilter);
            vfsDriver.deleteUrlNameMappingEntries(dbc, false, idFilter);
        } else {
            List<CmsUrlNameMappingEntry> entries = vfsDriver.readUrlNameMappingEntries(dbc, false, CmsUrlNameMappingFilter.ALL.filterStructureId(res.getStructureId()).filterState(0));
            if (!entries.isEmpty()) {
                long now = System.currentTimeMillis();
                for (CmsUrlNameMappingEntry entry : entries) {
                    CmsUrlNameMappingFilter nameFilter = CmsUrlNameMappingFilter.ALL.filterName(entry.getName());
                    vfsDriver.deleteUrlNameMappingEntries(dbc, true, nameFilter);
                    vfsDriver.deleteUrlNameMappingEntries(dbc, false, nameFilter);
                    CmsUrlNameMappingEntry newEntry = new CmsUrlNameMappingEntry(entry.getName(), entry.getStructureId(), 1, now, entry.getLocale());
                    vfsDriver.addUrlNameMappingEntry(dbc, true, newEntry);
                    vfsDriver.addUrlNameMappingEntry(dbc, false, newEntry);
                }
            }
        }
    }

    public CmsAccessControlEntry readAccessControlEntry(CmsDbContext dbc, CmsResource resource, CmsUUID principal) throws CmsException {
        return this.getUserDriver(dbc).readAccessControlEntry(dbc, dbc.currentProject(), resource.getResourceId(), principal);
    }

    public CmsAlias readAliasByPath(CmsDbContext dbc, CmsProject project, String siteRoot, String path) throws CmsException {
        List<CmsAlias> aliases = this.getVfsDriver(dbc).readAliases(dbc, project, new CmsAliasFilter(siteRoot, path, null));
        if (aliases.isEmpty()) {
            return null;
        }
        return aliases.get(0);
    }

    public List<CmsAlias> readAliasesBySite(CmsDbContext dbc, CmsProject currentProject, String siteRoot) throws CmsException {
        return this.getVfsDriver(dbc).readAliases(dbc, currentProject, new CmsAliasFilter(siteRoot, null, null));
    }

    public List<CmsAlias> readAliasesByStructureId(CmsDbContext dbc, CmsProject project, CmsUUID structureId) throws CmsException {
        return this.getVfsDriver(dbc).readAliases(dbc, project, new CmsAliasFilter(null, null, structureId));
    }

    public List<I_CmsHistoryResource> readAllAvailableVersions(CmsDbContext dbc, CmsResource resource) throws CmsException {
        List<I_CmsHistoryResource> versions = this.getHistoryDriver(dbc).readAllAvailableVersions(dbc, resource.getStructureId());
        if (versions.size() > OpenCms.getSystemInfo().getHistoryVersions() && OpenCms.getSystemInfo().getHistoryVersions() > -1) {
            return versions.subList(0, OpenCms.getSystemInfo().getHistoryVersions());
        }
        return versions;
    }

    public List<CmsPropertyDefinition> readAllPropertyDefinitions(CmsDbContext dbc) throws CmsException {
        List<CmsPropertyDefinition> result = this.getVfsDriver(dbc).readPropertyDefinitions(dbc, dbc.currentProject().getUuid());
        Collections.sort(result);
        return result;
    }

    public List<CmsResource> readAllSubscribedResources(CmsDbContext dbc, String poolName, CmsPrincipal principal) throws CmsException {
        List<CmsResource> result = this.getSubscriptionDriver().readAllSubscribedResources(dbc, poolName, principal);
        result = this.filterPermissions(dbc, result, CmsResourceFilter.DEFAULT);
        return result;
    }

    public String readBestUrlName(CmsDbContext dbc, CmsUUID id, Locale locale, List<Locale> defaultLocales) throws CmsDataAccessException {
        List<CmsUrlNameMappingEntry> entries = this.getVfsDriver(dbc).readUrlNameMappingEntries(dbc, dbc.currentProject().isOnlineProject(), CmsUrlNameMappingFilter.ALL.filterStructureId(id));
        if (entries.isEmpty()) {
            return null;
        }
        ArrayListMultimap entriesByLocale = ArrayListMultimap.create();
        for (CmsUrlNameMappingEntry entry : entries) {
            entriesByLocale.put((Object)entry.getLocale(), (Object)entry);
        }
        ArrayList<CmsUrlNameMappingEntry> lastEntries = new ArrayList<CmsUrlNameMappingEntry>();
        UrlNameMappingComparator dateChangedComparator = new UrlNameMappingComparator();
        for (String localeKey : entriesByLocale.keySet()) {
            CmsUrlNameMappingEntry latestEntryForLocale = Collections.max(entriesByLocale.get((Object)localeKey), dateChangedComparator);
            lastEntries.add(latestEntryForLocale);
        }
        CmsLocaleManager localeManager = OpenCms.getLocaleManager();
        ArrayList<Locale> availableLocales = new ArrayList<Locale>();
        for (CmsUrlNameMappingEntry entry : lastEntries) {
            availableLocales.add(CmsLocaleManager.getLocale(entry.getLocale()));
        }
        Locale bestLocale = localeManager.getBestMatchingLocale(locale, defaultLocales, availableLocales);
        String bestLocaleStr = bestLocale.getLanguage();
        for (CmsUrlNameMappingEntry entry : lastEntries) {
            if (!entry.getLocale().equals(bestLocaleStr)) continue;
            return entry.getName();
        }
        return null;
    }

    public List<CmsResource> readChildResources(CmsDbContext dbc, CmsResource resource, CmsResourceFilter filter, boolean getFolders, boolean getFiles, boolean checkPermissions) throws CmsException {
        String cacheKey = null;
        List<CmsResource> resourceList = null;
        if (this.m_monitor.isEnabled(CmsMemoryMonitor.CacheType.RESOURCE_LIST)) {
            String time = "";
            if (checkPermissions && dbc.getRequestContext() != null && OpenCms.getSiteManager().getSiteForSiteRoot(dbc.getRequestContext().getSiteRoot()) != null) {
                time = time + OpenCms.getSiteManager().getSiteForSiteRoot(dbc.getRequestContext().getSiteRoot()).getSiteMatcher().getTimeOffset();
            }
            String[] stringArray = new String[5];
            stringArray[0] = dbc.currentUser().getName();
            stringArray[1] = getFolders ? (getFiles ? "_all_" : "_folders_") : "_files_";
            stringArray[2] = checkPermissions ? "+" + time : "-";
            stringArray[3] = filter.getCacheId();
            stringArray[4] = resource.getRootPath();
            cacheKey = this.getCacheKey(stringArray, dbc);
            resourceList = this.m_monitor.getCachedResourceList(cacheKey);
        }
        if (resourceList == null || !dbc.getProjectId().isNullUUID()) {
            resourceList = this.getVfsDriver(dbc).readChildResources(dbc, dbc.currentProject(), resource, getFolders, getFiles);
            if (checkPermissions) {
                resourceList = this.filterPermissions(dbc, resourceList, filter);
            }
            if (dbc.getProjectId().isNullUUID()) {
                this.m_monitor.cacheResourceList(cacheKey, resourceList);
            }
        }
        return this.updateContextDates(dbc, resourceList, filter);
    }

    public CmsResource readDefaultFile(CmsDbContext dbc, CmsResource resource, CmsResourceFilter resourceFilter) {
        if (resource.isFolder()) {
            block9: {
                try {
                    String defaultFileName = this.readPropertyObject(dbc, resource, "default-file", false).getValue();
                    if (defaultFileName != null && !"##navigation_level_folder##".equals(defaultFileName)) {
                        String folderName = CmsResource.getFolderPath(resource.getRootPath());
                        resource = this.readResource(dbc, folderName + defaultFileName, resourceFilter.addRequireFile());
                    }
                }
                catch (CmsException e) {
                    if (!LOG.isDebugEnabled()) break block9;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (resource.isFolder()) {
                String folderName = CmsResource.getFolderPath(resource.getRootPath());
                Iterator<String> it = OpenCms.getDefaultFiles().iterator();
                while (it.hasNext()) {
                    String tmpResourceName = folderName + it.next();
                    try {
                        resource = this.readResource(dbc, tmpResourceName, resourceFilter.addRequireFile());
                        break;
                    }
                    catch (CmsException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
        if (resource.isFolder()) {
            resource = null;
        }
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<I_CmsHistoryResource> readDeletedResources(CmsDbContext dbc, CmsResource resource, boolean readTree, boolean isVfsManager) throws CmsException {
        HashSet<I_CmsHistoryResource> newResult;
        block18: {
            List<I_CmsHistoryResource> deletedResources;
            HashSet<I_CmsHistoryResource> result = new HashSet<I_CmsHistoryResource>();
            dbc.getRequestContext().setAttribute("ATTR_RESOURCE_NAME", resource.getRootPath());
            try {
                deletedResources = this.getHistoryDriver(dbc).readDeletedResources(dbc, resource.getStructureId(), isVfsManager ? null : dbc.currentUser().getId());
            }
            finally {
                dbc.getRequestContext().removeAttribute("ATTR_RESOURCE_NAME");
            }
            result.addAll(deletedResources);
            newResult = new HashSet<I_CmsHistoryResource>(result.size());
            I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
            for (I_CmsHistoryResource histRes : result) {
                try {
                    if (vfsDriver.validateStructureIdExists(dbc, dbc.currentProject().getUuid(), histRes.getStructureId())) {
                        newResult.add(histRes);
                        continue;
                    }
                    String resourcePath = histRes.getRootPath();
                    String resName = CmsResource.getName(resourcePath);
                    String path = CmsResource.getParentFolder(resourcePath);
                    CmsUUID parentId = histRes.getParentId();
                    try {
                        path = this.readResource(dbc, parentId, CmsResourceFilter.IGNORE_EXPIRATION).getRootPath();
                    }
                    catch (CmsDataAccessException e) {
                        try {
                            parentId = this.readResource(dbc, path, CmsResourceFilter.IGNORE_EXPIRATION).getStructureId();
                        }
                        catch (CmsDataAccessException e1) {
                            // empty catch block
                        }
                    }
                    resourcePath = path + resName;
                    boolean isFolder = resourcePath.endsWith("/");
                    if (isFolder) {
                        newResult.add(new CmsHistoryFolder(histRes.getPublishTag(), histRes.getStructureId(), histRes.getResourceId(), resourcePath, histRes.getTypeId(), histRes.getFlags(), histRes.getProjectLastModified(), histRes.getState(), histRes.getDateCreated(), histRes.getUserCreated(), histRes.getDateLastModified(), histRes.getUserLastModified(), histRes.getDateReleased(), histRes.getDateExpired(), histRes.getVersion(), parentId, histRes.getResourceVersion(), histRes.getStructureVersion()));
                        continue;
                    }
                    newResult.add(new CmsHistoryFile(histRes.getPublishTag(), histRes.getStructureId(), histRes.getResourceId(), resourcePath, histRes.getTypeId(), histRes.getFlags(), histRes.getProjectLastModified(), histRes.getState(), histRes.getDateCreated(), histRes.getUserCreated(), histRes.getDateLastModified(), histRes.getUserLastModified(), histRes.getDateReleased(), histRes.getDateExpired(), histRes.getLength(), histRes.getDateContent(), histRes.getVersion(), parentId, null, histRes.getResourceVersion(), histRes.getStructureVersion()));
                }
                catch (CmsDataAccessException e) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            if (readTree) {
                for (I_CmsHistoryResource delResource : deletedResources) {
                    if (!delResource.isFolder()) continue;
                    newResult.addAll(this.readDeletedResources(dbc, (CmsFolder)((Object)delResource), readTree, isVfsManager));
                }
                try {
                    this.readResource(dbc, resource.getStructureId(), CmsResourceFilter.ALL);
                    for (CmsResource subResource : this.readResources(dbc, resource, CmsResourceFilter.ALL.addRequireFolder(), readTree)) {
                        if (!subResource.isFolder()) continue;
                        newResult.addAll(this.readDeletedResources(dbc, subResource, readTree, isVfsManager));
                    }
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break block18;
                    LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        ArrayList<I_CmsHistoryResource> finalRes = new ArrayList<I_CmsHistoryResource>(newResult);
        Collections.sort(finalRes, I_CmsResource.COMPARE_ROOT_PATH);
        return finalRes;
    }

    public CmsFile readFile(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (resource.isFolder()) {
            throw new CmsVfsResourceNotFoundException(org.opencms.db.Messages.get().container("ERR_ACCESS_FOLDER_AS_FILE_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        CmsUUID projectId = dbc.currentProject().getUuid();
        CmsFile file = null;
        if (resource instanceof I_CmsHistoryResource) {
            file = new CmsHistoryFile((I_CmsHistoryResource)((Object)resource));
            file.setContents(this.getHistoryDriver(dbc).readContent(dbc, resource.getResourceId(), ((I_CmsHistoryResource)((Object)resource)).getPublishTag()));
        } else {
            file = new CmsFile(resource);
            file.setContents(this.getVfsDriver(dbc).readContent(dbc, projectId, resource.getResourceId()));
        }
        return file;
    }

    public CmsFolder readFolder(CmsDbContext dbc, String resourcename, CmsResourceFilter filter) throws CmsDataAccessException {
        CmsResource resource = this.readResource(dbc, resourcename, filter);
        return this.convertResourceToFolder(resource);
    }

    public CmsGroup readGroup(CmsDbContext dbc, CmsProject project) {
        try {
            return this.readGroup(dbc, project.getGroupId());
        }
        catch (CmsException exc) {
            return new CmsGroup(CmsUUID.getNullUUID(), CmsUUID.getNullUUID(), project.getGroupId() + "", "deleted group", 0);
        }
    }

    public CmsGroup readGroup(CmsDbContext dbc, CmsUUID groupId) throws CmsException {
        CmsGroup group = null;
        group = this.m_monitor.getCachedGroup(groupId.toString());
        if (group == null) {
            group = this.getUserDriver(dbc).readGroup(dbc, groupId);
            this.m_monitor.cacheGroup(group);
        }
        return group;
    }

    public CmsGroup readGroup(CmsDbContext dbc, String groupname) throws CmsDataAccessException {
        CmsGroup group = null;
        group = this.m_monitor.getCachedGroup(groupname);
        if (group == null) {
            group = this.getUserDriver(dbc).readGroup(dbc, groupname);
            this.m_monitor.cacheGroup(group);
        }
        return group;
    }

    public CmsHistoryPrincipal readHistoricalPrincipal(CmsDbContext dbc, CmsUUID principalId) throws CmsException {
        return this.getHistoryDriver(dbc).readPrincipal(dbc, principalId);
    }

    public CmsHistoryProject readHistoryProject(CmsDbContext dbc, CmsUUID projectId) throws CmsException {
        return this.getHistoryDriver(dbc).readProject(dbc, projectId);
    }

    public CmsHistoryProject readHistoryProject(CmsDbContext dbc, int publishTag) throws CmsException {
        return this.getHistoryDriver(dbc).readProject(dbc, publishTag);
    }

    public List<CmsProperty> readHistoryPropertyObjects(CmsDbContext dbc, I_CmsHistoryResource historyResource) throws CmsException {
        return this.getHistoryDriver(dbc).readProperties(dbc, historyResource);
    }

    public CmsUUID readIdForUrlName(CmsDbContext dbc, String name) throws CmsDataAccessException {
        List<CmsUrlNameMappingEntry> entries = this.getVfsDriver(dbc).readUrlNameMappingEntries(dbc, dbc.currentProject().isOnlineProject(), CmsUrlNameMappingFilter.ALL.filterName(name));
        if (entries.isEmpty()) {
            return null;
        }
        return entries.get(0).getStructureId();
    }

    public void readLocks(CmsDbContext dbc) throws CmsException {
        this.m_lockManager.readLocks(dbc);
    }

    public CmsGroup readManagerGroup(CmsDbContext dbc, CmsProject project) {
        try {
            return this.readGroup(dbc, project.getManagerGroupId());
        }
        catch (CmsException exc) {
            return new CmsGroup(CmsUUID.getNullUUID(), CmsUUID.getNullUUID(), project.getManagerGroupId() + "", "deleted group", 0);
        }
    }

    public String readNewestUrlNameForId(CmsDbContext dbc, CmsUUID id) throws CmsDataAccessException {
        List<CmsUrlNameMappingEntry> entries = this.getVfsDriver(dbc).readUrlNameMappingEntries(dbc, dbc.currentProject().isOnlineProject(), CmsUrlNameMappingFilter.ALL.filterStructureId(id));
        if (entries.isEmpty()) {
            return null;
        }
        Collections.sort(entries, new UrlNameMappingComparator());
        CmsUrlNameMappingEntry lastEntry = entries.get(entries.size() - 1);
        return lastEntry.getName();
    }

    public CmsOrganizationalUnit readOrganizationalUnit(CmsDbContext dbc, String ouFqn) throws CmsException {
        CmsOrganizationalUnit organizationalUnit = null;
        organizationalUnit = this.m_monitor.getCachedOrgUnit(ouFqn);
        if (organizationalUnit == null) {
            organizationalUnit = this.getUserDriver(dbc).readOrganizationalUnit(dbc, ouFqn);
            this.m_monitor.cacheOrgUnit(organizationalUnit);
        }
        return organizationalUnit;
    }

    public CmsUser readOwner(CmsDbContext dbc, CmsProject project) throws CmsException {
        return this.readUser(dbc, project.getOwnerId());
    }

    public CmsResource readParentFolder(CmsDbContext dbc, CmsUUID structureId) throws CmsDataAccessException {
        return this.getVfsDriver(dbc).readParentFolder(dbc, dbc.currentProject().getUuid(), structureId);
    }

    public List<CmsResource> readPath(CmsDbContext dbc, String path, CmsResourceFilter filter) throws CmsException {
        List<String> tokens = CmsStringUtil.splitAsList(path, '/');
        int count = tokens.size() + 1;
        ArrayList<CmsResource> pathList = new ArrayList<CmsResource>(count);
        boolean lastResourceIsFile = false;
        int folderCount = count;
        if (!path.endsWith("/")) {
            --folderCount;
            lastResourceIsFile = true;
        }
        String currentResourceName = "/";
        StringBuffer currentPath = new StringBuffer(64);
        currentPath.append('/');
        String cp = currentPath.toString();
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        String cacheKey = this.getCacheKey(null, false, projectId, cp);
        CmsResource currentResource = this.m_monitor.getCachedResource(cacheKey);
        if (currentResource == null || !dbc.getProjectId().isNullUUID()) {
            currentResource = this.getVfsDriver(dbc).readFolder(dbc, projectId, cp);
            if (dbc.getProjectId().isNullUUID()) {
                this.m_monitor.cacheResource(cacheKey, currentResource);
            }
        }
        pathList.add(0, currentResource);
        if (count == 1) {
            return pathList;
        }
        Iterator<String> it = tokens.iterator();
        currentResourceName = it.next();
        int i = 0;
        for (i = 1; i < folderCount; ++i) {
            currentPath.append(currentResourceName);
            currentPath.append('/');
            cp = currentPath.toString();
            cacheKey = this.getCacheKey(null, false, projectId, cp);
            currentResource = this.m_monitor.getCachedResource(cacheKey);
            if (currentResource == null || !dbc.getProjectId().isNullUUID()) {
                currentResource = this.getVfsDriver(dbc).readFolder(dbc, projectId, cp);
                if (dbc.getProjectId().isNullUUID()) {
                    this.m_monitor.cacheResource(cacheKey, currentResource);
                }
            }
            pathList.add(i, currentResource);
            if (i >= folderCount - 1) continue;
            currentResourceName = it.next();
        }
        if (lastResourceIsFile) {
            if (it.hasNext()) {
                currentResourceName = it.next();
            }
            currentPath.append(currentResourceName);
            cp = currentPath.toString();
            cacheKey = this.getCacheKey(null, false, projectId, cp);
            currentResource = this.m_monitor.getCachedResource(cacheKey);
            if (currentResource == null || !dbc.getProjectId().isNullUUID()) {
                currentResource = this.getVfsDriver(dbc).readResource(dbc, projectId, cp, filter.includeDeleted());
                if (dbc.getProjectId().isNullUUID()) {
                    this.m_monitor.cacheResource(cacheKey, currentResource);
                }
            }
            pathList.add(i, currentResource);
        }
        return pathList;
    }

    public CmsProject readProject(CmsDbContext dbc, CmsUUID id) throws CmsDataAccessException {
        CmsProject project = null;
        project = this.m_monitor.getCachedProject(id.toString());
        if (project == null) {
            project = this.getProjectDriver(dbc).readProject(dbc, id);
            this.m_monitor.cacheProject(project);
        }
        return project;
    }

    public CmsProject readProject(CmsDbContext dbc, String name) throws CmsException {
        CmsProject project = null;
        project = this.m_monitor.getCachedProject(name);
        if (project == null) {
            project = this.getProjectDriver(dbc).readProject(dbc, name);
            this.m_monitor.cacheProject(project);
        }
        return project;
    }

    public List<String> readProjectResources(CmsDbContext dbc, CmsProject project) throws CmsException {
        return this.getProjectDriver(dbc).readProjectResources(dbc, project);
    }

    public List<CmsResource> readProjectView(CmsDbContext dbc, CmsUUID projectId, CmsResourceState state) throws CmsException {
        List<CmsResource> resources = state.isNew() || state.isChanged() || state.isDeleted() ? this.getVfsDriver(dbc).readResources(dbc, projectId, state, 1) : this.getVfsDriver(dbc).readResources(dbc, projectId, CmsResource.STATE_UNCHANGED, 2);
        List<CmsResource> result = this.filterPermissions(dbc, resources, CmsResourceFilter.ALL);
        Collections.sort(result);
        return this.updateContextDates(dbc, result);
    }

    public CmsPropertyDefinition readPropertyDefinition(CmsDbContext dbc, String name) throws CmsException {
        return this.getVfsDriver(dbc).readPropertyDefinition(dbc, name, dbc.currentProject().getUuid());
    }

    public CmsProperty readPropertyObject(CmsDbContext dbc, CmsResource resource, String key, boolean search) throws CmsException {
        List<CmsProperty> properties = this.readPropertyObjects(dbc, resource, search);
        int i = properties.indexOf(new CmsProperty(key, null, null));
        CmsProperty result = i >= 0 ? properties.get(i) : CmsProperty.getNullProperty();
        return result.cloneAsProperty();
    }

    public List<CmsProperty> readPropertyObjects(CmsDbContext dbc, CmsResource resource, boolean search) throws CmsException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        String cacheKey = this.getCacheKey(CACHE_ALL_PROPERTIES, search, projectId, resource.getRootPath());
        List<CmsProperty> properties = this.m_monitor.getCachedPropertyList(cacheKey);
        if (properties == null || !dbc.getProjectId().isNullUUID()) {
            if (search) {
                boolean cont;
                properties = new ArrayList<CmsProperty>();
                List<CmsProperty> parentProperties = null;
                do {
                    try {
                        parentProperties = this.readPropertyObjects(dbc, resource, false);
                        parentProperties.removeAll(properties);
                        parentProperties.addAll(properties);
                        properties.clear();
                        properties.addAll(parentProperties);
                        cont = resource.getRootPath().length() > 1;
                    }
                    catch (CmsSecurityException se) {
                        cont = false;
                    }
                    if (!cont) continue;
                    resource = this.readResource(dbc, CmsResource.getParentFolder(resource.getRootPath()), CmsResourceFilter.ALL);
                } while (cont);
            } else {
                properties = this.getVfsDriver(dbc).readPropertyObjects(dbc, dbc.currentProject(), resource);
            }
            CmsProperty.setFrozen(properties);
            if (dbc.getProjectId().isNullUUID()) {
                this.m_monitor.cachePropertyList(cacheKey, properties);
            }
        }
        return new ArrayList<CmsProperty>(properties);
    }

    public List<CmsPublishedResource> readPublishedResources(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        String cacheKey = publishHistoryId.toString();
        List<CmsPublishedResource> resourceList = this.m_monitor.getCachedPublishedResources(cacheKey);
        if (resourceList == null || !dbc.getProjectId().isNullUUID()) {
            resourceList = this.getProjectDriver(dbc).readPublishedResources(dbc, publishHistoryId);
            if (dbc.getProjectId().isNullUUID()) {
                this.m_monitor.cachePublishedResources(cacheKey, resourceList);
            }
        }
        return resourceList;
    }

    public CmsPublishJobInfoBean readPublishJob(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        return this.getProjectDriver(dbc).readPublishJob(dbc, publishHistoryId);
    }

    public List<CmsPublishJobInfoBean> readPublishJobs(CmsDbContext dbc, long startTime, long endTime) throws CmsException {
        return this.getProjectDriver(dbc).readPublishJobs(dbc, startTime, endTime);
    }

    public CmsPublishList readPublishList(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        return this.getProjectDriver(dbc).readPublishList(dbc, publishHistoryId);
    }

    public byte[] readPublishReportContents(CmsDbContext dbc, CmsUUID publishHistoryId) throws CmsException {
        return this.getProjectDriver(dbc).readPublishReportContents(dbc, publishHistoryId);
    }

    public I_CmsHistoryResource readResource(CmsDbContext dbc, CmsResource resource, int version) throws CmsException {
        for (I_CmsHistoryResource histRes : this.getHistoryDriver(dbc).readAllAvailableVersions(dbc, resource.getStructureId())) {
            if (histRes.getVersion() != version) continue;
            return histRes;
        }
        throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_HISTORY_FILE_NOT_FOUND_1", resource.getStructureId()));
    }

    public CmsResource readResource(CmsDbContext dbc, CmsUUID structureID, CmsResourceFilter filter) throws CmsDataAccessException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        CmsResource resource = this.getVfsDriver(dbc).readResource(dbc, projectId, structureID, filter.includeDeleted());
        this.updateContextDates(dbc, resource);
        return resource;
    }

    public CmsResource readResource(CmsDbContext dbc, String resourcePath, CmsResourceFilter filter) throws CmsDataAccessException {
        CmsUUID projectId = this.getProjectIdForContext(dbc);
        CmsResource resource = this.getVfsDriver(dbc).readResource(dbc, projectId, resourcePath, filter.includeDeleted());
        this.updateContextDates(dbc, resource);
        return resource;
    }

    public List<CmsResource> readResources(CmsDbContext dbc, CmsResource parent, CmsResourceFilter filter, boolean readTree) throws CmsException, CmsDataAccessException {
        String cacheKey = this.getCacheKey(new String[]{dbc.currentUser().getName(), filter.getCacheId(), readTree ? "+" : "-", parent.getRootPath()}, dbc);
        List<CmsResource> resourceList = this.m_monitor.getCachedResourceList(cacheKey);
        if (resourceList == null || !dbc.getProjectId().isNullUUID()) {
            resourceList = this.getVfsDriver(dbc).readResourceTree(dbc, dbc.currentProject().getUuid(), readTree ? parent.getRootPath() : parent.getStructureId().toString(), filter.getType(), filter.getState(), filter.getModifiedAfter(), filter.getModifiedBefore(), filter.getReleaseAfter(), filter.getReleaseBefore(), filter.getExpireAfter(), filter.getExpireBefore(), (readTree ? 0 : 1) | (filter.excludeType() ? 4 : 0) | (filter.excludeState() ? 8 : 0) | (filter.getOnlyFolders() != null ? (filter.getOnlyFolders().booleanValue() ? 64 : 128) : 0));
            if (!parent.getRootPath().startsWith("/system/orgunits/")) {
                resourceList = this.filterPermissions(dbc, resourceList, filter);
            }
            if (dbc.getProjectId().isNullUUID()) {
                this.m_monitor.cacheResourceList(cacheKey, resourceList);
            }
        }
        return this.updateContextDates(dbc, resourceList, filter);
    }

    public List<CmsResource> readResourcesVisitedBy(CmsDbContext dbc, String poolName, CmsVisitedByFilter filter) throws CmsException {
        List<CmsResource> result = this.getSubscriptionDriver().readResourcesVisitedBy(dbc, poolName, filter);
        result = this.filterPermissions(dbc, result, CmsResourceFilter.DEFAULT);
        return result;
    }

    public List<CmsResource> readResourcesWithProperty(CmsDbContext dbc, CmsResource folder, String propertyDefinition, String value, CmsResourceFilter filter) throws CmsException {
        String cacheKey = value == null ? this.getCacheKey(new String[]{dbc.currentUser().getName(), folder.getRootPath(), propertyDefinition, filter.getCacheId()}, dbc) : this.getCacheKey(new String[]{dbc.currentUser().getName(), folder.getRootPath(), propertyDefinition, value, filter.getCacheId()}, dbc);
        List<CmsResource> resourceList = this.m_monitor.getCachedResourceList(cacheKey);
        if (resourceList == null || !dbc.getProjectId().isNullUUID()) {
            CmsPropertyDefinition propDef = this.readPropertyDefinition(dbc, propertyDefinition);
            resourceList = this.getVfsDriver(dbc).readResourcesWithProperty(dbc, dbc.currentProject().getUuid(), propDef.getId(), folder.getRootPath(), value);
            resourceList = this.filterPermissions(dbc, resourceList, filter);
            if (dbc.getProjectId().isNullUUID()) {
                this.m_monitor.cacheResourceList(cacheKey, resourceList);
            }
        }
        return this.updateContextDates(dbc, resourceList, filter);
    }

    public Set<I_CmsPrincipal> readResponsiblePrincipals(CmsDbContext dbc, CmsResource resource) throws CmsException {
        HashSet<I_CmsPrincipal> result = new HashSet<I_CmsPrincipal>();
        for (CmsAccessControlEntry ace : this.getAccessControlEntries(dbc, resource, true)) {
            I_CmsPrincipal p;
            if (!ace.isResponsible() || (p = this.lookupPrincipal(dbc, ace.getPrincipal())) == null) continue;
            result.add(p);
        }
        return result;
    }

    public Set<CmsUser> readResponsibleUsers(CmsDbContext dbc, CmsResource resource) throws CmsException {
        HashSet<CmsUser> result = new HashSet<CmsUser>();
        for (I_CmsPrincipal principal : this.readResponsiblePrincipals(dbc, resource)) {
            if (principal.isGroup()) {
                try {
                    result.addAll(this.getUsersOfGroup(dbc, principal.getName(), true, false, false));
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) continue;
                    LOG.info((Object)e);
                }
                continue;
            }
            result.add((CmsUser)principal);
        }
        return result;
    }

    public List<CmsResource> readSiblings(CmsDbContext dbc, CmsResource resource, CmsResourceFilter filter) throws CmsException {
        List<CmsResource> siblings = this.getVfsDriver(dbc).readSiblings(dbc, dbc.currentProject().getUuid(), resource, filter.includeDeleted());
        return this.updateContextDates(dbc, siblings, filter);
    }

    public String readStaticExportPublishedResourceParameters(CmsDbContext dbc, String rfsName) throws CmsException {
        return this.getProjectDriver(dbc).readStaticExportPublishedResourceParameters(dbc, rfsName);
    }

    public List<String> readStaticExportResources(CmsDbContext dbc, int parameterResources, long timestamp) throws CmsException {
        return this.getProjectDriver(dbc).readStaticExportResources(dbc, parameterResources, timestamp);
    }

    public List<I_CmsHistoryResource> readSubscribedDeletedResources(CmsDbContext dbc, String poolName, CmsUser user, List<CmsGroup> groups, CmsResource parent, boolean includeSubFolders, long deletedFrom) throws CmsException {
        List<I_CmsHistoryResource> result = this.getSubscriptionDriver().readSubscribedDeletedResources(dbc, poolName, user, groups, parent, includeSubFolders, deletedFrom);
        return result;
    }

    public List<CmsResource> readSubscribedResources(CmsDbContext dbc, String poolName, CmsSubscriptionFilter filter) throws CmsException {
        List<CmsResource> result = this.getSubscriptionDriver().readSubscribedResources(dbc, poolName, filter);
        result = this.filterPermissions(dbc, result, CmsResourceFilter.DEFAULT);
        return result;
    }

    public List<CmsUrlNameMappingEntry> readUrlNameMappingEntries(CmsDbContext dbc, boolean online, CmsUrlNameMappingFilter filter) throws CmsDataAccessException {
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        return vfsDriver.readUrlNameMappingEntries(dbc, online, filter);
    }

    public List<CmsUrlNameMappingEntry> readUrlNameMappings(CmsDbContext dbc, CmsUrlNameMappingFilter filter) throws CmsDataAccessException {
        List<CmsUrlNameMappingEntry> entries = this.getVfsDriver(dbc).readUrlNameMappingEntries(dbc, dbc.currentProject().isOnlineProject(), filter);
        return entries;
    }

    public List<String> readUrlNamesForAllLocales(CmsDbContext dbc, CmsUUID id) throws CmsDataAccessException {
        ArrayList<String> result = new ArrayList<String>();
        List<CmsUrlNameMappingEntry> entries = this.getVfsDriver(dbc).readUrlNameMappingEntries(dbc, dbc.currentProject().isOnlineProject(), CmsUrlNameMappingFilter.ALL.filterStructureId(id));
        ArrayListMultimap entriesByLocale = ArrayListMultimap.create();
        for (CmsUrlNameMappingEntry entry : entries) {
            String localeKey = entry.getLocale();
            entriesByLocale.put((Object)localeKey, (Object)entry);
        }
        for (String localeKey : entriesByLocale.keySet()) {
            List entrs = entriesByLocale.get((Object)localeKey);
            CmsUrlNameMappingEntry maxEntryForLocale = Collections.max(entrs, new UrlNameMappingComparator());
            result.add(maxEntryForLocale.getName());
        }
        return result;
    }

    public CmsUser readUser(CmsDbContext dbc, CmsUUID id) throws CmsException {
        CmsUser user = this.m_monitor.getCachedUser(id.toString());
        if (user == null) {
            user = this.getUserDriver(dbc).readUser(dbc, id);
            this.m_monitor.cacheUser(user);
        }
        return user;
    }

    public CmsUser readUser(CmsDbContext dbc, String username) throws CmsDataAccessException {
        CmsUser user = this.m_monitor.getCachedUser(username);
        if (user == null) {
            user = this.getUserDriver(dbc).readUser(dbc, username);
            this.m_monitor.cacheUser(user);
        }
        return user;
    }

    public CmsUser readUser(CmsDbContext dbc, String username, String password) throws CmsException {
        CmsUser user = this.getUserDriver(dbc).readUser(dbc, username, password, null);
        this.m_monitor.cacheUser(user);
        return user;
    }

    public void removeAccessControlEntry(CmsDbContext dbc, CmsResource resource, CmsUUID principal) throws CmsException {
        this.getUserDriver(dbc).removeAccessControlEntry(dbc, dbc.currentProject(), resource.getResourceId(), principal);
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_PERMISSIONS, new String[]{resource.getRootPath()}), false);
        this.setDateLastModified(dbc, resource, resource.getDateLastModified());
        this.m_monitor.clearAccessControlListCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(1));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void removeResourceFromOrgUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsResource resource) throws CmsException {
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.HAS_ROLE, CmsMemoryMonitor.CacheType.ROLE_LIST);
        this.getUserDriver(dbc).removeResourceFromOrganizationalUnit(dbc, orgUnit, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void removeResourceFromProject(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (this.isInsideCurrentProject(dbc, resource.getRootPath())) {
            I_CmsProjectDriver projectDriver = this.getProjectDriver(dbc);
            if (resource.isFolder()) {
                List<String> projectResources = projectDriver.readProjectResources(dbc, dbc.currentProject());
                for (int i = 0; i < projectResources.size(); ++i) {
                    String resname = projectResources.get(i);
                    if (!resname.startsWith(resource.getRootPath())) continue;
                    projectDriver.deleteProjectResource(dbc, dbc.currentProject().getUuid(), resname);
                }
            }
            try {
                projectDriver.deleteProjectResource(dbc, dbc.currentProject().getUuid(), resource.getRootPath());
            }
            catch (CmsException exc) {
                this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
                OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
                catch (Throwable throwable) {
                    this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
                    OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
                    throw throwable;
                }
            }
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROJECT_RESOURCES);
            OpenCms.fireCmsEvent(new CmsEvent(18, Collections.singletonMap("project", dbc.currentProject())));
        }
    }

    public void removeResourceFromUsersPubList(CmsDbContext dbc, CmsUUID userId, Collection<CmsUUID> structureIds) throws CmsDataAccessException {
        for (CmsUUID structureId : structureIds) {
            CmsLogEntry entry = new CmsLogEntry(userId, System.currentTimeMillis(), structureId, CmsLogEntryType.RESOURCE_HIDDEN, new String[]{this.readResource(dbc, structureId, CmsResourceFilter.ALL).getRootPath()});
            this.log(dbc, entry, true);
        }
    }

    public void removeUserFromGroup(CmsDbContext dbc, String username, String groupname, boolean readRoles) throws CmsException, CmsIllegalArgumentException, CmsDbEntryNotFoundException, CmsSecurityException {
        CmsGroup group = this.readGroup(dbc, groupname);
        if (group == null) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        if (group.isVirtual() && !readRoles) {
            this.removeUserFromGroup(dbc, username, CmsRole.valueOf(group).getGroupName(), true);
            return;
        }
        if (group.isVirtual()) {
            readRoles = false;
        }
        if (readRoles && !group.isRole() || !readRoles && group.isRole()) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        if (!this.userInGroup(dbc, username, groupname, readRoles)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_USER_NOT_IN_GROUP_2", username, groupname));
        }
        CmsUser user = this.readUser(dbc, username);
        if (user == null) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_USER_NOT_IN_GROUP_2", username, groupname));
        }
        if (readRoles) {
            CmsRole role = CmsRole.valueOf(group);
            if (role.equals(CmsRole.WORKPLACE_USER.forOrgUnit(role.getOuFqn())) && this.getGroupsOfUser(dbc, username, role.getOuFqn(), false, true, true, dbc.getRequestContext().getRemoteAddress()).size() > 1) {
                return;
            }
            for (CmsGroup virtualGroup : this.getVirtualGroupsForRole(dbc, role)) {
                if (!this.userInGroup(dbc, username, virtualGroup.getName(), false)) continue;
                this.removeUserFromGroup(dbc, username, virtualGroup.getName(), true);
            }
        }
        this.getUserDriver(dbc).deleteUserInGroup(dbc, user.getId(), group.getId());
        if (readRoles) {
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.HAS_ROLE, CmsMemoryMonitor.CacheType.ROLE_LIST);
        }
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.USERGROUPS, CmsMemoryMonitor.CacheType.USER_LIST);
        if (!dbc.getProjectId().isNullUUID()) {
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("userId", user.getId().toString());
        eventData.put("userName", user.getName());
        eventData.put("groupId", group.getId().toString());
        eventData.put("groupName", group.getName());
        eventData.put("userAction", "removeUserFromGroup");
        OpenCms.fireCmsEvent(new CmsEvent(29, eventData));
    }

    public void repairCategories(CmsDbContext dbc, CmsUUID projectId, CmsResource resource) throws CmsException {
        CmsObject cms = OpenCms.initCmsObject(new CmsObject(this.getSecurityManager(), dbc.getRequestContext()));
        cms.getRequestContext().setSiteRoot("");
        cms.getRequestContext().setCurrentProject(this.readProject(dbc, projectId));
        CmsCategoryService.getInstance().repairRelations(cms, resource);
    }

    public void replaceResource(CmsDbContext dbc, CmsResource resource, int type, byte[] content, List<CmsProperty> properties) throws CmsException {
        this.getVfsDriver(dbc).replaceResource(dbc, resource, content, type);
        if (properties != null && !properties.isEmpty()) {
            this.getVfsDriver(dbc).writePropertyObjects(dbc, dbc.currentProject(), resource, properties);
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        }
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        resource.setUserLastModified(dbc.currentUser().getId());
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_CONTENT_MODIFIED, new String[]{resource.getRootPath()}), false);
        this.setDateLastModified(dbc, resource, System.currentTimeMillis());
        this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), resource, 4, false);
        this.deleteRelationsWithSiblings(dbc, resource);
        this.m_monitor.clearResourceCache();
        if (properties != null && !properties.isEmpty()) {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", resource)));
        } else {
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            data.put("resource", resource);
            data.put("change", new Integer(24));
            OpenCms.fireCmsEvent(new CmsEvent(11, data));
        }
    }

    public void resetPassword(CmsDbContext dbc, String username, String oldPassword, String newPassword) throws CmsException, CmsSecurityException {
        if (oldPassword != null && newPassword != null) {
            CmsUser user = null;
            this.validatePassword(newPassword);
            try {
                user = this.getUserDriver(dbc).readUser(dbc, username, oldPassword, null);
            }
            catch (CmsDbEntryNotFoundException e) {
                throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_RESET_PASSWORD_1", username), (Throwable)e);
            }
            if (user == null || user.isManaged()) {
                throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_RESET_PASSWORD_1", username));
            }
            this.getUserDriver(dbc).writePassword(dbc, username, oldPassword, newPassword);
            if (!dbc.getProjectId().isNullUUID()) {
                return;
            }
            HashMap<String, Object> eventData = new HashMap<String, Object>();
            eventData.put("userId", user.getId().toString());
            eventData.put("userAction", "resetPassword");
            OpenCms.fireCmsEvent(new CmsEvent(29, eventData));
        } else {
            if (CmsStringUtil.isEmpty(oldPassword)) {
                throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_PWD_OLD_MISSING_0"));
            }
            if (CmsStringUtil.isEmpty(newPassword)) {
                throw new CmsDataAccessException(org.opencms.db.Messages.get().container("ERR_PWD_NEW_MISSING_0"));
            }
        }
    }

    public void restoreDeletedResource(CmsDbContext dbc, CmsUUID structureId) throws CmsException {
        CmsResource parent;
        int version = this.getHistoryDriver(dbc).readLastVersion(dbc, structureId);
        I_CmsHistoryResource histRes = this.getHistoryDriver(dbc).readResource(dbc, structureId, version);
        try {
            parent = this.getVfsDriver(dbc).readResource(dbc, dbc.currentProject().getUuid(), histRes.getParentId(), true);
        }
        catch (CmsVfsResourceNotFoundException e) {
            try {
                parent = this.getVfsDriver(dbc).readResource(dbc, dbc.currentProject().getUuid(), CmsResource.getParentFolder(histRes.getRootPath()), true);
            }
            catch (CmsVfsResourceNotFoundException e1) {
                this.restoreDeletedResource(dbc, histRes.getParentId());
                parent = this.readResource(dbc, histRes.getParentId(), CmsResourceFilter.IGNORE_EXPIRATION);
            }
        }
        this.m_securityManager.checkPermissions(dbc, parent, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.IGNORE_EXPIRATION);
        String path = CmsResource.getParentFolder(histRes.getRootPath());
        String resName = CmsResource.getName(histRes.getRootPath());
        String ext = "";
        if (resName.charAt(resName.length() - 1) == '/') {
            resName = resName.substring(0, resName.length() - 1);
        } else {
            ext = CmsFileUtil.getExtension(resName);
        }
        String nameWOExt = resName.substring(0, resName.length() - ext.length());
        int i = 1;
        while (true) {
            try {
                this.readResource(dbc, path + resName, CmsResourceFilter.ALL);
                resName = nameWOExt + "_" + i + ext;
            }
            catch (CmsVfsResourceNotFoundException e) {
                break;
            }
            ++i;
        }
        CmsUUID id = structureId;
        if (this.getVfsDriver(dbc).validateStructureIdExists(dbc, dbc.currentProject().getUuid(), structureId)) {
            id = new CmsUUID();
        }
        byte[] contents = null;
        boolean isFolder = true;
        if (histRes instanceof CmsFile) {
            contents = ((CmsFile)((Object)histRes)).getContents();
            if (contents == null || contents.length == 0) {
                contents = this.getHistoryDriver(dbc).readContent(dbc, histRes.getResourceId(), histRes.getPublishTag());
            }
            isFolder = false;
        }
        List<CmsProperty> properties = this.getHistoryDriver(dbc).readProperties(dbc, histRes);
        CmsResource newResource = new CmsResource(id, histRes.getResourceId(), path + resName, histRes.getTypeId(), isFolder, histRes.getFlags(), dbc.currentProject().getUuid(), CmsResource.STATE_NEW, histRes.getDateCreated(), histRes.getUserCreated(), histRes.getDateLastModified(), dbc.currentUser().getId(), histRes.getDateReleased(), histRes.getDateExpired(), histRes.getSiblingCount(), histRes.getLength(), histRes.getDateContent(), histRes.getVersion());
        this.log(dbc, new CmsLogEntry(dbc, newResource.getStructureId(), CmsLogEntryType.RESOURCE_RESTORE_DELETED, new String[]{newResource.getRootPath()}), false);
        newResource.setDateLastModified(newResource.getDateLastModified());
        CmsResource resource = this.createResource(dbc, path + resName, newResource, contents, properties, true);
        newResource.setState(CmsResource.STATE_CHANGED);
        this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), newResource, 1, false);
        newResource.setState(CmsResource.STATE_NEW);
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(24));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void restoreResource(CmsDbContext dbc, CmsResource resource, int version) throws CmsException {
        I_CmsHistoryResource historyResource = this.readResource(dbc, resource, version);
        CmsResourceState state = CmsResource.STATE_CHANGED;
        if (resource.getState().isNew()) {
            state = CmsResource.STATE_NEW;
        }
        int newVersion = resource.getVersion();
        if (resource.getState().isUnchanged()) {
            ++newVersion;
        }
        CmsResource newResource = null;
        if (historyResource instanceof CmsFile) {
            int flags = historyResource.getFlags();
            if (resource.isLabeled()) {
                flags |= 2;
            }
            CmsFile newFile = new CmsFile(resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), historyResource.getTypeId(), flags, dbc.currentProject().getUuid(), state, resource.getDateCreated(), historyResource.getUserCreated(), resource.getDateLastModified(), dbc.currentUser().getId(), historyResource.getDateReleased(), historyResource.getDateExpired(), resource.getSiblingCount(), historyResource.getLength(), historyResource.getDateContent(), newVersion, this.readFile(dbc, (CmsHistoryFile)historyResource).getContents());
            this.log(dbc, new CmsLogEntry(dbc, newFile.getStructureId(), CmsLogEntryType.RESOURCE_HISTORY, new String[]{newFile.getRootPath()}), false);
            newResource = this.writeFile(dbc, newFile);
        } else {
            newResource = new CmsFolder(resource.getStructureId(), resource.getResourceId(), resource.getRootPath(), historyResource.getTypeId(), historyResource.getFlags(), dbc.currentProject().getUuid(), state, resource.getDateCreated(), historyResource.getUserCreated(), resource.getDateLastModified(), dbc.currentUser().getId(), historyResource.getDateReleased(), historyResource.getDateExpired(), newVersion);
            this.log(dbc, new CmsLogEntry(dbc, newResource.getStructureId(), CmsLogEntryType.RESOURCE_HISTORY, new String[]{newResource.getRootPath()}), false);
            this.writeResource(dbc, newResource);
        }
        if (newResource != null) {
            List<CmsProperty> historyProperties = this.getHistoryDriver(dbc).readProperties(dbc, historyResource);
            this.deleteAllProperties(dbc, newResource.getRootPath());
            this.writePropertyObjects(dbc, newResource, historyProperties, false);
            this.m_monitor.clearResourceCache();
        }
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(24));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void saveAliases(CmsDbContext dbc, CmsProject project, CmsUUID structureId, List<CmsAlias> aliases) throws CmsException {
        for (CmsAlias alias : aliases) {
            if (structureId.equals(alias.getStructureId())) continue;
            throw new IllegalArgumentException("Aliases to replace must have the same structure id!");
        }
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        vfsDriver.deleteAliases(dbc, project, new CmsAliasFilter(null, null, structureId));
        for (CmsAlias alias : aliases) {
            String aliasPath = alias.getAliasPath();
            if (CmsAlias.ALIAS_PATTERN.matcher(aliasPath).matches()) {
                vfsDriver.insertAlias(dbc, project, alias);
                continue;
            }
            LOG.error((Object)("Invalid alias path: " + aliasPath));
        }
    }

    public void saveRewriteAliases(CmsDbContext dbc, String siteRoot, List<CmsRewriteAlias> newAliases) throws CmsException {
        CmsRewriteAliasFilter filter = new CmsRewriteAliasFilter().setSiteRoot(siteRoot);
        this.getVfsDriver(dbc).deleteRewriteAliases(dbc, filter);
        this.getVfsDriver(dbc).insertRewriteAliases(dbc, newAliases);
    }

    public List<CmsUser> searchUsers(CmsDbContext dbc, CmsUserSearchParameters searchParams) throws CmsDataAccessException {
        return this.getUserDriver(dbc).searchUsers(dbc, searchParams);
    }

    public void setDateExpired(CmsDbContext dbc, CmsResource resource, long dateExpired) throws CmsDataAccessException {
        resource.setDateExpired(dateExpired);
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), resource, 5, false);
        this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), resource, 6, false);
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_DATE_EXPIRED, new String[]{resource.getRootPath()}), false);
        this.m_monitor.clearResourceCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(2));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void setDateLastModified(CmsDbContext dbc, CmsResource resource, long dateLastModified) throws CmsDataAccessException {
        resource.setDateLastModified(dateLastModified);
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        } else if (resource.getState().isNew() && resource.getSiblingCount() > 1) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        resource.setUserLastModified(dbc.currentUser().getId());
        this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), resource, 4, false);
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_TOUCHED, new String[]{resource.getRootPath()}), false);
        this.m_monitor.clearResourceCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(4));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void setDateReleased(CmsDbContext dbc, CmsResource resource, long dateReleased) throws CmsDataAccessException {
        resource.setDateReleased(dateReleased);
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), resource, 5, false);
        this.getVfsDriver(dbc).writeResourceState(dbc, dbc.currentProject(), resource, 6, false);
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_DATE_RELEASED, new String[]{resource.getRootPath()}), false);
        this.m_monitor.clearResourceCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(2));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void setParentGroup(CmsDbContext dbc, String groupName, String parentGroupName) throws CmsException, CmsDataAccessException {
        CmsGroup group = this.readGroup(dbc, groupName);
        CmsUUID parentGroupId = CmsUUID.getNullUUID();
        if (parentGroupName != null) {
            parentGroupId = this.readGroup(dbc, parentGroupName).getId();
        }
        group.setParentId(parentGroupId);
        this.writeGroup(dbc, group);
    }

    public void setPassword(CmsDbContext dbc, String username, String newPassword) throws CmsException, CmsIllegalArgumentException {
        this.validatePassword(newPassword);
        this.getUserDriver(dbc).readUser(dbc, username);
        this.getUserDriver(dbc).writePassword(dbc, username, null, newPassword);
    }

    public void setSubscribedResourceAsDeleted(CmsDbContext dbc, String poolName, CmsResource resource) throws CmsException {
        this.getSubscriptionDriver().setSubscribedResourceAsDeleted(dbc, poolName, resource);
    }

    public void setUsersOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit orgUnit, CmsUser user) throws CmsException {
        if (!this.getGroupsOfUser(dbc, user.getName(), false).isEmpty()) {
            throw new CmsDbConsistencyException(org.opencms.db.Messages.get().container("ERR_ORGUNIT_MOVE_USER_2", orgUnit.getName(), user.getName()));
        }
        this.getUserDriver(dbc).setUsersOrganizationalUnit(dbc, orgUnit, user);
        this.m_monitor.clearUserCache(user);
        if (!dbc.getProjectId().isNullUUID()) {
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("userId", user.getId().toString());
        eventData.put("ouName", user.getOuFqn());
        eventData.put("userAction", "setOu");
        OpenCms.fireCmsEvent(new CmsEvent(29, eventData));
    }

    public void subscribeResourceFor(CmsDbContext dbc, String poolName, CmsPrincipal principal, CmsResource resource) throws CmsException {
        this.getSubscriptionDriver().subscribeResourceFor(dbc, poolName, principal, resource);
    }

    public void undelete(CmsDbContext dbc, CmsResource resource) throws CmsException {
        if (!resource.getState().isDeleted()) {
            throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_UNDELETE_FOR_RESOURCE_DELETED_1", dbc.removeSiteRoot(resource.getRootPath())));
        }
        resource.setState(CmsResourceState.STATE_CHANGED);
        this.updateState(dbc, resource, false);
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_UNDELETED, new String[]{resource.getRootPath()}), false);
        this.m_monitor.clearResourceCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(8));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void undoChanges(CmsDbContext dbc, CmsResource resource, CmsResource.CmsResourceUndoMode mode) throws CmsException {
        boolean moved;
        if (resource.getState().isNew()) {
            throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_UNDO_CHANGES_FOR_RESOURCE_NEW_0"));
        }
        CmsProject onlineProject = this.readProject(dbc, CmsProject.ONLINE_PROJECT_ID);
        CmsResource onlineResource = this.getVfsDriver(dbc).readResource(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getStructureId(), true);
        CmsResource onlineResourceByPath = null;
        try {
            onlineResourceByPath = this.getVfsDriver(dbc).readResource(dbc, CmsProject.ONLINE_PROJECT_ID, resource.getRootPath(), true);
            if (!mode.isUndoMove() && !onlineResourceByPath.getRootPath().equals(onlineResource.getRootPath())) {
                mode = mode.includeMove();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean bl = moved = !onlineResource.getRootPath().equals(resource.getRootPath());
        if (moved && mode.isUndoMove()) {
            this.moveResource(dbc, resource, onlineResource.getRootPath(), true);
            if (onlineResourceByPath != null && !onlineResourceByPath.getRootPath().equals(onlineResource.getRootPath())) {
                this.undoContentChanges(dbc, onlineProject, null, onlineResourceByPath, CmsResource.STATE_UNCHANGED, true);
            }
        }
        CmsResourceState newState = CmsResource.STATE_UNCHANGED;
        if (moved && !mode.isUndoMove()) {
            newState = CmsResource.STATE_CHANGED;
        }
        this.undoContentChanges(dbc, onlineProject, resource, onlineResource, newState, moved && mode.isUndoMove());
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_CHANGES_UNDONE, new String[]{resource.getRootPath()}), true);
    }

    public void unlockProject(CmsProject project) {
        this.m_lockManager.removeResourcesInProject(project.getUuid(), false);
        this.m_monitor.clearResourceCache();
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROJECT, CmsMemoryMonitor.CacheType.PERMISSION);
    }

    public void unlockResource(CmsDbContext dbc, CmsResource resource, boolean force, boolean removeSystemLock) throws CmsException {
        this.m_monitor.clearResourceCache();
        this.m_lockManager.removeResource(dbc, resource, force, removeSystemLock);
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PERMISSION);
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(0));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void unsubscribeAllDeletedResources(CmsDbContext dbc, String poolName, long deletedTo) throws CmsException {
        this.getSubscriptionDriver().unsubscribeAllDeletedResources(dbc, poolName, deletedTo);
    }

    public void unsubscribeAllResourcesFor(CmsDbContext dbc, String poolName, CmsPrincipal principal) throws CmsException {
        this.getSubscriptionDriver().unsubscribeAllResourcesFor(dbc, poolName, principal);
    }

    public void unsubscribeResourceFor(CmsDbContext dbc, String poolName, CmsPrincipal principal, CmsResource resource) throws CmsException {
        this.getSubscriptionDriver().unsubscribeResourceFor(dbc, poolName, principal, resource);
    }

    public void unsubscribeResourceForAll(CmsDbContext dbc, String poolName, CmsResource resource) throws CmsException {
        this.getSubscriptionDriver().unsubscribeResourceForAll(dbc, poolName, resource);
    }

    public void updateExportPoints(CmsDbContext dbc) {
        block10: {
            try {
                HashSet<CmsExportPoint> exportPoints = new HashSet<CmsExportPoint>();
                exportPoints.addAll(OpenCms.getExportPoints());
                exportPoints.addAll(OpenCms.getModuleManager().getExportPoints());
                if (exportPoints.size() == 0) {
                    if (LOG.isWarnEnabled()) {
                        LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("LOG_NO_EXPORT_POINTS_CONFIGURED_0"));
                    }
                    return;
                }
                CmsExportPointDriver exportPointDriver = new CmsExportPointDriver(exportPoints);
                Iterator<String> i = exportPointDriver.getExportPointPaths().iterator();
                I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
                while (i.hasNext()) {
                    String currentExportPoint = i.next();
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)org.opencms.db.Messages.get().getBundle().key("LOG_WRITE_EXPORT_POINT_1", currentExportPoint));
                    }
                    try {
                        CmsResourceFilter filter = CmsResourceFilter.DEFAULT;
                        List<CmsResource> resources = vfsDriver.readResourceTree(dbc, CmsProject.ONLINE_PROJECT_ID, currentExportPoint, filter.getType(), filter.getState(), filter.getModifiedAfter(), filter.getModifiedBefore(), filter.getReleaseAfter(), filter.getReleaseBefore(), filter.getExpireAfter(), filter.getExpireBefore(), 0 | (filter.excludeType() ? 4 : 0) | (filter.excludeState() ? 8 : 0));
                        for (CmsResource currentResource : resources) {
                            if (currentResource.isFolder()) {
                                exportPointDriver.createFolder(currentResource.getRootPath(), currentExportPoint);
                                continue;
                            }
                            exportPointDriver.createFolder(currentExportPoint, currentExportPoint);
                            byte[] onlineContent = vfsDriver.readContent(dbc, CmsProject.ONLINE_PROJECT_ID, currentResource.getResourceId());
                            exportPointDriver.writeFile(currentResource.getRootPath(), currentExportPoint, onlineContent);
                        }
                    }
                    catch (CmsException e) {
                        if (!(e instanceof CmsVfsResourceNotFoundException) || !LOG.isErrorEnabled()) continue;
                        LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_UPDATE_EXORT_POINTS_ERROR_0"), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block10;
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_UPDATE_EXORT_POINTS_ERROR_0"), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLog(CmsDbContext dbc) throws CmsDataAccessException {
        Object object = this.m_publishListUpdateLock;
        synchronized (object) {
            if (this.m_log.isEmpty()) {
                return;
            }
            ArrayList<CmsLogEntry> log = new ArrayList<CmsLogEntry>(this.m_log);
            this.m_log.clear();
            String logTableEnabledStr = (String)OpenCms.getRuntimeProperty(PARAM_LOG_TABLE_ENABLED);
            if (Boolean.parseBoolean(logTableEnabledStr)) {
                this.m_projectDriver.log(dbc, log);
            }
            CmsLogToPublishListChangeConverter converter = new CmsLogToPublishListChangeConverter();
            for (CmsLogEntry entry : log) {
                converter.add(entry);
            }
            this.m_projectDriver.deleteUserPublishListEntries(dbc, converter.getPublishListDeletions());
            this.m_projectDriver.writeUserPublishListEntries(dbc, converter.getPublishListAdditions());
        }
    }

    public void updateRelationsForResource(CmsDbContext dbc, CmsResource resource, List<CmsLink> links) throws CmsException {
        this.deleteRelationsWithSiblings(dbc, resource);
        if (links == null || links.isEmpty()) {
            return;
        }
        HashSet<CmsRelation> writtenRelations = new HashSet<CmsRelation>();
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        for (CmsLink link : links) {
            CmsRelation originalRelation;
            if (!link.isInternal() || CmsStringUtil.isEmptyOrWhitespaceOnly(link.getTarget())) continue;
            CmsUUID targetId = link.getStructureId();
            String destPath = link.getTarget();
            if (targetId != null) {
                try {
                    CmsResource destRes = this.readResource(dbc, targetId, CmsResourceFilter.ALL);
                    destPath = destRes.getRootPath();
                }
                catch (CmsVfsResourceNotFoundException e) {
                    // empty catch block
                }
            }
            if (writtenRelations.contains(originalRelation = new CmsRelation(resource.getStructureId(), resource.getRootPath(), link.getStructureId(), destPath, link.getType()))) continue;
            writtenRelations.add(originalRelation);
            for (CmsResource sibling : this.readSiblings(dbc, resource, CmsResourceFilter.ALL)) {
                CmsRelation relation = new CmsRelation(sibling.getStructureId(), sibling.getRootPath(), originalRelation.getTargetId(), originalRelation.getTargetPath(), link.getType());
                vfsDriver.createRelation(dbc, dbc.currentProject().getUuid(), relation);
            }
        }
    }

    public boolean userInGroup(CmsDbContext dbc, String username, String groupname, boolean readRoles) throws CmsException {
        List<CmsGroup> groups = this.getGroupsOfUser(dbc, username, readRoles);
        for (int i = 0; i < groups.size(); ++i) {
            CmsGroup group = groups.get(i);
            if (!groupname.equals(group.getName()) && !groupname.substring(1).equals(group.getName())) continue;
            return true;
        }
        return false;
    }

    public void validatePassword(String password) throws CmsSecurityException {
        OpenCms.getPasswordHandler().validatePassword(password);
    }

    public Map<String, List<CmsRelation>> validateRelations(CmsDbContext dbc, CmsPublishList publishList, I_CmsReport report) throws Exception {
        return this.m_htmlLinkValidator.validateResources(dbc, publishList, report);
    }

    public void writeAccessControlEntry(CmsDbContext dbc, CmsResource resource, CmsAccessControlEntry ace) throws CmsException {
        this.getUserDriver(dbc).writeAccessControlEntry(dbc, dbc.currentProject(), ace);
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_PERMISSIONS, new String[]{resource.getRootPath()}), false);
        this.setDateLastModified(dbc, resource, resource.getDateLastModified());
        this.m_monitor.clearAccessControlListCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(1));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void writeExportPoints(CmsDbContext dbc, I_CmsReport report, CmsUUID publishHistoryId) {
        List<CmsPublishedResource> publishedResources;
        boolean printReportHeaders;
        block20: {
            printReportHeaders = false;
            publishedResources = null;
            try {
                publishedResources = this.getProjectDriver(dbc).readPublishedResources(dbc, publishHistoryId);
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block20;
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_READ_PUBLISHED_RESOURCES_FOR_ID_1", publishHistoryId), (Throwable)e);
            }
        }
        if (publishedResources == null || publishedResources.isEmpty()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("LOG_EMPTY_PUBLISH_HISTORY_1", publishHistoryId));
            }
            return;
        }
        HashSet<CmsExportPoint> exportPoints = new HashSet<CmsExportPoint>();
        exportPoints.addAll(OpenCms.getExportPoints());
        exportPoints.addAll(OpenCms.getModuleManager().getExportPoints());
        if (exportPoints.size() == 0) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)org.opencms.db.Messages.get().getBundle().key("LOG_NO_EXPORT_POINTS_CONFIGURED_0"));
            }
            return;
        }
        CmsExportPointDriver exportPointDriver = new CmsExportPointDriver(exportPoints);
        if (report == null) {
            report = dbc.getRequestContext() != null ? new CmsLogReport(dbc.getRequestContext().getLocale(), this.getClass()) : new CmsLogReport(CmsLocaleManager.getDefaultLocale(), this.getClass());
        }
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        for (CmsPublishedResource currentPublishedResource : publishedResources) {
            String currentExportPoint = exportPointDriver.getExportPoint(currentPublishedResource.getRootPath());
            if (currentExportPoint == null) continue;
            if (!printReportHeaders) {
                report.println(org.opencms.db.Messages.get().container("RPT_EXPORT_POINTS_WRITE_BEGIN_0"), 2);
                printReportHeaders = true;
            }
            if (currentPublishedResource.getState().isDeleted()) {
                report.print(org.opencms.db.Messages.get().container("RPT_EXPORT_POINTS_DELETE_0"), 3);
            } else {
                report.print(org.opencms.db.Messages.get().container("RPT_EXPORT_POINTS_WRITE_0"), 3);
            }
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", currentPublishedResource.getRootPath()));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            if (currentPublishedResource.isFolder()) {
                if (currentPublishedResource.getState().isDeleted()) {
                    exportPointDriver.deleteResource(currentPublishedResource.getRootPath(), currentExportPoint);
                } else {
                    exportPointDriver.createFolder(currentPublishedResource.getRootPath(), currentExportPoint);
                }
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                continue;
            }
            try {
                if (currentPublishedResource.getState().isDeleted()) {
                    exportPointDriver.deleteResource(currentPublishedResource.getRootPath(), currentExportPoint);
                } else {
                    byte[] onlineContent = vfsDriver.readContent(dbc, CmsProject.ONLINE_PROJECT_ID, currentPublishedResource.getResourceId());
                    exportPointDriver.writeFile(currentPublishedResource.getRootPath(), currentExportPoint, onlineContent);
                }
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            }
            catch (CmsException e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("LOG_WRITE_EXPORT_POINT_ERROR_1", currentPublishedResource.getRootPath()), (Throwable)e);
                }
                report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
            }
        }
        if (printReportHeaders) {
            report.println(org.opencms.db.Messages.get().container("RPT_EXPORT_POINTS_WRITE_END_0"), 2);
        }
    }

    public CmsFile writeFile(CmsDbContext dbc, CmsFile resource) throws CmsException {
        resource.setUserLastModified(dbc.currentUser().getId());
        resource.setContents(resource.getContents());
        this.getVfsDriver(dbc).writeResource(dbc, dbc.currentProject().getUuid(), resource, 1);
        byte[] contents = resource.getContents();
        this.getVfsDriver(dbc).writeContent(dbc, resource.getResourceId(), contents);
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_CONTENT_MODIFIED, new String[]{resource.getRootPath()}), false);
        resource = new CmsFile(this.readResource(dbc, resource.getStructureId(), CmsResourceFilter.ALL));
        resource.setContents(contents);
        this.deleteRelationsWithSiblings(dbc, resource);
        this.m_monitor.clearResourceCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(16));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
        return resource;
    }

    public void writeGroup(CmsDbContext dbc, CmsGroup group) throws CmsException {
        CmsGroup oldGroup = this.readGroup(dbc, group.getName());
        this.m_monitor.uncacheGroup(oldGroup);
        this.getUserDriver(dbc).writeGroup(dbc, group);
        this.m_monitor.cacheGroup(group);
        if (!dbc.getProjectId().isNullUUID()) {
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("groupId", group.getId().toString());
        eventData.put("groupName", oldGroup.getName());
        eventData.put("userAction", "writeGroup");
        OpenCms.fireCmsEvent(new CmsEvent(31, eventData));
    }

    public void writeHistoryProject(CmsDbContext dbc, int publishTag, long publishDate) throws CmsDataAccessException {
        this.getHistoryDriver(dbc).writeProject(dbc, publishTag, publishDate);
    }

    public void writeLocks(CmsDbContext dbc) throws CmsException {
        this.m_lockManager.writeLocks(dbc);
    }

    public void writeOrganizationalUnit(CmsDbContext dbc, CmsOrganizationalUnit organizationalUnit) throws CmsException {
        this.m_monitor.uncacheOrgUnit(organizationalUnit);
        this.getUserDriver(dbc).writeOrganizationalUnit(dbc, organizationalUnit);
        CmsResource ouRes = this.readResource(dbc, organizationalUnit.getId(), CmsResourceFilter.DEFAULT);
        CmsPublishList pl = new CmsPublishList(ouRes, false);
        pl.add(ouRes, false);
        this.getProjectDriver(dbc).writePublishHistory(dbc, pl.getPublishHistoryId(), new CmsPublishedResource(ouRes, -1, CmsResourceState.STATE_NEW));
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("publishHistoryId", pl.getPublishHistoryId().toString());
        eventData.put("projectId", dbc.currentProject().getUuid());
        eventData.put("dbContext", dbc);
        CmsEvent afterPublishEvent = new CmsEvent(2, eventData);
        OpenCms.fireCmsEvent(afterPublishEvent);
        this.m_monitor.cacheOrgUnit(organizationalUnit);
    }

    public void writeProject(CmsDbContext dbc, CmsProject project) throws CmsException {
        this.m_monitor.uncacheProject(project);
        this.getProjectDriver(dbc).writeProject(dbc, project);
        this.m_monitor.cacheProject(project);
    }

    public void writeProjectLastModified(CmsDbContext dbc, CmsResource resource, CmsUUID projectId) throws CmsDataAccessException {
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        vfsDriver.writeLastModifiedProjectId(dbc, dbc.currentProject(), projectId, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePropertyObject(CmsDbContext dbc, CmsResource resource, CmsProperty property) throws CmsException {
        block4: {
            try {
                if (property != CmsProperty.getNullProperty()) break block4;
                this.m_monitor.clearResourceCache();
            }
            catch (Throwable throwable) {
                this.m_monitor.clearResourceCache();
                this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("resource", resource);
                data.put("property", property);
                OpenCms.fireCmsEvent(new CmsEvent(14, data));
                throw throwable;
            }
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("resource", resource);
            data.put("property", property);
            OpenCms.fireCmsEvent(new CmsEvent(14, data));
            return;
        }
        int updateState = this.getUpdateState(dbc, resource, Collections.singletonList(property));
        this.getVfsDriver(dbc).writePropertyObject(dbc, dbc.currentProject(), resource, property);
        if (updateState > 0) {
            this.updateState(dbc, resource, updateState == 2);
        }
        this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_PROPERTIES, new String[]{resource.getRootPath()}), false);
        this.m_monitor.clearResourceCache();
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("resource", resource);
        data.put("property", property);
        OpenCms.fireCmsEvent(new CmsEvent(14, data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePropertyObjects(CmsDbContext dbc, CmsResource resource, List<CmsProperty> properties, boolean updateState) throws CmsException {
        if (properties == null || properties.size() == 0) {
            return;
        }
        try {
            CmsProperty property;
            int n = properties.size();
            for (int i = 0; i < n; ++i) {
                HashSet<String> keyValidationSet = new HashSet<String>();
                property = properties.get(i);
                if (keyValidationSet.contains(property.getName())) {
                    throw new CmsVfsException(org.opencms.db.Messages.get().container("ERR_VFS_INVALID_PROPERTY_LIST_1", property.getName()));
                }
                keyValidationSet.add(property.getName());
            }
            int updateStateValue = 0;
            if (updateState) {
                updateStateValue = this.getUpdateState(dbc, resource, properties);
            }
            I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
            for (int i = 0; i < properties.size(); ++i) {
                property = properties.get(i);
                vfsDriver.writePropertyObject(dbc, dbc.currentProject(), resource, property);
            }
            if (updateStateValue > 0) {
                this.updateState(dbc, resource, updateStateValue == 2);
            }
            if (updateState) {
                this.log(dbc, new CmsLogEntry(dbc, resource.getStructureId(), CmsLogEntryType.RESOURCE_PROPERTIES, new String[]{resource.getRootPath()}), false);
            }
            this.m_monitor.clearResourceCache();
        }
        catch (Throwable throwable) {
            this.m_monitor.clearResourceCache();
            this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", resource)));
            throw throwable;
        }
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", resource)));
    }

    public void writePublishJob(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsException {
        this.getProjectDriver(dbc).writePublishJob(dbc, publishJob);
    }

    public void writePublishReport(CmsDbContext dbc, CmsPublishJobInfoBean publishJob) throws CmsException {
        CmsPublishReport report = (CmsPublishReport)publishJob.removePublishReport();
        if (report != null) {
            this.getProjectDriver(dbc).writePublishReport(dbc, publishJob.getPublishHistoryId(), report.getContents());
        }
    }

    public void writeResource(CmsDbContext dbc, CmsResource resource) throws CmsException {
        resource.setUserLastModified(dbc.currentUser().getId());
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? dbc.currentProject().getUuid() : dbc.getProjectId();
        this.getVfsDriver(dbc).writeResource(dbc, projectId, resource, 1);
        if (resource.getState().isUnchanged()) {
            resource.setState(CmsResource.STATE_CHANGED);
        }
        if (!(OpenCms.getResourceManager().getResourceType(resource.getTypeId()) instanceof I_CmsLinkParseable)) {
            this.deleteRelationsWithSiblings(dbc, resource);
        }
        this.m_monitor.clearResourceCache();
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("resource", resource);
        data.put("change", new Integer(8));
        OpenCms.fireCmsEvent(new CmsEvent(11, data));
    }

    public void writeStaticExportPublishedResource(CmsDbContext dbc, String resourceName, int linkType, String linkParameter, long timestamp) throws CmsException {
        this.getProjectDriver(dbc).writeStaticExportPublishedResource(dbc, resourceName, linkType, linkParameter, timestamp);
    }

    public String writeUrlNameMapping(CmsDbContext dbc, Iterator<String> nameSeq, CmsUUID structureId, String locale) throws CmsDataAccessException {
        String bestName = this.findBestNameForUrlNameMapping(dbc, nameSeq, structureId, locale);
        this.addOrReplaceUrlNameMapping(dbc, bestName, structureId, locale);
        return bestName;
    }

    public void writeUser(CmsDbContext dbc, CmsUser user) throws CmsException {
        CmsUser oldUser = this.readUser(dbc, user.getId());
        this.m_monitor.clearUserCache(oldUser);
        this.getUserDriver(dbc).writeUser(dbc, user);
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.USERGROUPS, CmsMemoryMonitor.CacheType.USER_LIST);
        if (!dbc.getProjectId().isNullUUID()) {
            return;
        }
        HashMap<String, Object> eventData = new HashMap<String, Object>();
        eventData.put("userId", user.getId().toString());
        eventData.put("userName", oldUser.getName());
        eventData.put("userAction", "writeUser");
        OpenCms.fireCmsEvent(new CmsEvent(29, eventData));
    }

    protected void addOrReplaceUrlNameMapping(CmsDbContext dbc, String name, CmsUUID structureId, String locale) throws CmsDataAccessException {
        this.getVfsDriver(dbc).deleteUrlNameMappingEntries(dbc, false, CmsUrlNameMappingFilter.ALL.filterStructureId(structureId).filterLocale(locale).filterState(0));
        CmsUrlNameMappingEntry newEntry = new CmsUrlNameMappingEntry(name, structureId, 0, System.currentTimeMillis(), locale);
        this.getVfsDriver(dbc).addUrlNameMappingEntry(dbc, false, newEntry);
    }

    protected CmsFolder convertResourceToFolder(CmsResource resource) throws CmsVfsResourceNotFoundException {
        if (resource.isFolder()) {
            return new CmsFolder(resource);
        }
        throw new CmsVfsResourceNotFoundException(org.opencms.db.Messages.get().container("ERR_ACCESS_FILE_AS_FOLDER_1", resource.getRootPath()));
    }

    protected Object createDriver(CmsDbContext dbc, CmsConfigurationManager configManager, CmsParameterConfiguration config, String driverChainKey, String suffix) {
        List<String> drivers = config.getList(driverChainKey);
        String driverKey = drivers.get(0) + suffix;
        String driverName = config.get(driverKey);
        List<String> list = drivers = drivers.size() > 1 ? drivers.subList(1, drivers.size()) : null;
        if (driverName == null) {
            CmsLog.INIT.error((Object)org.opencms.db.Messages.get().getBundle().key("INIT_DRIVER_FAILED_1", driverKey));
        }
        return this.newDriverInstance(dbc, configManager, driverName, drivers);
    }

    protected void deleteRelationsWithSiblings(CmsDbContext dbc, CmsResource resource) throws CmsException {
        List<Object> siblings;
        if (resource.getSiblingCount() > 1) {
            siblings = this.readSiblings(dbc, resource, CmsResourceFilter.ALL);
        } else {
            siblings = new ArrayList<CmsResource>();
            siblings.add(resource);
        }
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        for (CmsResource cmsResource : siblings) {
            vfsDriver.deleteRelations(dbc, dbc.currentProject().getUuid(), cmsResource, CmsRelationFilter.TARGETS.filterDefinedInContent());
        }
    }

    protected void ensureSubResourcesOfMovedFoldersPublished(CmsObject cms, CmsDbContext dbc, CmsPublishList pubList) throws CmsException {
        List<CmsResource> topMovedFolders = pubList.getTopMovedFolders(cms);
        for (CmsResource folder : topMovedFolders) {
            this.addSubResources(dbc, pubList, folder);
        }
        List<CmsResource> missingSubResources = pubList.getMissingSubResources(cms, topMovedFolders);
        if (missingSubResources.isEmpty()) {
            return;
        }
        StringBuffer pathBuffer = new StringBuffer();
        for (CmsResource missing : missingSubResources) {
            pathBuffer.append(missing.getRootPath());
            pathBuffer.append(" ");
        }
        throw new CmsVfsException(org.opencms.db.Messages.get().container("RPT_CHILDREN_OF_MOVED_FOLDER_NOT_PUBLISHED_1", pathBuffer.toString()));
    }

    protected String findBestNameForUrlNameMapping(CmsDbContext dbc, Iterator<String> nameSeq, CmsUUID structureId, String locale) throws CmsDataAccessException {
        String newName;
        boolean alreadyInUse;
        block0: do {
            newName = nameSeq.next();
            alreadyInUse = false;
            CmsUrlNameMappingFilter filter = CmsUrlNameMappingFilter.ALL.filterName(newName);
            List<CmsUrlNameMappingEntry> entriesWithSameName = this.getVfsDriver(dbc).readUrlNameMappingEntries(dbc, false, filter);
            for (CmsUrlNameMappingEntry entry : entriesWithSameName) {
                boolean sameId = entry.getStructureId().equals(structureId);
                boolean sameLocale = Objects.equal((Object)entry.getLocale(), (Object)locale);
                if (sameId && sameLocale) continue;
                alreadyInUse = true;
                continue block0;
            }
        } while (alreadyInUse);
        return newName;
    }

    protected String findBestNameForUrlNameMapping(CmsDbContext dbc, String name, CmsUUID structureId) throws CmsDataAccessException {
        String numberedName;
        List<CmsUrlNameMappingEntry> entriesStartingWithName = this.getVfsDriver(dbc).readUrlNameMappingEntries(dbc, false, CmsUrlNameMappingFilter.ALL.filterNamePattern(name + "%").filterRejectStructureId(structureId));
        HashSet<String> usedNames = new HashSet<String>();
        for (CmsUrlNameMappingEntry entry : entriesStartingWithName) {
            usedNames.add(entry.getName());
        }
        int counter = 0;
        do {
            numberedName = this.getNumberedName(name, counter);
            ++counter;
        } while (usedNames.contains(numberedName));
        return numberedName;
    }

    protected CmsLockManager getLockManager() {
        return this.m_lockManager;
    }

    protected String getNumberedName(String name, int number) {
        if (number == 0) {
            return name;
        }
        PrintfFormat fmt = new PrintfFormat("%0.6d");
        return name + "_" + fmt.sprintf(number);
    }

    long countUsers(CmsDbContext dbc, CmsUserSearchParameters searchParams) throws CmsDataAccessException {
        return this.getUserDriver(dbc).countUsers(dbc, searchParams);
    }

    private void addSubResources(CmsDbContext dbc, CmsPublishList publishList, CmsResource directPublishResource) throws CmsDataAccessException {
        int flags = 8;
        if (!directPublishResource.getState().isDeleted()) {
            flags |= 2;
        }
        List<CmsResource> folderList = this.getVfsDriver(dbc).readResourceTree(dbc, dbc.currentProject().getUuid(), directPublishResource.getRootPath(), -1, CmsResource.STATE_UNCHANGED, 0L, 0L, 0L, 0L, 0L, 0L, flags | 0x40);
        publishList.addAll(this.filterResources(dbc, publishList, folderList), true);
        List<CmsResource> fileList = this.getVfsDriver(dbc).readResourceTree(dbc, dbc.currentProject().getUuid(), directPublishResource.getRootPath(), -1, CmsResource.STATE_UNCHANGED, 0L, 0L, 0L, 0L, 0L, 0L, flags | 0x80);
        publishList.addAll(this.filterResources(dbc, publishList, fileList), true);
    }

    private boolean checkDeletedParentFolder(CmsDbContext dbc, List<CmsResource> deletedFolders, CmsResource res) {
        CmsResource parent;
        String parentPath = CmsResource.getParentFolder(res.getRootPath());
        if (parentPath == null) {
            return false;
        }
        try {
            parent = this.readResource(dbc, parentPath, CmsResourceFilter.ALL);
        }
        catch (Exception e) {
            return false;
        }
        if (!parent.getState().isDeleted()) {
            return false;
        }
        for (int j = 0; j < deletedFolders.size(); ++j) {
            if (!deletedFolders.get(j).getStructureId().equals(parent.getStructureId())) continue;
            return true;
        }
        return false;
    }

    private void checkParentFolders(CmsDbContext dbc, CmsPublishList publishList) throws CmsVfsException {
        boolean directPublish = publishList.isDirectPublish();
        if (directPublish) {
            Iterator<CmsResource> it = publishList.getDirectPublishResources().iterator();
            List<String> parentFolderNames = new ArrayList<String>();
            while (it.hasNext()) {
                CmsResource res = it.next();
                String parentFolderName = CmsResource.getParentFolder(res.getRootPath());
                if (parentFolderName == null) continue;
                parentFolderNames.add(parentFolderName);
            }
            parentFolderNames = CmsFileUtil.removeRedundancies(parentFolderNames);
            String parentFolderName2 = null;
            try {
                I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
                for (String parentFolderName2 : parentFolderNames) {
                    vfsDriver.readFolder(dbc, CmsProject.ONLINE_PROJECT_ID, parentFolderName2);
                }
            }
            catch (CmsException e) {
                throw new CmsVfsException(org.opencms.db.Messages.get().container("RPT_PARENT_FOLDER_NOT_PUBLISHED_1", parentFolderName2));
            }
        }
    }

    private boolean checkParentResource(CmsDbContext dbc, List<CmsResource> folderList, CmsResource res) {
        CmsResource parent;
        String parentPath = CmsResource.getParentFolder(res.getRootPath());
        if (parentPath == null) {
            return true;
        }
        try {
            parent = this.readResource(dbc, parentPath, CmsResourceFilter.ALL);
        }
        catch (Exception e) {
            return false;
        }
        if (!parent.getState().isNew()) {
            return true;
        }
        for (int j = 0; j < folderList.size(); ++j) {
            if (!folderList.get(j).getStructureId().equals(parent.getStructureId())) continue;
            return true;
        }
        return false;
    }

    private void copyRelations(CmsDbContext dbc, CmsResource source, CmsResource target) throws CmsException {
        CmsObject cms = new CmsObject(this.getSecurityManager(), dbc.getRequestContext());
        for (CmsRelation relation : this.getRelationsForResource(dbc, source, CmsRelationFilter.TARGETS.filterNotDefinedInContent())) {
            try {
                CmsResource relTarget = relation.getTarget(cms, CmsResourceFilter.ALL);
                this.addRelationToResource(dbc, target, relTarget, relation.getType(), true);
            }
            catch (CmsVfsResourceNotFoundException e) {
                if (!LOG.isWarnEnabled()) continue;
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        this.repairCategories(dbc, this.getProjectIdForContext(dbc), target);
    }

    private List<CmsResource> filterPermissions(CmsDbContext dbc, List<CmsResource> resourceList, CmsResourceFilter filter) throws CmsException {
        if (filter.requireTimerange()) {
            filter = filter.addExcludeTimerange();
        }
        ArrayList<CmsResource> result = new ArrayList<CmsResource>(resourceList.size());
        for (int i = 0; i < resourceList.size(); ++i) {
            CmsResource currentResource = resourceList.get(i);
            if (!this.m_securityManager.hasPermissions(dbc, currentResource, CmsPermissionSet.ACCESS_READ, true, filter).isAllowed()) continue;
            result.add(currentResource);
        }
        return result;
    }

    private List<CmsResource> filterResources(CmsDbContext dbc, CmsPublishList publishList, List<CmsResource> resourceList) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        ArrayList<CmsResource> newFolderList = new ArrayList<CmsResource>(publishList == null ? resourceList : publishList.getFolderList());
        for (int i = 0; i < resourceList.size(); ++i) {
            CmsResource res = resourceList.get(i);
            try {
                CmsLock lock = this.getLock(dbc, res);
                if (lock.isPublish() || !lock.isLockableBy(dbc.currentUser()) && (!lock.isShared() || publishList == null || !res.getState().isDeleted() || !this.checkDeletedParentFolder(dbc, publishList.getDeletedFolderList(), res)) || !"/".equals(res.getRootPath()) && !this.checkParentResource(dbc, newFolderList, res)) continue;
                try {
                    this.m_securityManager.checkPermissions(dbc, res, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
                }
                catch (CmsException e) {
                    continue;
                }
                if (res.isFolder()) {
                    newFolderList.add(res);
                }
                result.add(res);
                continue;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private List<CmsResource> filterSiblings(CmsDbContext dbc, CmsPublishList publishList, Collection<CmsResource> resourceList) {
        ArrayList<CmsResource> result = new ArrayList<CmsResource>();
        for (CmsResource res : resourceList) {
            try {
                CmsLock lock = this.getLock(dbc, res);
                if (lock.isPublish() || !lock.isLockableBy(dbc.currentUser()) && (!lock.isShared() || publishList == null || !res.getState().isDeleted() || !this.checkDeletedParentFolder(dbc, publishList.getDeletedFolderList(), res)) || !"/".equals(res.getRootPath()) && !this.checkParentResource(dbc, publishList.getFolderList(), res)) continue;
                try {
                    this.m_securityManager.checkPermissions(dbc, res, CmsPermissionSet.ACCESS_DIRECT_PUBLISH, false, CmsResourceFilter.ALL);
                }
                catch (CmsException e) {
                    continue;
                }
                result.add(res);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private CmsAccessControlList getAccessControlList(CmsDbContext dbc, CmsResource resource, boolean inheritedOnly, boolean forFolder, int depth) throws CmsException {
        String cacheKey = this.getCacheKey(new String[]{inheritedOnly ? "+" : "-", forFolder ? "+" : "-", Integer.toString(depth), resource.getStructureId().toString()}, dbc);
        CmsAccessControlList acl = this.m_monitor.getCachedACL(cacheKey);
        if (acl != null && dbc.getProjectId().isNullUUID()) {
            return acl;
        }
        List<CmsAccessControlEntry> aces = this.getUserDriver(dbc).readAccessControlEntries(dbc, dbc.currentProject(), resource.getResourceId(), depth > 1 || depth > 0 && forFolder);
        boolean overwriteAll = this.sortAceList(aces);
        if (!overwriteAll) {
            CmsFolder parentResource;
            block10: {
                parentResource = null;
                try {
                    parentResource = this.getVfsDriver(dbc).readParentFolder(dbc, dbc.currentProject().getUuid(), resource.getStructureId());
                }
                catch (CmsVfsResourceNotFoundException e) {
                    String parentPath = CmsResource.getParentFolder(resource.getRootPath());
                    if (parentPath == null) break block10;
                    parentResource = this.getVfsDriver(dbc).readFolder(dbc, dbc.currentProject().getUuid(), parentPath);
                }
            }
            if (parentResource != null) {
                acl = (CmsAccessControlList)this.getAccessControlList(dbc, parentResource, inheritedOnly, forFolder, depth + 1).clone();
            }
        }
        if (acl == null) {
            acl = new CmsAccessControlList();
        }
        if (depth != 0 || !inheritedOnly) {
            for (CmsAccessControlEntry acEntry : aces) {
                if (depth > 0) {
                    acEntry.setFlags(8);
                }
                acl.add(acEntry);
                if ((acEntry.getFlags() & 4) <= 0) continue;
                acl.setAllowedPermissions(acEntry);
            }
        }
        if (dbc.getProjectId().isNullUUID()) {
            this.m_monitor.cacheACL(cacheKey, acl);
        }
        return acl;
    }

    private String getCacheKey(String prefix, boolean flag, CmsUUID projectId, String resource) {
        StringBuffer b = new StringBuffer(64);
        if (prefix != null) {
            b.append(prefix);
            b.append(flag ? (char)'+' : '-');
        }
        b.append(CmsProject.isOnlineProject(projectId) ? (char)'+' : '-');
        return b.append(resource).toString();
    }

    private String getCacheKey(String[] keys, CmsDbContext dbc) {
        if (!dbc.getProjectId().isNullUUID()) {
            return "";
        }
        StringBuffer b = new StringBuffer(64);
        int len = keys.length;
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                b.append(keys[i]);
                b.append('_');
            }
        }
        if (dbc.currentProject().isOnlineProject()) {
            b.append("+");
        } else {
            b.append("-");
        }
        return b.toString();
    }

    private CmsUUID getProjectIdForContext(CmsDbContext dbc) {
        CmsUUID projectId = dbc.getProjectId();
        if (projectId.isNullUUID()) {
            projectId = dbc.currentProject().getUuid();
        }
        return projectId;
    }

    private int getUpdateState(CmsDbContext dbc, CmsResource resource, List<CmsProperty> properties) throws CmsDataAccessException {
        int updateState = 0;
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        Iterator<CmsProperty> it = properties.iterator();
        while (it.hasNext() && updateState < 2) {
            CmsProperty property = it.next();
            CmsProperty existingProperty = vfsDriver.readPropertyObject(dbc, property.getName(), dbc.currentProject(), resource);
            if (property.getResourceValue() != null) {
                if (property.isDeleteResourceValue()) {
                    if (existingProperty.getResourceValue() != null) {
                        updateState = 2;
                    }
                } else if (existingProperty.getResourceValue() == null) {
                    updateState = 2;
                } else if (!property.getResourceValue().equals(existingProperty.getResourceValue())) {
                    updateState = 2;
                }
            }
            if (updateState != 0 || property.getStructureValue() == null) continue;
            if (property.isDeleteStructureValue()) {
                if (existingProperty.getStructureValue() == null) continue;
                updateState = 1;
                continue;
            }
            if (existingProperty.getStructureValue() == null) {
                updateState = 1;
                continue;
            }
            if (property.getStructureValue().equals(existingProperty.getStructureValue())) continue;
            updateState = 1;
        }
        return updateState;
    }

    private List<CmsGroup> getVirtualGroupsForRole(CmsDbContext dbc, CmsRole role) throws CmsException {
        HashSet<Integer> roleFlags = new HashSet<Integer>();
        Integer flags = new Integer(role.getVirtualGroupFlags());
        roleFlags.add(flags);
        for (CmsRole child : role.getChildren(true)) {
            flags = new Integer(child.getVirtualGroupFlags());
            roleFlags.add(flags);
        }
        ArrayList<CmsGroup> groups = new ArrayList<CmsGroup>();
        for (CmsGroup group : this.getGroups(dbc, this.readOrganizationalUnit(dbc, role.getOuFqn()), false, false)) {
            CmsRole r;
            if (!group.isVirtual() || !roleFlags.contains(new Integer((r = CmsRole.valueOf(group)).getVirtualGroupFlags()))) continue;
            groups.add(group);
        }
        return groups;
    }

    private List<CmsUser> internalUsersOfGroup(CmsDbContext dbc, String ouFqn, String groupname, boolean includeOtherOuUsers, boolean directUsersOnly, boolean readRoles) throws CmsException {
        CmsGroup group = this.readGroup(dbc, groupname);
        if (group == null || (readRoles || group.isRole()) && (!readRoles || !group.isRole())) {
            throw new CmsDbEntryNotFoundException(org.opencms.db.Messages.get().container("ERR_UNKNOWN_GROUP_1", groupname));
        }
        String prefix = "_" + includeOtherOuUsers + "_" + directUsersOnly + "_" + ouFqn;
        String cacheKey = this.m_keyGenerator.getCacheKeyForGroupUsers(prefix, dbc, group);
        List<CmsUser> allUsers = this.m_monitor.getCachedUserList(cacheKey);
        if (allUsers == null) {
            HashSet<CmsUser> users = new HashSet<CmsUser>(this.getUserDriver(dbc).readUsersOfGroup(dbc, groupname, includeOtherOuUsers));
            if (readRoles && !directUsersOnly) {
                String parentOu;
                block15: {
                    CmsRole role = CmsRole.valueOf(group);
                    if (role.getParentRole() != null) {
                        try {
                            String parentGroup = role.getParentRole().getGroupName();
                            this.readGroup(dbc, parentGroup);
                            users.addAll(this.internalUsersOfGroup(dbc, ouFqn, parentGroup, includeOtherOuUsers, directUsersOnly, readRoles));
                        }
                        catch (CmsDbEntryNotFoundException e) {
                            if (!LOG.isDebugEnabled()) break block15;
                            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                if ((parentOu = CmsOrganizationalUnit.getParentFqn(group.getOuFqn())) != null) {
                    users.addAll(this.internalUsersOfGroup(dbc, ouFqn, parentOu + group.getSimpleName(), includeOtherOuUsers, directUsersOnly, readRoles));
                }
            } else if (!readRoles && !directUsersOnly) {
                List<CmsGroup> groups = this.getChildren(dbc, group, false);
                for (CmsGroup parentGroup : groups) {
                    try {
                        users.addAll(this.internalUsersOfGroup(dbc, ouFqn, parentGroup.getName(), includeOtherOuUsers, directUsersOnly, readRoles));
                    }
                    catch (CmsDbEntryNotFoundException e) {
                        if (!LOG.isDebugEnabled()) continue;
                        LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
            if (!includeOtherOuUsers) {
                Iterator itUsers = users.iterator();
                while (itUsers.hasNext()) {
                    CmsUser user = (CmsUser)itUsers.next();
                    if (user.getOuFqn().equals(ouFqn)) continue;
                    itUsers.remove();
                }
            }
            allUsers = Collections.unmodifiableList(new ArrayList<CmsUser>(users));
            if (dbc.getProjectId().isNullUUID()) {
                this.m_monitor.cacheUserList(cacheKey, allUsers);
            }
        }
        return allUsers;
    }

    private List<CmsResource> readChangedResourcesInsideProject(CmsDbContext dbc, CmsUUID projectId, CmsReadChangedProjectResourceMode mode) throws CmsException {
        String cacheKey = projectId + "_" + mode.toString();
        List<CmsResource> result = this.m_monitor.getCachedProjectResources(cacheKey);
        if (result != null) {
            return result;
        }
        List<String> projectResources = this.readProjectResources(dbc, this.readProject(dbc, projectId));
        result = new ArrayList<CmsResource>();
        String currentProjectResource = null;
        ArrayList<CmsResource> resources = new ArrayList<CmsResource>();
        CmsResource currentResource = null;
        CmsLock currentLock = null;
        for (int i = 0; i < projectResources.size(); ++i) {
            currentProjectResource = projectResources.get(i);
            try {
                currentResource = this.readResource(dbc, currentProjectResource, CmsResourceFilter.ALL);
                if (currentResource.isFolder()) {
                    resources.addAll(this.readResources(dbc, currentResource, CmsResourceFilter.ALL, true));
                    continue;
                }
                resources.add(currentResource);
                continue;
            }
            catch (CmsException e) {
                if (e instanceof CmsVfsResourceNotFoundException) continue;
                throw e;
            }
        }
        for (int j = 0; j < resources.size(); ++j) {
            currentResource = (CmsResource)resources.get(j);
            currentLock = this.getLock(dbc, currentResource).getEditionLock();
            if (currentResource.getState().isUnchanged() || (!currentLock.isNullLock() || !currentResource.getProjectLastModified().equals(projectId)) && (!currentLock.isOwnedBy(dbc.currentUser()) || !currentLock.getProjectId().equals(projectId)) || mode != RCPRM_FILES_AND_FOLDERS_MODE && (!currentResource.isFolder() || mode != RCPRM_FOLDERS_ONLY_MODE) && (!currentResource.isFile() || mode != RCPRM_FILES_ONLY_MODE)) continue;
            result.add(currentResource);
        }
        resources.clear();
        resources = null;
        this.m_monitor.cacheProjectResources(cacheKey, result);
        return result;
    }

    private boolean sortAceList(List<CmsAccessControlEntry> aces) {
        Collections.sort(aces, CmsAccessControlEntry.COMPARATOR_ACE);
        for (int i = 0; i < Math.min(aces.size(), 2); ++i) {
            CmsAccessControlEntry acEntry = aces.get(i);
            if (!acEntry.getPrincipal().equals(CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID)) continue;
            return true;
        }
        return false;
    }

    private void transferPrincipalResources(CmsDbContext dbc, CmsProject project, CmsUUID principalId, CmsUUID replacementId, boolean withACEs) throws CmsException {
        I_CmsUserDriver userDriver = this.getUserDriver(dbc);
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        Set<CmsResource> resources = this.getResourcesForPrincipal(dbc, project, principalId, null, true);
        for (CmsResource resource : resources) {
            boolean attrModified = false;
            CmsUUID createdUser = null;
            if (resource.getUserCreated().equals(principalId)) {
                createdUser = replacementId;
                attrModified = true;
            }
            CmsUUID lastModUser = null;
            if (resource.getUserLastModified().equals(principalId)) {
                lastModUser = replacementId;
                attrModified = true;
            }
            if (attrModified) {
                vfsDriver.transferResource(dbc, project, resource, createdUser, lastModUser);
                this.m_monitor.clearResourceCache();
            }
            boolean aceModified = false;
            if (withACEs) {
                for (CmsAccessControlEntry ace : userDriver.readAccessControlEntries(dbc, project, resource.getResourceId(), false)) {
                    if (!ace.getPrincipal().equals(principalId)) continue;
                    CmsAccessControlEntry newAce = new CmsAccessControlEntry(ace.getResource(), replacementId, ace.getAllowedPermissions(), ace.getDeniedPermissions(), ace.getFlags());
                    userDriver.writeAccessControlEntry(dbc, project, newAce);
                    aceModified = true;
                }
                if (aceModified) {
                    this.m_monitor.clearAccessControlListCache();
                }
            }
            if (!attrModified && !aceModified) continue;
            HashMap<String, Object> data = new HashMap<String, Object>(2);
            data.put("resource", resource);
            data.put("change", new Integer((attrModified ? 8 : 0) | (aceModified ? 1 : 0)));
            OpenCms.fireCmsEvent(new CmsEvent(11, data));
        }
    }

    private void undoContentChanges(CmsDbContext dbc, CmsProject onlineProject, CmsResource offlineResource, CmsResource onlineResource, CmsResourceState newState, boolean moveUndone) throws CmsException {
        String path = moveUndone || offlineResource == null ? onlineResource.getRootPath() : offlineResource.getRootPath();
        I_CmsUserDriver userDriver = this.getUserDriver(dbc);
        I_CmsVfsDriver vfsDriver = this.getVfsDriver(dbc);
        if (onlineResource.isFolder()) {
            CmsFolder restoredFolder = new CmsFolder(onlineResource.getStructureId(), onlineResource.getResourceId(), path, onlineResource.getTypeId(), onlineResource.getFlags(), dbc.currentProject().getUuid(), newState, onlineResource.getDateCreated(), onlineResource.getUserCreated(), onlineResource.getDateLastModified(), onlineResource.getUserLastModified(), onlineResource.getDateReleased(), onlineResource.getDateExpired(), onlineResource.getVersion());
            restoredFolder.setDateLastModified(onlineResource.getDateLastModified());
            vfsDriver.writeResource(dbc, dbc.currentProject().getUuid(), restoredFolder, 0);
            vfsDriver.deletePropertyObjects(dbc, dbc.currentProject().getUuid(), restoredFolder, 1);
            List<CmsProperty> propertyInfos = vfsDriver.readPropertyObjects(dbc, onlineProject, onlineResource);
            vfsDriver.writePropertyObjects(dbc, dbc.currentProject(), restoredFolder, propertyInfos);
            userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), onlineResource.getResourceId());
            ListIterator<CmsAccessControlEntry> aceList = userDriver.readAccessControlEntries(dbc, onlineProject, onlineResource.getResourceId(), false).listIterator();
            while (aceList.hasNext()) {
                CmsAccessControlEntry ace = aceList.next();
                userDriver.createAccessControlEntry(dbc, dbc.currentProject(), onlineResource.getResourceId(), ace.getPrincipal(), ace.getPermissions().getAllowedPermissions(), ace.getPermissions().getDeniedPermissions(), ace.getFlags());
            }
        } else {
            byte[] onlineContent = vfsDriver.readContent(dbc, CmsProject.ONLINE_PROJECT_ID, onlineResource.getResourceId());
            CmsFile restoredFile = new CmsFile(onlineResource.getStructureId(), onlineResource.getResourceId(), path, onlineResource.getTypeId(), onlineResource.getFlags(), dbc.currentProject().getUuid(), newState, onlineResource.getDateCreated(), onlineResource.getUserCreated(), onlineResource.getDateLastModified(), onlineResource.getUserLastModified(), onlineResource.getDateReleased(), onlineResource.getDateExpired(), 0, onlineResource.getLength(), onlineResource.getDateContent(), onlineResource.getVersion(), onlineContent);
            restoredFile.setDateLastModified(onlineResource.getDateLastModified());
            List<CmsProperty> properties = vfsDriver.readPropertyObjects(dbc, onlineProject, onlineResource);
            if (offlineResource != null) {
                vfsDriver.deletePropertyObjects(dbc, dbc.currentProject().getUuid(), onlineResource, 1);
                this.deleteResource(dbc, offlineResource, CmsResource.DELETE_PRESERVE_SIBLINGS);
            }
            CmsResource res = this.createResource(dbc, restoredFile.getRootPath(), restoredFile, restoredFile.getContents(), properties, false);
            if (offlineResource != null) {
                userDriver.removeAccessControlEntries(dbc, dbc.currentProject(), onlineResource.getResourceId());
            }
            ListIterator<CmsAccessControlEntry> aceList = userDriver.readAccessControlEntries(dbc, onlineProject, onlineResource.getResourceId(), false).listIterator();
            while (aceList.hasNext()) {
                CmsAccessControlEntry ace = aceList.next();
                userDriver.createAccessControlEntry(dbc, dbc.currentProject(), res.getResourceId(), ace.getPrincipal(), ace.getPermissions().getAllowedPermissions(), ace.getPermissions().getDeniedPermissions(), ace.getFlags());
            }
            vfsDriver.deleteUrlNameMappingEntries(dbc, false, CmsUrlNameMappingFilter.ALL.filterStructureId(res.getStructureId()).filterState(0));
            res.setState(newState);
            this.m_vfsDriver.writeResourceState(dbc, dbc.currentProject(), res, 3, false);
        }
        if (offlineResource != null) {
            vfsDriver.deleteRelations(dbc, dbc.currentProject().getUuid(), offlineResource, CmsRelationFilter.TARGETS);
        }
        List<CmsRelation> relations = vfsDriver.readRelations(dbc, CmsProject.ONLINE_PROJECT_ID, onlineResource, CmsRelationFilter.TARGETS);
        for (CmsRelation relation : relations) {
            vfsDriver.createRelation(dbc, dbc.currentProject().getUuid(), relation);
        }
        this.m_monitor.clearResourceCache();
        this.m_monitor.flushCache(CmsMemoryMonitor.CacheType.PROPERTY, CmsMemoryMonitor.CacheType.PROPERTY_LIST);
        if (offlineResource == null || offlineResource.getRootPath().equals(onlineResource.getRootPath())) {
            this.log(dbc, new CmsLogEntry(dbc, onlineResource.getStructureId(), CmsLogEntryType.RESOURCE_RESTORED, new String[]{onlineResource.getRootPath()}), false);
        } else {
            this.log(dbc, new CmsLogEntry(dbc, offlineResource.getStructureId(), CmsLogEntryType.RESOURCE_MOVE_RESTORED, new String[]{offlineResource.getRootPath(), onlineResource.getRootPath()}), false);
        }
        if (offlineResource != null) {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", offlineResource)));
        } else {
            OpenCms.fireCmsEvent(new CmsEvent(15, Collections.singletonMap("resource", onlineResource)));
        }
    }

    private void updateContextDates(CmsDbContext dbc, CmsResource resource) {
        CmsFlexRequestContextInfo info = dbc.getFlexRequestContextInfo();
        if (info != null) {
            info.updateFromResource(resource);
        }
    }

    private List<CmsResource> updateContextDates(CmsDbContext dbc, List<CmsResource> resourceList) {
        CmsFlexRequestContextInfo info = dbc.getFlexRequestContextInfo();
        if (info != null) {
            for (int i = 0; i < resourceList.size(); ++i) {
                CmsResource resource = resourceList.get(i);
                info.updateFromResource(resource);
            }
        }
        return resourceList;
    }

    private List<CmsResource> updateContextDates(CmsDbContext dbc, List<CmsResource> resourceList, CmsResourceFilter filter) {
        if (CmsResourceFilter.ALL == filter) {
            return new ArrayList<CmsResource>(this.updateContextDates(dbc, resourceList));
        }
        CmsFlexRequestContextInfo info = dbc.getFlexRequestContextInfo();
        ArrayList<CmsResource> result = new ArrayList<CmsResource>(resourceList.size());
        for (int i = 0; i < resourceList.size(); ++i) {
            CmsResource resource = resourceList.get(i);
            if (filter.isValid(dbc.getRequestContext(), resource)) {
                result.add(resource);
            }
            if (info == null) continue;
            info.updateFromResource(resource);
        }
        return result;
    }

    private void updateState(CmsDbContext dbc, CmsResource resource, boolean resourceState) throws CmsDataAccessException {
        CmsUUID projectId = dbc.getProjectId() == null || dbc.getProjectId().isNullUUID() ? dbc.currentProject().getUuid() : dbc.getProjectId();
        resource.setUserLastModified(dbc.currentUser().getId());
        if (resourceState) {
            this.getVfsDriver(dbc).writeResource(dbc, projectId, resource, 1);
        } else {
            this.getVfsDriver(dbc).writeResource(dbc, projectId, resource, 2);
        }
    }

    private static class CmsReadChangedProjectResourceMode {
        protected CmsReadChangedProjectResourceMode() {
        }
    }

    class UrlNameMappingComparator
    implements Comparator<CmsUrlNameMappingEntry> {
        UrlNameMappingComparator() {
        }

        @Override
        public int compare(CmsUrlNameMappingEntry o1, CmsUrlNameMappingEntry o2) {
            long date2;
            long date1 = o1.getDateChanged();
            if (date1 < (date2 = o2.getDateChanged())) {
                return -1;
            }
            if (date1 > date2) {
                return 1;
            }
            return 0;
        }
    }
}

