/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsRewriteAlias;
import org.opencms.main.CmsLog;

public class CmsRewriteAliasMatcher {
    private static final Log LOG = CmsLog.getLog(CmsRewriteAliasMatcher.class);
    private List<CmsRewriteAlias> m_aliases;

    public CmsRewriteAliasMatcher(Collection<CmsRewriteAlias> aliases) {
        this.m_aliases = new ArrayList<CmsRewriteAlias>(aliases);
    }

    public RewriteResult match(String path) {
        for (CmsRewriteAlias alias : this.m_aliases) {
            try {
                Pattern pattern = Pattern.compile(alias.getPatternString());
                Matcher matcher = pattern.matcher(path);
                if (!matcher.matches()) continue;
                String newPath = matcher.replaceFirst(alias.getReplacementString());
                return new RewriteResult(newPath, alias);
            }
            catch (PatternSyntaxException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (IndexOutOfBoundsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public static class RewriteResult {
        private CmsRewriteAlias m_alias;
        private String m_newPath;

        public RewriteResult(String newPath, CmsRewriteAlias alias) {
            this.m_newPath = newPath;
            this.m_alias = alias;
        }

        public CmsRewriteAlias getAlias() {
            return this.m_alias;
        }

        public String getNewPath() {
            return this.m_newPath;
        }
    }
}

