/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db;

import java.util.Date;
import org.opencms.util.CmsUUID;

public final class CmsVisitEntryFilter
implements Cloneable {
    public static final CmsVisitEntryFilter ALL = new CmsVisitEntryFilter();
    private long m_dateFrom;
    private long m_dateTo = Long.MAX_VALUE;
    private CmsUUID m_structureId;
    private CmsUUID m_userId;

    private CmsVisitEntryFilter() {
    }

    public Object clone() {
        CmsVisitEntryFilter filter = new CmsVisitEntryFilter();
        filter.m_structureId = this.m_structureId;
        filter.m_userId = this.m_userId;
        filter.m_dateFrom = this.m_dateFrom;
        filter.m_dateTo = this.m_dateTo;
        return filter;
    }

    public CmsVisitEntryFilter filterFrom(long from) {
        CmsVisitEntryFilter filter = (CmsVisitEntryFilter)this.clone();
        filter.m_dateFrom = from;
        return filter;
    }

    public CmsVisitEntryFilter filterResource(CmsUUID structureId) {
        CmsVisitEntryFilter filter = (CmsVisitEntryFilter)this.clone();
        filter.m_structureId = structureId;
        return filter;
    }

    public CmsVisitEntryFilter filterTo(long to) {
        CmsVisitEntryFilter filter = (CmsVisitEntryFilter)this.clone();
        filter.m_dateTo = to;
        return filter;
    }

    public CmsVisitEntryFilter filterUser(CmsUUID userId) {
        CmsVisitEntryFilter filter = (CmsVisitEntryFilter)this.clone();
        filter.m_userId = userId;
        return filter;
    }

    public long getDateFrom() {
        return this.m_dateFrom;
    }

    public long getDateTo() {
        return this.m_dateTo;
    }

    public CmsUUID getStructureId() {
        return this.m_structureId;
    }

    public CmsUUID getUserId() {
        return this.m_userId;
    }

    public String toString() {
        StringBuffer str = new StringBuffer(128);
        str.append("[");
        str.append("resource").append("=").append(this.m_structureId).append(", ");
        str.append("user").append("=").append(this.m_userId).append(", ");
        str.append("from").append("=").append(new Date(this.m_dateFrom)).append(", ");
        str.append("to").append("=").append(new Date(this.m_dateTo));
        str.append("]");
        return str.toString();
    }
}

