/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.util.List;
import java.util.Locale;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.tagext.Tag;
import javax.servlet.jsp.tagext.TagSupport;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.I_CmsXmlContentContainer;
import org.opencms.jsp.Messages;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;

public class CmsJspTagContentLoop
extends TagSupport
implements I_CmsXmlContentContainer {
    private static final long serialVersionUID = 8832749526732064836L;
    private transient I_CmsXmlContentContainer m_container;
    private transient I_CmsXmlDocument m_content;
    private String m_currentElement;
    private String m_element;
    private boolean m_firstLoop;
    private int m_index = -1;
    private Locale m_locale;

    public CmsJspTagContentLoop() {
    }

    public CmsJspTagContentLoop(I_CmsXmlContentContainer container, String element) {
        this.m_element = element;
        this.init(container);
    }

    public int doAfterBody() {
        if (this.hasMoreResources()) {
            return 2;
        }
        return 0;
    }

    public int doEndTag() {
        this.release();
        return 6;
    }

    public int doStartTag() throws JspException {
        Tag ancestor = CmsJspTagContentLoop.findAncestorWithClass((Tag)this, I_CmsXmlContentContainer.class);
        if (ancestor == null) {
            CmsMessageContainer errMsgContainer = Messages.get().container("ERR_PARENTLESS_TAG_1", "contentloop");
            String msg = Messages.getLocalizedMessage(errMsgContainer, this.pageContext);
            throw new JspTagException(msg);
        }
        I_CmsXmlContentContainer container = (I_CmsXmlContentContainer)ancestor;
        this.init(container);
        if (this.hasMoreResources()) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getCollectorName() {
        return this.m_container.getCollectorName();
    }

    @Override
    public String getCollectorParam() {
        return this.m_container.getCollectorParam();
    }

    @Override
    public List<CmsResource> getCollectorResult() {
        return this.m_container.getCollectorResult();
    }

    public String getElement() {
        return this.m_element != null ? this.m_element : "";
    }

    @Override
    public CmsResource getResource() {
        return this.m_content.getFile();
    }

    @Override
    public String getResourceName() {
        return this.m_container.getResourceName();
    }

    @Override
    public I_CmsXmlDocument getXmlDocument() {
        return this.m_content;
    }

    @Override
    public String getXmlDocumentElement() {
        return this.m_currentElement;
    }

    @Override
    public Locale getXmlDocumentLocale() {
        return this.m_locale;
    }

    @Override
    @Deprecated
    public boolean hasMoreContent() {
        return this.hasMoreResources();
    }

    @Override
    public boolean hasMoreResources() {
        if (this.m_firstLoop) {
            this.m_firstLoop = false;
        } else {
            ++this.m_index;
        }
        if (this.m_content.hasValue(this.m_element, this.m_locale, this.m_index)) {
            this.m_currentElement = CmsXmlUtils.createXpath(this.m_element, this.m_index + 1);
            return true;
        }
        return false;
    }

    @Override
    public boolean isPreloader() {
        return this.m_container.isPreloader();
    }

    public void release() {
        this.m_element = null;
        this.m_currentElement = null;
        this.m_content = null;
        this.m_locale = null;
        this.m_container = null;
        this.m_index = 0;
        super.release();
    }

    public void setElement(String element) {
        this.m_element = element;
    }

    protected void init(I_CmsXmlContentContainer container) {
        this.m_container = container;
        this.m_element = CmsXmlUtils.concatXpath(this.m_container.getXmlDocumentElement(), this.m_element);
        this.m_content = this.m_container.getXmlDocument();
        this.m_locale = this.m_container.getXmlDocumentLocale();
        this.m_index = 0;
        this.m_currentElement = null;
        this.m_firstLoop = true;
    }
}

