/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.commons.logging.Log;
import org.opencms.ade.containerpage.shared.CmsFormatterConfig;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.CmsHistoryResourceHandler;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.jsp.CmsJspTagContainer;
import org.opencms.jsp.CmsJspTagLink;
import org.opencms.jsp.I_CmsJspTagParamParent;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsJspTagHeadIncludes
extends BodyTagSupport
implements I_CmsJspTagParamParent {
    public static final String TYPE_CSS = "css";
    public static final String TYPE_JAVASCRIPT = "javascript";
    private static final Log LOG = CmsLog.getLog(CmsJspTagHeadIncludes.class);
    private static final long serialVersionUID = 5496349529835666345L;
    private String m_closeTags;
    private String m_defaults;
    private String m_detailType;
    private String m_detailWidth;
    private Map<String, String[]> m_parameterMap;
    private String m_type;

    public static void addParameter(Map<String, String[]> parameters, String name, String value, boolean overwrite) {
        if (parameters == null || name == null || value == null) {
            return;
        }
        if (parameters.containsKey(name) && !overwrite) {
            String[] values = parameters.get(name);
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = value;
            parameters.put(name, newValues);
        } else {
            String[] values = new String[]{value};
            parameters.put(name, values);
        }
    }

    @Override
    public void addParameter(String name, String value) {
        if (name == null || value == null) {
            return;
        }
        if (this.m_parameterMap == null) {
            this.m_parameterMap = new HashMap<String, String[]>();
        }
        CmsJspTagHeadIncludes.addParameter(this.m_parameterMap, name, value, false);
    }

    public int doEndTag() throws JspException {
        ServletRequest req = this.pageContext.getRequest();
        CmsFlexController controller = CmsFlexController.getController(req);
        CmsObject cms = controller.getCmsObject();
        try {
            if (TYPE_CSS.equals(this.m_type)) {
                this.tagCssAction(cms, req);
            }
            if (TYPE_JAVASCRIPT.equals(this.m_type)) {
                this.tagJSAction(cms, req);
            }
        }
        catch (Exception e) {
            throw new JspException((Throwable)e);
        }
        finally {
            this.m_parameterMap = null;
        }
        return 6;
    }

    public int doStartTag() {
        return 2;
    }

    public String getDefaults() {
        return this.m_defaults;
    }

    public String getDetailtype() {
        return this.m_detailType;
    }

    public String getDetailwidth() {
        return this.m_detailWidth;
    }

    public String getType() {
        return this.m_type;
    }

    public void setClosetags(String closeTags) {
        this.m_closeTags = closeTags;
    }

    public void setDefaults(String defaults) {
        this.m_defaults = defaults;
    }

    public void setDetailtype(String detailType) {
        this.m_detailType = detailType;
    }

    public void setDetailwidth(String detailWidth) {
        this.m_detailWidth = detailWidth;
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public boolean shouldCloseTags() {
        if (this.m_closeTags == null) {
            return true;
        }
        return Boolean.parseBoolean(this.m_closeTags);
    }

    public void tagCssAction(CmsObject cms, ServletRequest req) throws CmsException, IOException {
        StringBuffer inline;
        CmsJspStandardContextBean standardContext = this.getStandardContext(cms, req);
        CmsContainerPageBean containerPage = standardContext.getPage();
        LinkedHashSet<String> cssIncludes = new LinkedHashSet<String>();
        LinkedHashMap<String, String> inlineCss = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_defaults)) {
            String[] defaults = this.m_defaults.split("\\|");
            for (int i = 0; i < defaults.length; ++i) {
                cssIncludes.add(defaults[i]);
            }
        }
        if (containerPage != null && containerPage.getElements() != null) {
            Map<CmsUUID, I_CmsFormatterBean> formatters = OpenCms.getADEManager().getCachedFormatters(standardContext.getIsOnlineProject()).getFormatters();
            for (CmsContainerBean container : containerPage.getContainers().values()) {
                for (CmsContainerElementBean element : container.getElements()) {
                    try {
                        element.initResource(cms);
                        if (standardContext.getIsOnlineProject() && !element.getResource().isReleasedAndNotExpired(cms.getRequestContext().getRequestTime())) continue;
                        if (element.isGroupContainer(cms) || element.isInheritedContainer(cms)) {
                            List<CmsContainerElementBean> subElements = element.isGroupContainer(cms) ? CmsJspTagContainer.getGroupContainerElements(cms, element, req, container.getType()) : CmsJspTagContainer.getInheritedContainerElements(cms, element);
                            for (CmsContainerElementBean subElement : subElements) {
                                subElement.initResource(cms);
                                if (standardContext.getIsOnlineProject() && !subElement.getResource().isReleasedAndNotExpired(cms.getRequestContext().getRequestTime())) continue;
                                I_CmsFormatterBean formatter = this.getFormatterBeanForElement(subElement, container, formatters);
                                if (formatter != null) {
                                    cssIncludes.addAll(formatter.getCssHeadIncludes());
                                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineCss())) continue;
                                    inlineCss.put(formatter.getId(), formatter.getInlineCss());
                                    continue;
                                }
                                cssIncludes.addAll(this.getCSSHeadIncludes(cms, subElement.getResource()));
                            }
                            continue;
                        }
                        I_CmsFormatterBean formatter = this.getFormatterBeanForElement(element, container, formatters);
                        if (formatter != null) {
                            cssIncludes.addAll(formatter.getCssHeadIncludes());
                            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineCss())) continue;
                            inlineCss.put(formatter.getId(), formatter.getInlineCss());
                            continue;
                        }
                        cssIncludes.addAll(this.getCSSHeadIncludes(cms, element.getResource()));
                    }
                    catch (CmsException e) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", element.getSitePath()), (Throwable)e);
                    }
                }
            }
        }
        if (standardContext.getDetailContentId() != null) {
            try {
                CmsResource detailContent = cms.readResource(standardContext.getDetailContentId());
                CmsFormatterConfiguration config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri()).getFormatters(cms, detailContent);
                boolean requiresAllIncludes = true;
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getDetailtype()) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getDetailwidth())) {
                    try {
                        int width = Integer.parseInt(this.getDetailwidth());
                        I_CmsFormatterBean formatter = config.getDetailFormatter(this.getDetailtype(), width);
                        cssIncludes.addAll(formatter.getCssHeadIncludes());
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineCss())) {
                            inlineCss.put(formatter.getId(), formatter.getInlineCss());
                        }
                        requiresAllIncludes = false;
                    }
                    catch (NumberFormatException ne) {
                        // empty catch block
                    }
                }
                if (requiresAllIncludes) {
                    for (I_CmsFormatterBean formatter : config.getDetailFormatters()) {
                        cssIncludes.addAll(formatter.getCssHeadIncludes());
                        if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineCss())) continue;
                        inlineCss.put(formatter.getId(), formatter.getInlineCss());
                    }
                }
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", standardContext.getDetailContentId()), (Throwable)e);
            }
        }
        for (String cssUri : cssIncludes) {
            this.pageContext.getOut().print("\n<link rel=\"stylesheet\" href=\"" + CmsJspTagLink.linkTagAction(cssUri.trim(), req) + this.generateReqParams() + "\" type=\"text/css\">");
            if (!this.shouldCloseTags()) continue;
            this.pageContext.getOut().print("</link>");
        }
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            if (!inlineCss.isEmpty()) {
                inline = new StringBuffer("\n<style type=\"text/css\">\n");
                for (Map.Entry cssEntry : inlineCss.entrySet()) {
                    inline.append((String)cssEntry.getValue()).append("\n\n");
                }
                inline.append("\n</style>\n");
                this.pageContext.getOut().print(inline.toString());
            }
        } else {
            inline = new StringBuffer();
            for (Map.Entry cssEntry : inlineCss.entrySet()) {
                inline.append("\n<style type=\"text/css\" rel=\"" + (String)cssEntry.getKey() + "\">\n");
                inline.append((String)cssEntry.getValue()).append("\n\n");
                inline.append("\n</style>\n");
            }
            this.pageContext.getOut().print(inline.toString());
        }
    }

    public void tagJSAction(CmsObject cms, ServletRequest req) throws CmsException, IOException {
        CmsJspStandardContextBean standardContext = this.getStandardContext(cms, req);
        CmsContainerPageBean containerPage = standardContext.getPage();
        LinkedHashSet<String> jsIncludes = new LinkedHashSet<String>();
        LinkedHashMap<String, String> inlineJS = new LinkedHashMap<String, String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_defaults)) {
            String[] defaults = this.m_defaults.split("\\|");
            for (int i = 0; i < defaults.length; ++i) {
                jsIncludes.add(defaults[i]);
            }
        }
        if (containerPage != null && containerPage.getElements() != null) {
            Map<CmsUUID, I_CmsFormatterBean> formatters = OpenCms.getADEManager().getCachedFormatters(standardContext.getIsOnlineProject()).getFormatters();
            for (CmsContainerBean container : containerPage.getContainers().values()) {
                for (CmsContainerElementBean element : container.getElements()) {
                    try {
                        element.initResource(cms);
                        if (standardContext.getIsOnlineProject() && !element.getResource().isReleasedAndNotExpired(cms.getRequestContext().getRequestTime())) continue;
                        if (element.isGroupContainer(cms) || element.isInheritedContainer(cms)) {
                            List<CmsContainerElementBean> subElements = element.isGroupContainer(cms) ? CmsJspTagContainer.getGroupContainerElements(cms, element, req, container.getType()) : CmsJspTagContainer.getInheritedContainerElements(cms, element);
                            for (CmsContainerElementBean subElement : subElements) {
                                subElement.initResource(cms);
                                if (standardContext.getIsOnlineProject() && !subElement.getResource().isReleasedAndNotExpired(cms.getRequestContext().getRequestTime())) continue;
                                I_CmsFormatterBean formatter = this.getFormatterBeanForElement(subElement, container, formatters);
                                if (formatter != null) {
                                    jsIncludes.addAll(formatter.getJavascriptHeadIncludes());
                                    if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineJavascript())) continue;
                                    inlineJS.put(formatter.getId(), formatter.getInlineJavascript());
                                    continue;
                                }
                                jsIncludes.addAll(this.getJSHeadIncludes(cms, subElement.getResource()));
                            }
                            continue;
                        }
                        I_CmsFormatterBean formatter = this.getFormatterBeanForElement(element, container, formatters);
                        if (formatter != null) {
                            jsIncludes.addAll(formatter.getJavascriptHeadIncludes());
                            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(formatter.getInlineJavascript())) continue;
                            inlineJS.put(formatter.getId(), formatter.getInlineJavascript());
                            continue;
                        }
                        jsIncludes.addAll(this.getJSHeadIncludes(cms, element.getResource()));
                    }
                    catch (CmsException e) {
                        LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", element.getSitePath()), (Throwable)e);
                    }
                }
            }
        }
        if (standardContext.getDetailContentId() != null) {
            try {
                CmsResource detailContent = cms.readResource(standardContext.getDetailContentId());
                CmsFormatterConfiguration config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri()).getFormatters(cms, detailContent);
                boolean requiresAllIncludes = true;
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getDetailtype()) && CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getDetailwidth())) {
                    try {
                        int width = Integer.parseInt(this.getDetailwidth());
                        jsIncludes.addAll(config.getDetailFormatter(this.getDetailtype(), width).getCssHeadIncludes());
                        requiresAllIncludes = false;
                    }
                    catch (NumberFormatException ne) {
                        // empty catch block
                    }
                }
                if (requiresAllIncludes) {
                    for (I_CmsFormatterBean formatter : config.getDetailFormatters()) {
                        jsIncludes.addAll(formatter.getJavascriptHeadIncludes());
                    }
                }
            }
            catch (CmsException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_READING_REQUIRED_RESOURCE_1", standardContext.getDetailContentId()), (Throwable)e);
            }
        }
        for (String jsUri : jsIncludes) {
            this.pageContext.getOut().print("\n<script type=\"text/javascript\" src=\"" + CmsJspTagLink.linkTagAction(jsUri.trim(), req) + this.generateReqParams() + "\"></script>");
        }
        if (!inlineJS.isEmpty()) {
            StringBuffer inline = new StringBuffer("\n<script type=\"text/javascript\">\n");
            for (Map.Entry jsEntry : inlineJS.entrySet()) {
                inline.append((String)jsEntry.getValue()).append("\n\n");
            }
            inline.append("\n</script>\n");
            this.pageContext.getOut().print(inline.toString());
        }
    }

    private String generateReqParams() throws UnsupportedEncodingException {
        String params = "";
        if (this.m_parameterMap != null && !this.m_parameterMap.isEmpty()) {
            for (Map.Entry<String, String[]> paramEntry : this.m_parameterMap.entrySet()) {
                if (paramEntry.getValue() == null) continue;
                for (int i = 0; i < paramEntry.getValue().length; ++i) {
                    params = params + "&" + paramEntry.getKey() + "=" + URLEncoder.encode(paramEntry.getValue()[i], "UTF-8");
                }
            }
            params = "?" + params.substring(1);
        }
        return params;
    }

    private Set<String> getCSSHeadIncludes(CmsObject cms, CmsResource resource) {
        if (CmsResourceTypeXmlContent.isXmlContent(resource)) {
            try {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
                return contentDefinition.getContentHandler().getCSSHeadIncludes(cms, resource);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    private I_CmsFormatterBean getFormatterBeanForElement(CmsContainerElementBean element, CmsContainerBean container, Map<CmsUUID, I_CmsFormatterBean> formatters) {
        String formatterConfigId;
        I_CmsFormatterBean result = null;
        String string = formatterConfigId = element.getSettings() != null ? element.getSettings().get(CmsFormatterConfig.getSettingsKeyForContainer(container.getName())) : null;
        if (CmsUUID.isValidUUID(formatterConfigId)) {
            result = formatters.get(new CmsUUID(formatterConfigId));
        }
        return result;
    }

    private Set<String> getJSHeadIncludes(CmsObject cms, CmsResource resource) throws CmsLoaderException {
        I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
        if (resType instanceof CmsResourceTypeXmlContent) {
            try {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
                return contentDefinition.getContentHandler().getJSHeadIncludes(cms, resource);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.emptySet();
    }

    private CmsJspStandardContextBean getStandardContext(CmsObject cms, ServletRequest req) throws CmsException {
        String requestUri = cms.getRequestContext().getUri();
        CmsJspStandardContextBean standardContext = CmsJspStandardContextBean.getInstance(req);
        CmsContainerPageBean containerPage = standardContext.getPage();
        if (containerPage == null) {
            CmsResource pageResource = (CmsResource)((Object)CmsHistoryResourceHandler.getHistoryResource(req));
            if (pageResource == null) {
                pageResource = cms.readResource(requestUri);
            }
            CmsXmlContainerPage xmlContainerPage = CmsXmlContainerPageFactory.unmarshal(cms, pageResource, req);
            containerPage = xmlContainerPage.getContainerPage(cms, cms.getRequestContext().getLocale());
            standardContext.setPage(containerPage);
        }
        return standardContext;
    }
}

