/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.jsp.util;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import org.apache.commons.collections.Transformer;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEManager;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.detailpage.CmsDetailPageResourceHandler;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.flex.CmsFlexRequest;
import org.opencms.jsp.CmsJspBean;
import org.opencms.jsp.CmsJspTagEditable;
import org.opencms.jsp.Messages;
import org.opencms.jsp.util.CmsDynamicFunctionBeanWrapper;
import org.opencms.jsp.util.CmsDynamicFunctionFormatWrapper;
import org.opencms.jsp.util.CmsJspContentAccessBean;
import org.opencms.jsp.util.CmsJspVfsAccessBean;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsCollectionsGenericWrapper;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionBean;
import org.opencms.xml.containerpage.CmsDynamicFunctionParser;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public final class CmsJspStandardContextBean {
    public static final String ATTRIBUTE_CMS_OBJECT = "__cmsObject";
    public static final String ATTRIBUTE_NAME = "cms";
    protected static final Log LOG = CmsLog.getLog(CmsJspStandardContextBean.class);
    protected CmsObject m_cms;
    private CmsContainerBean m_container;
    private CmsResource m_detailContentResource;
    private CmsContainerPageBean m_detailOnlyPage;
    private boolean m_edited;
    private CmsContainerElementBean m_element;
    private Object m_function;
    private CmsContainerPageBean m_page;
    private ServletRequest m_request;
    private CmsJspVfsAccessBean m_vfsBean;

    private CmsJspStandardContextBean() {
    }

    private CmsJspStandardContextBean(ServletRequest req) {
        CmsFlexController controller = CmsFlexController.getController(req);
        this.m_request = req;
        CmsObject cms = controller != null ? controller.getCmsObject() : (CmsObject)req.getAttribute(ATTRIBUTE_CMS_OBJECT);
        if (cms == null) {
            throw new CmsRuntimeException(Messages.get().container("ERR_MISSING_CMS_CONTROLLER_1", CmsJspBean.class.getName()));
        }
        this.updateCmsObject(cms);
        this.m_detailContentResource = CmsDetailPageResourceHandler.getDetailResource(req);
    }

    public static CmsJspStandardContextBean getInstance(ServletRequest req) {
        CmsJspStandardContextBean result;
        Object attribute = req.getAttribute(ATTRIBUTE_NAME);
        if (attribute != null && attribute instanceof CmsJspStandardContextBean) {
            result = (CmsJspStandardContextBean)attribute;
        } else {
            result = new CmsJspStandardContextBean(req);
            req.setAttribute(ATTRIBUTE_NAME, (Object)result);
        }
        return result;
    }

    public CmsJspStandardContextBean createCopy() {
        CmsJspStandardContextBean result = new CmsJspStandardContextBean();
        result.m_container = this.getContainer();
        if (this.getDetailContent() != null) {
            result.m_detailContentResource = this.getDetailContent().getCopy();
        }
        result.m_element = this.getElement();
        result.m_page = this.getPage();
        return result;
    }

    public String elementCachingHash() {
        if (this.m_element != null && this.m_container != null) {
            return this.m_element.editorHash() + "w:" + this.m_container.getWidth() + "cName:" + this.m_container.getName() + "cType:" + this.m_container.getType();
        }
        return "";
    }

    public CmsContainerBean getContainer() {
        return this.m_container;
    }

    public CmsResource getDetailContent() {
        return this.m_detailContentResource;
    }

    public CmsUUID getDetailContentId() {
        return this.m_detailContentResource == null ? null : this.m_detailContentResource.getStructureId();
    }

    public String getDetailContentSitePath() {
        return this.m_cms == null || this.m_detailContentResource == null ? null : this.m_cms.getSitePath(this.m_detailContentResource);
    }

    public CmsContainerPageBean getDetailOnlyPage() {
        return this.m_detailOnlyPage;
    }

    public CmsContainerElementBean getElement() {
        return this.m_element;
    }

    public Object getFunction() {
        if (this.m_function != null) {
            return this.m_function;
        }
        Transformer transformer = new Transformer(){

            public Object transform(Object key) {
                try {
                    CmsDynamicFunctionBean dynamicFunction = CmsJspStandardContextBean.this.readDynamicFunctionBean((String)key);
                    CmsDynamicFunctionBeanWrapper wrapper = new CmsDynamicFunctionBeanWrapper(CmsJspStandardContextBean.this.m_cms, dynamicFunction);
                    return wrapper;
                }
                catch (CmsException e) {
                    return new CmsDynamicFunctionBeanWrapper(CmsJspStandardContextBean.this.m_cms, null);
                }
            }
        };
        this.m_function = CmsCollectionsGenericWrapper.createLazyMap(transformer);
        return this.m_function;
    }

    public Map<String, String> getFunctionDetail() {
        Transformer transformer = new Transformer(){

            public Object transform(Object key) {
                String detailType = "function@" + key;
                CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(CmsJspStandardContextBean.this.m_cms, CmsJspStandardContextBean.this.m_cms.addSiteRoot(CmsJspStandardContextBean.this.m_cms.getRequestContext().getUri()));
                List<CmsDetailPageInfo> detailPages = config.getDetailPagesForType(detailType);
                if (detailPages == null || detailPages.size() == 0) {
                    return "";
                }
                CmsDetailPageInfo mainDetailPage = detailPages.get(0);
                CmsUUID id = mainDetailPage.getId();
                try {
                    CmsResource detailRes = CmsJspStandardContextBean.this.m_cms.readResource(id);
                    return OpenCms.getLinkManager().substituteLink(CmsJspStandardContextBean.this.m_cms, detailRes);
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return "";
                }
            }
        };
        return CmsCollectionsGenericWrapper.createLazyMap(transformer);
    }

    public Map<CmsJspContentAccessBean, CmsDynamicFunctionFormatWrapper> getFunctionFormatFromContent() {
        Transformer transformer = new Transformer(){

            public Object transform(Object contentAccess) {
                CmsXmlContent content = (CmsXmlContent)((CmsJspContentAccessBean)contentAccess).getRawContent();
                CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
                CmsDynamicFunctionBean functionBean = null;
                try {
                    functionBean = parser.parseFunctionBean(CmsJspStandardContextBean.this.m_cms, content);
                }
                catch (CmsException e) {
                    return new CmsDynamicFunctionFormatWrapper(CmsJspStandardContextBean.this.m_cms, null);
                }
                String type = CmsJspStandardContextBean.this.getContainer().getType();
                String width = CmsJspStandardContextBean.this.getContainer().getWidth();
                int widthNum = -1;
                try {
                    widthNum = Integer.parseInt(width);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                CmsDynamicFunctionBean.Format format = functionBean.getFormatForContainer(CmsJspStandardContextBean.this.m_cms, type, widthNum);
                CmsDynamicFunctionFormatWrapper wrapper = new CmsDynamicFunctionFormatWrapper(CmsJspStandardContextBean.this.m_cms, format);
                return wrapper;
            }
        };
        return CmsCollectionsGenericWrapper.createLazyMap(transformer);
    }

    public boolean getIsEditMode() {
        return CmsJspTagEditable.isEditableRequest(this.m_request);
    }

    public boolean getIsOnlineProject() {
        return this.m_cms.getRequestContext().getCurrentProject().isOnlineProject();
    }

    public Locale getLocale() {
        return this.getRequestContext().getLocale();
    }

    public CmsContainerPageBean getPage() {
        return this.m_page;
    }

    public Map<String, String> getPreviewFormatter() {
        Transformer transformer = new Transformer(){

            public Object transform(Object uri) {
                try {
                    String rootPath = CmsJspStandardContextBean.this.m_cms.getRequestContext().addSiteRoot((String)uri);
                    CmsResource resource = CmsJspStandardContextBean.this.m_cms.readResource((String)uri);
                    CmsADEManager adeManager = OpenCms.getADEManager();
                    CmsADEConfigData configData = adeManager.lookupConfiguration(CmsJspStandardContextBean.this.m_cms, rootPath);
                    CmsFormatterConfiguration formatterConfig = configData.getFormatters(CmsJspStandardContextBean.this.m_cms, resource);
                    if (formatterConfig == null) {
                        return "";
                    }
                    I_CmsFormatterBean previewFormatter = formatterConfig.getPreviewFormatter();
                    if (previewFormatter == null) {
                        return "";
                    }
                    CmsUUID structureId = previewFormatter.getJspStructureId();
                    CmsJspStandardContextBean.this.m_cms.readResource(structureId);
                    CmsResource formatterResource = CmsJspStandardContextBean.this.m_cms.readResource(structureId);
                    String formatterSitePath = CmsJspStandardContextBean.this.m_cms.getRequestContext().removeSiteRoot(formatterResource.getRootPath());
                    return formatterSitePath;
                }
                catch (CmsException e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return "";
                }
            }
        };
        return CmsCollectionsGenericWrapper.createLazyMap(transformer);
    }

    public CmsRequestContext getRequestContext() {
        return this.m_cms.getRequestContext();
    }

    public String getSubSitePath() {
        return this.m_cms.getRequestContext().removeSiteRoot(OpenCms.getADEManager().getSubSiteRoot(this.m_cms, this.m_cms.getRequestContext().getRootUri()));
    }

    public TemplateBean getTemplate() {
        TemplateBean templateBean = (TemplateBean)this.getRequestAttribute("ATTR_TEMPLATE_BEAN");
        if (templateBean == null) {
            templateBean = new TemplateBean("", "");
        }
        return templateBean;
    }

    public String getTitle() {
        String result = null;
        try {
            CmsResource res;
            CmsFile file;
            CmsXmlContent content;
            if (this.isDetailRequest() && (result = (content = CmsXmlContentFactory.unmarshal(this.m_cms, file = this.m_cms.readFile(res = this.getDetailContent()))).getHandler().getTitleMapping(this.m_cms, content, this.m_cms.getRequestContext().getLocale())) == null) {
                result = this.m_cms.readPropertyObject(res, "Title", false).getValue();
            }
            if (result == null) {
                result = this.m_cms.readPropertyObject(this.m_cms.getRequestContext().getUri(), "Title", true).getValue();
            }
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = "";
        }
        return result;
    }

    public CmsJspVfsAccessBean getVfs() {
        if (this.m_vfsBean == null) {
            this.m_vfsBean = CmsJspVfsAccessBean.create(this.m_cms);
        }
        return this.m_vfsBean;
    }

    public Locale getWorkplaceLocale() {
        return OpenCms.getWorkplaceManager().getWorkplaceLocale(this.m_cms);
    }

    public boolean isDetailPageAvailable() {
        if (this.m_cms == null) {
            return false;
        }
        CmsContainerElementBean element = this.getElement();
        if (element == null) {
            return false;
        }
        if (element.isInMemoryOnly()) {
            return false;
        }
        CmsResource res = element.getResource();
        if (res == null) {
            return false;
        }
        try {
            String detailPage = OpenCms.getADEManager().getDetailPageFinder().getDetailPage(this.m_cms, res.getRootPath(), this.m_cms.getRequestContext().getUri());
            return detailPage != null;
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public boolean isDetailRequest() {
        return this.m_detailContentResource != null;
    }

    public boolean isEdited() {
        return this.m_edited;
    }

    public void setContainer(CmsContainerBean container) {
        this.m_container = container;
    }

    public void setDetailOnlyPage(CmsContainerPageBean detailOnlyPage) {
        this.m_detailOnlyPage = detailOnlyPage;
    }

    public void setEdited(boolean edited) {
        this.m_edited = edited;
    }

    public void setElement(CmsContainerElementBean element) {
        this.m_element = element;
    }

    public void setPage(CmsContainerPageBean page) {
        this.m_page = page;
    }

    public void updateCmsObject(CmsObject cms) {
        try {
            this.m_cms = OpenCms.initCmsObject(cms);
        }
        catch (CmsException e) {
            this.m_cms = cms;
        }
    }

    public void updateRequestData(CmsFlexRequest cmsFlexRequest) {
        CmsResource detailRes;
        this.m_detailContentResource = detailRes = CmsDetailPageResourceHandler.getDetailResource((ServletRequest)cmsFlexRequest);
        this.m_request = cmsFlexRequest;
    }

    protected CmsDynamicFunctionBean readDynamicFunctionBean(String configuredName) throws CmsException {
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.m_cms, this.m_cms.addSiteRoot(this.m_cms.getRequestContext().getUri()));
        CmsFunctionReference functionRef = config.getFunctionReference(configuredName);
        if (functionRef == null) {
            return null;
        }
        CmsDynamicFunctionParser parser = new CmsDynamicFunctionParser();
        CmsResource functionResource = this.m_cms.readResource(functionRef.getStructureId());
        CmsDynamicFunctionBean result = parser.parseFunctionBean(this.m_cms, functionResource);
        return result;
    }

    private <A> A getRequestAttribute(String name) {
        Object attribute = this.m_request.getAttribute(name);
        return (A)(attribute != null ? attribute : null);
    }

    public static class TemplateBean {
        private boolean m_forced;
        private String m_name;
        private CmsResource m_resource;
        private String m_uri;

        public TemplateBean(String name, CmsResource resource) {
            this.m_resource = resource;
            this.m_name = name;
        }

        public TemplateBean(String name, String uri) {
            this.m_name = name;
            this.m_uri = uri;
        }

        public String getName() {
            return this.m_name;
        }

        public CmsResource getResource() {
            return this.m_resource;
        }

        public String getUri() {
            if (this.m_resource != null) {
                return this.m_resource.getRootPath();
            }
            return this.m_uri;
        }

        public boolean isForced() {
            return this.m_forced;
        }

        public void setForced(boolean forced) {
            this.m_forced = forced;
        }
    }
}

