/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.loader;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.util.CmsJspStandardContextBean;
import org.opencms.loader.CmsLoaderException;
import org.opencms.loader.CmsTemplateContext;
import org.opencms.loader.CmsTemplateLoaderFacade;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.loader.I_CmsResourceStringDumpLoader;
import org.opencms.loader.Messages;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.I_CmsXmlDocument;

abstract class A_CmsXmlDocumentLoader
implements I_CmsResourceLoader,
I_CmsResourceStringDumpLoader {
    A_CmsXmlDocumentLoader() {
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
    }

    @Override
    public void destroy() {
    }

    @Override
    public byte[] dump(CmsObject cms, CmsResource resource, String element, Locale selectedLocale, HttpServletRequest req, HttpServletResponse res) throws CmsException, IOException {
        if (element == null || selectedLocale == null) {
            throw new CmsLoaderException(Messages.get().container("ERR_LOADER_XML_NEED_ELEMENT_LOCALE_1", resource.getRootPath()));
        }
        String value = this.dumpAsString(cms, resource, element, selectedLocale, (ServletRequest)req, (ServletResponse)res);
        if (value != null) {
            I_CmsXmlDocument doc = this.unmarshalXmlDocument(cms, resource, (ServletRequest)req);
            return value.getBytes(doc.getEncoding());
        }
        return new byte[0];
    }

    @Override
    public String dumpAsString(CmsObject cms, CmsResource resource, String element, Locale selectedLocale, ServletRequest req, ServletResponse res) throws CmsException {
        I_CmsXmlDocument doc = this.unmarshalXmlDocument(cms, resource, req);
        List<Locale> locales = doc.getLocales(element);
        if (locales.isEmpty()) {
            return null;
        }
        Locale locale = OpenCms.getLocaleManager().getBestMatchingLocale(selectedLocale, OpenCms.getLocaleManager().getDefaultLocales(cms, cms.getSitePath(resource)), locales);
        if (locale == null) {
            throw new CmsLoaderException(Messages.get().container("ERR_LOADER_UNKNOWN_LOCALE_5", new Object[]{resource.getRootPath(), element, selectedLocale, CmsLocaleManager.getLocaleNames(locales), CmsLocaleManager.getLocaleNames(OpenCms.getLocaleManager().getDefaultLocales(cms, cms.getSitePath(resource)))}));
        }
        return doc.getStringValue(cms, element, locale);
    }

    @Override
    public byte[] export(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        CmsTemplateLoaderFacade loaderFacade = OpenCms.getResourceManager().getTemplateLoaderFacade(cms, req, resource, this.getTemplatePropertyDefinition());
        return loaderFacade.getLoader().export(cms, loaderFacade.getLoaderStartResource(), req, res);
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        return null;
    }

    @Override
    public void initConfiguration() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_LOADER_INITIALIZED_1", this.getClass().getName()));
        }
    }

    @Override
    public boolean isStaticExportEnabled() {
        return true;
    }

    @Override
    public boolean isStaticExportProcessable() {
        return true;
    }

    @Override
    public boolean isUsableForTemplates() {
        return false;
    }

    @Override
    public boolean isUsingUriWhenLoadingTemplate() {
        return false;
    }

    @Override
    public void load(CmsObject cms, CmsResource resource, HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException, CmsException {
        this.unmarshalXmlDocument(cms, resource, (ServletRequest)req);
        CmsTemplateLoaderFacade loaderFacade = OpenCms.getResourceManager().getTemplateLoaderFacade(cms, req, resource, this.getTemplatePropertyDefinition());
        CmsTemplateContext context = loaderFacade.getTemplateContext();
        req.setAttribute("templateContext", (Object)context);
        CmsJspStandardContextBean.TemplateBean templateBean = new CmsJspStandardContextBean.TemplateBean(context != null ? context.getKey() : loaderFacade.getTemplateName(), loaderFacade.getTemplate());
        templateBean.setForced(context != null && context.isForced());
        req.setAttribute("ATTR_TEMPLATE_BEAN", (Object)templateBean);
        loaderFacade.getLoader().load(cms, loaderFacade.getLoaderStartResource(), req, res);
    }

    @Override
    public void service(CmsObject cms, CmsResource resource, ServletRequest req, ServletResponse res) throws IOException, CmsException {
        String element = req.getParameter("__element");
        String value = this.dumpAsString(cms, resource, element, cms.getRequestContext().getLocale(), req, res);
        if (value != null) {
            I_CmsXmlDocument doc = this.unmarshalXmlDocument(cms, resource, req);
            byte[] result = value.getBytes(doc.getEncoding());
            res.getOutputStream().write(result);
        }
    }

    protected abstract String getTemplatePropertyDefinition();

    protected abstract I_CmsXmlDocument unmarshalXmlDocument(CmsObject var1, CmsResource var2, ServletRequest var3) throws CmsException;
}

