/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.report.I_CmsReport;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.Messages;
import org.opencms.search.documents.CmsIndexNoContentException;
import org.opencms.search.documents.I_CmsDocumentFactory;

public class CmsIndexingThread
extends Thread {
    private static final Log LOG = CmsLog.getLog(CmsIndexingThread.class);
    private CmsObject m_cms;
    private int m_count;
    private CmsSearchIndex m_index;
    private I_CmsReport m_report;
    private CmsResource m_res;
    private I_CmsSearchDocument m_result;

    public CmsIndexingThread(CmsObject cms, CmsResource res, CmsSearchIndex index, int count, I_CmsReport report) {
        super("OpenCms: Indexing '" + res.getName() + "'");
        this.m_cms = cms;
        this.m_res = res;
        this.m_index = index;
        this.m_count = count;
        this.m_report = report;
        this.m_result = null;
    }

    public I_CmsSearchDocument getResult() {
        return this.m_result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean docOk = false;
        try {
            this.m_result = this.createIndexDocument(this.m_cms, this.m_res, this.m_index, this.m_count, this.m_report);
            docOk = true;
            if (this.isInterrupted() && LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_ABANDONED_THREAD_FINISHED_1", this.m_res.getRootPath()));
            }
        }
        catch (CmsIndexNoContentException e) {
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        catch (Exception exc) {
            if (this.m_report != null) {
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                this.m_report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", exc.toString()), 5);
            }
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()), (Throwable)exc);
            }
            docOk = true;
        }
        finally {
            if (!docOk) {
                if (this.m_report != null) {
                    this.m_report.println(org.opencms.report.Messages.get().container("RPT_FAILED_0"), 5);
                    this.m_report.println(Messages.get().container("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()), 5);
                }
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_INDEX_RESOURCE_FAILED_2", this.m_res.getRootPath(), this.m_index.getName()));
                }
            }
        }
    }

    protected I_CmsSearchDocument createIndexDocument(CmsObject cms, CmsResource res, CmsSearchIndex index, int count, I_CmsReport report) throws CmsException {
        I_CmsDocumentFactory documentFactory;
        boolean excludeFromIndex;
        I_CmsSearchDocument result = null;
        if (report != null) {
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_1", String.valueOf(count)), 3);
            report.print(Messages.get().container("RPT_SEARCH_INDEXING_FILE_BEGIN_0"), 3);
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", report.removeSiteRoot(res.getRootPath())));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"), 0);
        }
        if (!(excludeFromIndex = index.excludeFromIndex(cms, res)) && (documentFactory = index.getDocumentFactory(res)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_INDEXING_WITH_FACTORY_2", res.getRootPath(), documentFactory.getName()));
            }
            result = documentFactory.createDocument(cms, res, index);
        }
        if (result == null) {
            if (report != null) {
                report.println(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 3);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_SKIPPED_1", res.getRootPath()));
            }
        } else if (this.m_report != null) {
            this.m_report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
        }
        return result;
    }
}

