/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.fields.CmsLuceneField;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldConfiguration;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;

public class CmsLuceneFieldConfiguration
extends CmsSearchFieldConfiguration {
    public static final CmsLuceneFieldConfiguration DEFAULT_STANDARD = CmsLuceneFieldConfiguration.createStandardConfiguration();
    public static final String STR_STANDARD_DESCRIPTION = "The standard OpenCms search index field configuration.";
    private static Set<String> m_returnFields = new HashSet<String>();
    private List<String> m_excerptFieldNames;
    private boolean m_fieldAdded;

    private static CmsLuceneFieldConfiguration createStandardConfiguration() {
        CmsLuceneFieldConfiguration result = new CmsLuceneFieldConfiguration();
        result.setName("standard");
        result.setDescription(STR_STANDARD_DESCRIPTION);
        CmsLuceneField field = new CmsLuceneField("content", "%(key.field.content)", true, true, true, true, true, null, 1.0f, null);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, null));
        result.addField(field);
        field = new CmsLuceneField("title-key", "-", true, true, false, false, 0.0f, null);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        result.addField(field);
        field = new CmsLuceneField("title", "%(key.field.title)", false, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        result.addField(field);
        field = new CmsLuceneField("keywords", "%(key.field.keywords)", true, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Keywords"));
        result.addField(field);
        field = new CmsLuceneField("description", "%(key.field.description)", true, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description"));
        result.addField(field);
        field = new CmsLuceneField("meta", "%(key.field.meta)", false, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Keywords"));
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description"));
        result.addField(field);
        return result;
    }

    @Override
    public void addField(CmsSearchField field) {
        super.addField(field);
        this.m_fieldAdded = true;
    }

    public Analyzer getAnalyzer(Analyzer analyzer) {
        WhitespaceAnalyzer ws = new WhitespaceAnalyzer(CmsSearchIndex.LUCENE_VERSION);
        HashMap<String, Object> analyzers = new HashMap<String, Object>();
        analyzers.put("parent-folders", ws);
        analyzers.put("category", ws);
        analyzers.put("lastmodified_lookup", ws);
        analyzers.put("created_lookup", ws);
        for (CmsLuceneField field : this.getLuceneFields()) {
            Analyzer fieldAnalyzer = field.getAnalyzer();
            if (fieldAnalyzer == null) continue;
            analyzers.put(field.getName(), fieldAnalyzer);
        }
        return new PerFieldAnalyzerWrapper(analyzer, analyzers);
    }

    public List<String> getExcerptFieldNames() {
        if (this.m_excerptFieldNames == null) {
            this.m_excerptFieldNames = new ArrayList<String>();
            for (CmsLuceneField cmsLuceneField : this.getFields()) {
                if (!cmsLuceneField.isInExcerptAndStored()) continue;
                this.m_excerptFieldNames.add(cmsLuceneField.getName());
            }
        }
        return new ArrayList<String>(this.m_excerptFieldNames);
    }

    public Set<String> getExcerptFields() {
        return new HashSet<String>(this.getExcerptFieldNames());
    }

    public List<CmsLuceneField> getLuceneFields() {
        ArrayList<CmsLuceneField> result = new ArrayList<CmsLuceneField>();
        for (CmsSearchField field : this.getFields()) {
            if (!(field instanceof CmsLuceneField)) continue;
            result.add((CmsLuceneField)field);
        }
        return result;
    }

    public Set<String> getReturnFields() {
        if (this.m_fieldAdded) {
            for (CmsLuceneField field : this.getLuceneFields()) {
                if (!field.isStored() || LAZY_FIELDS.contains(field.getName())) continue;
                m_returnFields.add(field.getName());
            }
        }
        this.m_fieldAdded = false;
        return m_returnFields;
    }

    static {
        m_returnFields.add("category");
        m_returnFields.add("contentdate");
        m_returnFields.add("created");
        m_returnFields.add("expired");
        m_returnFields.add("lastmodified");
        m_returnFields.add("released");
        m_returnFields.add("parent-folders");
        m_returnFields.add("path");
        m_returnFields.add("suffix");
        m_returnFields.add("type");
    }
}

