/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.solr;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.search.CmsIndexException;
import org.opencms.search.CmsSearchIndex;
import org.opencms.search.I_CmsSearchDocument;
import org.opencms.search.documents.I_CmsDocumentFactory;
import org.opencms.search.documents.Messages;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.solr.CmsSolrDocumentXmlContent;
import org.opencms.search.solr.CmsSolrFieldConfiguration;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.containerpage.CmsXmlContainerPageFactory;

public class CmsSolrDocumentContainerPage
extends CmsSolrDocumentXmlContent {
    public static final String TYPE_CONTAINERPAGE_SOLR = "containerpage-solr";
    private static final Log LOG = CmsLog.getLog(CmsSolrDocumentContainerPage.class);

    public CmsSolrDocumentContainerPage(String name) {
        super(name);
    }

    @Override
    public I_CmsSearchDocument createDocument(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        I_CmsExtractionResult content = null;
        if (index.isExtractingContent()) {
            try {
                content = this.extractContent(cms, resource, index);
            }
            catch (Exception e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
            }
        }
        return index.getFieldConfiguration().createDocument(cms, resource, index, content);
    }

    @Override
    public I_CmsExtractionResult extractContent(CmsObject cms, CmsResource resource, CmsSearchIndex index) throws CmsException {
        this.logContentExtraction(resource, index);
        I_CmsExtractionResult ex = null;
        try {
            CmsFile file = this.readFile(cms, resource);
            CmsXmlContainerPage containerPage = CmsXmlContainerPageFactory.unmarshal(cms, file);
            Locale locale = index.getLocaleForResource(cms, resource, containerPage.getLocales());
            ArrayList<I_CmsExtractionResult> all = new ArrayList<I_CmsExtractionResult>();
            CmsContainerPageBean containerBean = containerPage.getContainerPage(cms, locale);
            if (containerBean != null) {
                for (CmsContainerElementBean element : containerBean.getElements()) {
                    element.initResource(cms);
                    CmsADEConfigData adeConfig = OpenCms.getADEManager().lookupConfiguration(cms, file.getRootPath());
                    CmsFormatterConfiguration formatters = adeConfig.getFormatters(cms, element.getResource());
                    if (formatters == null || element.getFormatterId() == null || !formatters.isSearchContent(element.getFormatterId())) continue;
                    element.initResource(cms);
                    I_CmsDocumentFactory xmlFac = index.getDocumentFactory(element.getResource());
                    all.add(xmlFac.extractContent(cms, element.getResource(), index));
                }
            }
            ex = this.merge(cms, resource, all, (CmsSolrFieldConfiguration)index.getFieldConfiguration());
            ex.getContentItems().put("res_locales", locale.toString());
            return ex;
        }
        catch (Exception e) {
            throw new CmsIndexException(Messages.get().container("ERR_TEXT_EXTRACTION_1", resource.getRootPath()), (Throwable)e);
        }
    }

    @Override
    public boolean isLocaleDependend() {
        return true;
    }

    @Override
    public boolean isUsingCache() {
        return true;
    }

    private I_CmsExtractionResult merge(CmsObject cms, CmsResource resource, List<I_CmsExtractionResult> all, CmsSolrFieldConfiguration conf) {
        StringBuffer content = new StringBuffer();
        HashMap<String, String> items = new HashMap<String, String>();
        HashSet<CmsSearchField> fields = new HashSet<CmsSearchField>();
        for (I_CmsExtractionResult ex : all) {
            Set<CmsSearchField> mappedFields;
            if (ex.getContent() != null) {
                content.append(ex.getContent());
            }
            if (ex.getContentItems() != null) {
                for (Map.Entry<String, String> item : ex.getContentItems().entrySet()) {
                    String key = item.getKey();
                    String value = item.getValue();
                    if (items.containsKey(key) && items.get(key) != null) {
                        if (((String)items.get(key)).equals(value)) continue;
                        items.put(key, (String)items.get(key) + " " + value);
                        continue;
                    }
                    items.put(key, value);
                }
            }
            if ((mappedFields = conf.getXSDMappings(cms, resource)) == null) continue;
            fields.addAll(mappedFields);
        }
        return new CmsExtractionResult(content.toString(), items);
    }
}

