/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;

public class CmsTextareaWidget
extends A_CmsWidget
implements I_CmsADEWidget {
    private static final int DEFAULT_ROWS_NUMBER = 4;

    public CmsTextareaWidget() {
        this(4);
    }

    public CmsTextareaWidget(int rows) {
        super("" + rows);
    }

    public CmsTextareaWidget(String configuration) {
        super(configuration);
    }

    @Override
    public String getConfiguration(CmsObject cms, A_CmsXmlContentValue schemaType, CmsMessages messages, CmsResource resource, Locale contentLocale) {
        return this.getConfiguration();
    }

    @Override
    public List<String> getCssResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public I_CmsXmlContentHandler.DisplayType getDefaultDisplayType() {
        return I_CmsXmlContentHandler.DisplayType.wide;
    }

    @Override
    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String id = param.getId();
        StringBuffer result = new StringBuffer(16);
        int rows = 4;
        try {
            rows = new Integer(this.getConfiguration());
        }
        catch (Exception e) {
            // empty catch block
        }
        result.append("<td class=\"xmlTd\">");
        result.append("<textarea class=\"xmlInput maxwidth");
        if (param.hasError()) {
            result.append(" xmlInputError");
        }
        result.append("\" name=\"");
        result.append(id);
        result.append("\" rows=\"");
        result.append(rows);
        result.append("\" cols=\"60\" style=\"overflow:auto;\">");
        result.append(CmsEncoder.escapeXml(param.getStringValue(cms)));
        result.append("</textarea>");
        result.append("</td>");
        return result.toString();
    }

    @Override
    public String getInitCall() {
        return null;
    }

    @Override
    public List<String> getJavaScriptResourceLinks(CmsObject cms) {
        return null;
    }

    @Override
    public String getWidgetName() {
        return CmsTextareaWidget.class.getName();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Override
    public I_CmsWidget newInstance() {
        return new CmsTextareaWidget(this.getConfiguration());
    }
}

