/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.CmsHistoryList;
import org.opencms.workplace.comparison.CmsAttributeComparison;
import org.opencms.workplace.comparison.CmsResourceComparison;
import org.opencms.workplace.comparison.CmsResourceComparisonDialog;
import org.opencms.workplace.comparison.Messages;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;

public class CmsPropertyComparisonList
extends A_CmsListDialog {
    public static final String LIST_ACTION_VIEW1 = "v1";
    public static final String LIST_ACTION_VIEW2 = "v2";
    public static final String LIST_COLUMN_ICON = "ci";
    public static final String LIST_COLUMN_PROPERTY_NAME = "cp";
    public static final String LIST_COLUMN_TYPE = "cz";
    public static final String LIST_COLUMN_VERSION_1 = "cv";
    public static final String LIST_COLUMN_VERSION_2 = "cw";
    public static final String LIST_DEFACTION_VIEW = "dv";
    public static final String LIST_DETAIL_TYPE = "dt";
    public static final String LIST_IACTION_SHOW = "is";
    public static final String LIST_ID = "hipcl";
    public static final String PARAM_COMPARE = "compare";
    protected static final int TRIM_AT_LENGTH = 60;
    private static final Log LOG = CmsLog.getLog(CmsPropertyComparisonList.class);
    private String m_paramId1;
    private String m_paramId2;
    private String m_paramVersion1;
    private String m_paramVersion2;
    private CmsResource m_resource1;
    private CmsResource m_resource2;
    private int m_resourceType;

    public CmsPropertyComparisonList(CmsJspActionElement jsp) {
        this(LIST_ID, jsp);
    }

    public CmsPropertyComparisonList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    protected CmsPropertyComparisonList(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp, listId, listName, sortedColId, sortOrder, searchableColId);
    }

    protected CmsPropertyComparisonList(String listId, CmsJspActionElement jsp) {
        super(jsp, listId, Messages.get().container("GUI_COMPARE_PROPERTIES_0"), LIST_COLUMN_PROPERTY_NAME, CmsListOrderEnum.ORDER_ASCENDING, null);
    }

    @Override
    public void executeListMultiActions() {
        this.throwListUnsupportedActionException();
    }

    @Override
    public void executeListSingleActions() throws IOException, ServletException {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        params.put("version1", (String[])this.getParamVersion1());
        params.put("version2", (String[])this.getParamVersion2());
        params.put("id1", (String[])this.getParamId1());
        params.put("id2", (String[])this.getParamId2());
        params.put(PARAM_COMPARE, (String[])"properties");
        params.put("resource", (String[])this.getParamResource());
        this.getToolManager().jspForwardTool(this, "/history/comparison/difference", params);
    }

    public String getParamId1() {
        return this.m_paramId1;
    }

    public String getParamId2() {
        return this.m_paramId2;
    }

    public String getParamVersion1() {
        return this.m_paramVersion1;
    }

    public String getParamVersion2() {
        return this.m_paramVersion2;
    }

    public CmsResource getResource1() {
        return this.m_resource1;
    }

    public CmsResource getResource2() {
        return this.m_resource2;
    }

    public int getResourceType() {
        return this.m_resourceType;
    }

    public void setParamId1(String paramId1) {
        this.m_paramId1 = paramId1;
    }

    public void setParamId2(String paramId2) {
        this.m_paramId2 = paramId2;
    }

    public void setParamVersion1(String paramNewversionid) {
        this.m_paramVersion1 = paramNewversionid;
    }

    public void setParamVersion2(String paramOldversionid) {
        this.m_paramVersion2 = paramOldversionid;
    }

    @Override
    protected void fillDetails(String detailId) {
    }

    protected List getListItems() throws CmsException {
        ArrayList<CmsListItem> ret = new ArrayList<CmsListItem>();
        for (CmsAttributeComparison comparison : CmsResourceComparison.compareProperties(this.getCms(), this.getResource1(), this.getParamVersion1(), this.getResource2(), this.getParamVersion2())) {
            CmsListItem item = this.getList().newItem(comparison.getName());
            item.set(LIST_COLUMN_PROPERTY_NAME, comparison.getName());
            item.set(LIST_COLUMN_VERSION_1, CmsStringUtil.trimToSize(comparison.getVersion1(), 60));
            item.set(LIST_COLUMN_VERSION_2, CmsStringUtil.trimToSize(comparison.getVersion2(), 60));
            if ("added".equals(comparison.getStatus())) {
                item.set(LIST_COLUMN_TYPE, this.key("GUI_COMPARE_ADDED_0"));
            } else if ("removed".equals(comparison.getStatus())) {
                item.set(LIST_COLUMN_TYPE, this.key("GUI_COMPARE_REMOVED_0"));
            } else if ("changed".equals(comparison.getStatus())) {
                item.set(LIST_COLUMN_TYPE, this.key("GUI_COMPARE_CHANGED_0"));
            } else {
                if (!this.getList().getMetadata().getItemDetailDefinition(LIST_IACTION_SHOW).isVisible()) continue;
                item.set(LIST_COLUMN_TYPE, this.key("GUI_COMPARE_UNCHANGED_0"));
            }
            ret.add(item);
        }
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_VERSION_1).setName(Messages.get().container("GUI_COMPARE_VERSION_1", CmsHistoryList.getDisplayVersion(this.getParamVersion1(), this.getLocale())));
        this.getList().getMetadata().getColumnDefinition(LIST_COLUMN_VERSION_2).setName(Messages.get().container("GUI_COMPARE_VERSION_1", CmsHistoryList.getDisplayVersion(this.getParamVersion2(), this.getLocale())));
        return ret;
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        try {
            this.m_resource1 = CmsResourceComparisonDialog.readResource(this.getCms(), new CmsUUID(this.getParamId1()), this.getParamVersion1());
            this.m_resource2 = CmsResourceComparisonDialog.readResource(this.getCms(), new CmsUUID(this.getParamId2()), this.getParamVersion2());
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        this.m_resourceType = this.m_resource1.getTypeId();
    }

    @Override
    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition iconCol = new CmsListColumnDefinition(LIST_COLUMN_ICON);
        iconCol.setName(Messages.get().container("GUI_COMPARE_COLS_ICON_0"));
        iconCol.setWidth("20");
        iconCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        iconCol.setSorteable(true);
        CmsListDirectAction addedAction = new CmsListDirectAction("added"){

            @Override
            public boolean isVisible() {
                String type = this.getItem().get(CmsPropertyComparisonList.LIST_COLUMN_TYPE).toString();
                return CmsPropertyComparisonList.this.key("GUI_COMPARE_ADDED_0").equals(type);
            }
        };
        addedAction.setName(Messages.get().container("GUI_COMPARE_ELEM_ADDED_0"));
        addedAction.setIconPath("tools/ex_history/buttons/added.png");
        addedAction.setEnabled(true);
        iconCol.addDirectAction(addedAction);
        CmsListDirectAction removedAction = new CmsListDirectAction("removed"){

            @Override
            public boolean isVisible() {
                String type = this.getItem().get(CmsPropertyComparisonList.LIST_COLUMN_TYPE).toString();
                return CmsPropertyComparisonList.this.key("GUI_COMPARE_REMOVED_0").equals(type);
            }
        };
        removedAction.setName(Messages.get().container("GUI_COMPARE_ELEM_REMOVED_0"));
        removedAction.setIconPath("tools/ex_history/buttons/removed.png");
        removedAction.setEnabled(true);
        iconCol.addDirectAction(removedAction);
        CmsListDirectAction changedAction = new CmsListDirectAction("changed"){

            @Override
            public boolean isVisible() {
                String type = this.getItem().get(CmsPropertyComparisonList.LIST_COLUMN_TYPE).toString();
                return CmsPropertyComparisonList.this.key("GUI_COMPARE_CHANGED_0").equals(type);
            }
        };
        changedAction.setName(Messages.get().container("GUI_COMPARE_ELEM_CHANGED_0"));
        changedAction.setIconPath("tools/ex_history/buttons/changed.png");
        changedAction.setEnabled(true);
        iconCol.addDirectAction(changedAction);
        CmsListDirectAction unchangedAction = new CmsListDirectAction("unchanged"){

            @Override
            public boolean isVisible() {
                String type = this.getItem().get(CmsPropertyComparisonList.LIST_COLUMN_TYPE).toString();
                return CmsPropertyComparisonList.this.key("GUI_COMPARE_UNCHANGED_0").equals(type);
            }
        };
        unchangedAction.setName(Messages.get().container("GUI_COMPARE_ELEM_UNCHANGED_0"));
        unchangedAction.setIconPath("tools/ex_history/buttons/unchanged.png");
        unchangedAction.setEnabled(true);
        iconCol.addDirectAction(unchangedAction);
        metadata.addColumn(iconCol);
        iconCol.setPrintable(false);
        CmsListColumnDefinition typeCol = new CmsListColumnDefinition(LIST_COLUMN_TYPE);
        typeCol.setName(Messages.get().container("GUI_COMPARE_COLS_STATUS_0"));
        typeCol.setWidth("10%");
        CmsListDefaultAction typeColAction = new CmsListDefaultAction("at");
        typeColAction.setName(Messages.get().container("GUI_COMPARE_COLS_STATUS_0"));
        typeColAction.setEnabled(true);
        typeCol.addDefaultAction(typeColAction);
        metadata.addColumn(typeCol);
        typeCol.setPrintable(true);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_PROPERTY_NAME);
        nameCol.setName(Messages.get().container("GUI_COMPARE_COLS_PROPERTY_NAME_0"));
        nameCol.setWidth("20%");
        metadata.addColumn(nameCol);
        nameCol.setPrintable(true);
        CmsListColumnDefinition version1Col = new CmsListColumnDefinition(LIST_COLUMN_VERSION_1);
        version1Col.setName(Messages.get().container("GUI_COMPARE_VERSION_1", CmsHistoryList.getDisplayVersion(this.getParamVersion1(), this.getLocale())));
        version1Col.setWidth("35%");
        version1Col.setSorteable(false);
        metadata.addColumn(version1Col);
        version1Col.setPrintable(true);
        CmsListColumnDefinition version2Col = new CmsListColumnDefinition(LIST_COLUMN_VERSION_2);
        version2Col.setName(Messages.get().container("GUI_COMPARE_VERSION_1", CmsHistoryList.getDisplayVersion(this.getParamVersion2(), this.getLocale())));
        version2Col.setWidth("35%");
        version2Col.setSorteable(false);
        metadata.addColumn(version2Col);
        version2Col.setPrintable(true);
    }

    @Override
    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails eventDetails = new CmsListItemDetails(LIST_IACTION_SHOW);
        eventDetails.setVisible(false);
        eventDetails.setShowActionName(Messages.get().container("GUI_COMPARE_SHOW_ALL_PROPERTIES_0"));
        eventDetails.setHideActionName(Messages.get().container("GUI_COMPARE_HIDE_IDENTICAL_PROPERTIES_0"));
        metadata.addItemDetails(eventDetails);
    }

    @Override
    protected void setMultiActions(CmsListMetadata metadata) {
    }
}

