/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsDbSqlException;
import org.opencms.db.CmsImportFolder;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceException;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;
import org.opencms.workplace.explorer.CmsNewResource;
import org.opencms.workplace.explorer.Messages;

public class CmsNewResourceUpload
extends CmsNewResource {
    public static final int ACTION_APPLET = 140;
    public static final int ACTION_APPLET_CHECK_OVERWRITE = 141;
    public static final int ACTION_GWT = 160;
    public static final int ACTION_NEWFORM2 = 120;
    public static final int ACTION_SHOWERROR = 150;
    public static final int ACTION_SUBMITFORM2 = 130;
    public static final String APPLET_FILEFILTER_IMAGES = "imagefilter";
    public static final String APPLET_FILEFILTER_OFFICE = "officefilter";
    public static final String APPLET_FILEFILTER_WEB = "webfilter";
    public static final String ATTR_UPLOAD_FOLDER = "upload_folder";
    public static final Map<String, String> DEFAULT_APPLET_WINDOW_COLORS = new HashMap<String, String>();
    public static final String DIALOG_CHECK_OVERWRITE = "checkoverwrite";
    public static final String DIALOG_SHOWERROR = "showerror";
    public static final String DIALOG_SUBMITFORM2 = "submitform2";
    public static final String PARAM_CLIENTFOLDER = "clientfolder";
    public static final String PARAM_NEWRESOURCENAME = "newresourcename";
    public static final String PARAM_REDIRECTURL = "redirecturl";
    public static final String PARAM_RESOURCES = "resources";
    public static final String PARAM_TARGETFRAME = "targetframe";
    public static final String PARAM_UNZIPFILE = "unzipfile";
    public static final String PARAM_UPLOADAPPLET = "uploadapplet";
    public static final String PARAM_UPLOADERROR = "uploaderror";
    public static final String PARAM_UPLOADFILE = "uploadfile";
    public static final String PARAM_UPLOADFOLDER = "uploadfolder";
    private static final String ATTR_UPLOADED_FILES = "uploaded_files";
    private static final Log LOG = CmsLog.getLog(CmsNewResourceUpload.class);
    private Map<String, String> m_appletWindowColors = DEFAULT_APPLET_WINDOW_COLORS;
    private boolean m_closingAfterUnzip;
    private String m_paramClientFolder;
    private String m_paramNewResourceName;
    private String m_paramRedirectUrl;
    private String m_paramTargetFrame;
    private String m_paramUnzipFile;
    private String m_paramUploadError;
    private String m_paramUploadFile;
    private String m_paramUploadFolder;
    private List<String> m_uploadedFiles = new ArrayList<String>();

    public CmsNewResourceUpload(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsNewResourceUpload(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static String buildTypeList(CmsDialog dialog, boolean useTypeId) {
        StringBuffer result = new StringBuffer(512);
        try {
            CmsObject cms = dialog.getCms();
            CmsResource res = cms.readResource(dialog.getParamResource(), CmsResourceFilter.ALL);
            int currentResTypeId = res.getTypeId();
            List<CmsExplorerTypeSettings> resTypes = OpenCms.getWorkplaceManager().getExplorerTypeSettings();
            boolean isFolder = res.isFolder();
            for (int i = 0; i < resTypes.size(); ++i) {
                CmsPermissionSet permissions;
                boolean isResourceType;
                boolean changeable = false;
                CmsExplorerTypeSettings settings = resTypes.get(i);
                try {
                    OpenCms.getResourceManager().getResourceType(settings.getName());
                    isResourceType = true;
                }
                catch (CmsLoaderException e) {
                    isResourceType = false;
                }
                if (!isResourceType) continue;
                int resTypeId = OpenCms.getResourceManager().getResourceType(settings.getName()).getTypeId();
                if (isFolder && OpenCms.getResourceManager().getResourceType(resTypeId).isFolder()) {
                    changeable = true;
                } else if (!isFolder && !OpenCms.getResourceManager().getResourceType(resTypeId).isFolder()) {
                    changeable = true;
                }
                if (!changeable || !(permissions = settings.getAccess().getPermissions(cms, res)).requiresWritePermission() || !permissions.requiresControlPermission()) continue;
                result.append("<tr><td>");
                result.append("<input type=\"radio\" name=\"");
                result.append("newresourcetype");
                result.append("\" value=\"");
                if (useTypeId) {
                    result.append(resTypeId);
                } else {
                    result.append(settings.getName());
                }
                result.append("\"");
                if (resTypeId == currentResTypeId) {
                    result.append(" checked=\"checked\"");
                }
                result.append("></td>");
                result.append("\t<td><img src=\"");
                result.append(CmsNewResourceUpload.getSkinUri());
                result.append("filetypes/");
                result.append(settings.getIcon());
                result.append("\" border=\"0\" title=\"");
                result.append(dialog.key(settings.getKey()));
                result.append("\"></td>\n");
                result.append("<td>");
                result.append(dialog.key(settings.getKey()));
                result.append("</td></tr>\n");
            }
        }
        catch (CmsException e) {
            LOG.error((Object)org.opencms.workplace.commons.Messages.get().getBundle().key("ERR_BUILDING_RESTYPE_LIST_1", dialog.getParamResource()));
        }
        return result.toString();
    }

    public static String createAppletCode(CmsJspActionElement jsp, Locale locale, String currentFolder, String redirectUrl, String targetFrame, Map<String, String> appletWindowColors) {
        StringBuffer applet = new StringBuffer(2048);
        String scheme = jsp.getRequest().getScheme();
        String host = jsp.getRequest().getServerName();
        String path = OpenCms.getStaticExportManager().getVfsPrefix();
        int port = jsp.getRequest().getServerPort();
        String webapp = scheme + "://" + host + ":" + port + OpenCms.getSystemInfo().getContextPath();
        String fileExtensions = "";
        Map<String, String> extensions = OpenCms.getResourceManager().getExtensionMapping();
        for (Map.Entry<String, String> entry : extensions.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            fileExtensions = fileExtensions + key + "=" + value + ",";
        }
        fileExtensions = fileExtensions.substring(0, fileExtensions.length() - 1);
        long maxFileSize = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(jsp.getCmsObject());
        HttpSession session = jsp.getRequest().getSession(false);
        String sessionId = ((CmsUUID)session.getAttribute("__org.opencms.main.CmsSessionInfo#m_sessionId")).getStringValue();
        StringBuffer colors = new StringBuffer();
        if (appletWindowColors == null || appletWindowColors.size() == 0) {
            appletWindowColors = DEFAULT_APPLET_WINDOW_COLORS;
        }
        Iterator<Map.Entry<String, String>> it = appletWindowColors.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> color = it.next();
            colors.append(color.getKey()).append('=').append(color.getValue());
            if (!it.hasNext()) continue;
            colors.append(',');
        }
        applet.append("<applet code=\"org.opencms.applet.upload.FileUploadApplet.class\" archive=\"");
        applet.append(webapp);
        applet.append("/resources/components/upload_applet/upload.jar\" width=\"500\" height=\"100\">\n");
        applet.append("<param name=\"opencms\" value=\"");
        applet.append(scheme);
        applet.append("://");
        applet.append(host);
        applet.append(":");
        applet.append(port);
        applet.append(CmsNewResourceUpload.getSkinUri());
        applet.append("filetypes/\">\n");
        applet.append("<param name=\"target\" value=\"");
        applet.append(scheme);
        applet.append("://");
        applet.append(host);
        applet.append(":");
        applet.append(port);
        applet.append(path);
        applet.append("/system/workplace/commons/newresource_upload.jsp\">\n");
        applet.append("<param name=\"redirect\" value=\"");
        applet.append(scheme);
        applet.append("://");
        applet.append(host);
        applet.append(":");
        applet.append(port);
        applet.append(path);
        if (CmsStringUtil.isEmpty(redirectUrl)) {
            applet.append("/system/workplace/views/explorer/explorer_files.jsp");
        } else {
            applet.append(redirectUrl);
        }
        applet.append("?time=").append(System.currentTimeMillis());
        applet.append("\">\n");
        applet.append("<param name=\"targetframe\" value=\"");
        applet.append(targetFrame);
        applet.append("\">\n");
        applet.append("<param name=\"error\" value=\"");
        applet.append(scheme);
        applet.append("://");
        applet.append(host);
        applet.append(":");
        applet.append(port);
        applet.append(path);
        applet.append("/system/workplace/views/explorer/explorer_files.jsp\">\n");
        applet.append("<param name=\"sessionId\" value=\"");
        applet.append(sessionId);
        applet.append("\">\n");
        applet.append("<param name=\"filelist\" value=\"");
        applet.append(currentFolder);
        applet.append("\">\n");
        applet.append("<param name=\"filefilterselection\" value=\"");
        applet.append(CmsNewResourceUpload.getAppletFileFilterPreselectionConstant(jsp.getCmsObject(), currentFolder));
        applet.append("\">\n");
        applet.append("<param name=\"colors\" value=\"");
        applet.append(colors.toString());
        applet.append("\">\n");
        applet.append("<param name=\"fileExtensions\" value=\"");
        applet.append(fileExtensions);
        applet.append("\">\n\n");
        applet.append("<param name=\"maxsize\" value=\"");
        applet.append(maxFileSize);
        applet.append("\">\n");
        applet.append("<param name=\"actionOutputSelect\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ACTION_SELECT_0"));
        applet.append("\">\n");
        applet.append("<param name=\"actionOutputCount\"value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ACTION_COUNT_0"));
        applet.append("\">\n");
        applet.append("<param name=\"actionOutputCreate\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ACTION_CREATE_0"));
        applet.append("\">\n");
        applet.append("<param name=\"actionOutputUpload\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ACTION_UPLOAD_0"));
        applet.append("\">\n");
        applet.append("<param name=\"actionOverwriteCheck\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ACTION_OVERWRITECHECK_0"));
        applet.append("\">\n");
        applet.append("<param name=\"messageOutputUpload\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_MESSAGE_UPLOAD_0"));
        applet.append("\">\n");
        applet.append("<param name=\"messageOutputErrorZip\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_MESSAGE_ERROR_ZIP_0"));
        applet.append("\">\n");
        applet.append("<param name=\"messageOutputErrorSize\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_MESSAGE_ERROR_SIZE_0"));
        applet.append("\">\n");
        applet.append("<param name=\"messageNoPreview\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_MESSAGE_NOPREVIEW_0"));
        applet.append("\">\n");
        applet.append("<param name=\"messageOutputAdding\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_MESSAGE_ADDING_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"errorTitle\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ERROR_TITLE_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"errorLine1\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ERROR_LINE1_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"certificateErrorTitle\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ERROR_CERT_TITLE_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"overwriteDialogTitle\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_OVERWRITE_DIALOG_TITLE_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"overwriteDialogIntro\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_OVERWRITE_DIALOG_INTRO_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"overwriteDialogOk\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_OVERWRITE_DIALOG_OK_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"overwriteDialogCancel\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_OVERWRITE_DIALOG_CANCEL_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"overwriteDialogLocale\" value=\"");
        applet.append(locale.toString());
        applet.append(" \">\n");
        applet.append("<param name=\"certificateErrorMessage\" value=\"");
        applet.append(Messages.get().getBundle(locale).key("GUI_UPLOADAPPLET_ERROR_CERT_MESSAGE_0"));
        applet.append(" \">\n");
        applet.append("<param name=\"uriPrefix\" value=\"");
        applet.append(scheme);
        applet.append("://");
        applet.append(host);
        applet.append(":");
        applet.append(port);
        applet.append(path);
        applet.append("\">\n");
        applet.append("<param name=\"clientFolder\" value=\"");
        applet.append(new CmsUserSettings(jsp.getCmsObject()).getUploadAppletClientFolder());
        applet.append(" \">\n");
        applet.append("</applet>\n");
        return applet.toString();
    }

    private static String getAppletFileFilterPreselectionConstant(CmsObject cms, String currentFolder) {
        String result = "";
        try {
            CmsResource res = cms.readResource(currentFolder, CmsResourceFilter.IGNORE_EXPIRATION);
            result = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
            if ("imagegallery".equals(result)) {
                result = APPLET_FILEFILTER_IMAGES;
            } else if ("htmlgallery".equals(result)) {
                result = APPLET_FILEFILTER_WEB;
            } else if ("downloadgallery".equals(result)) {
                result = APPLET_FILEFILTER_OFFICE;
            }
        }
        catch (CmsException e) {
            System.err.println(e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionCloseDialog() throws JspException {
        block13: {
            String uploadHook;
            String uploadFolder;
            if (this.getAction() == 4) {
                try {
                    CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
                    if (res.getState().isNew()) {
                        this.getCms().deleteResource(this.getParamResource(), CmsResource.DELETE_PRESERVE_SIBLINGS);
                    }
                    if (!res.getState().isChanged()) break block13;
                    CmsProject currentProject = this.getCms().getRequestContext().getCurrentProject();
                    byte[] onlineContents = null;
                    try {
                        this.getCms().getRequestContext().setCurrentProject(this.getCms().readProject(CmsProject.ONLINE_PROJECT_ID));
                        CmsFile onlineFile = this.getCms().readFile(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
                        onlineContents = onlineFile.getContents();
                    }
                    finally {
                        this.getCms().getRequestContext().setCurrentProject(currentProject);
                    }
                    if (onlineContents != null) {
                        CmsFile modFile = this.getCms().readFile(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
                        modFile.setContents(onlineContents);
                        this.getCms().writeFile(modFile);
                    }
                }
                catch (RuntimeException e) {
                }
                catch (Exception e) {}
            } else if (this.m_closingAfterUnzip && this.getJsp().getRequest().getParameter(PARAM_UPLOADAPPLET) == null && (uploadFolder = this.getJsp().getRequest().getParameter(PARAM_UPLOADFOLDER)) != null && (uploadHook = OpenCms.getWorkplaceManager().getUploadHook(this.getJsp().getCmsObject(), uploadFolder)) != null) {
                HashMap<String, String[]> params = new HashMap<String, String[]>();
                params.put(PARAM_RESOURCES, new String[]{(String)this.getJsp().getRequest().getSession().getAttribute(ATTR_UPLOADED_FILES)});
                params.put("closelink", new String[]{this.getParamCloseLink()});
                try {
                    this.forwardEditProperties(params);
                    return;
                }
                catch (Exception e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        super.actionCloseDialog();
    }

    public void actionUpdateFile() throws JspException {
        try {
            CmsResource res = this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL);
            I_CmsResourceType oldType = OpenCms.getResourceManager().getResourceType(res.getTypeId());
            int newType = oldType.getTypeId();
            if (!oldType.getTypeName().equals(this.getParamNewResourceType())) {
                newType = CmsStringUtil.isEmptyOrWhitespaceOnly(this.getParamNewResourceType()) ? OpenCms.getResourceManager().getDefaultTypeForName(res.getName()).getTypeId() : OpenCms.getResourceManager().getResourceType(this.getParamNewResourceType()).getTypeId();
                this.getCms().chtype(this.getParamResource(), newType);
            }
            if (this.getParamNewResourceName() != null && !this.getParamResource().endsWith(this.getParamNewResourceName())) {
                String newResourceName = CmsResource.getFolderPath(this.getParamResource()) + this.getParamNewResourceName();
                this.getCms().renameResource(this.getParamResource(), newResourceName);
                this.setParamResource(newResourceName);
            }
        }
        catch (Throwable e) {
            this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_UPLOAD_FILE_0"));
            this.includeErrorpage(this, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionUpload() throws JspException {
        block27: {
            boolean unzipFile;
            block26: {
                unzipFile = Boolean.valueOf(this.getParamUnzipFile());
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamClientFolder())) {
                    CmsUserSettings userSettings = new CmsUserSettings(this.getCms());
                    userSettings.setUploadAppletClientFolder(this.getParamClientFolder());
                    try {
                        userSettings.save(this.getCms());
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block26;
                        LOG.error((Object)Messages.get().getBundle(this.getLocale()).key("ERR_UPLOAD_STORE_CLIENT_FOLDER_1", new Object[]{this.getCms().getRequestContext().getCurrentUser().getName()}), (Throwable)e);
                    }
                }
            }
            try {
                Iterator<FileItem> i = this.getMultiPartFileItems().iterator();
                FileItem fi = null;
                while (i.hasNext() && (fi = i.next()).getName() == null) {
                }
                if (fi != null) {
                    String fileName = fi.getName();
                    long size = fi.getSize();
                    long maxFileSizeBytes = OpenCms.getWorkplaceManager().getFileBytesMaxUploadSize(this.getCms());
                    if (maxFileSizeBytes > 0L && size > maxFileSizeBytes) {
                        throw new CmsWorkplaceException(Messages.get().container("ERR_UPLOAD_FILE_SIZE_TOO_HIGH_1", new Long(maxFileSizeBytes / 1024L)));
                    }
                    byte[] content = fi.get();
                    fi.delete();
                    if (unzipFile) {
                        String currentFolder = this.getParamUploadFolder();
                        if (CmsStringUtil.isEmpty(currentFolder)) {
                            currentFolder = this.getParamCurrentFolder();
                        }
                        if (CmsStringUtil.isEmpty(currentFolder) || !currentFolder.startsWith("/")) {
                            currentFolder = this.computeCurrentFolder();
                        }
                        this.getJsp().getRequest().getSession().setAttribute(ATTR_UPLOAD_FOLDER, (Object)currentFolder);
                        CmsImportFolder importFolder = new CmsImportFolder(content, currentFolder, this.getCms(), false);
                        for (CmsResource importedResource : importFolder.getImportedResources()) {
                            this.m_uploadedFiles.add(importedResource.getStructureId().toString());
                        }
                        break block27;
                    }
                    String newResname = CmsResource.getName(fileName.replace('\\', '/'));
                    String title = newResname;
                    if (title.lastIndexOf(46) != -1) {
                        title = title.substring(0, title.lastIndexOf(46));
                    }
                    ArrayList<CmsProperty> properties = new ArrayList<CmsProperty>(1);
                    CmsProperty titleProp = new CmsProperty();
                    titleProp.setName("Title");
                    if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                        titleProp.setStructureValue(title);
                    } else {
                        titleProp.setResourceValue(title);
                    }
                    properties.add(titleProp);
                    newResname = this.getCms().getRequestContext().getFileTranslator().translateResource(newResname);
                    this.setParamNewResourceName(newResname);
                    this.setParamResource(newResname);
                    this.setParamResource(this.computeFullResourceName());
                    int resTypeId = OpenCms.getResourceManager().getDefaultTypeForName(newResname).getTypeId();
                    int plainId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
                    String uploadFolder = CmsResource.getParentFolder(this.getParamResource());
                    this.getJsp().getRequest().getSession().setAttribute(ATTR_UPLOAD_FOLDER, (Object)uploadFolder);
                    if (!this.getCms().existsResource(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION)) {
                        try {
                            CmsResource uploadedFile = this.getCms().createResource(this.getParamResource(), resTypeId, content, properties);
                            this.m_uploadedFiles.add(uploadedFile.getStructureId().toString());
                            break block27;
                        }
                        catch (CmsSecurityException e) {
                            CmsResource uploadedFile = this.getCms().createResource(this.getParamResource(), plainId, content, properties);
                            this.m_uploadedFiles.add(uploadedFile.getStructureId().toString());
                            break block27;
                        }
                        catch (CmsDbSqlException sqlExc) {
                            this.getCms().lockResource(this.getParamResource());
                            this.getCms().deleteResource(this.getParamResource(), CmsResource.DELETE_PRESERVE_SIBLINGS);
                            throw sqlExc;
                        }
                    }
                    this.checkLock(this.getParamResource());
                    CmsFile file = this.getCms().readFile(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
                    byte[] contents = file.getContents();
                    try {
                        this.getCms().replaceResource(this.getParamResource(), resTypeId, content, null);
                        this.m_uploadedFiles.add(file.getStructureId().toString());
                        break block27;
                    }
                    catch (CmsSecurityException e) {
                        this.getCms().replaceResource(this.getParamResource(), plainId, content, null);
                        this.m_uploadedFiles.add(file.getStructureId().toString());
                        break block27;
                    }
                    catch (CmsDbSqlException sqlExc) {
                        file.setContents(contents);
                        this.getCms().writeFile(file);
                        throw sqlExc;
                    }
                }
                throw new CmsWorkplaceException(Messages.get().container("ERR_UPLOAD_FILE_NOT_FOUND_0"));
            }
            catch (Throwable e) {
                this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_UPLOAD_FILE_0"));
                this.setAction(150);
                this.includeErrorpage(this, e);
            }
            finally {
                if (!this.m_uploadedFiles.isEmpty()) {
                    String uploadedFilesString = Joiner.on((String)",").join(this.m_uploadedFiles);
                    this.getJsp().getRequest().getSession().setAttribute(ATTR_UPLOADED_FILES, (Object)uploadedFilesString);
                }
            }
        }
    }

    public String buildTypeList() {
        return CmsNewResourceUpload.buildTypeList(this, false);
    }

    public String createAppletCode() {
        return CmsNewResourceUpload.createAppletCode(this.getJsp(), this.getLocale(), this.getParamCurrentFolder(), this.getParamRedirectUrl(), this.getParamTargetFrame(), this.m_appletWindowColors);
    }

    @Override
    public void forwardEditProperties(Map<String, String[]> params) throws IOException, ServletException {
        String uploadHook;
        String uploadFolder = (String)this.getJsp().getRequest().getSession().getAttribute(ATTR_UPLOAD_FOLDER);
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(uploadFolder) && (uploadHook = OpenCms.getWorkplaceManager().getUploadHook(this.getCms(), uploadFolder)) != null) {
            String uploadedFilesString;
            if (params.get("closelink") == null) {
                params.put("closelink", new String[]{OpenCms.getLinkManager().getServerLink(this.getJsp().getCmsObject(), "/system/workplace/views/explorer/explorer_files.jsp")});
            }
            if ((uploadedFilesString = (String)this.getJsp().getRequest().getSession().getAttribute(ATTR_UPLOADED_FILES)) != null) {
                params.put(PARAM_RESOURCES, new String[]{uploadedFilesString});
            }
            this.sendForward(uploadHook, params);
            return;
        }
        super.forwardEditProperties(params);
    }

    public String getCloseLink() {
        String frameUri;
        if (this.getParamCloseLink() != null) {
            return this.getParamCloseLink();
        }
        if (this.getParamFramename() != null && (frameUri = this.getSettings().getFrameUris().get(this.getParamFramename())) != null) {
            if (frameUri.startsWith(OpenCms.getSystemInfo().getOpenCmsContext())) {
                frameUri = frameUri.substring(OpenCms.getSystemInfo().getOpenCmsContext().length());
            }
            return frameUri;
        }
        return "/system/workplace/views/explorer/explorer_files.jsp";
    }

    public String getParamClientFolder() {
        return this.m_paramClientFolder;
    }

    public String getParamNewResourceName() {
        return this.m_paramNewResourceName;
    }

    public String getParamRedirectUrl() {
        return this.m_paramRedirectUrl;
    }

    public String getParamTargetFrame() {
        if (CmsStringUtil.isEmpty(this.m_paramTargetFrame)) {
            return "explorer_files";
        }
        return this.m_paramTargetFrame;
    }

    public String getParamUnzipFile() {
        return this.m_paramUnzipFile;
    }

    public String getParamUploadError() {
        return this.m_paramUploadError;
    }

    public String getParamUploadFile() {
        return this.m_paramUploadFile;
    }

    public String getParamUploadFolder() {
        return this.m_paramUploadFolder;
    }

    public String getUploadedFiles() {
        return "<!--CMS_UPLOADED_FILES=" + Joiner.on((String)",").join(this.m_uploadedFiles) + "-->";
    }

    public String getUploadHook() {
        String uploadHook = OpenCms.getWorkplaceManager().getUploadHook(this.getCms(), this.getParamUploadFolder());
        if (uploadHook == null) {
            return "";
        }
        return "<!--CMS_UPLOAD_HOOK=" + uploadHook + "-->";
    }

    public String handleUploadOverwriteCheckRequest(HttpServletRequest request) {
        StringBuffer result = new StringBuffer();
        String uploadFiles = CmsEncoder.decode(request.getHeader("uploadFiles"));
        String currentFolder = CmsEncoder.decode(request.getHeader("uploadFolder"));
        if (currentFolder.endsWith("/")) {
            currentFolder = currentFolder.substring(0, currentFolder.length() - 1);
        }
        List<String> vfsfiles = CmsStringUtil.splitAsList(uploadFiles, '\n');
        for (String clientfile : vfsfiles) {
            String vfsfile = new StringBuffer(currentFolder).append(clientfile).toString();
            vfsfile = OpenCms.getResourceManager().getFileTranslator().translateResource(vfsfile);
            if (!this.getCms().existsResource(vfsfile)) continue;
            result.append(CmsEncoder.encode(clientfile, "UTF-8"));
            result.append('\n');
        }
        return result.toString();
    }

    @Override
    public void sendForward(String location, Map<String, String[]> params) throws IOException, ServletException {
        if (!CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_paramUploadFolder)) {
            params.put(PARAM_UPLOADFOLDER, new String[]{this.m_paramUploadFolder});
        }
        super.sendForward(location, params);
    }

    public final void setAppletWindowColors(Map<String, String> appletWindowColors) {
        this.m_appletWindowColors = appletWindowColors;
    }

    public void setClosingAfterUnzip(boolean closingAfterUnzip) {
        this.m_closingAfterUnzip = closingAfterUnzip;
    }

    public void setParamClientFolder(String clientFolder) {
        this.m_paramClientFolder = clientFolder;
    }

    public void setParamNewResourceName(String newResourceName) {
        this.m_paramNewResourceName = newResourceName;
    }

    public void setParamRedirectUrl(String paramRedirectUrl) {
        this.m_paramRedirectUrl = paramRedirectUrl;
    }

    public void setParamTargetFrame(String paramTargetFrame) {
        this.m_paramTargetFrame = paramTargetFrame;
    }

    public void setParamUnzipFile(String unzipFile) {
        this.m_paramUnzipFile = unzipFile;
    }

    public void setParamUploadError(String uploadError) {
        this.m_paramUploadError = uploadError;
    }

    public void setParamUploadFile(String uploadFile) {
        this.m_paramUploadFile = uploadFile;
    }

    public void setParamUploadFolder(String uploadFolder) {
        this.m_paramUploadFolder = uploadFolder;
    }

    public boolean unzipUpload() {
        return Boolean.valueOf(this.getParamUnzipFile());
    }

    @Override
    protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        String siteRoot = jsp.getRequestContext().getSiteRoot();
        super.initWorkplaceMembers(jsp);
        if (!siteRoot.equals(this.getSettings().getSite())) {
            this.getSettings().setSite(siteRoot);
            jsp.getRequestContext().setSiteRoot(siteRoot);
        }
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype("newresource");
        if ("ok".equals(this.getParamAction())) {
            this.setAction(3);
        } else if ("submitform".equals(this.getParamAction())) {
            this.setAction(110);
        } else if (DIALOG_SUBMITFORM2.equals(this.getParamAction())) {
            this.setAction(130);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else if (DIALOG_CHECK_OVERWRITE.equals(this.getParamAction())) {
            this.setAction(141);
        } else {
            switch (this.getSettings().getUserSettings().getUploadVariant()) {
                case basic: {
                    this.setAction(0);
                    break;
                }
                default: {
                    this.setAction(160);
                }
            }
            this.setParamTitle(this.key("GUI_NEWRESOURCE_UPLOAD_0"));
        }
    }

    static {
        DEFAULT_APPLET_WINDOW_COLORS.put("bgColor", "#C0C0C0");
        DEFAULT_APPLET_WINDOW_COLORS.put("outerBorderRightBottom", "#333333");
        DEFAULT_APPLET_WINDOW_COLORS.put("outerBorderLeftTop", "#C0C0C0");
        DEFAULT_APPLET_WINDOW_COLORS.put("innerBorderRightBottom", "#777777");
        DEFAULT_APPLET_WINDOW_COLORS.put("innerBorderLeftTop", "#F0F0F0");
        DEFAULT_APPLET_WINDOW_COLORS.put("colorText", "#000000");
        DEFAULT_APPLET_WINDOW_COLORS.put("progessBar", "#E10050");
    }
}

