/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.io.File;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;
import org.opencms.workplace.tools.I_CmsHtmlIconButton;
import org.opencms.workplace.tools.Messages;

public abstract class A_CmsHtmlIconButton
implements I_CmsHtmlIconButton {
    public static final CmsMessageContainer EMPTY_MESSAGE = Messages.get().container("GUI_EMPTY_MESSAGE_0");
    protected String m_id;
    private boolean m_enabled = true;
    private CmsMessageContainer m_helpText;
    private String m_iconPath;
    private CmsMessageContainer m_name;
    private boolean m_visible = true;

    public A_CmsHtmlIconButton(String id) {
        this.m_id = id;
    }

    public A_CmsHtmlIconButton(String id, CmsMessageContainer name, CmsMessageContainer helpText, String iconPath, boolean enabled) {
        this(id);
        this.setName(name);
        this.setHelpText(helpText);
        this.setIconPath(iconPath);
        this.setEnabled(enabled);
    }

    public static String defaultButtonHtml(CmsHtmlIconButtonStyleEnum style, String id, String name, String helpText, boolean enabled, String iconPath, String confirmationMessage, String onClick) {
        return A_CmsHtmlIconButton.defaultButtonHtml(style, id, id, name, helpText, enabled, iconPath, confirmationMessage, onClick, false, null);
    }

    public static String defaultButtonHtml(CmsHtmlIconButtonStyleEnum style, String id, String helpId, String name, String helpText, boolean enabled, String iconPath, String confirmationMessage, String onClick, boolean singleHelp, String rightHtml) {
        StringBuffer html = new StringBuffer(1024);
        if (style == CmsHtmlIconButtonStyleEnum.BIG_ICON_TEXT) {
            html.append("<div class='bigLink' id='img");
            html.append(id);
            html.append("'>\n");
        }
        html.append("\t<span class=\"link");
        if (enabled) {
            html.append("\"");
        } else {
            html.append(" linkdisabled\"");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(helpText)) {
            if (!singleHelp) {
                html.append(" onMouseOver=\"sMH('");
                html.append(id);
                html.append("');\" onMouseOut=\"hMH('");
                html.append(id);
                html.append("');\"");
            } else {
                html.append(" onMouseOver=\"sMHS('");
                html.append(id);
                html.append("', '");
                html.append(helpId);
                html.append("');\" onMouseOut=\"hMH('");
                html.append(id);
                html.append("', '");
                html.append(helpId);
                html.append("');\"");
            }
        }
        if (enabled && CmsStringUtil.isNotEmptyOrWhitespaceOnly(onClick)) {
            html.append(" onClick=\"");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(confirmationMessage)) {
                html.append("if (confirm('" + CmsStringUtil.escapeJavaScript(confirmationMessage) + "')) {");
            }
            html.append(onClick);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(confirmationMessage)) {
                html.append(" }");
            }
            html.append("\"");
        }
        if (style == CmsHtmlIconButtonStyleEnum.SMALL_ICON_ONLY) {
            html.append(" title='");
            html.append(name);
            html.append("'");
        }
        html.append(">");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(iconPath)) {
            html.append("<img src='");
            html.append(CmsWorkplace.getSkinUri());
            if (!enabled) {
                StringBuffer icon = new StringBuffer(128);
                icon.append(iconPath.substring(0, iconPath.lastIndexOf(46)));
                icon.append("_disabled");
                icon.append(iconPath.substring(iconPath.lastIndexOf(46)));
                String resourcesRoot = OpenCms.getSystemInfo().getWebApplicationRfsPath() + "resources/";
                File test = new File(resourcesRoot + icon.toString());
                if (test.exists()) {
                    html.append(icon);
                } else {
                    html.append(iconPath);
                }
            } else {
                html.append(iconPath);
            }
            html.append("'");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) {
                html.append(" alt='");
                html.append(name);
                html.append("'");
                html.append(" title='");
                html.append(name);
                html.append("'");
            }
            html.append(">");
            if (style == CmsHtmlIconButtonStyleEnum.BIG_ICON_TEXT) {
                html.append("<br>");
            }
        }
        if (style != CmsHtmlIconButtonStyleEnum.SMALL_ICON_ONLY && CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(iconPath) && style != CmsHtmlIconButtonStyleEnum.BIG_ICON_TEXT) {
                html.append("&nbsp;");
            }
            if (enabled) {
                if (style != CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT) {
                    html.append("<a href='#'>");
                } else {
                    html.append("<a href='#' style='white-space: nowrap;'>");
                }
            }
            html.append(name);
            if (enabled) {
                html.append("</a>");
            }
        }
        html.append("</span>");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(rightHtml)) {
            html.append(rightHtml);
        }
        if (style == CmsHtmlIconButtonStyleEnum.BIG_ICON_TEXT) {
            html.append("</div>\n");
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(helpText) && !singleHelp) {
            html.append("<div class='help' id='help");
            html.append(helpId);
            html.append("' onMouseOver=\"sMH('");
            html.append(id);
            html.append("');\" onMouseOut=\"hMH('");
            html.append(id);
            html.append("');\">");
            html.append(helpText);
            html.append("</div>\n");
        }
        return html.toString();
    }

    public static String defaultHelpHtml(String helpId, String helpText) {
        StringBuffer html = new StringBuffer(1024);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(helpText)) {
            html.append("<div class='help' id='help");
            html.append(helpId);
            html.append("' onMouseOut=\"hMH('");
            html.append(helpId);
            html.append("');\">");
            html.append(helpText);
            html.append("</div>\n");
        }
        return html.toString();
    }

    @Override
    public CmsMessageContainer getHelpText() {
        if (this.m_helpText == null) {
            this.m_helpText = EMPTY_MESSAGE;
        }
        return this.m_helpText;
    }

    @Override
    public String getIconPath() {
        return this.m_iconPath;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public CmsMessageContainer getName() {
        return this.m_name;
    }

    @Override
    public boolean isEnabled() {
        return this.m_enabled;
    }

    @Override
    public boolean isVisible() {
        return this.m_visible;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    @Override
    public void setHelpText(CmsMessageContainer helpText) {
        if (helpText == null) {
            helpText = EMPTY_MESSAGE;
        }
        this.m_helpText = helpText;
    }

    @Override
    public void setIconPath(String iconPath) {
        this.m_iconPath = iconPath;
    }

    @Override
    public void setName(CmsMessageContainer name) {
        if (name == null) {
            name = EMPTY_MESSAGE;
        }
        this.m_name = name;
    }

    @Override
    public void setVisible(boolean visible) {
        this.m_visible = visible;
    }
}

